/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitNewBranchOptions;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J4\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J2\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J,\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J*\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lgit4idea/ui/branch/GitBranchCheckoutOperation;", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;)V", "brancher", "Lgit4idea/branch/GitBrancher;", "kotlin.jvm.PlatformType", "perform", "", "startPoint", "", "options", "Lgit4idea/branch/GitNewBranchOptions;", "callInAwtLater", "Ljava/lang/Runnable;", "performCheckout", "name", "localHasMoreCommits", "", "reset", "performCreate", "checkout", "localConflictResolution", "Lgit4idea/ui/branch/GitBranchCheckoutOperation$Companion$CheckoutConflictResolution;", "create", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchCheckoutOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchCheckoutOperation.kt\ngit4idea/ui/branch/GitBranchCheckoutOperation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,200:1\n3347#2,10:201\n3347#2,10:211\n3347#2,10:221\n1300#2,2:231\n1315#2,4:233\n1300#2,2:237\n1315#2,4:239\n13#3:243\n*S KotlinDebug\n*F\n+ 1 GitBranchCheckoutOperation.kt\ngit4idea/ui/branch/GitBranchCheckoutOperation\n*L\n103#1:201,10\n120#1:211,10\n123#1:221,10\n129#1:231,2\n129#1:233,4\n134#1:237,2\n134#1:239,4\n139#1:243\n*E\n"})
public final class GitBranchCheckoutOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<GitRepository> repositories;
    private final GitBrancher brancher;
    @NotNull
    private static final Logger LOG;

    public GitBranchCheckoutOperation(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        this.project = project;
        this.repositories = repositories;
        this.brancher = GitBrancher.getInstance(this.project);
        boolean bl2 = bl = !this.repositories.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void perform(@NotNull String startPoint, @NotNull GitNewBranchOptions options2) {
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        this.perform(startPoint, options2, null);
    }

    public final void perform(@NotNull String startPoint, @NotNull GitNewBranchOptions options2, @Nullable Runnable callInAwtLater) {
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        boolean checkout2 = options2.shouldCheckout();
        String name = options2.getName();
        boolean reset = options2.shouldReset();
        boolean localHasMoreCommits = Companion.checkLocalHasMoreCommits$intellij_vcs_git(this.project, this.repositories, name, startPoint);
        if (checkout2) {
            this.performCheckout(startPoint, name, localHasMoreCommits, reset, callInAwtLater);
        } else {
            this.performCreate(startPoint, name, localHasMoreCommits, reset, callInAwtLater);
        }
    }

    private final void performCheckout(String startPoint, String name, boolean localHasMoreCommits, boolean reset, Runnable callInAwtLater) {
        if (localHasMoreCommits) {
            if (reset) {
                Object[] objectArray = new Object[]{name, startPoint};
                String string = GitBundle.message("branches.checkout.with.reset.local.has.more.commits", objectArray);
                objectArray = new Object[]{startPoint};
                int result2 = Messages.showYesNoCancelDialog((String)string, (String)GitBundle.message("checkout.0", objectArray), (String)GitBundle.message("checkout.and.rebase", new Object[0]), (String)GitBundle.message("branches.drop.local.commits", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null);
                switch (result2) {
                    case 0: {
                        this.checkout(startPoint, name, Companion.CheckoutConflictResolution.REBASE, callInAwtLater);
                        break;
                    }
                    case 1: {
                        this.checkout(startPoint, name, Companion.CheckoutConflictResolution.RESET, callInAwtLater);
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            } else {
                Object[] objectArray = new Object[]{name, startPoint};
                String string = GitBundle.message("branches.checkout.local.has.more.commits", objectArray);
                objectArray = new Object[]{startPoint};
                int result3 = Messages.showYesNoCancelDialog((String)string, (String)GitBundle.message("checkout.0", objectArray), (String)GitBundle.message("checkout.and.rebase", new Object[0]), (String)GitBundle.message("branches.checkout.local", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null);
                switch (result3) {
                    case 0: {
                        this.checkout(startPoint, name, Companion.CheckoutConflictResolution.REBASE, callInAwtLater);
                        break;
                    }
                    case 1: {
                        this.checkout(startPoint, name, Companion.CheckoutConflictResolution.USE_LOCAL, callInAwtLater);
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
        } else {
            this.checkout(startPoint, name, reset ? Companion.CheckoutConflictResolution.RESET : Companion.CheckoutConflictResolution.TRY, callInAwtLater);
        }
    }

    static /* synthetic */ void performCheckout$default(GitBranchCheckoutOperation gitBranchCheckoutOperation, String string, String string2, boolean bl, boolean bl2, Runnable runnable2, int n, Object object) {
        if ((n & 0x10) != 0) {
            runnable2 = null;
        }
        gitBranchCheckoutOperation.performCheckout(string, string2, bl, bl2, runnable2);
    }

    private final void performCreate(String startPoint, String name, boolean localHasMoreCommits, boolean reset, Runnable callInAwtLater) {
        if (localHasMoreCommits) {
            if (reset) {
                Object[] objectArray = new Object[]{name, startPoint};
                String string = GitBundle.message("branches.create.with.reset.local.has.more.commits", objectArray);
                objectArray = new Object[]{startPoint};
                int result2 = Messages.showYesNoDialog((String)string, (String)GitBundle.message("checkout.0", objectArray), (String)GitBundle.message("branches.drop.local.commits", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null);
                if (result2 == 0) {
                    this.create(startPoint, name, true, callInAwtLater);
                }
            } else {
                Object[] objectArray = new Object[]{name, startPoint};
                String string = GitBundle.message("branches.create.local.has.more.commits", objectArray);
                objectArray = new Object[]{startPoint};
                int result3 = Messages.showYesNoDialog((String)string, (String)GitBundle.message("checkout.0", objectArray), (String)GitBundle.message("new.branch.dialog.operation.create.name", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null);
                if (result3 == 0) {
                    this.create(startPoint, name, false, callInAwtLater);
                }
            }
        } else {
            this.create(startPoint, name, reset, callInAwtLater);
        }
    }

    private final void checkout(String startPoint, String name, Companion.CheckoutConflictResolution localConflictResolution, Runnable callInAwtLater) {
        Iterable $this$partition$iv = this.repositories;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            GitRepository it = (GitRepository)element$iv;
            boolean bl = false;
            boolean bl2 = it.getBranches().findLocalBranch(name) != null ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List reposWithLocalBranch = (List)pair.component1();
        List reposWithoutLocalBranch = (List)pair.component2();
        if (!((Collection)reposWithLocalBranch).isEmpty()) {
            switch (WhenMappings.$EnumSwitchMapping$0[localConflictResolution.ordinal()]) {
                case 1: {
                    this.brancher.checkout(name, false, reposWithLocalBranch, callInAwtLater);
                    break;
                }
                case 2: {
                    this.brancher.checkoutNewBranchStartingFrom(name, startPoint, true, reposWithLocalBranch, callInAwtLater);
                    break;
                }
                case 3: {
                    this.brancher.rebase(reposWithLocalBranch, startPoint, name);
                    break;
                }
                case 4: {
                    this.brancher.checkoutNewBranchStartingFrom(name, startPoint, false, reposWithLocalBranch, callInAwtLater);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (!((Collection)reposWithoutLocalBranch).isEmpty()) {
            this.brancher.checkoutNewBranchStartingFrom(name, startPoint, false, reposWithoutLocalBranch, callInAwtLater);
        }
    }

    static /* synthetic */ void checkout$default(GitBranchCheckoutOperation gitBranchCheckoutOperation, String string, String string2, Companion.CheckoutConflictResolution checkoutConflictResolution, Runnable runnable2, int n, Object object) {
        if ((n & 8) != 0) {
            runnable2 = null;
        }
        gitBranchCheckoutOperation.checkout(string, string2, checkoutConflictResolution, runnable2);
    }

    /*
     * WARNING - void declaration
     */
    private final void create(String startPoint, String name, boolean reset, Runnable callInAwtLater) {
        String string;
        Map map2;
        Object t;
        void $this$associateWith$iv;
        GitBrancher gitBrancher;
        String string2;
        Iterable $this$partition$iv = this.repositories;
        boolean $i$f$partition = false;
        Pair first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            GitRepository it = (GitRepository)element$iv;
            boolean bl = false;
            boolean bl2 = it.getBranches().findLocalBranch(name) != null ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List reposWithLocalBranch = (List)pair.component1();
        List reposWithoutLocalBranch = (List)pair.component2();
        if (!((Collection)reposWithLocalBranch).isEmpty() && reset) {
            Iterable $this$partition$iv2 = reposWithLocalBranch;
            boolean $i$f$partition2 = false;
            Iterable<Object> first$iv2 = new ArrayList();
            ArrayList second$iv2 = new ArrayList();
            for (Object element$iv : $this$partition$iv2) {
                GitRepository it = (GitRepository)element$iv;
                boolean bl = false;
                boolean bl3 = Intrinsics.areEqual((Object)it.getCurrentBranchName(), (Object)name) ? first$iv2.add(element$iv) : second$iv2.add(element$iv);
            }
            first$iv = new Pair(first$iv2, second$iv2);
            List currentBranchOfSameName = (List)first$iv.component1();
            List currentBranchOfDifferentName = (List)first$iv.component2();
            if (!((Collection)currentBranchOfSameName).isEmpty()) {
                this.brancher.checkoutNewBranchStartingFrom(name, startPoint, true, currentBranchOfSameName, callInAwtLater);
            }
            if (!((Collection)currentBranchOfDifferentName).isEmpty()) {
                void $this$associateWithTo$iv$iv;
                Object element$iv;
                first$iv2 = currentBranchOfDifferentName;
                string2 = name;
                gitBrancher = this.brancher;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                element$iv = $this$associateWith$iv;
                Map destination$iv$iv = result$iv;
                boolean $i$f$associateWithTo2 = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    GitRepository gitRepository = (GitRepository)element$iv$iv;
                    t = element$iv$iv;
                    map2 = destination$iv$iv;
                    boolean bl = false;
                    string = startPoint;
                    map2.put(t, string);
                }
                map2 = destination$iv$iv;
                gitBrancher.createBranch(string2, map2, true, callInAwtLater);
            }
        }
        if (!((Collection)reposWithoutLocalBranch).isEmpty()) {
            void $this$associateWithTo$iv$iv;
            void $this$associateWith$iv2;
            first$iv = reposWithoutLocalBranch;
            string2 = name;
            gitBrancher = this.brancher;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv2, (int)10)), (int)16));
            $this$associateWith$iv = $this$associateWith$iv2;
            Map destination$iv$iv = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                GitRepository $i$f$associateWithTo2 = (GitRepository)element$iv$iv;
                t = element$iv$iv;
                map2 = destination$iv$iv;
                boolean bl = false;
                string = startPoint;
                map2.put(t, string);
            }
            map2 = destination$iv$iv;
            gitBrancher.createBranch(string2, (Map<GitRepository, String>)map2, callInAwtLater);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitBranchCheckoutOperation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0010J.\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J.\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J(\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lgit4idea/ui/branch/GitBranchCheckoutOperation$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "checkLocalHasMoreCommits", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "localBranch", "", "startPoint", "checkLocalHasMoreCommits$intellij_vcs_git", "checkCommitsUnderProgress", "", "startRef", "branchName", "checkCommitsBetweenRefAndBranchName", "hasCommits", "repository", "endRef", "CheckoutConflictResolution", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitBranchCheckoutOperation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchCheckoutOperation.kt\ngit4idea/ui/branch/GitBranchCheckoutOperation$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1807#2,3:201\n*S KotlinDebug\n*F\n+ 1 GitBranchCheckoutOperation.kt\ngit4idea/ui/branch/GitBranchCheckoutOperation$Companion\n*L\n168#1:201,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean checkLocalHasMoreCommits$intellij_vcs_git(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull String localBranch, @NotNull String startPoint) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Intrinsics.checkNotNullParameter((Object)localBranch, (String)"localBranch");
            Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
            Map map2 = ContainerUtil.map2MapNotNull(repositories, arg_0 -> Companion.checkLocalHasMoreCommits$lambda$1(arg_0 -> Companion.checkLocalHasMoreCommits$lambda$0(localBranch, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"map2MapNotNull(...)");
            Map existingLocalBranches = map2;
            boolean existingLocalHasCommits = !existingLocalBranches.isEmpty() ? this.checkCommitsUnderProgress(project, CollectionsKt.toList((Iterable)existingLocalBranches.keySet()), startPoint, localBranch) : false;
            return existingLocalHasCommits;
        }

        private final boolean checkCommitsUnderProgress(Project project, List<? extends GitRepository> repositories, String startRef, String branchName) {
            String string = GitBundle.message("branches.checking.existing.commits.process", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return (Boolean)TasksKt.runWithModalProgressBlocking((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(project, repositories, startRef, branchName, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ List<GitRepository> $repositories;
                final /* synthetic */ String $startRef;
                final /* synthetic */ String $branchName;
                {
                    this.$project = $project;
                    this.$repositories = $repositories;
                    this.$startRef = $startRef;
                    this.$branchName = $branchName;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            return Boxing.boxBoolean((boolean)git4idea.ui.branch.GitBranchCheckoutOperation$Companion.access$checkCommitsBetweenRefAndBranchName(GitBranchCheckoutOperation.Companion, this.$project, this.$repositories, this.$startRef, this.$branchName));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final boolean checkCommitsBetweenRefAndBranchName(Project project, List<? extends GitRepository> repositories, String startRef, String branchName) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = repositories;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl2 = false;
                        GitLocalBranch existingBranch = it.getBranches().findLocalBranch(branchName);
                        if (!(existingBranch != null && Companion.hasCommits(project, it, startRef, existingBranch.getName()))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean hasCommits(Project project, GitRepository repository2, String startRef, String endRef) {
            try {
                String[] stringArray = new String[]{startRef + ".." + endRef};
                List<? extends TimedVcsCommit> list = GitHistoryUtils.collectTimedCommits(project, repository2.getRoot(), stringArray);
                Intrinsics.checkNotNullExpressionValue(list, (String)"collectTimedCommits(...)");
                return !((Collection)list).isEmpty();
            }
            catch (VcsException ex) {
                LOG.warn("Couldn't collect commits in " + repository2.getPresentableUrl() + " for " + startRef + ".." + endRef);
                return true;
            }
        }

        private static final com.intellij.openapi.util.Pair checkLocalHasMoreCommits$lambda$0(String $localBranch, GitRepository r) {
            GitLocalBranch local;
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            GitLocalBranch gitLocalBranch = local = r.getBranches().findLocalBranch($localBranch);
            return gitLocalBranch != null ? com.intellij.openapi.util.Pair.create((Object)r, (Object)gitLocalBranch) : null;
        }

        private static final com.intellij.openapi.util.Pair checkLocalHasMoreCommits$lambda$1(Function1 $tmp0, Object p0) {
            return (com.intellij.openapi.util.Pair)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ boolean access$checkCommitsBetweenRefAndBranchName(Companion $this, Project project, List repositories, String startRef, String branchName) {
            return $this.checkCommitsBetweenRefAndBranchName(project, repositories, startRef, branchName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/ui/branch/GitBranchCheckoutOperation$Companion$CheckoutConflictResolution;", "", "<init>", "(Ljava/lang/String;I)V", "USE_LOCAL", "RESET", "REBASE", "TRY", "intellij.vcs.git"})
        private static final class CheckoutConflictResolution
        extends Enum<CheckoutConflictResolution> {
            public static final /* enum */ CheckoutConflictResolution USE_LOCAL = new CheckoutConflictResolution();
            public static final /* enum */ CheckoutConflictResolution RESET = new CheckoutConflictResolution();
            public static final /* enum */ CheckoutConflictResolution REBASE = new CheckoutConflictResolution();
            public static final /* enum */ CheckoutConflictResolution TRY = new CheckoutConflictResolution();
            private static final /* synthetic */ CheckoutConflictResolution[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static CheckoutConflictResolution[] values() {
                return (CheckoutConflictResolution[])$VALUES.clone();
            }

            public static CheckoutConflictResolution valueOf(String value) {
                return Enum.valueOf(CheckoutConflictResolution.class, value);
            }

            @NotNull
            public static EnumEntries<CheckoutConflictResolution> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = checkoutConflictResolutionArray = new CheckoutConflictResolution[]{CheckoutConflictResolution.USE_LOCAL, CheckoutConflictResolution.RESET, CheckoutConflictResolution.REBASE, CheckoutConflictResolution.TRY};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Companion.CheckoutConflictResolution.values().length];
            try {
                nArray[Companion.CheckoutConflictResolution.USE_LOCAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.CheckoutConflictResolution.RESET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.CheckoutConflictResolution.REBASE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.CheckoutConflictResolution.TRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

