/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.commands.Git;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import git4idea.util.GitPreservingProcess;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0001%Ba\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u0012\u000b\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016BY\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u0012\u000b\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0017\u001a\u00020\u0010\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0018J\u001a\u0010\u001e\u001a\u00020\u001f2\u0010\b\u0002\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010!H\u0007J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010#\u001a\u00020\u0012H\u0002J\u0006\u0010$\u001a\u00020\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0019\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lgit4idea/util/GitPreservingProcess;", "", "project", "Lcom/intellij/openapi/project/Project;", "git", "Lgit4idea/commands/Git;", "rootsToSave", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "operationTitle", "", "Lorg/jetbrains/annotations/Nls;", "destinationName", "saveMethod", "Lgit4idea/config/GitSaveChangesPolicy;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "reportLocalHistoryActivity", "", "operation", "Ljava/lang/Runnable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/commands/Git;Ljava/util/Collection;Ljava/lang/String;Ljava/lang/String;Lgit4idea/config/GitSaveChangesPolicy;Lcom/intellij/openapi/progress/ProgressIndicator;ZLjava/lang/Runnable;)V", "indicator", "(Lcom/intellij/openapi/project/Project;Lgit4idea/commands/Git;Ljava/util/Collection;Ljava/lang/String;Ljava/lang/String;Lgit4idea/config/GitSaveChangesPolicy;Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/Runnable;)V", "stashMessage", "saver", "Lgit4idea/stash/GitChangesSaver;", "isLoaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "execute", "", "autoLoadDecision", "Lcom/intellij/openapi/util/Computable;", "configureSaver", "save", "load", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitPreservingProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitPreservingProcess.kt\ngit4idea/util/GitPreservingProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,193:1\n13#2:194\n*S KotlinDebug\n*F\n+ 1 GitPreservingProcess.kt\ngit4idea/util/GitPreservingProcess\n*L\n166#1:194\n*E\n"})
public final class GitPreservingProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Git git;
    @NotNull
    private final Collection<VirtualFile> rootsToSave;
    @NotNull
    private final String operationTitle;
    @NotNull
    private final String destinationName;
    @NotNull
    private final ProgressIndicator progressIndicator;
    @NotNull
    private final Runnable operation;
    @Nls
    @NotNull
    private final String stashMessage;
    @NotNull
    private final GitChangesSaver saver;
    @NotNull
    private final AtomicBoolean isLoaded;
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    public GitPreservingProcess(@NotNull Project project, @NotNull Git git, @NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull String operationTitle, @NotNull String destinationName, @NotNull GitSaveChangesPolicy saveMethod, @NotNull ProgressIndicator progressIndicator, boolean reportLocalHistoryActivity, @NotNull Runnable operation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter(rootsToSave, (String)"rootsToSave");
        Intrinsics.checkNotNullParameter((Object)operationTitle, (String)"operationTitle");
        Intrinsics.checkNotNullParameter((Object)destinationName, (String)"destinationName");
        Intrinsics.checkNotNullParameter((Object)((Object)saveMethod), (String)"saveMethod");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        this.project = project;
        this.git = git;
        this.rootsToSave = rootsToSave;
        this.operationTitle = operationTitle;
        this.destinationName = destinationName;
        this.progressIndicator = progressIndicator;
        this.operation = operation;
        Object[] objectArray = new Object[]{StringUtil.capitalize((String)this.operationTitle), DateFormatUtil.formatDateTime((long)Clock.getTime())};
        String string = VcsBundle.message((String)"stash.changes.message.with.date", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.stashMessage = string;
        this.saver = this.configureSaver(saveMethod, reportLocalHistoryActivity);
        this.isLoaded = new AtomicBoolean();
    }

    public GitPreservingProcess(@NotNull Project project, @NotNull Git git, @NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull String operationTitle, @NotNull String destinationName, @NotNull GitSaveChangesPolicy saveMethod, @NotNull ProgressIndicator indicator, @NotNull Runnable operation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter(rootsToSave, (String)"rootsToSave");
        Intrinsics.checkNotNullParameter((Object)operationTitle, (String)"operationTitle");
        Intrinsics.checkNotNullParameter((Object)destinationName, (String)"destinationName");
        Intrinsics.checkNotNullParameter((Object)((Object)saveMethod), (String)"saveMethod");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        this(project, git, rootsToSave, operationTitle, destinationName, saveMethod, indicator, true, operation);
    }

    @JvmOverloads
    public final void execute(@Nullable Computable<Boolean> autoLoadDecision) {
        Runnable operation = () -> GitPreservingProcess.execute$lambda$0(this, autoLoadDecision);
        new GitFreezingProcess(this.project, this.operationTitle, operation).execute();
    }

    public static /* synthetic */ void execute$default(GitPreservingProcess gitPreservingProcess, Computable computable, int n, Object object) {
        if ((n & 1) != 0) {
            computable = null;
        }
        gitPreservingProcess.execute((Computable<Boolean>)computable);
    }

    private final GitChangesSaver configureSaver(GitSaveChangesPolicy saveMethod, boolean reportLocalHistoryActivity) {
        GitChangesSaver gitChangesSaver = GitChangesSaver.getSaver(this.project, this.git, this.progressIndicator, this.stashMessage, saveMethod, reportLocalHistoryActivity);
        Intrinsics.checkNotNullExpressionValue((Object)gitChangesSaver, (String)"getSaver(...)");
        GitChangesSaver saver = gitChangesSaver;
        MergeDialogCustomizer mergeDialogCustomizer2 = new MergeDialogCustomizer(this, saveMethod){
            final /* synthetic */ GitPreservingProcess this$0;
            final /* synthetic */ GitSaveChangesPolicy $saveMethod;
            {
                this.this$0 = $receiver;
                this.$saveMethod = $saveMethod;
            }

            public String getMultipleFileMergeDescription(Collection<VirtualFile> files) {
                Intrinsics.checkNotNullParameter(files, (String)"files");
                Object[] objectArray = new Object[]{GitPreservingProcess.access$getOperationTitle$p(this.this$0), XmlStringUtil.wrapInHtmlTag((String)GitPreservingProcess.access$getDestinationName$p(this.this$0), (String)"code")};
                String string = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("restore.conflict.dialog.description.label.text", objectArray));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapInHtml(...)");
                return string;
            }

            public String getLeftPanelTitle(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                String string = this.$saveMethod.selectBundleMessage(GitBundle.message("restore.conflict.diff.dialog.left.stash.title", new Object[0]), GitBundle.message("restore.conflict.diff.dialog.left.shelf.title", new Object[0]));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selectBundleMessage(...)");
                return string;
            }

            public String getRightPanelTitle(VirtualFile file, VcsRevisionNumber revisionNumber) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Object[] objectArray = new Object[]{XmlStringUtil.wrapInHtmlTag((String)GitPreservingProcess.access$getDestinationName$p(this.this$0), (String)"b")};
                String string = XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("restore.conflict.diff.dialog.right.title", objectArray));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapInHtml(...)");
                return string;
            }
        };
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.project).setReverse(true).setMergeDialogCustomizer(mergeDialogCustomizer2).setErrorNotificationTitle(GitBundle.message("preserving.process.local.changes.not.restored.error.title", new Object[0]));
        saver.setConflictResolverParams(params);
        return saver;
    }

    private final boolean save() {
        String errorMessage = this.saver.saveLocalChangesOrError(this.rootsToSave);
        if (errorMessage == null) {
            return true;
        }
        Object[] objectArray = new Object[]{this.operationTitle};
        VcsNotifier.getInstance((Project)this.project).notifyError("git.could.not.save.uncommitted.changes", GitBundle.message("save.notification.failed.title", objectArray), errorMessage);
        return false;
    }

    public final void load() {
        if (this.isLoaded.compareAndSet(false, true)) {
            this.saver.load();
        } else {
            LOG.info("The changes were already loaded");
        }
    }

    @JvmOverloads
    public final void execute() {
        GitPreservingProcess.execute$default(this, null, 1, null);
    }

    private static final Boolean execute$lambda$0$0(GitPreservingProcess this$0) {
        return this$0.save();
    }

    private static final void execute$lambda$0$1(GitPreservingProcess this$0) {
        this$0.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void execute$lambda$0(GitPreservingProcess this$0, Computable $autoLoadDecision) {
        Object object = ProgressManager.getInstance().computeInNonCancelableSection(() -> GitPreservingProcess.execute$lambda$0$0(this$0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeInNonCancelableSection(...)");
        boolean savedSuccessfully = (Boolean)object;
        LOG.debug("save result: " + savedSuccessfully);
        if (savedSuccessfully) {
            try {
                LOG.debug("running operation");
                this$0.operation.run();
                LOG.debug("operation completed.");
            }
            finally {
                if ($autoLoadDecision == null || ((Boolean)$autoLoadDecision.compute()).booleanValue()) {
                    LOG.debug("loading");
                    ProgressManager.getInstance().executeNonCancelableSection(() -> GitPreservingProcess.execute$lambda$0$1(this$0));
                } else {
                    this$0.saver.notifyLocalChangesAreNotRestored(this$0.operationTitle);
                }
            }
        }
        LOG.debug("finished.");
    }

    public static final /* synthetic */ String access$getOperationTitle$p(GitPreservingProcess $this) {
        return $this.operationTitle;
    }

    public static final /* synthetic */ String access$getDestinationName$p(GitPreservingProcess $this) {
        return $this.destinationName;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitPreservingProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/util/GitPreservingProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "runWithPreservedLocalChanges", "R", "repository", "Lgit4idea/repo/GitRepository;", "operationTitle", "", "destinationName", "operation", "Lkotlin/Function0;", "(Lgit4idea/repo/GitRepository;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final <R> Object runWithPreservedLocalChanges(@NotNull GitRepository repository, @Nls @NotNull String operationTitle, @NlsSafe @NotNull String destinationName, @NotNull Function0<? extends R> operation, @NotNull Continuation<? super R> $completion) {
            if (!($completion instanceof runWithPreservedLocalChanges.1)) ** GOTO lbl-1000
            var8_6 = $completion;
            if ((var8_6.label & -2147483648) != 0) {
                var8_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.runWithPreservedLocalChanges(null, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    result = new Ref.ObjectRef();
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)repository);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)operationTitle);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)destinationName);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)operation);
                    $continuation.L$4 = result;
                    $continuation.label = 1;
                    v0 = CoroutinesKt.coroutineToIndicator((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, runWithPreservedLocalChanges$lambda$0(git4idea.repo.GitRepository java.lang.String java.lang.String kotlin.jvm.internal.Ref$ObjectRef kotlin.jvm.functions.Function0 com.intellij.openapi.progress.ProgressIndicator ), (Lcom/intellij/openapi/progress/ProgressIndicator;)Lkotlin/Unit;)((GitRepository)repository, (String)operationTitle, (String)destinationName, (Ref.ObjectRef)result, (Function0)operation), $continuation);
                    if (v0 == var9_8) {
                        return var9_8;
                    }
                    ** GOTO lbl31
                }
                case 1: {
                    result = (Ref.ObjectRef)$continuation.L$4;
                    operation = (Function0)$continuation.L$3;
                    destinationName = (String)$continuation.L$2;
                    operationTitle = (String)$continuation.L$1;
                    repository = (GitRepository)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    return result.element;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private static final void runWithPreservedLocalChanges$lambda$0$0(Ref.ObjectRef $result, Function0 $operation) {
            $result.element = $operation.invoke();
        }

        private static final Unit runWithPreservedLocalChanges$lambda$0(GitRepository $repository, String $operationTitle, String $destinationName, Ref.ObjectRef $result, Function0 $operation, ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            GitSaveChangesPolicy gitSaveChangesPolicy = GitVcsSettings.getInstance($repository.getProject()).getSaveChangesPolicy();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitSaveChangesPolicy), (String)"getSaveChangesPolicy(...)");
            GitSaveChangesPolicy saveMethod = gitSaveChangesPolicy;
            Project project = $repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Git git = Git.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)git, (String)"getInstance(...)");
            GitPreservingProcess process = new GitPreservingProcess(project, git, CollectionsKt.listOf((Object)$repository.getRoot()), $operationTitle, $destinationName, saveMethod, indicator, () -> Companion.runWithPreservedLocalChanges$lambda$0$0($result, $operation));
            GitPreservingProcess.execute$default(process, null, 1, null);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

