/*
 * Decompiled with CFR 0.152.
 */
package git4idea.workingTrees;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.vcs.git.workingTrees.GitWorkingTreesUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/workingTrees/GitWorkingTreesNewBadgeUtil;", "", "<init>", "()V", "STOP_SHOWING_NEW_BADGE_KEY", "", "NUMBER_OF_PROJECTS_WITH_GIT_KEY", "shouldShowBadgeNew", "", "workingTreesFeatureWasUsed", "", "addLabelNewIfNeeded", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "reportProjectWithGitOpened", "intellij.vcs.git"})
public final class GitWorkingTreesNewBadgeUtil {
    @NotNull
    public static final GitWorkingTreesNewBadgeUtil INSTANCE = new GitWorkingTreesNewBadgeUtil();
    @NotNull
    private static final String STOP_SHOWING_NEW_BADGE_KEY = "git.working.trees.stop.showing.new.badge";
    @NotNull
    private static final String NUMBER_OF_PROJECTS_WITH_GIT_KEY = "git.working.trees.number.of.projects.with.git";

    private GitWorkingTreesNewBadgeUtil() {
    }

    public final boolean shouldShowBadgeNew() {
        return GitWorkingTreesUtil.INSTANCE.isWorkingTreesFeatureEnabled() && !PropertiesComponent.getInstance().getBoolean(STOP_SHOWING_NEW_BADGE_KEY, false);
    }

    public final void workingTreesFeatureWasUsed() {
        PropertiesComponent.getInstance().setValue(STOP_SHOWING_NEW_BADGE_KEY, true);
    }

    public final void addLabelNewIfNeeded(@NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (this.shouldShowBadgeNew()) {
            presentation.putClientProperty(ActionUtil.SECONDARY_ICON, (Object)AllIcons.General.New_badge);
        }
    }

    public final void reportProjectWithGitOpened() {
        if (!GitWorkingTreesUtil.INSTANCE.isWorkingTreesFeatureEnabled() || !this.shouldShowBadgeNew()) {
            return;
        }
        PropertiesComponent properties = PropertiesComponent.getInstance();
        int number = properties.getInt(NUMBER_OF_PROJECTS_WITH_GIT_KEY, 0);
        if (number > 4) {
            properties.setValue(STOP_SHOWING_NEW_BADGE_KEY, true);
            properties.unsetValue(NUMBER_OF_PROJECTS_WITH_GIT_KEY);
        } else {
            properties.setValue(NUMBER_OF_PROJECTS_WITH_GIT_KEY, number + 1, 0);
        }
    }
}

