/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.CommandLineInspectionProjectAsyncConfigurator;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.ide.environment.EnvironmentService;
import com.intellij.ide.impl.ProjectOpenKeyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationViewManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.SdkLookup;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.lang.JavaVersion;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenCommandLineInspectionProjectConfigurator;
import org.jetbrains.idea.maven.MavenCommandLineInspectionProjectConfiguratorKt;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenPluginWithArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenAsyncUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenOpenProjectProvider;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\"\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/idea/maven/MavenCommandLineInspectionProjectConfigurator;", "Lcom/intellij/ide/CommandLineInspectionProjectAsyncConfigurator;", "<init>", "()V", "getName", "", "getDescription", "configureEnvironment", "", "context", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;", "configureProjectAsync", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setupDefaultJdk", "projects", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "setupJdkWithSuitableVersion", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/projectRoots/Sdk;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "iterateVersions", "level", "Lcom/intellij/pom/java/LanguageLevel;", "progressIndicator", "LogBuildProgressListener", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenCommandLineInspectionProjectConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCommandLineInspectionProjectConfigurator.kt\norg/jetbrains/idea/maven/MavenCommandLineInspectionProjectConfigurator\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n42#2,3:191\n30#3,2:194\n30#3,2:196\n30#3,2:198\n832#4:200\n862#4,2:201\n832#4:203\n862#4,2:204\n*S KotlinDebug\n*F\n+ 1 MavenCommandLineInspectionProjectConfigurator.kt\norg/jetbrains/idea/maven/MavenCommandLineInspectionProjectConfigurator\n*L\n69#1:191,3\n83#1:194,2\n84#1:196,2\n85#1:198,2\n115#1:200\n115#1:201,2\n121#1:203\n121#1:204,2\n*E\n"})
public final class MavenCommandLineInspectionProjectConfigurator
implements CommandLineInspectionProjectAsyncConfigurator {
    @NotNull
    public String getName() {
        return "maven";
    }

    @NotNull
    public String getDescription() {
        String string = MavenProjectBundle.message("maven.commandline.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        CommandLineInspectionProjectConfigurator.ConfiguratorContext $this$configureEnvironment_u24lambda_u240 = context2;
        boolean bl = false;
        System.setProperty("maven.create.dummy.module.on.first.import", "false");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object configureProjectAsync(@NotNull Project project, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof configureProjectAsync.1)) ** GOTO lbl-1000
        var33_4 = $completion;
        if ((var33_4.label & -2147483648) != 0) {
            var33_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ MavenCommandLineInspectionProjectConfigurator this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.configureProjectAsync(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var34_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = context.getProjectPath();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProjectPath(...)");
                basePath = v0.toString();
                pomXmlFile = basePath + "/pom.xml";
                v1 = Paths.get((String)pomXmlFile, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"get(...)");
                if (!Files.exists(v1, new LinkOption[0])) {
                    return Unit.INSTANCE;
                }
                $i$f$service = false;
                serviceClass$iv = EnvironmentService.class;
                v2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (v2 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                service = (EnvironmentService)v2;
                $continuation.L$0 = project;
                $continuation.L$1 = context;
                $continuation.L$2 = basePath;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)pomXmlFile);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)service);
                $continuation.label = 1;
                v3 = service.getEnvironmentValue(ProjectOpenKeyProvider.Keys.INSTANCE.getPROJECT_OPEN_PROCESSOR(), "Maven", (Continuation)$continuation);
                if (v3 == var34_6) {
                    return var34_6;
                }
                ** GOTO lbl44
            }
            case 1: {
                service = (EnvironmentService)$continuation.L$4;
                pomXmlFile = (String)$continuation.L$3;
                basePath = (String)$continuation.L$2;
                context = (CommandLineInspectionProjectConfigurator.ConfiguratorContext)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl44:
                // 2 sources

                if (!Intrinsics.areEqual((Object)(projectSelectionKey = (String)v3), (Object)"Maven")) {
                    return Unit.INSTANCE;
                }
                v4 = ExternalSystemUnlinkedProjectAware.Companion.getInstance(MavenUtil.SYSTEM_ID);
                Intrinsics.checkNotNull((Object)v4);
                mavenProjectAware = v4;
                isMavenProjectLinked = mavenProjectAware.isLinkedProject(project, basePath);
                MavenCommandLineInspectionProjectConfiguratorKt.access$getLOG$p().info("maven project: " + project.getName() + " is linked: " + (isMavenProjectLinked != false));
                v5 = Disposer.newDisposable();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"newDisposable(...)");
                disposable = v5;
                progressListener = new LogBuildProgressListener();
                $this$service$iv = (ComponentManager)project;
                $i$f$service = false;
                serviceClass$iv = ExternalSystemRunConfigurationViewManager.class;
                v6 = $this$service$iv.getService(serviceClass$iv);
                if (v6 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                externalSystemRunConfigurationViewManager = (ExternalSystemRunConfigurationViewManager)v6;
                $this$service$iv = (ComponentManager)project;
                $i$f$service = false;
                serviceClass$iv = BuildViewManager.class;
                v7 = $this$service$iv.getService(serviceClass$iv);
                if (v7 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                buildViewManager = (BuildViewManager)v7;
                $this$service$iv = (ComponentManager)project;
                $i$f$service = false;
                serviceClass$iv = SyncViewManager.class;
                v8 = $this$service$iv.getService(serviceClass$iv);
                if (v8 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                syncViewManager = (SyncViewManager)v8;
                externalSystemRunConfigurationViewManager.addListener((BuildProgressListener)progressListener, disposable);
                buildViewManager.addListener((BuildProgressListener)progressListener, disposable);
                syncViewManager.addListener((BuildProgressListener)progressListener, disposable);
                if (isMavenProjectLinked) ** GOTO lbl148
                $continuation.L$0 = project;
                $continuation.L$1 = context;
                $continuation.L$2 = basePath;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)pomXmlFile);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)service);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)projectSelectionKey);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)mavenProjectAware);
                $continuation.L$7 = disposable;
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)progressListener);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)externalSystemRunConfigurationViewManager);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)buildViewManager);
                $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)syncViewManager);
                $continuation.Z$0 = isMavenProjectLinked;
                $continuation.label = 2;
                v9 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
                    int label;
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = CoroutinesKt.writeIntentReadAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(), ()Lkotlin/Unit;)(), (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.label = 2;
                                v1 = MavenAsyncUtil.Companion.setupProjectSdk(this.$project, (Continuation<? super Unit>)((Continuation)this));
                                if (v1 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl21
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl21:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0() {
                        FileDocumentManager.getInstance().saveAllDocuments();
                        return Unit.INSTANCE;
                    }
                }), (Continuation)$continuation);
                if (v9 == var34_6) {
                    return var34_6;
                }
                ** GOTO lbl114
            }
            case 2: {
                isMavenProjectLinked = $continuation.Z$0;
                syncViewManager = (SyncViewManager)$continuation.L$11;
                buildViewManager = (BuildViewManager)$continuation.L$10;
                externalSystemRunConfigurationViewManager = (ExternalSystemRunConfigurationViewManager)$continuation.L$9;
                progressListener = (LogBuildProgressListener)$continuation.L$8;
                disposable = (Disposable)$continuation.L$7;
                mavenProjectAware = (ExternalSystemUnlinkedProjectAware)$continuation.L$6;
                projectSelectionKey = (String)$continuation.L$5;
                service = (EnvironmentService)$continuation.L$4;
                pomXmlFile = (String)$continuation.L$3;
                basePath = (String)$continuation.L$2;
                context = (CommandLineInspectionProjectConfigurator.ConfiguratorContext)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl114:
                // 2 sources

                $continuation.L$0 = project;
                $continuation.L$1 = context;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)basePath);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)pomXmlFile);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)service);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)projectSelectionKey);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)mavenProjectAware);
                $continuation.L$7 = disposable;
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)progressListener);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)externalSystemRunConfigurationViewManager);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)buildViewManager);
                $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)syncViewManager);
                $continuation.Z$0 = isMavenProjectLinked;
                $continuation.label = 3;
                v10 = new MavenOpenProjectProvider().forceLinkToExistingProjectAsync(basePath, project, (Continuation<? super Unit>)$continuation);
                if (v10 == var34_6) {
                    return var34_6;
                }
                ** GOTO lbl148
            }
            case 3: {
                isMavenProjectLinked = $continuation.Z$0;
                syncViewManager = (SyncViewManager)$continuation.L$11;
                buildViewManager = (BuildViewManager)$continuation.L$10;
                externalSystemRunConfigurationViewManager = (ExternalSystemRunConfigurationViewManager)$continuation.L$9;
                progressListener = (LogBuildProgressListener)$continuation.L$8;
                disposable = (Disposable)$continuation.L$7;
                mavenProjectAware = (ExternalSystemUnlinkedProjectAware)$continuation.L$6;
                projectSelectionKey = (String)$continuation.L$5;
                service = (EnvironmentService)$continuation.L$4;
                pomXmlFile = (String)$continuation.L$3;
                basePath = (String)$continuation.L$2;
                context = (CommandLineInspectionProjectConfigurator.ConfiguratorContext)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl148:
                // 3 sources

                MavenLog.LOG.warn("linked finished for " + project.getName());
                mavenProjectsManager = MavenProjectsManager.getInstance(project);
                Disposer.dispose((Disposable)disposable);
                for (MavenProject mavenProject : mavenProjectsManager.getProjects()) {
                    hasReadingProblems = mavenProject.hasReadingErrors();
                    if (hasReadingProblems) {
                        throw new IllegalStateException("Maven project " + mavenProject + " has import problems:" + mavenProject.getProblems());
                    }
                    hasUnresolvedArtifacts = mavenProject.hasUnresolvedArtifacts();
                    if (hasUnresolvedArtifacts) {
                        $this$filterNot$iv = mavenProject.getDependencies();
                        $i$f$filterNot = false;
                        var23_35 = $this$filterNot$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterNotTo = false;
                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                            it = (MavenArtifact)element$iv$iv;
                            $i$a$-filterNot-MavenCommandLineInspectionProjectConfigurator$configureProjectAsync$unresolvedArtifacts$1 = false;
                            if (it.isResolved()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterNot$iv = mavenProject.getExternalAnnotationProcessors();
                        var31_46 = (List)destination$iv$iv;
                        $i$f$filterNot = false;
                        $this$filterNotTo$iv$iv = $this$filterNot$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterNotTo = false;
                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                            it = (MavenArtifact)element$iv$iv;
                            $i$a$-filterNot-MavenCommandLineInspectionProjectConfigurator$configureProjectAsync$unresolvedArtifacts$2 = false;
                            if (it.isResolved()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        unresolvedArtifacts = CollectionsKt.plus((Collection)var31_46, (Iterable)((List)destination$iv$iv));
                        throw new IllegalStateException("Maven project " + mavenProject + " has unresolved artifacts: " + unresolvedArtifacts);
                    }
                    hasUnresolvedPlugins = mavenProject.hasUnresolvedPlugins();
                    if (!hasUnresolvedPlugins) continue;
                    $this$filterNot$iv = mavenProject.getDeclaredPluginInfos();
                    $i$f$filterNot = false;
                    destination$iv$iv = $this$filterNot$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        it = (MavenPluginWithArtifact)element$iv$iv;
                        $i$a$-filterNot-MavenCommandLineInspectionProjectConfigurator$configureProjectAsync$unresolvedPlugins$1 = false;
                        v11 = it.getArtifact();
                        if (v11 != null ? v11.isResolved() : false) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    unresolvedPlugins = (List)destination$iv$iv;
                    errorMessage = "maven project: " + mavenProject + " has unresolved plugins: " + unresolvedPlugins;
                    if (Boolean.parseBoolean(System.getProperty("maven.command.line.configurator.exit.on.unresolved.plugins", "false"))) {
                        throw new IllegalStateException(errorMessage);
                    }
                    MavenCommandLineInspectionProjectConfiguratorKt.access$getLOG$p().warn(errorMessage);
                }
                v12 = mavenProjectsManager.getProjects();
                Intrinsics.checkNotNullExpressionValue(v12, (String)"getProjects(...)");
                if (((Collection)v12).isEmpty() == false) {
                    v13 = mavenProjectsManager.getProjects();
                    Intrinsics.checkNotNullExpressionValue(v13, (String)"getProjects(...)");
                    this.setupDefaultJdk(v13, context, project);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void setupDefaultJdk(List<MavenProject> projects2, CommandLineInspectionProjectConfigurator.ConfiguratorContext context2, Project project) {
        List list = ProjectJdkTable.getInstance((Project)project).getSdksOfType((SdkTypeId)JavaSdk.getInstance());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSdksOfType(...)");
        if (!((Collection)list).isEmpty()) {
            return;
        }
        ProgressIndicator progressIndicator = context2.getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
        Sdk sdk = this.setupJdkWithSuitableVersion(projects2, progressIndicator).get();
        if (sdk != null) {
            ActionsKt.invokeAndWaitIfNeeded$default(null, () -> MavenCommandLineInspectionProjectConfigurator.setupDefaultJdk$lambda$0(project, sdk), (int)1, null);
        }
    }

    @NotNull
    public final CompletableFuture<Sdk> setupJdkWithSuitableVersion(@NotNull List<MavenProject> projects2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter(projects2, (String)"projects");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        LanguageLevel maxLevel = MavenImportUtil.INSTANCE.getMaxMavenJavaVersion$intellij_maven(projects2);
        return this.iterateVersions(maxLevel, indicator);
    }

    private final CompletableFuture<Sdk> iterateVersions(LanguageLevel level, ProgressIndicator progressIndicator) {
        if (level == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CompletableFuture future = new CompletableFuture();
        SdkLookupBuilder sdkLookupBuilder = SdkLookup.Companion.newLookupBuilder().withProgressIndicator(progressIndicator).withVersionFilter(arg_0 -> MavenCommandLineInspectionProjectConfigurator.iterateVersions$lambda$0(level, arg_0));
        JavaSdk javaSdk = JavaSdk.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)javaSdk, (String)"getInstance(...)");
        sdkLookupBuilder.withSdkType((SdkType)javaSdk).onSdkResolved(arg_0 -> MavenCommandLineInspectionProjectConfigurator.iterateVersions$lambda$1(future, arg_0)).executeLookup();
        CompletionStage completionStage = future.thenCompose(arg_0 -> MavenCommandLineInspectionProjectConfigurator.iterateVersions$lambda$3(arg_0 -> MavenCommandLineInspectionProjectConfigurator.iterateVersions$lambda$2(this, level, progressIndicator, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    private static final Unit setupDefaultJdk$lambda$0$0(Project $project, Sdk $sdk) {
        ProjectRootManager.getInstance((Project)$project).setProjectSdk($sdk);
        return Unit.INSTANCE;
    }

    private static final Unit setupDefaultJdk$lambda$0(Project $project, Sdk $sdk) {
        ActionsKt.runWriteAction(() -> MavenCommandLineInspectionProjectConfigurator.setupDefaultJdk$lambda$0$0($project, $sdk));
        return Unit.INSTANCE;
    }

    private static final boolean iterateVersions$lambda$0(LanguageLevel $level, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JavaVersion javaVersion = JavaVersion.Companion.tryParse(it);
        return javaVersion != null ? javaVersion.feature == $level.feature() : false;
    }

    private static final Unit iterateVersions$lambda$1(CompletableFuture $future, Sdk sdk) {
        $future.complete(sdk);
        return Unit.INSTANCE;
    }

    private static final CompletionStage iterateVersions$lambda$2(MavenCommandLineInspectionProjectConfigurator this$0, LanguageLevel $level, ProgressIndicator $progressIndicator, Sdk sdk) {
        return sdk != null ? CompletableFuture.completedFuture(sdk) : this$0.iterateVersions($level.next(), $progressIndicator);
    }

    private static final CompletionStage iterateVersions$lambda$3(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/maven/MavenCommandLineInspectionProjectConfigurator$LogBuildProgressListener;", "Lcom/intellij/build/BuildProgressListener;", "<init>", "()V", "onEvent", "", "buildId", "", "event", "Lcom/intellij/build/events/BuildEvent;", "intellij.maven"})
    public static final class LogBuildProgressListener
    implements BuildProgressListener {
        public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
            Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            OutputBuildEvent outputBuildEvent = event instanceof OutputBuildEvent ? (OutputBuildEvent)event : null;
            if (outputBuildEvent == null) {
                return;
            }
            OutputBuildEvent outputBuildEvent2 = outputBuildEvent;
            String prefix = outputBuildEvent2.isStdOut() ? "" : "stderr: ";
            MavenCommandLineInspectionProjectConfiguratorKt.access$getMAVEN_OUTPUT_LOG$p().debug(prefix + outputBuildEvent2.getMessage());
        }
    }
}

