/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReference;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenPropertyCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        int offset;
        PsiFile psiFile;
        Project project;
        MavenProjectsManager manager;
        if (parameters == null) {
            MavenPropertyCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            MavenPropertyCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!(manager = MavenProjectsManager.getInstance(project = (psiFile = parameters.getOriginalFile()).getProject())).isMavenizedProject()) {
            return;
        }
        MavenProject projectFile2 = MavenDomUtil.findContainingProject((PsiElement)psiFile);
        if (projectFile2 == null) {
            return;
        }
        if (!MavenDomUtil.isMavenFile(psiFile) && !MavenDomUtil.isFilteredResourceFile((PsiElement)psiFile)) {
            return;
        }
        String text = psiFile.getText();
        int braceOffset = MavenPropertyCompletionContributor.findOpenBrace(text, offset = parameters.getOffset());
        if (braceOffset == -1) {
            return;
        }
        TextRange range = TextRange.create((int)braceOffset, (int)offset);
        String prefix = range.substring(text);
        MavenFilteredPropertyPsiReference ref = new MavenFilteredPropertyPsiReference(projectFile2, (PsiElement)psiFile, prefix, range);
        MavenPropertyCompletionContributor.addVariants(Arrays.asList(ref.getVariants()), result.withPrefixMatcher(prefix));
    }

    public static void addVariants(Collection<?> variants, CompletionResultSet result) {
        for (Object each : variants) {
            Object e = each instanceof LookupElement ? (LookupElement)each : (each instanceof String ? LookupElementBuilder.create((String)((String)each)) : (each instanceof PsiNamedElement ? LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)each)) : LookupElementBuilder.create(each, (String)String.valueOf(each))));
            result.addElement(e);
        }
    }

    private static int findOpenBrace(CharSequence text, int offset) {
        for (int i2 = offset - 1; i2 > 0; --i2) {
            char c = text.charAt(i2);
            if (c == '{' && text.charAt(i2 - 1) == '$') {
                return i2 + 1;
            }
            if (Character.isLetterOrDigit(c) || c == '.') continue;
            return -1;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/dom/references/MavenPropertyCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

