/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.target;

import com.intellij.execution.CantRunException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.value.DeferredTargetValue;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelMachineProviderUtil;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.execution.target.MavenCommandLineSetup;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTargetConfiguration;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTypeConstants;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenSettingsCache;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 R2\u00020\u0001:\u0001RB$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020%H\u0007J\u0016\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001cJ\b\u0010)\u001a\u00020 H\u0002J\u0010\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010-\u001a\u00020%2\b\u0010.\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010/\u001a\u0004\u0018\u00010\u0005H\u0082@\u00a2\u0006\u0002\u00100J\b\u00101\u001a\u00020 H\u0002J$\u00102\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0012\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0005040\u001eH\u0002J$\u00105\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0012\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0005040\u001eH\u0002J\u0010\u00106\u001a\u0002072\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u00108\u001a\u00020,2\u0006\u0010\"\u001a\u00020#H\u0002J&\u00109\u001a\b\u0012\u0004\u0012\u00020\u0005042\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0005H\u0002J\u0018\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010D\u001a\u0004\u0018\u00010\u00052\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00050FH\u0002J\u001e\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00050F2\u0006\u0010H\u001a\u00020I2\u0006\u0010\u0002\u001a\u00020JH\u0002J\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020J0L2\u0006\u0010H\u001a\u00020I2\u0006\u0010\u0002\u001a\u00020JH\u0002J\u001b\u0010M\u001a\u00020\u00052\f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00050OH\u0002\u00a2\u0006\u0002\u0010PJ\f\u0010Q\u001a\u00020\u0005*\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lorg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup;", "", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/target/TargetEnvironmentRequest;)V", "commandLine", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "getCommandLine", "()Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "platform", "Lcom/intellij/execution/Platform;", "Lorg/jetbrains/annotations/NotNull;", "getPlatform", "()Lcom/intellij/execution/Platform;", "defaultMavenRuntimeConfiguration", "Lorg/jetbrains/idea/maven/execution/target/MavenRuntimeTargetConfiguration;", "defaultJavaRuntimeConfiguration", "Lcom/intellij/execution/target/java/JavaLanguageRuntimeConfiguration;", "environmentPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/TargetProgressIndicator;", "dependingOnEnvironmentPromise", "", "Lorg/jetbrains/concurrency/Promise;", "", "setupCommandLine", "settings", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenSettings;", "setupEventListener", "", "provideEnvironment", "environment", "progressIndicator", "setupExePath", "setupTargetJavaRuntime", "runnerSettings", "Lorg/jetbrains/idea/maven/execution/MavenRunnerSettings;", "isValidJavaHomePath", "javaHomePath", "calculateTargetJavaHome", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setupMavenExtClassPath", "addMavenParameters", "mavenOptsValues", "Lcom/intellij/execution/target/value/TargetValue;", "setupTargetEnvironmentVariables", "mavenGeneralSettings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "mavenRunnerSettings", "upload", "uploadRoot", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "uploadPathString", "uploadRelativePath", "createUploadRoot", "volumeDescriptor", "Lcom/intellij/execution/target/LanguageRuntimeType$VolumeDescriptor;", "localRootPath", "Ljava/nio/file/Path;", "setupTargetProjectDirectories", "findCommonAncestor", "paths", "", "findPathsToUpload", "mavenProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "Lorg/jetbrains/idea/maven/project/MavenProject;", "findAllInheritors", "", "joinPath", "segments", "", "([Ljava/lang/String;)Ljava/lang/String;", "asTargetPathString", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenCommandLineSetup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCommandLineSetup.kt\norg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n491#2,7:357\n221#3,2:364\n221#3,2:367\n1#4:366\n1807#5,3:369\n*S KotlinDebug\n*F\n+ 1 MavenCommandLineSetup.kt\norg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup\n*L\n188#1:357,7\n189#1:364,2\n240#1:367,2\n330#1:369,3\n*E\n"})
public final class MavenCommandLineSetup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String name;
    @NotNull
    private final TargetEnvironmentRequest request;
    @NotNull
    private final TargetedCommandLineBuilder commandLine;
    @NotNull
    private final Platform platform;
    @Nullable
    private final MavenRuntimeTargetConfiguration defaultMavenRuntimeConfiguration;
    @Nullable
    private final JavaLanguageRuntimeConfiguration defaultJavaRuntimeConfiguration;
    @NotNull
    private final AsyncPromise<Pair<TargetEnvironment, TargetProgressIndicator>> environmentPromise;
    @NotNull
    private final List<Promise<Unit>> dependingOnEnvironmentPromise;
    @NotNull
    private static final Key<MavenCommandLineSetup> setupKey;

    public MavenCommandLineSetup(@NotNull Project project, @NotNull String name, @NotNull TargetEnvironmentRequest request) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.project = project;
        this.name = name;
        this.request = request;
        this.commandLine = new TargetedCommandLineBuilder(this.request);
        Platform platform = this.request.getTargetPlatform().getPlatform();
        Intrinsics.checkNotNullExpressionValue((Object)platform, (String)"getPlatform(...)");
        this.platform = platform;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.request.getConfiguration();
        this.defaultMavenRuntimeConfiguration = targetEnvironmentConfiguration != null && (targetEnvironmentConfiguration = targetEnvironmentConfiguration.getRuntimes()) != null ? (MavenRuntimeTargetConfiguration)targetEnvironmentConfiguration.findByType(MavenRuntimeTargetConfiguration.class) : null;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration2 = this.request.getConfiguration();
        this.defaultJavaRuntimeConfiguration = targetEnvironmentConfiguration2 != null && (targetEnvironmentConfiguration2 = targetEnvironmentConfiguration2.getRuntimes()) != null ? (JavaLanguageRuntimeConfiguration)targetEnvironmentConfiguration2.findByType(JavaLanguageRuntimeConfiguration.class) : null;
        this.environmentPromise = new AsyncPromise();
        this.dependingOnEnvironmentPromise = new ArrayList();
        this.commandLine.putUserData(setupKey, (Object)this);
    }

    @NotNull
    public final TargetedCommandLineBuilder getCommandLine() {
        return this.commandLine;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    @JvmOverloads
    @NotNull
    public final MavenCommandLineSetup setupCommandLine(@NotNull MavenRunConfiguration.MavenSettings settings, boolean setupEventListener) throws CantRunException {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        List mavenOptsValues = new ArrayList();
        this.setupExePath();
        this.setupTargetJavaRuntime(this.mavenRunnerSettings(settings));
        this.setupTargetProjectDirectories(settings);
        if (setupEventListener) {
            this.setupMavenExtClassPath();
        }
        this.addMavenParameters(settings, mavenOptsValues);
        this.setupTargetEnvironmentVariables(settings, mavenOptsValues);
        return this;
    }

    public static /* synthetic */ MavenCommandLineSetup setupCommandLine$default(MavenCommandLineSetup mavenCommandLineSetup, MavenRunConfiguration.MavenSettings mavenSettings, boolean bl, int n, Object object) throws CantRunException {
        if ((n & 2) != 0) {
            bl = true;
        }
        return mavenCommandLineSetup.setupCommandLine(mavenSettings, bl);
    }

    public final void provideEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        this.environmentPromise.setResult((Object)TuplesKt.to((Object)environment, (Object)progressIndicator));
        for (Promise<Unit> promise : this.dependingOnEnvironmentPromise) {
            promise.blockingGet(0);
        }
    }

    private final void setupExePath() throws CantRunException {
        if (this.defaultMavenRuntimeConfiguration == null) {
            this.commandLine.setExePath("mvn");
            return;
        }
        String homePath = this.defaultMavenRuntimeConfiguration.getHomePath();
        if (StringUtil.isEmptyOrSpaces((String)homePath)) {
            this.commandLine.setExePath("mvn");
            return;
        }
        this.commandLine.addEnvironmentVariable("MAVEN_HOME", homePath);
        this.commandLine.addEnvironmentVariable("M2_HOME", homePath);
        String[] stringArray = new String[]{homePath, "bin", "mvn"};
        this.commandLine.setExePath(this.joinPath(stringArray));
    }

    private final void setupTargetJavaRuntime(MavenRunnerSettings runnerSettings) {
        String targetJavaHome = null;
        if (!Intrinsics.areEqual((Object)runnerSettings.getJreName(), (Object)"#USE_PROJECT_JDK")) {
            String jdkPath;
            Sdk sdk = ProjectJdkTable.getInstance((Project)this.project).findJdk(runnerSettings.getJreName());
            String string = jdkPath = sdk != null ? sdk.getHomePath() : null;
            if (this.isValidJavaHomePath(jdkPath)) {
                String string2 = jdkPath;
                Intrinsics.checkNotNull((Object)string2);
                targetJavaHome = this.asTargetPathString(string2);
            }
        } else {
            JavaLanguageRuntimeConfiguration javaLanguageRuntimeConfiguration = this.defaultJavaRuntimeConfiguration;
            if (this.isValidJavaHomePath(javaLanguageRuntimeConfiguration != null ? javaLanguageRuntimeConfiguration.getHomePath() : null)) {
                JavaLanguageRuntimeConfiguration javaLanguageRuntimeConfiguration2 = this.defaultJavaRuntimeConfiguration;
                String string = javaLanguageRuntimeConfiguration2 != null ? javaLanguageRuntimeConfiguration2.getHomePath() : null;
                Intrinsics.checkNotNull((Object)string);
                targetJavaHome = this.asTargetPathString(string);
            }
        }
        if (targetJavaHome == null) {
            targetJavaHome = (String)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, null){
                int label;
                final /* synthetic */ MavenCommandLineSetup this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = MavenCommandLineSetup.access$calculateTargetJavaHome(this.this$0, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        if (targetJavaHome != null) {
            this.commandLine.addEnvironmentVariable("JAVA_HOME", targetJavaHome);
        }
    }

    private final boolean isValidJavaHomePath(String javaHomePath) {
        if (javaHomePath == null || StringsKt.isBlank((CharSequence)javaHomePath)) {
            return false;
        }
        Path path = Path.of(javaHomePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        if (!Intrinsics.areEqual((Object)EelProviderUtil.getEelDescriptor((Path)path), (Object)EelProviderUtil.getEelDescriptor((Project)this.project))) {
            Object[] objectArray = new Object[]{javaHomePath, this.name};
            throw new CantRunException(RunnerBundle.message("maven.target.run.incompatible.jdk", objectArray));
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object calculateTargetJavaHome(Continuation<? super String> $completion) {
        if (!($completion instanceof calculateTargetJavaHome.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MavenCommandLineSetup this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MavenCommandLineSetup.access$calculateTargetJavaHome(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                descriptor = EelProviderUtil.getEelDescriptor((Project)this.project);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)descriptor);
                $continuation.label = 1;
                v0 = EelMachineProviderUtil.toEelApi((EelDescriptor)descriptor, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                descriptor = (EelDescriptor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                eel = (EelApi)v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)descriptor);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)eel);
                $continuation.label = 2;
                v1 = eel.getExec().fetchLoginShellEnvVariables((Continuation)$continuation);
                if (v1 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl36
            }
            case 2: {
                eel = (EelApi)$continuation.L$1;
                descriptor = (EelDescriptor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl36:
                // 2 sources

                if ((targetJavaHome = (String)(targetEnv = (Map)v1).get("JAVA_HOME")) != null) {
                    return targetJavaHome;
                }
                jdk = ProjectRootManager.getInstance((Project)this.project).getProjectSdk();
                v2 /* !! */  = jdk;
                return v2 /* !! */  != null && (v2 /* !! */  = v2 /* !! */ .getHomePath()) != null ? this.asTargetPathString((String)v2 /* !! */ ) : null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void setupMavenExtClassPath() {
        File mavenEventListener = MavenServerManager.Companion.getInstance().getMavenEventListener();
        Path uploadPath = Paths.get(FileUtil.toSystemDependentName((String)mavenEventListener.getPath()), new String[0]);
        LanguageRuntimeType.VolumeDescriptor volumeDescriptor = MavenRuntimeTypeConstants.getMAVEN_EXT_CLASS_PATH_VOLUME();
        Path path = uploadPath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        TargetEnvironment.UploadRoot uploadRoot = this.createUploadRoot(volumeDescriptor, path);
        ((Collection)this.request.getUploadVolumes()).add(uploadRoot);
        TargetValue<String> targetValue = this.upload(uploadRoot, ((Object)uploadPath).toString(), ((Object)uploadPath.getFileName()).toString());
        TargetValue targetValue2 = TargetValue.map(targetValue, arg_0 -> MavenCommandLineSetup.setupMavenExtClassPath$lambda$1(MavenCommandLineSetup::setupMavenExtClassPath$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)targetValue2, (String)"map(...)");
        this.commandLine.addParameter(targetValue2);
    }

    /*
     * WARNING - void declaration
     */
    private final void addMavenParameters(MavenRunConfiguration.MavenSettings settings, List<TargetValue<String>> mavenOptsValues) {
        String string;
        CharSequence charSequence;
        Object object;
        void $this$forEach$iv;
        Map $this$filterKeys$iv;
        MavenGeneralSettings generalSettings = this.mavenGeneralSettings(settings);
        MavenRunnerSettings runnerSettings = this.mavenRunnerSettings(settings);
        if (runnerSettings.isSkipTests()) {
            this.commandLine.addParameter("-DskipTests=true");
        }
        TargetValue targetValue = TargetValue.fixed((Object)("-Didea.version=" + MavenUtil.getIdeaVersionToPassToMavenProcess()));
        Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"fixed(...)");
        mavenOptsValues.add((TargetValue<String>)targetValue);
        String string2 = runnerSettings.getVmOptions();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVmOptions(...)");
        if (!StringsKt.isBlank((CharSequence)string2)) {
            TargetValue targetValue2 = TargetValue.fixed((Object)runnerSettings.getVmOptions());
            Intrinsics.checkNotNullExpressionValue((Object)targetValue2, (String)"fixed(...)");
            mavenOptsValues.add((TargetValue<String>)targetValue2);
        }
        ParametersList mavenPropertiesList = new ParametersList();
        Map<String, String> map = runnerSettings.getMavenProperties();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getMavenProperties(...)");
        Map<String, String> map2 = map;
        boolean $i$f$filterKeys = false;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            linkedHashMap.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = linkedHashMap;
        boolean $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            object = entry;
            boolean bl = false;
            String key = (String)object.getKey();
            String value = (String)object.getValue();
            mavenPropertiesList.addProperty(key, value);
        }
        List list = mavenPropertiesList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
        this.commandLine.addParameters(list);
        MavenRunnerParameters mavenRunnerParameters = settings.myRunnerParameters;
        if (mavenRunnerParameters == null) {
            mavenRunnerParameters = new MavenRunnerParameters();
        }
        MavenRunnerParameters runnerParameters = mavenRunnerParameters;
        for (String string3 : runnerParameters.getGoals()) {
            Intrinsics.checkNotNull((Object)string3);
            this.commandLine.addParameter(string3);
        }
        if (runnerParameters.getPomFileName() != null && !FileUtil.namesEqual((String)"pom.xml", (String)runnerParameters.getPomFileName())) {
            this.commandLine.addParameter("-f");
            String string4 = runnerParameters.getPomFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPomFileName(...)");
            this.commandLine.addParameter(string4);
        }
        String encodeProfiles = MavenExternalParameters.encodeProfiles(runnerParameters.getProfilesMap());
        Intrinsics.checkNotNull((Object)encodeProfiles);
        if (((CharSequence)encodeProfiles).length() > 0) {
            String[] stringArray = new String[]{"-P", encodeProfiles};
            this.commandLine.addParameters(stringArray);
        }
        if (generalSettings.isWorkOffline()) {
            this.commandLine.addParameter("--offline");
        }
        if (generalSettings.getOutputLevel() == MavenExecutionOptions.LoggingLevel.DEBUG) {
            this.commandLine.addParameter("--debug");
        }
        if (generalSettings.isNonRecursive()) {
            this.commandLine.addParameter("--non-recursive");
        }
        if (generalSettings.isPrintErrorStackTraces()) {
            this.commandLine.addParameter("--errors");
        }
        if (generalSettings.isAlwaysUpdateSnapshots()) {
            this.commandLine.addParameter("--update-snapshots");
        }
        if (!((charSequence = (CharSequence)(string = generalSettings.getThreads())) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String[] stringArray = new String[]{"-T", string};
            this.commandLine.addParameters(stringArray);
        }
        String string5 = StringKt.nullize((String)generalSettings.getFailureBehavior().getCommandLineOption(), (boolean)true);
        if (string5 != null) {
            Object it = object = string5;
            boolean bl = false;
            this.commandLine.addParameter((String)it);
        }
        String string6 = StringKt.nullize((String)generalSettings.getChecksumPolicy().getCommandLineOption(), (boolean)true);
        if (string6 != null) {
            Object it = object = string6;
            boolean bl = false;
            this.commandLine.addParameter((String)it);
        }
        String string7 = generalSettings.getUserSettingsFile();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getUserSettingsFile(...)");
        if (!StringsKt.isBlank((CharSequence)string7)) {
            String[] stringArray = new String[2];
            stringArray[0] = "-s";
            String string8 = generalSettings.getUserSettingsFile();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getUserSettingsFile(...)");
            stringArray[1] = this.asTargetPathString(string8);
            this.commandLine.addParameters(stringArray);
        }
        String string9 = generalSettings.getLocalRepository();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getLocalRepository(...)");
        if (!StringsKt.isBlank((CharSequence)string9)) {
            this.commandLine.addParameter("-Dmaven.repo.local=" + MavenSettingsCache.Companion.getInstance(this.project).getEffectiveUserLocalRepo());
        }
    }

    private final void setupTargetEnvironmentVariables(MavenRunConfiguration.MavenSettings settings, List<TargetValue<String>> mavenOptsValues) {
        MavenRunnerSettings runnerSettings = this.mavenRunnerSettings(settings);
        Map<String, String> map = runnerSettings.getEnvironmentProperties();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getEnvironmentProperties(...)");
        Map<String, String> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            String value = entry.getValue();
            if (Intrinsics.areEqual((Object)"MAVEN_OPTS", (Object)name)) {
                TargetValue targetValue = TargetValue.fixed((Object)value);
                Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"fixed(...)");
                mavenOptsValues.add((TargetValue<String>)targetValue);
                continue;
            }
            Intrinsics.checkNotNull((Object)name);
            this.commandLine.addEnvironmentVariable(name, value);
        }
        TargetValue targetValue = TargetValue.composite((Collection)mavenOptsValues, arg_0 -> MavenCommandLineSetup.setupTargetEnvironmentVariables$lambda$2(MavenCommandLineSetup::setupTargetEnvironmentVariables$lambda$1, arg_0));
        this.commandLine.addEnvironmentVariable("MAVEN_OPTS", targetValue);
    }

    private final MavenGeneralSettings mavenGeneralSettings(MavenRunConfiguration.MavenSettings settings) {
        MavenGeneralSettings mavenGeneralSettings = settings.myGeneralSettings;
        if (mavenGeneralSettings == null) {
            MavenGeneralSettings mavenGeneralSettings2 = MavenProjectsManager.getInstance(this.project).getGeneralSettings();
            mavenGeneralSettings = mavenGeneralSettings2;
            Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings2, (String)"getGeneralSettings(...)");
        }
        return mavenGeneralSettings;
    }

    private final MavenRunnerSettings mavenRunnerSettings(MavenRunConfiguration.MavenSettings settings) {
        MavenRunnerSettings mavenRunnerSettings = settings.myRunnerSettings;
        if (mavenRunnerSettings == null) {
            MavenRunnerSettings mavenRunnerSettings2 = MavenRunner.getInstance(this.project).getState();
            mavenRunnerSettings = mavenRunnerSettings2;
            Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerSettings2, (String)"getState(...)");
        }
        return mavenRunnerSettings;
    }

    private final TargetValue<String> upload(TargetEnvironment.UploadRoot uploadRoot, String uploadPathString, String uploadRelativePath) {
        DeferredTargetValue result = new DeferredTargetValue((Object)uploadPathString);
        Collection collection = this.dependingOnEnvironmentPromise;
        collection.add(this.environmentPromise.then(arg_0 -> MavenCommandLineSetup.upload$lambda$1(arg_0 -> MavenCommandLineSetup.upload$lambda$0(uploadRoot, uploadRelativePath, result, arg_0), arg_0)));
        return (TargetValue)result;
    }

    private final TargetEnvironment.UploadRoot createUploadRoot(LanguageRuntimeType.VolumeDescriptor volumeDescriptor, Path localRootPath) {
        return MavenRuntimeTargetConfiguration.Companion.createUploadRoot(this.defaultMavenRuntimeConfiguration, this.request, volumeDescriptor, localRootPath);
    }

    private final void setupTargetProjectDirectories(MavenRunConfiguration.MavenSettings settings) {
        String commonAncestor;
        Object[] it;
        Object[] objectArray;
        MavenProjectsManager mavenProjectsManager;
        block9: {
            block8: {
                mavenProjectsManager = MavenProjectsManager.getInstance(this.project);
                objectArray = settings.myRunnerParameters;
                if (settings.myRunnerParameters == null) break block8;
                it = objectArray;
                boolean bl = false;
                VirtualFile virtualFile = VfsUtil.findFile((Path)Path.of(it.getWorkingDirPath(), new String[0]), (boolean)false);
                objectArray = virtualFile;
                if (virtualFile != null) break block9;
            }
            Object[] objectArray2 = new Object[]{this.name};
            throw new CantRunException(RunnerBundle.message("maven.target.message.unable.to.use.working.directory", objectArray2));
        }
        Object[] file2 = objectArray;
        Module module = (Module)ReadAction.compute(() -> MavenCommandLineSetup.setupTargetProjectDirectories$lambda$1(this, (VirtualFile)file2));
        if (module == null) {
            Object[] objectArray3 = new Object[]{this.name};
            throw new CantRunException(RunnerBundle.message("maven.target.message.unable.to.find.maven.project.for.working.directory", objectArray3));
        }
        Module module2 = module;
        MavenProject mavenProject = mavenProjectsManager.findProject(module2);
        if (mavenProject == null) {
            it = new Object[]{this.name};
            throw new CantRunException(RunnerBundle.message("maven.target.message.unable.to.find.maven.project.for.working.directory", it));
        }
        MavenProject mavenProject2 = mavenProject;
        String string = FileUtil.toSystemDependentName((String)mavenProject2.getDirectory());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        String mavenProjectDirectory = string;
        Intrinsics.checkNotNull((Object)mavenProjectsManager);
        Set<String> pathsToUpload = this.findPathsToUpload(mavenProjectsManager, mavenProject2);
        String string2 = commonAncestor = this.findCommonAncestor(pathsToUpload);
        Intrinsics.checkNotNull((Object)string2);
        Path uploadPath = Paths.get(FileUtil.toSystemDependentName((String)string2), new String[0]);
        LanguageRuntimeType.VolumeDescriptor volumeDescriptor = MavenRuntimeTypeConstants.getPROJECT_FOLDER_VOLUME();
        Intrinsics.checkNotNull((Object)uploadPath);
        TargetEnvironment.UploadRoot uploadRoot = this.createUploadRoot(volumeDescriptor, uploadPath);
        ((Collection)this.request.getUploadVolumes()).add(uploadRoot);
        char targetFileSeparator = this.request.getTargetPlatform().getPlatform().fileSeparator;
        TargetValue targetWorkingDirectory = null;
        for (String path : pathsToUpload) {
            String string3;
            String workingDirRelativePath;
            String relativePath;
            String string4 = relativePath = FileUtil.getRelativePath((String)commonAncestor, (String)path, (char)File.separatorChar);
            Intrinsics.checkNotNull((Object)string4);
            TargetValue<String> targetValue = this.upload(uploadRoot, path, string4);
            if (targetWorkingDirectory != null || !FileUtil.isAncestor((String)path, (String)mavenProjectDirectory, (boolean)false)) continue;
            Intrinsics.checkNotNull((Object)FileUtil.getRelativePath((String)path, (String)mavenProjectDirectory, (char)File.separatorChar));
            if (Intrinsics.areEqual((Object)workingDirRelativePath, (Object)".")) {
                string3 = "";
            } else {
                String string5 = FileUtil.toSystemDependentName((String)workingDirRelativePath, (char)targetFileSeparator);
                string3 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toSystemDependentName(...)");
            }
            String targetWorkingDirRelativePath = string3;
            targetWorkingDirectory = TargetValue.map(targetValue, arg_0 -> MavenCommandLineSetup.setupTargetProjectDirectories$lambda$3(arg_0 -> MavenCommandLineSetup.setupTargetProjectDirectories$lambda$2(targetFileSeparator, targetWorkingDirRelativePath, arg_0), arg_0));
        }
        TargetValue targetValue = targetWorkingDirectory;
        Intrinsics.checkNotNull(targetValue);
        this.commandLine.setWorkingDirectory(targetValue);
    }

    private final String findCommonAncestor(Set<String> paths) {
        boolean bl;
        File commonRoot = null;
        for (String path : paths) {
            File file2 = commonRoot;
            commonRoot = file2 == null ? new File(path) : FileUtil.findAncestor((File)file2, (File)new File(path));
            if (commonRoot != null) continue;
            boolean bl2 = false;
            String string = "no common root found";
            throw new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = commonRoot != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        File file3 = commonRoot;
        Intrinsics.checkNotNull(file3);
        return file3.getPath();
    }

    private final Set<String> findPathsToUpload(MavenProjectsManager mavenProjectsManager, MavenProject project) {
        MavenProject mavenProject = mavenProjectsManager.findRootProject(project);
        if (mavenProject == null) {
            return SetsKt.emptySet();
        }
        MavenProject rootProject = mavenProject;
        LinkedList projects2 = new LinkedList();
        ((Collection)projects2).add(rootProject);
        projects2.addAll(this.findAllInheritors(mavenProjectsManager, rootProject));
        Set paths = new HashSet();
        while (!((Collection)projects2).isEmpty()) {
            String projectDirectory;
            boolean bl;
            block5: {
                MavenProject mavenProject2;
                MavenProject mavenProject3 = mavenProject2 = (MavenProject)projects2.pop();
                Intrinsics.checkNotNull((Object)mavenProject3);
                Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemDependentName((String)mavenProject3.getDirectory()), (String)"toSystemDependentName(...)");
                Iterable $this$any$iv = paths;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!FileUtil.isAncestor((String)it, (String)projectDirectory, (boolean)false)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            paths.removeIf(arg_0 -> MavenCommandLineSetup.findPathsToUpload$lambda$2(arg_0 -> MavenCommandLineSetup.findPathsToUpload$lambda$1(projectDirectory, arg_0), arg_0));
            paths.add(projectDirectory);
        }
        return paths;
    }

    private final List<MavenProject> findAllInheritors(MavenProjectsManager mavenProjectsManager, MavenProject project) {
        Collection<MavenProject> collection = mavenProjectsManager.findInheritors(project);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"findInheritors(...)");
        Collection<MavenProject> inheritors = collection;
        ArrayList<MavenProject> result = new ArrayList<MavenProject>(inheritors);
        for (MavenProject inheritor : inheritors) {
            Collection collection2 = result;
            Intrinsics.checkNotNull((Object)inheritor);
            CollectionsKt.addAll((Collection)collection2, (Iterable)this.findAllInheritors(mavenProjectsManager, inheritor));
        }
        return result;
    }

    private final String joinPath(String[] segments) {
        String string = ((StringBuilder)ArraysKt.joinTo$default((Object[])segments, (Appendable)new StringBuilder(), (CharSequence)String.valueOf(this.platform.fileSeparator), null, null, (int)0, null, null, (int)124, null)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String asTargetPathString(String $this$asTargetPathString) {
        Path path = Path.of($this$asTargetPathString, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return EelNioBridgeServiceKt.asEelPath((Path)path).toString();
    }

    @JvmOverloads
    @NotNull
    public final MavenCommandLineSetup setupCommandLine(@NotNull MavenRunConfiguration.MavenSettings settings) throws CantRunException {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return MavenCommandLineSetup.setupCommandLine$default(this, settings, false, 2, null);
    }

    private static final String setupMavenExtClassPath$lambda$0(String it) {
        return "-Dmaven.ext.class.path=" + it;
    }

    private static final String setupMavenExtClassPath$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String setupTargetEnvironmentVariables$lambda$1(Collection it) {
        Intrinsics.checkNotNull((Object)it);
        return CollectionsKt.joinToString$default((Iterable)it, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String setupTargetEnvironmentVariables$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit upload$lambda$0(TargetEnvironment.UploadRoot $uploadRoot, String $uploadRelativePath, DeferredTargetValue $result, Pair pair) {
        TargetEnvironment environment = (TargetEnvironment)pair.component1();
        TargetProgressIndicator progress = (TargetProgressIndicator)pair.component2();
        TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)MapsKt.getValue((Map)environment.getUploadVolumes(), (Object)$uploadRoot);
        String resolvedTargetPath = volume.resolveTargetPath($uploadRelativePath);
        volume.upload($uploadRelativePath, progress);
        $result.resolve((Object)resolvedTargetPath);
        return Unit.INSTANCE;
    }

    private static final Unit upload$lambda$1(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Module setupTargetProjectDirectories$lambda$1(MavenCommandLineSetup this$0, VirtualFile $file) {
        return ProjectFileIndex.getInstance((Project)this$0.project).getModuleForFile($file);
    }

    private static final String setupTargetProjectDirectories$lambda$2(char $targetFileSeparator, String $targetWorkingDirRelativePath, String it) {
        return it + $targetFileSeparator + $targetWorkingDirRelativePath;
    }

    private static final String setupTargetProjectDirectories$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean findPathsToUpload$lambda$1(String $projectDirectory, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FileUtil.isAncestor((String)$projectDirectory, (String)it, (boolean)false);
    }

    private static final boolean findPathsToUpload$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @NotNull
    public static final Key<MavenCommandLineSetup> getSetupKey() {
        return Companion.getSetupKey();
    }

    public static final /* synthetic */ Object access$calculateTargetJavaHome(MavenCommandLineSetup $this, Continuation $completion) {
        return $this.calculateTargetJavaHome((Continuation<? super String>)$completion);
    }

    static {
        Key key = Key.create((String)"org.jetbrains.idea.maven.execution.target.MavenCommandLineSetup");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        setupKey = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R/\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup$Companion;", "", "<init>", "()V", "setupKey", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/idea/maven/execution/target/MavenCommandLineSetup;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getSetupKey$annotations", "getSetupKey", "()Lcom/intellij/openapi/util/Key;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<MavenCommandLineSetup> getSetupKey() {
            return setupKey;
        }

        @JvmStatic
        public static /* synthetic */ void getSetupKey$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

