/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBaseJavaLocalInspectionTool
extends LocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of();
        if (set == null) {
            AbstractBaseJavaLocalInspectionTool.$$$reportNull$$$0(0);
        }
        return set;
    }

    public boolean isAvailableForFile(@NotNull PsiFile file) {
        if (file == null) {
            AbstractBaseJavaLocalInspectionTool.$$$reportNull$$$0(1);
        }
        for (JavaFeature feature : this.requiredFeatures()) {
            if (PsiUtil.isAvailable((JavaFeature)feature, (PsiElement)file)) continue;
            return false;
        }
        return true;
    }

    public HtmlChunk getDescriptionAddendum() {
        Set<JavaFeature> features = this.requiredFeatures();
        JavaFeature feature = (JavaFeature)ContainerUtil.getOnlyItem(features);
        if (feature != null) {
            return HtmlChunk.text((String)JavaAnalysisBundle.message("inspection.depends.on.the.java.feature", feature.getFeatureName(), feature.getMinimumLevel().getShortText())).wrapWith("p");
        }
        if (features.size() > 1) {
            int minimalVersion = features.stream().mapToInt(f -> f.getMinimumLevel().feature()).max().getAsInt();
            return HtmlChunk.p().children(new HtmlChunk[]{HtmlChunk.text((String)JavaAnalysisBundle.message("inspection.depends.on.the.java.features", new Object[0])), HtmlChunk.ul().children(features.stream().map(JavaFeature::getFeatureName).sorted().map(name -> HtmlChunk.li().addText(name)).toList()), HtmlChunk.text((String)JavaAnalysisBundle.message("inspection.depends.on.the.java.features.minimal.version", minimalVersion))});
        }
        return HtmlChunk.empty();
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            AbstractBaseJavaLocalInspectionTool.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            AbstractBaseJavaLocalInspectionTool.$$$reportNull$$$0(3);
        }
        return null;
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            AbstractBaseJavaLocalInspectionTool.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            AbstractBaseJavaLocalInspectionTool.$$$reportNull$$$0(5);
        }
        return null;
    }

    public ProblemDescriptor @Nullable [] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            AbstractBaseJavaLocalInspectionTool.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            AbstractBaseJavaLocalInspectionTool.$$$reportNull$$$0(7);
        }
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            AbstractBaseJavaLocalInspectionTool.$$$reportNull$$$0(8);
        }
        return new JavaElementVisitor(){

            public void visitMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethod(method);
                this.addDescriptors(AbstractBaseJavaLocalInspectionTool.this.checkMethod(method, holder.getManager(), isOnTheFly));
            }

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitClass(aClass);
                this.addDescriptors(AbstractBaseJavaLocalInspectionTool.this.checkClass(aClass, holder.getManager(), isOnTheFly));
            }

            public void visitField(@NotNull PsiField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitField(field);
                this.addDescriptors(AbstractBaseJavaLocalInspectionTool.this.checkField(field, holder.getManager(), isOnTheFly));
            }

            public void visitFile(@NotNull PsiFile psiFile) {
                if (psiFile == null) {
                    1.$$$reportNull$$$0(3);
                }
                super.visitFile(psiFile);
                this.addDescriptors(AbstractBaseJavaLocalInspectionTool.this.checkFile(psiFile, holder.getManager(), isOnTheFly));
            }

            private void addDescriptors(ProblemDescriptor[] descriptors) {
                if (descriptors != null) {
                    for (ProblemDescriptor descriptor : descriptors) {
                        holder.registerProblem(descriptor);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

