/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
public final class JdkApiCompatibilityService {
    private static final Logger LOG = Logger.getInstance(JdkApiCompatibilityService.class);
    @NotNull
    private static final LanguageLevel FIRST_PREVIEW_API_LEVEL = LanguageLevel.JDK_13;
    private final Map<LanguageLevel, List<String>> cache = new ConcurrentHashMap<LanguageLevel, List<String>>();

    public static JdkApiCompatibilityService getInstance() {
        return (JdkApiCompatibilityService)ApplicationManager.getApplication().getService(JdkApiCompatibilityService.class);
    }

    @Nullable
    public LanguageLevel firstCompatibleLanguageLevel(@NotNull PsiMember member, @NotNull LanguageLevel contextLanguageLevel) {
        LanguageLevel targetLevel;
        LevelInfo info;
        if (member == null) {
            JdkApiCompatibilityService.$$$reportNull$$$0(0);
        }
        if (contextLanguageLevel == null) {
            JdkApiCompatibilityService.$$$reportNull$$$0(1);
        }
        if ((info = this.firstCompatibleLanguageLevelInfo(member, contextLanguageLevel)) == null) {
            return null;
        }
        LanguageLevel languageLevel = targetLevel = info.outOfPreviewLevel() == null ? info.firstAppearLevel() : info.outOfPreviewLevel();
        if (contextLanguageLevel.isLessThan(targetLevel)) {
            return targetLevel;
        }
        return null;
    }

    @Nullable
    public LevelInfo firstCompatibleLanguageLevelInfo(@NotNull PsiMember member, @NotNull LanguageLevel contextLanguageLevel) {
        PsiMethod method;
        PsiClass clazz;
        if (member == null) {
            JdkApiCompatibilityService.$$$reportNull$$$0(2);
        }
        if (contextLanguageLevel == null) {
            JdkApiCompatibilityService.$$$reportNull$$$0(3);
        }
        if (member instanceof PsiAnonymousClass) {
            return null;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass instanceof PsiAnonymousClass) {
            return null;
        }
        if (member instanceof PsiClass && PsiUtil.isLocalClass((PsiClass)(clazz = (PsiClass)member))) {
            return null;
        }
        ArrayList<Object> membersToCheck = new ArrayList<Object>();
        membersToCheck.add(member);
        if (member instanceof PsiMethod && !(method = (PsiMethod)member).isConstructor()) {
            membersToCheck.addAll(Arrays.asList(method.findSuperMethods()));
        }
        LanguageLevel incompatibleLevelForContext = contextLanguageLevel.next();
        LevelInfo lowestCompatibleLanguageLevel = null;
        for (PsiMember psiMember : membersToCheck) {
            String signature = this.getSignature(psiMember);
            if (signature == null) {
                return null;
            }
            LevelInfo compatibleLanguageLevelForMember = this.getIntroducedApiLevel(signature, incompatibleLevelForContext);
            if (compatibleLanguageLevelForMember == null) {
                return null;
            }
            if (lowestCompatibleLanguageLevel != null && !compatibleLanguageLevelForMember.isLessThan(lowestCompatibleLanguageLevel)) continue;
            lowestCompatibleLanguageLevel = compatibleLanguageLevelForMember;
        }
        return lowestCompatibleLanguageLevel;
    }

    @NotNull
    private List<String> getIntroducedApis(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            JdkApiCompatibilityService.$$$reportNull$$$0(4);
        }
        List list = this.cache.computeIfAbsent(languageLevel, level -> {
            String featureString = level.toJavaVersion().toFeatureString();
            List result = Collections.emptyList();
            URL resource = JdkApiCompatibilityService.class.getResource("api" + featureString + ".txt");
            if (resource != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
                    result = FileUtil.loadLines((BufferedReader)reader);
                }
                catch (IOException ex) {
                    LOG.error("Cannot load: " + resource.getFile(), (Throwable)ex);
                }
            }
            return result;
        });
        if (list == null) {
            JdkApiCompatibilityService.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Contract(value="_, null -> null")
    @Nullable
    private LevelInfo getIntroducedApiLevel(@NotNull String signature, @Nullable LanguageLevel languageLevel) {
        if (signature == null) {
            JdkApiCompatibilityService.$$$reportNull$$$0(6);
        }
        if (languageLevel == null) {
            return null;
        }
        LanguageLevel curLevel = LanguageLevel.HIGHEST;
        do {
            if (this.getIntroducedApis(curLevel).contains(signature)) {
                for (LanguageLevel maybePreview = languageLevel.previous(); maybePreview != null && maybePreview.isAtLeast(FIRST_PREVIEW_API_LEVEL); maybePreview = maybePreview.previous()) {
                    if (!this.getIntroducedApis(maybePreview).contains(signature)) continue;
                    return new LevelInfo(maybePreview, curLevel);
                }
                return new LevelInfo(curLevel, null);
            }
            if (languageLevel != curLevel) continue;
            return null;
        } while ((curLevel = curLevel.previous()) != null);
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public String getSignature(@Nullable PsiMember member) {
        if (member instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)member;
            return psiClass.getQualifiedName();
        }
        if (member instanceof PsiField) {
            String containingClass = this.getSignature((PsiMember)member.getContainingClass());
            return containingClass == null ? null : containingClass + "#" + member.getName();
        }
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            String containingClass = this.getSignature((PsiMember)member.getContainingClass());
            if (containingClass == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(containingClass);
            buf.append('#');
            buf.append(method.getName());
            buf.append('(');
            for (PsiType type : method.getSignature(PsiSubstitutor.EMPTY).getParameterTypes()) {
                buf.append(type.getCanonicalText());
                buf.append(";");
            }
            buf.append(')');
            return buf.toString();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLanguageLevel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/JdkApiCompatibilityService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/JdkApiCompatibilityService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntroducedApis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "firstCompatibleLanguageLevel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "firstCompatibleLanguageLevelInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIntroducedApis";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIntroducedApiLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public record LevelInfo(@NotNull LanguageLevel firstAppearLevel, @Nullable LanguageLevel outOfPreviewLevel) {
        @NotNull
        private final LanguageLevel firstAppearLevel;

        public LevelInfo(@NotNull LanguageLevel firstAppearLevel, @Nullable LanguageLevel outOfPreviewLevel) {
            if (firstAppearLevel == null) {
                LevelInfo.$$$reportNull$$$0(0);
            }
        }

        boolean isLessThan(LevelInfo level) {
            return this.firstAppearLevel.isLessThan(level.firstAppearLevel) || this.firstAppearLevel == level.firstAppearLevel && Comparator.nullsFirst(Comparator.naturalOrder()).compare(this.outOfPreviewLevel, level.outOfPreviewLevel) < 0;
        }

        @NotNull
        public LanguageLevel firstAppearLevel() {
            LanguageLevel languageLevel = this.firstAppearLevel;
            if (languageLevel == null) {
                LevelInfo.$$$reportNull$$$0(1);
            }
            return languageLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstAppearLevel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/module/JdkApiCompatibilityService$LevelInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/module/JdkApiCompatibilityService$LevelInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "firstAppearLevel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

