/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.JdkApiCompatibilityService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiMember;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageLevelUtil {
    private LanguageLevelUtil() {
    }

    @Nullable
    public static LanguageLevel getCustomLanguageLevel(@NotNull Module module) {
        LanguageLevelModuleExtension moduleExtension;
        if (module == null) {
            LanguageLevelUtil.$$$reportNull$$$0(0);
        }
        return (moduleExtension = (LanguageLevelModuleExtension)ModuleRootManager.getInstance((Module)module).getModuleExtension(LanguageLevelModuleExtension.class)) != null ? moduleExtension.getLanguageLevel() : null;
    }

    @NotNull
    public static LanguageLevel getEffectiveLanguageLevel(@NotNull Module module) {
        LanguageLevel level;
        if (module == null) {
            LanguageLevelUtil.$$$reportNull$$$0(1);
        }
        if ((level = LanguageLevelUtil.getCustomLanguageLevel(module)) != null) {
            LanguageLevel languageLevel = level;
            if (languageLevel == null) {
                LanguageLevelUtil.$$$reportNull$$$0(2);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevelProjectExtension.getInstance((Project)module.getProject()).getLanguageLevel();
        if (languageLevel == null) {
            LanguageLevelUtil.$$$reportNull$$$0(3);
        }
        return languageLevel;
    }

    @Deprecated(forRemoval=true)
    public static String getJdkName(LanguageLevel languageLevel) {
        return languageLevel.getShortText();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static LanguageLevel getNextLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            LanguageLevelUtil.$$$reportNull$$$0(4);
        }
        return languageLevel.next();
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static String getShortMessage(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            LanguageLevelUtil.$$$reportNull$$$0(5);
        }
        String string = languageLevel.toJavaVersion().toFeatureString();
        if (string == null) {
            LanguageLevelUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static LanguageLevel getLastIncompatibleLanguageLevel(@NotNull PsiMember member, @NotNull LanguageLevel languageLevel) {
        LanguageLevel firstCompatibleLanguageLevel;
        if (member == null) {
            LanguageLevelUtil.$$$reportNull$$$0(7);
        }
        if (languageLevel == null) {
            LanguageLevelUtil.$$$reportNull$$$0(8);
        }
        if ((firstCompatibleLanguageLevel = JdkApiCompatibilityService.getInstance().firstCompatibleLanguageLevel(member, languageLevel)) == null) {
            return null;
        }
        return firstCompatibleLanguageLevel.previous();
    }

    @Deprecated(forRemoval=true)
    public static Set<String> loadSignatureList(@NotNull URL resource) {
        HashSet<String> hashSet;
        if (resource == null) {
            LanguageLevelUtil.$$$reportNull$$$0(9);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));
        try {
            hashSet = new HashSet<String>(FileUtil.loadLines((BufferedReader)reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                Logger.getInstance(LanguageLevelUtil.class).warn("cannot load: " + resource.getFile(), (Throwable)ex);
                return Collections.emptySet();
            }
        }
        reader.close();
        return hashSet;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static String getSignature(@Nullable PsiMember member) {
        return JdkApiCompatibilityService.getInstance().getSignature(member);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/LanguageLevelUtil";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/LanguageLevelUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveLanguageLevel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomLanguageLevel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveLanguageLevel";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNextLanguageLevel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getShortMessage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLastIncompatibleLanguageLevel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadSignatureList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

