/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uast;

import com.intellij.psi.HintedPsiElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u001bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/intellij/uast/SimpleUastHintedVisitorAdapter;", "Lcom/intellij/psi/PsiElementVisitor;", "Lcom/intellij/psi/HintedPsiElementVisitor;", "plugin", "Lorg/jetbrains/uast/UastLanguagePlugin;", "visitor", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "uElementTypesHint", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "directOnly", "", "<init>", "(Lorg/jetbrains/uast/UastLanguagePlugin;Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;Ljava/lang/Class;Z)V", "getPlugin", "()Lorg/jetbrains/uast/UastLanguagePlugin;", "getVisitor", "()Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "getUElementTypesHint", "()Ljava/lang/Class;", "getDirectOnly", "()Z", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "getHintPsiElements", "", "intellij.java.analysis"})
final class SimpleUastHintedVisitorAdapter
extends PsiElementVisitor
implements HintedPsiElementVisitor {
    @NotNull
    private final UastLanguagePlugin plugin;
    @NotNull
    private final AbstractUastNonRecursiveVisitor visitor;
    @NotNull
    private final Class<? extends UElement> uElementTypesHint;
    private final boolean directOnly;

    public SimpleUastHintedVisitorAdapter(@NotNull UastLanguagePlugin plugin, @NotNull AbstractUastNonRecursiveVisitor visitor, @NotNull Class<? extends UElement> uElementTypesHint, boolean directOnly) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter(uElementTypesHint, (String)"uElementTypesHint");
        this.plugin = plugin;
        this.visitor = visitor;
        this.uElementTypesHint = uElementTypesHint;
        this.directOnly = directOnly;
    }

    @NotNull
    public final UastLanguagePlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final AbstractUastNonRecursiveVisitor getVisitor() {
        return this.visitor;
    }

    @NotNull
    public final Class<? extends UElement> getUElementTypesHint() {
        return this.uElementTypesHint;
    }

    public final boolean getDirectOnly() {
        return this.directOnly;
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UElement uElement = this.plugin.convertElementWithParent(element, this.uElementTypesHint);
        if (uElement == null) {
            return;
        }
        UElement uElement2 = uElement;
        if (!this.directOnly || uElement2.getSourcePsi() == element) {
            uElement2.accept((UastVisitor)this.visitor);
        }
    }

    @NotNull
    public List<Class<?>> getHintPsiElements() {
        Class[] classArray = new Class[]{this.uElementTypesHint};
        return this.plugin.getPossiblePsiSourceTypes(classArray).toList();
    }
}

