/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ExtendableSettingsEditor<T>
extends SettingsEditor<T> {
    private final SettingsEditor<T> myMainEditor;
    private final List<SettingsEditor<T>> myExtensionEditors;

    public ExtendableSettingsEditor(SettingsEditor<T> mainEditor) {
        this.myMainEditor = mainEditor;
        Disposer.register((Disposable)this, this.myMainEditor);
        this.myExtensionEditors = new ArrayList<SettingsEditor<T>>();
    }

    @Override
    protected void resetEditorFrom(@NotNull T s) {
        if (s == null) {
            ExtendableSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myMainEditor.resetFrom(s);
        for (SettingsEditor<T> extensionEditor : this.myExtensionEditors) {
            extensionEditor.resetFrom(s);
        }
    }

    @Override
    protected void applyEditorTo(@NotNull T s) throws ConfigurationException {
        if (s == null) {
            ExtendableSettingsEditor.$$$reportNull$$$0(1);
        }
        this.myMainEditor.applyTo(s);
        for (SettingsEditor<T> extensionEditor : this.myExtensionEditors) {
            extensionEditor.applyTo(s);
        }
    }

    public void addExtensionEditor(@NotNull SettingsEditor<T> extensionSettingsEditor) {
        if (extensionSettingsEditor == null) {
            ExtendableSettingsEditor.$$$reportNull$$$0(2);
        }
        this.myExtensionEditors.add(extensionSettingsEditor);
        Disposer.register((Disposable)this, extensionSettingsEditor);
    }

    @Override
    @NotNull
    protected JComponent createEditor() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        JComponent mainEditorComponent = this.myMainEditor.getComponent();
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBInsets.emptyInsets(), 0, 0);
        result.add((Component)mainEditorComponent, c);
        for (int i = 0; i < this.myExtensionEditors.size(); ++i) {
            c = (GridBagConstraints)c.clone();
            c.gridy = i + 1;
            result.add((Component)this.myExtensionEditors.get(i).getComponent(), c);
        }
        JPanel jPanel = result;
        if (jPanel == null) {
            ExtendableSettingsEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionSettingsEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ExtendableSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ExtendableSettingsEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionEditor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

