/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.proxy;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.proxy.CommonProxyCompatibility;
import com.intellij.util.proxy.NonStaticAuthenticator;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class CommonProxy
extends ProxySelector {
    static final Logger LOG = Logger.getInstance(CommonProxy.class);
    private static final CommonProxy ourInstance = new CommonProxy();
    @Deprecated
    @ApiStatus.Internal
    public static final List<Proxy> NO_PROXY_LIST = Collections.singletonList(Proxy.NO_PROXY);
    private static final long ourErrorInterval = TimeUnit.MINUTES.toMillis(3L);
    private static final AtomicInteger ourNotificationCount = new AtomicInteger();
    private static volatile long ourErrorTime;
    private static volatile ProxySelector ourWrong;
    private static final AtomicReference<Map<String, String>> ourProps;
    private final Object myLock = new Object();
    private final Map<String, AccessToken> myCustomAuthRegistrations = new HashMap<String, AccessToken>();

    public static CommonProxy getInstance() {
        return ourInstance;
    }

    private CommonProxy() {
        this.ensureAuthenticator();
    }

    @Deprecated
    public static void isInstalledAssertion() {
        ProxySelector aDefault = ProxySelector.getDefault();
        if (CommonProxyCompatibility.mainProxySelector != null && CommonProxyCompatibility.mainProxySelector != aDefault) {
            if (ourWrong != aDefault || CommonProxy.itsTime()) {
                LOG.error("ProxySelector.setDefault() was changed to [" + aDefault.toString() + "] - other than com.intellij.util.proxy.CommonProxy.myMainProxySelector.\nThis will make some " + ApplicationNamesInfo.getInstance().getProductName() + " network calls fail.\nInstead, methods of com.intellij.util.net.ProxyService should be used for proxying.");
                ourWrong = aDefault;
            }
            ProxySelector.setDefault(CommonProxyCompatibility.mainProxySelector);
            ourInstance.ensureAuthenticator();
        }
        CommonProxy.assertSystemPropertiesSet();
    }

    private static boolean itsTime() {
        boolean b;
        boolean bl = b = System.currentTimeMillis() - ourErrorTime > ourErrorInterval && ourNotificationCount.get() < 5;
        if (b) {
            ourErrorTime = System.currentTimeMillis();
            ourNotificationCount.incrementAndGet();
        }
        return b;
    }

    private static void assertSystemPropertiesSet() {
        Map<String, String> props = CommonProxy.getOldStyleProperties();
        Map<String, String> was = ourProps.get();
        if (Comparing.equal(was, props) && !CommonProxy.itsTime()) {
            return;
        }
        ourProps.set(props);
        String message = CommonProxy.getMessageFromProps(props);
        if (message != null) {
            LOG.info(message);
        }
    }

    @NlsContexts.DialogMessage
    @ApiStatus.Internal
    @Nullable
    public static String getMessageFromProps(Map<String, String> props) {
        String message = null;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (Strings.isEmptyOrSpaces((CharSequence)entry.getValue())) continue;
            message = IdeCoreBundle.message("proxy.old.way.label", entry.getKey(), entry.getValue());
            break;
        }
        return message;
    }

    @ApiStatus.Internal
    public static Map<String, String> getOldStyleProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("http.proxyHost", System.getProperty("http.proxyHost"));
        props.put("https.proxyHost", System.getProperty("https.proxyHost"));
        props.put("socksProxyHost", System.getProperty("socksProxyHost"));
        return props;
    }

    @Deprecated
    @ApiStatus.Internal
    public void ensureAuthenticator() {
        if (CommonProxyCompatibility.mainAuthenticator != null) {
            Authenticator.setDefault(CommonProxyCompatibility.mainAuthenticator);
        } else {
            LOG.warn("main authenticator is not yet registered");
        }
    }

    @Deprecated
    @ApiStatus.Internal
    public void removeNoProxy(@NotNull String protocol, @NotNull String host, int port) {
        if (protocol == null) {
            CommonProxy.$$$reportNull$$$0(0);
        }
        if (host == null) {
            CommonProxy.$$$reportNull$$$0(1);
        }
    }

    @Deprecated
    @ApiStatus.Internal
    public void noAuthentication(@NotNull String protocol, @NotNull String host, int port) {
        if (protocol == null) {
            CommonProxy.$$$reportNull$$$0(2);
        }
        if (host == null) {
            CommonProxy.$$$reportNull$$$0(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setCustomAuth(@NotNull String key, @NotNull NonStaticAuthenticator nonStaticAuthenticator) {
        if (key == null) {
            CommonProxy.$$$reportNull$$$0(4);
        }
        if (nonStaticAuthenticator == null) {
            CommonProxy.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            Function1<? super Authenticator, ? extends AccessToken> register = CommonProxyCompatibility.registerCustomAuthenticator;
            if (register != null) {
                LOG.debug("custom auth set: " + key + ", " + String.valueOf(nonStaticAuthenticator));
                this.myCustomAuthRegistrations.put(key, (AccessToken)register.invoke((Object)nonStaticAuthenticator.asAuthenticator()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeCustomAuth(@NotNull String key) {
        if (key == null) {
            CommonProxy.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.debug("custom auth removed: " + key);
            AccessToken registration = this.myCustomAuthRegistrations.remove(key);
            if (registration != null) {
                registration.finish();
            }
        }
    }

    @NotNull
    public List<Proxy> select(@NotNull URL url) {
        if (url == null) {
            CommonProxy.$$$reportNull$$$0(7);
        }
        List<Proxy> list = this.select(CommonProxy.createUri(url));
        if (list == null) {
            CommonProxy.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Proxy> select(@Nullable URI uri) {
        ProxySelector mainProxySelector = CommonProxyCompatibility.mainProxySelector;
        if (mainProxySelector == null) {
            LOG.warn("main proxy selector is not yet installed");
            List<Proxy> list = NO_PROXY_LIST;
            if (list == null) {
                CommonProxy.$$$reportNull$$$0(9);
            }
            return list;
        }
        CommonProxy.isInstalledAssertion();
        if (uri == null) {
            List<Proxy> list = NO_PROXY_LIST;
            if (list == null) {
                CommonProxy.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<Proxy> list = mainProxySelector.select(uri);
        if (list == null) {
            CommonProxy.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        ProxySelector mainProxySelector = CommonProxyCompatibility.mainProxySelector;
        if (mainProxySelector == null) {
            return;
        }
        mainProxySelector.connectFailed(uri, sa, ioe);
    }

    @Deprecated
    public Authenticator getAuthenticator() {
        return CommonProxyCompatibility.mainAuthenticator != null ? CommonProxyCompatibility.mainAuthenticator : Authenticator.getDefault();
    }

    @Deprecated
    public static String getHostNameReliably(String requestingHost, InetAddress site, URL requestingUrl) {
        String host = requestingHost;
        if (host == null) {
            if (site != null) {
                host = site.getHostName();
            } else if (requestingUrl != null) {
                host = requestingUrl.getHost();
            }
        }
        host = host == null ? "" : host;
        return host;
    }

    private static URI createUri(URL url) {
        return VfsUtil.toUri((String)url.toString());
    }

    static {
        ourProps = new AtomicReference();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonStaticAuthenticator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/proxy/CommonProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/proxy/CommonProxy";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeNoProxy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "noAuthentication";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCustomAuth";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeCustomAuth";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    @Deprecated
    public static final class HostInfo {
        public final String myProtocol;
        public final String myHost;
        public final int myPort;

        public HostInfo(@Nullable String protocol, @NotNull String host, int port) {
            if (host == null) {
                HostInfo.$$$reportNull$$$0(0);
            }
            this.myPort = port;
            this.myHost = host;
            this.myProtocol = protocol;
        }

        public String getProtocol() {
            return this.myProtocol;
        }

        public String getHost() {
            return this.myHost;
        }

        public int getPort() {
            return this.myPort;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostInfo info = (HostInfo)o;
            return this.myPort == info.myPort && this.myHost.equals(info.myHost) && Objects.equals(this.myProtocol, info.myProtocol);
        }

        public int hashCode() {
            int result = this.myProtocol != null ? this.myProtocol.hashCode() : 0;
            result = 31 * result + this.myHost.hashCode();
            result = 31 * result + this.myPort;
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/proxy/CommonProxy$HostInfo", "<init>"));
        }
    }
}

