/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils.indexes;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/performancePlugin/utils/indexes/CurrentIndexedFileResolver;", "", "<init>", "()V", "getAllToBeIndexedFilesInProject", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.performanceTesting"})
public final class CurrentIndexedFileResolver {
    @NotNull
    public static final CurrentIndexedFileResolver INSTANCE = new CurrentIndexedFileResolver();

    private CurrentIndexedFileResolver() {
    }

    @NotNull
    public final Map<IndexableFilesIterator, Set<VirtualFile>> getAllToBeIndexedFilesInProject(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.setText(PerformanceTestingBundle.message("checking.shared.indexes.collecting.all.indexed.files", new Object[0]));
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        HashMap providerToFiles = new HashMap();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexEx");
        List list = ((FileBasedIndexEx)fileBasedIndex).getIndexableFilesProviders(project);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIndexableFilesProviders(...)");
        List providers = list;
        IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
        Intrinsics.checkNotNullExpressionValue((Object)indexableFilesDeduplicateFilter, (String)"create(...)");
        IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter2 = indexableFilesDeduplicateFilter;
        Iterator iterator2 = ((Iterable)providers).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int finished = n++;
            IndexableFilesIterator provider = (IndexableFilesIterator)iterator2.next();
            indicator.checkCanceled();
            HashSet providerFiles = new HashSet();
            if (!provider.iterateFiles(project, arg_0 -> CurrentIndexedFileResolver.getAllToBeIndexedFilesInProject$lambda$0(providerFiles, arg_0), (VirtualFileFilter)indexableFilesDeduplicateFilter2)) break;
            indicator.setFraction((double)(finished + 1) * 1.0 / (double)providers.size());
            ((Map)providerToFiles).put(provider, providerFiles);
        }
        return providerToFiles;
    }

    private static final boolean getAllToBeIndexedFilesInProject$lambda$0(HashSet $providerFiles, VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        if (!fileOrDir.isDirectory()) {
            ((Collection)$providerFiles).add(fileOrDir);
        }
        return true;
    }
}

