/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import com.intellij.rt.debugger.agent.ClassTransformer;
import com.intellij.rt.debugger.agent.CollectionBreakpointStorage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.capture.org.objectweb.asm.ClassVisitor;
import org.jetbrains.capture.org.objectweb.asm.Label;
import org.jetbrains.capture.org.objectweb.asm.MethodVisitor;
import org.jetbrains.capture.org.objectweb.asm.Type;
import org.jetbrains.capture.org.objectweb.asm.commons.LocalVariablesSorter;
import org.jetbrains.capture.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.capture.org.objectweb.asm.tree.InsnList;
import org.jetbrains.capture.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.capture.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.capture.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.capture.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.capture.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.capture.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.capture.org.objectweb.asm.tree.VarInsnNode;

public class CollectionBreakpointInstrumentor {
    private static final String OBJECT_TYPE = "Ljava/lang/Object;";
    private static final String STRING_TYPE = "Ljava/lang/String;";
    private static final String MULTISET_TYPE = "Lcom/intellij/rt/debugger/agent/CollectionBreakpointInstrumentor$Multiset;";
    private static final String PAIR_TYPE = "Lcom/intellij/rt/debugger/agent/CollectionBreakpointInstrumentor$Pair;";
    private static final String COLLECTION_TYPE = "java/util/Collection";
    private static final String MAP_TYPE = "java/util/Map";
    private static final String ABSTRACT_COLLECTION_TYPE = "java/util/AbstractCollection";
    private static final String ABSTRACT_LIST_TYPE = "java/util/AbstractList";
    private static final String ARRAY_LIST_TYPE = "java/util/ArrayList";
    private static final String CAPTURE_COLLECTION_MODIFICATION_METHOD_NAME = "captureCollectionModification";
    private static final String CAPTURE_COLLECTION_MODIFICATION_METHOD_DESC = "(ZZLjava/lang/Object;Ljava/lang/Object;Z)V";
    private static final String CAPTURE_COLLECTION_MODIFICATION_DEFAULT_METHOD_NAME = "captureCollectionModification";
    private static final String CAPTURE_COLLECTION_MODIFICATION_DEFAULT_METHOD_DESC = "(Lcom/intellij/rt/debugger/agent/CollectionBreakpointInstrumentor$Multiset;Ljava/lang/Object;)V";
    private static final String CAPTURE_FIELD_MODIFICATION_METHOD_NAME = "captureFieldModification";
    private static final String CAPTURE_FIELD_MODIFICATION_METHOD_DESC = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Z)V";
    private static final String ON_CAPTURE_START_METHOD_NAME = "onCaptureStart";
    private static final String ON_CAPTURE_START_METHOD_DESC = "(Ljava/lang/Object;Z)Z";
    private static final String ON_CAPTURE_END_METHOD_NAME = "onCaptureEnd";
    private static final String ON_CAPTURE_END_METHOD_DESC = "(Ljava/lang/Object;Z)V";
    private static final String CAPTURE_COLLECTION_COPY_METHOD_NAME = "captureCollectionCopy";
    private static final String CAPTURE_COLLECTION_COPY_METHOD_DESC = "(ZLjava/lang/Object;)Lcom/intellij/rt/debugger/agent/CollectionBreakpointInstrumentor$Multiset;";
    private static final String CONSTRUCTOR_METHOD_NAME = "<init>";
    private static final String CREATE_PAIR_METHOD_NAME = "createPair";
    private static final String CREATE_PAIR_METHOD_DESC = "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/intellij/rt/debugger/agent/CollectionBreakpointInstrumentor$Pair;";
    private static final String COLLECTION_INTERFACE_NAME = "java.util.Collection";
    private static final String MAP_INTERFACE_NAME = "java.util.Map";
    private static final String JAVA_UTIL_PACKAGE_NAME = "java.util";
    private static final String OBJECT_CLASS_NAME = "java.lang.Object";
    private static final ConcurrentIdentityHashMap myInstanceFilters = new ConcurrentIdentityHashMap();
    private static final ConcurrentHashMap<String, Set<String>> myFieldsToCapture = new ConcurrentHashMap();
    private static final Map<String, KnownMethodsSet> myKnownMethods = new HashMap<String, KnownMethodsSet>();
    private static final Set<String> myUnprocessedNestedMembers = new HashSet<String>();
    private static final Map<String, KnownMethodsSet> myCollectionsToTransform = new HashMap<String, KnownMethodsSet>();
    private static final Set<String> myClassesToTransform = new HashSet<String>();
    private static final ReentrantLock myTransformLock = new ReentrantLock();
    public static boolean DEBUG;
    private static Instrumentation ourInstrumentation;

    private static void initializeKnownMethods() {
        KnownMethodsSet collectionKnownMethods = new KnownMethodsSet();
        collectionKnownMethods.add(new ImmutableMethod("size()I"));
        collectionKnownMethods.add(new ImmutableMethod("contains(Ljava/lang/Object;)Z"));
        collectionKnownMethods.add(new ImmutableMethod("iterator()Ljava/util/Iterator;"));
        collectionKnownMethods.add(new ImmutableMethod("toArray()[Ljava/lang/Object;"));
        collectionKnownMethods.add(new ImmutableMethod("toArray([Ljava/lang/Object;)[Ljava/lang/Object;"));
        collectionKnownMethods.add(new ImmutableMethod("containsAll(Ljava/util/Collection;)Z"));
        collectionKnownMethods.add(new ImmutableMethod("toArray(Ljava/util/function/IntFunction;)[Ljava/lang/Object;"));
        collectionKnownMethods.add(new ImmutableMethod("spliterator()Ljava/util/Spliterator;"));
        collectionKnownMethods.add(new ImmutableMethod("parallelStream()Ljava/util/stream/Stream;"));
        collectionKnownMethods.add(new ImmutableMethod("equals(Ljava/lang/Object;)Z"));
        collectionKnownMethods.add(new ImmutableMethod("hashCode()I"));
        collectionKnownMethods.add(new ReturnsBooleanMethod("add(Ljava/lang/Object;)Z", true));
        collectionKnownMethods.add(new ReturnsBooleanMethod("remove(Ljava/lang/Object;)Z", false));
        myKnownMethods.put(COLLECTION_TYPE, collectionKnownMethods);
        KnownMethodsSet abstractCollectionKnownMethods = new KnownMethodsSet();
        abstractCollectionKnownMethods.add(new ImmutableMethod("toString()Ljava/lang/String;"));
        myKnownMethods.put(ABSTRACT_COLLECTION_TYPE, abstractCollectionKnownMethods);
        KnownMethodsSet abstractListKnownMethods = new KnownMethodsSet();
        abstractListKnownMethods.add(new ImmutableMethod("indexOf(Ljava/lang/Object;)I"));
        abstractListKnownMethods.add(new ImmutableMethod("lastIndexOf(Ljava/lang/Object;)I"));
        abstractListKnownMethods.add(new ImmutableMethod("listIterator()Ljava/util/ListIterator;"));
        abstractListKnownMethods.add(new ImmutableMethod("listIterator(I)Ljava/util/ListIterator;"));
        abstractListKnownMethods.add(new ImmutableMethod("subList(II)Ljava/util/List;"));
        myKnownMethods.put(ABSTRACT_LIST_TYPE, abstractListKnownMethods);
        KnownMethodsSet arrayListKnownMethods = new KnownMethodsSet();
        arrayListKnownMethods.add(new ImmutableMethod("indexOfRange(Ljava/lang/Object;II)I"));
        arrayListKnownMethods.add(new ImmutableMethod("lastIndexOfRange(Ljava/lang/Object;II)I"));
        arrayListKnownMethods.add(new ImmutableMethod("clone()Ljava/lang/Object;"));
        arrayListKnownMethods.add(new ImmutableMethod("equalsRange(Ljava/util/List;II)Z"));
        arrayListKnownMethods.add(new ImmutableMethod("equalsArrayList(Ljava/util/ArrayList;)Z"));
        arrayListKnownMethods.add(new ImmutableMethod("hashCodeRange(II)I"));
        arrayListKnownMethods.add(new ImmutableMethod("outOfBoundsMsg(I)Ljava/lang/String;"));
        myKnownMethods.put(ARRAY_LIST_TYPE, arrayListKnownMethods);
        KnownMethodsSet mapKnownMethods = new KnownMethodsSet();
        mapKnownMethods.add(new ImmutableMethod("size()I"));
        mapKnownMethods.add(new ImmutableMethod("isEmpty()Z"));
        mapKnownMethods.add(new ImmutableMethod("keySet()Ljava/util/Set;"));
        mapKnownMethods.add(new ImmutableMethod("values()Ljava/util/Collection;"));
        mapKnownMethods.add(new ImmutableMethod("entrySet()Ljava/util/Set;"));
        mapKnownMethods.add(new ImmutableMethod("containsKey(Ljava/lang/Object;)Z"));
        mapKnownMethods.add(new ImmutableMethod("containsValue(Ljava/lang/Object;)Z"));
        mapKnownMethods.add(new ImmutableMethod("equals(Ljava/lang/Object;)Z"));
        mapKnownMethods.add(new ImmutableMethod("hashCode()I"));
        mapKnownMethods.add(new PutMethod());
        mapKnownMethods.add(new RemoveKeyMethod());
        myKnownMethods.put(MAP_TYPE, mapKnownMethods);
    }

    public static void init(Properties properties, Instrumentation instrumentation) {
        boolean enabled = Boolean.parseBoolean(properties.getProperty("collectionBreakpoints", "false"));
        if (!enabled) {
            return;
        }
        CollectionBreakpointInstrumentor.initializeKnownMethods();
        ourInstrumentation = instrumentation;
        ourInstrumentation.addTransformer(new CollectionBreakpointTransformer(), true);
        if (DEBUG) {
            System.out.println("Collection breakpoint instrumentor: ready");
        }
    }

    private static void processFailedToInstrumentError(String className, Exception error) {
        System.out.println("CollectionBreakpoint instrumentor: failed to instrument " + className);
        error.printStackTrace();
    }

    private static void writeDebugInfo(String className, byte[] bytes) {
        try {
            System.out.println("instrumented: " + className);
            try (FileOutputStream stream = new FileOutputStream("instrumented_" + className.replaceAll("/", "_") + ".class");){
                stream.write(bytes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void captureCollectionModification(boolean shouldCapture, boolean modified, Object collectionInstance, Object elem, boolean isAddition) {
        try {
            if (!shouldCapture || !modified) {
                return;
            }
            CollectionBreakpointStorage.saveCollectionModification(collectionInstance, elem, isAddition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void captureCollectionModification(Multiset oldElements, Object newCollectionInstance) {
        try {
            CollectionInstanceLock lock = myInstanceFilters.get(newCollectionInstance);
            if (oldElements == null || lock == null) {
                return;
            }
            ArrayList<Modification> modifications = CollectionBreakpointInstrumentor.getModifications(oldElements, newCollectionInstance);
            if (!modifications.isEmpty()) {
                CollectionBreakpointInstrumentor.saveCollectionModifications(newCollectionInstance, modifications);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean onCaptureStart(Object collectionInstance, boolean shouldSynchronized) {
        try {
            CollectionInstanceLock lock = myInstanceFilters.get(collectionInstance);
            if (lock != null) {
                return lock.lock(shouldSynchronized);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void onCaptureEnd(Object collectionInstance, boolean shouldSynchronized) {
        try {
            CollectionInstanceLock lock = myInstanceFilters.get(collectionInstance);
            if (lock != null) {
                lock.unlock(shouldSynchronized);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Multiset captureCollectionCopy(boolean shouldCapture, Object collectionInstance) {
        try {
            if (!shouldCapture) {
                return null;
            }
            return Multiset.toMultiset(collectionInstance);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void saveCollectionModifications(Object collectionInstance, ArrayList<Modification> modifications) {
        Collections.sort(modifications);
        for (Modification modification : modifications) {
            CollectionBreakpointStorage.saveCollectionModification(collectionInstance, modification.getElement(), modification.isAddition());
        }
    }

    private static ArrayList<Modification> getModifications(Multiset oldElements, Object newCollection) {
        Integer newNumber;
        Multiset newElements = Multiset.toMultiset(newCollection);
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        for (Map.Entry entry : newElements.entrySet()) {
            newNumber = (Integer)entry.getValue();
            Integer oldNumber = oldElements.get(entry.getKey());
            Object element = entry.getKey();
            if (element instanceof Wrapper) {
                element = ((Wrapper)element).getValue();
            }
            if (newNumber.equals(oldNumber)) continue;
            boolean isAddition = oldNumber == null || newNumber > oldNumber;
            modifications.add(new Modification(element, isAddition));
        }
        for (Map.Entry entry : oldElements.entrySet()) {
            newNumber = newElements.get(entry.getKey());
            Object element = entry.getKey();
            if (element instanceof Wrapper) {
                element = ((Wrapper)element).getValue();
            }
            if (newNumber != null) continue;
            modifications.add(new Modification(element, false));
        }
        return modifications;
    }

    public static void captureFieldModification(Object collectionInstance, Object clsInstance, String clsTypeDesc, String fieldName, boolean shouldSaveStack) {
        try {
            if (collectionInstance == null) {
                return;
            }
            myInstanceFilters.add(collectionInstance);
            CollectionBreakpointInstrumentor.transformCollectionClassIfNeeded(collectionInstance.getClass());
            CollectionBreakpointStorage.saveFieldModification(clsTypeDesc, fieldName, clsInstance, collectionInstance, shouldSaveStack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transformClassToCaptureFields(String qualifiedClsName) {
        try {
            myTransformLock.lock();
            for (Class cls : ourInstrumentation.getAllLoadedClasses()) {
                String name = cls.getName();
                if (!name.equals(qualifiedClsName)) continue;
                try {
                    ourInstrumentation.retransformClasses(cls);
                }
                catch (UnmodifiableClassException e) {
                    e.printStackTrace();
                }
            }
            CollectionBreakpointInstrumentor.transformClassNestedMembers();
        }
        finally {
            myTransformLock.unlock();
        }
    }

    private static void transformClassNestedMembers() {
        while (!myUnprocessedNestedMembers.isEmpty()) {
            myClassesToTransform.addAll(myUnprocessedNestedMembers);
            HashSet<String> nestedNames = new HashSet<String>(myUnprocessedNestedMembers);
            myUnprocessedNestedMembers.clear();
            CollectionBreakpointInstrumentor.transformNestedMembers(nestedNames);
        }
    }

    private static void transformCollectionNestedMembers() {
        for (String nestedName : myUnprocessedNestedMembers) {
            myCollectionsToTransform.put(nestedName, new KnownMethodsSet());
        }
        HashSet<String> nestedNames = new HashSet<String>(myUnprocessedNestedMembers);
        myUnprocessedNestedMembers.clear();
        CollectionBreakpointInstrumentor.transformNestedMembers(nestedNames);
    }

    private static void transformNestedMembers(Set<String> nestedNames) {
        for (Class loadedCls : ourInstrumentation.getAllLoadedClasses()) {
            String loadedClsName = CaptureAgent.getInternalClsName(loadedCls);
            if (!nestedNames.contains(loadedClsName)) continue;
            try {
                ourInstrumentation.retransformClasses(loadedCls);
            }
            catch (UnmodifiableClassException e) {
                e.printStackTrace();
            }
        }
    }

    private static List<Class<?>> getSuperClassesAndInterfaces(Class<?> cls) {
        ArrayList result = new ArrayList();
        HashSet<String> alreadyProcessed = new HashSet<String>();
        LinkedList<Class<Object>> supersQueue = new LinkedList<Class<Object>>();
        supersQueue.add(cls);
        ArrayList unprocessed = new ArrayList();
        while (!supersQueue.isEmpty()) {
            Class currentCls = (Class)supersQueue.poll();
            alreadyProcessed.add(currentCls.getName());
            result.add(currentCls);
            if (COLLECTION_INTERFACE_NAME.equals(currentCls.getName()) || MAP_INTERFACE_NAME.equals(currentCls.getName())) continue;
            Class superCls = currentCls.getSuperclass();
            if (superCls != null && !OBJECT_CLASS_NAME.equals(superCls.getName()) && !alreadyProcessed.contains(superCls.getName())) {
                unprocessed.add(superCls);
            }
            for (Class<?> inter : currentCls.getInterfaces()) {
                if (!JAVA_UTIL_PACKAGE_NAME.equals(inter.getPackage().getName()) || alreadyProcessed.contains(inter.getName())) continue;
                unprocessed.add(inter);
            }
            if (!supersQueue.isEmpty()) continue;
            supersQueue.addAll(unprocessed);
            unprocessed.clear();
        }
        return result;
    }

    private static Set<String> getClassesNames(List<Class<?>> classes) {
        HashSet<String> result = new HashSet<String>();
        for (Class<?> cls : classes) {
            result.add(cls.getName());
        }
        return result;
    }

    private static KnownMethodsSet getAllKnownMethods(Class<?> cls, List<Class<?>> supers) {
        boolean fairCheckIsNecessary;
        String internalClsName = CaptureAgent.getInternalClsName(cls);
        boolean bl = fairCheckIsNecessary = !internalClsName.startsWith("java/util") || internalClsName.split("/").length != 3;
        if (fairCheckIsNecessary) {
            return new KnownMethodsSet();
        }
        int index = supers.indexOf(cls);
        if (index == -1) {
            return new KnownMethodsSet();
        }
        KnownMethodsSet result = new KnownMethodsSet();
        List<Class<?>> clsAndItsSupers = supers.subList(index, supers.size());
        for (Class<?> superCls : clsAndItsSupers) {
            KnownMethodsSet knownMethods = myKnownMethods.get(CaptureAgent.getInternalClsName(superCls));
            if (knownMethods == null) continue;
            result.addAll(knownMethods);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transformCollectionClassIfNeeded(Class<?> cls) {
        try {
            myTransformLock.lock();
            String qualifiedClassName = CaptureAgent.getInternalClsName(cls);
            if (myCollectionsToTransform.containsKey(qualifiedClassName)) {
                return;
            }
            List<Class<?>> allSupers = CollectionBreakpointInstrumentor.getSuperClassesAndInterfaces(cls);
            Set<String> allSupersNames = CollectionBreakpointInstrumentor.getClassesNames(allSupers);
            for (Class loadedCls : ourInstrumentation.getAllLoadedClasses()) {
                if (!allSupersNames.contains(loadedCls.getName())) continue;
                try {
                    myCollectionsToTransform.put(CaptureAgent.getInternalClsName(loadedCls), CollectionBreakpointInstrumentor.getAllKnownMethods(loadedCls, allSupers));
                    ourInstrumentation.retransformClasses(loadedCls);
                }
                catch (UnmodifiableClassException e) {
                    e.printStackTrace();
                }
            }
            CollectionBreakpointInstrumentor.transformCollectionNestedMembers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            myTransformLock.unlock();
        }
    }

    public static void putFieldToCapture(String clsTypeDesc, String fieldName) {
        String internalClsName = CaptureAgent.getInternalClsName(clsTypeDesc);
        myFieldsToCapture.putIfAbsent(internalClsName, Collections.newSetFromMap(new ConcurrentHashMap()));
        Set<String> fields = myFieldsToCapture.get(internalClsName);
        fields.add(fieldName);
        myClassesToTransform.add(internalClsName);
    }

    public static void emulateFieldWatchpoint(String ... clsNames) {
        for (String clsName : clsNames) {
            CollectionBreakpointInstrumentor.transformClassToCaptureFields(clsName);
        }
    }

    private static String getInstrumentorClassName() {
        return CaptureAgent.getInternalClsName(CollectionBreakpointInstrumentor.class);
    }

    public static Pair createPair(Object key, Object value) {
        return new Pair(key, value);
    }

    private static class RemoveKeyMethod
    extends KnownMethod {
        private RemoveKeyMethod() {
            super("remove(Ljava/lang/Object;)Ljava/lang/Object;", true);
        }

        @Override
        public int addCaptureModificationCode(MethodVisitor mv, int shouldCaptureVar) {
            mv.visitInsn(89);
            mv.visitInsn(89);
            Label label = new Label();
            Label end = new Label();
            mv.visitJumpInsn(199, label);
            mv.visitLdcInsn(false);
            mv.visitJumpInsn(167, end);
            mv.visitLabel(label);
            mv.visitLdcInsn(true);
            mv.visitLabel(end);
            mv.visitVarInsn(21, shouldCaptureVar);
            mv.visitInsn(91);
            mv.visitInsn(87);
            mv.visitInsn(90);
            mv.visitInsn(87);
            mv.visitVarInsn(25, 1);
            mv.visitInsn(95);
            mv.visitMethodInsn(184, CollectionBreakpointInstrumentor.getInstrumentorClassName(), CollectionBreakpointInstrumentor.CREATE_PAIR_METHOD_NAME, CollectionBreakpointInstrumentor.CREATE_PAIR_METHOD_DESC, false);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(95);
            mv.visitLdcInsn(false);
            mv.visitMethodInsn(184, CollectionBreakpointInstrumentor.getInstrumentorClassName(), "captureCollectionModification", CollectionBreakpointInstrumentor.CAPTURE_COLLECTION_MODIFICATION_METHOD_DESC, false);
            return 7;
        }
    }

    private static class PutMethod
    extends KnownMethod {
        private PutMethod() {
            super("put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
        }

        @Override
        public int addCaptureModificationCode(MethodVisitor mv, int shouldCaptureVar) {
            mv.visitInsn(89);
            mv.visitVarInsn(25, 2);
            Label label = new Label();
            Label end = new Label();
            mv.visitJumpInsn(166, label);
            mv.visitLdcInsn(false);
            mv.visitJumpInsn(167, end);
            mv.visitLabel(label);
            mv.visitLdcInsn(true);
            mv.visitLabel(end);
            mv.visitVarInsn(21, shouldCaptureVar);
            mv.visitInsn(95);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(184, CollectionBreakpointInstrumentor.getInstrumentorClassName(), CollectionBreakpointInstrumentor.CREATE_PAIR_METHOD_NAME, CollectionBreakpointInstrumentor.CREATE_PAIR_METHOD_DESC, false);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(95);
            mv.visitLdcInsn(true);
            mv.visitMethodInsn(184, CollectionBreakpointInstrumentor.getInstrumentorClassName(), "captureCollectionModification", CollectionBreakpointInstrumentor.CAPTURE_COLLECTION_MODIFICATION_METHOD_DESC, false);
            return 6;
        }
    }

    private static class ReturnsBooleanMethod
    extends KnownMethod {
        private final boolean myIsAddition;

        private ReturnsBooleanMethod(String desc, boolean isAddition) {
            super(desc, true);
            this.myIsAddition = isAddition;
        }

        @Override
        public int addCaptureModificationCode(MethodVisitor mv, int shouldCaptureVar) {
            mv.visitInsn(89);
            mv.visitVarInsn(21, shouldCaptureVar);
            mv.visitInsn(95);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn(this.myIsAddition);
            mv.visitMethodInsn(184, CollectionBreakpointInstrumentor.getInstrumentorClassName(), "captureCollectionModification", CollectionBreakpointInstrumentor.CAPTURE_COLLECTION_MODIFICATION_METHOD_DESC, false);
            return 5;
        }
    }

    private static class ImmutableMethod
    extends KnownMethod {
        private ImmutableMethod(String desc) {
            super(desc, false);
        }

        @Override
        public int addCaptureModificationCode(MethodVisitor mv, int shouldCaptureVar) {
            return 0;
        }
    }

    private static abstract class KnownMethod {
        private final String myMethodFullDesc;
        private final boolean myIsMutable;

        private KnownMethod(String desc, boolean mutable) {
            this.myMethodFullDesc = desc;
            this.myIsMutable = mutable;
        }

        private boolean isMutable() {
            return this.myIsMutable;
        }

        public abstract int addCaptureModificationCode(MethodVisitor var1, int var2);

        public boolean equals(Object obj) {
            return obj instanceof KnownMethod && this.myMethodFullDesc.equals(((KnownMethod)obj).myMethodFullDesc);
        }

        public int hashCode() {
            return this.myMethodFullDesc.hashCode();
        }
    }

    private static class KnownMethodsSet {
        private final Map<String, KnownMethod> myContainer = new HashMap<String, KnownMethod>();

        private KnownMethodsSet() {
        }

        public void add(KnownMethod method) {
            if (!this.myContainer.containsKey(method.myMethodFullDesc)) {
                this.myContainer.put(method.myMethodFullDesc, method);
            }
        }

        public void addAll(KnownMethodsSet set) {
            for (KnownMethod method : set.myContainer.values()) {
                this.add(method);
            }
        }

        public KnownMethod get(String methodFullDesc) {
            return this.myContainer.get(methodFullDesc);
        }

        public boolean equals(Object obj) {
            return obj instanceof KnownMethodsSet && this.myContainer.equals(((KnownMethodsSet)obj).myContainer);
        }

        public int hashCode() {
            return this.myContainer.hashCode();
        }
    }

    public static class Pair
    implements Map.Entry<Object, Object> {
        private final Object key;
        private final Object value;

        private Pair(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            return null;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Pair && ((Pair)obj).key == this.key && ((Pair)obj).value == this.value;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key) + 31 * System.identityHashCode(this.key);
        }
    }

    private static class Wrapper {
        private final Object value;

        private Wrapper(Object value) {
            this.value = value;
        }

        private Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            return obj instanceof Wrapper && this.value == ((Wrapper)obj).value;
        }

        public int hashCode() {
            return System.identityHashCode(this.value);
        }
    }

    public static class CollectionInstanceLock {
        private final ReentrantLock myLock = new ReentrantLock();
        private final ThreadLocal<Integer> myMethodEnterNumber = new ThreadLocal();

        private CollectionInstanceLock() {
            this.myMethodEnterNumber.set(0);
        }

        public boolean lock(boolean shouldSynchronized) {
            if (shouldSynchronized) {
                try {
                    this.myLock.tryLock(10L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            int result = this.myMethodEnterNumber.get();
            this.myMethodEnterNumber.set(result + 1);
            return result == 0;
        }

        public void unlock(boolean shouldSynchronized) {
            try {
                this.myMethodEnterNumber.set(this.myMethodEnterNumber.get() - 1);
                if (shouldSynchronized) {
                    this.myLock.unlock();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private static class ConcurrentIdentityHashMap {
        private final Map<Object, CollectionInstanceLock> myContainer = new IdentityHashMap<Object, CollectionInstanceLock>();
        private final ReentrantLock myLock = new ReentrantLock();

        private ConcurrentIdentityHashMap() {
        }

        public void add(Object obj) {
            this.myLock.lock();
            try {
                if (!this.myContainer.containsKey(obj)) {
                    this.myContainer.put(obj, new CollectionInstanceLock());
                }
            }
            finally {
                this.myLock.unlock();
            }
        }

        public CollectionInstanceLock get(Object obj) {
            this.myLock.lock();
            try {
                CollectionInstanceLock collectionInstanceLock = this.myContainer.get(obj);
                return collectionInstanceLock;
            }
            finally {
                this.myLock.unlock();
            }
        }
    }

    private static class Multiset {
        private final HashMap<Object, Integer> myContainer = new HashMap();

        private Multiset() {
        }

        public void add(Object element) {
            Integer number = this.myContainer.get(element);
            if (number == null) {
                this.myContainer.put(element, 1);
            } else {
                this.myContainer.put(element, number + 1);
            }
        }

        public Integer get(Object elem) {
            return this.myContainer.get(elem);
        }

        private Set<Map.Entry<Object, Integer>> entrySet() {
            return this.myContainer.entrySet();
        }

        public static Multiset toMultiset(Object collection) {
            Multiset multiset;
            block3: {
                block2: {
                    multiset = new Multiset();
                    if (!(collection instanceof Collection)) break block2;
                    for (Object element : (Collection)collection) {
                        multiset.add(new Wrapper(element));
                    }
                    break block3;
                }
                if (!(collection instanceof Map)) break block3;
                for (Map.Entry element : ((Map)collection).entrySet()) {
                    multiset.add(new Pair(element.getKey(), element.getValue()));
                }
            }
            return multiset;
        }
    }

    private static class Modification
    implements Comparable<Modification> {
        private final Object myElement;
        private final boolean myIsAddition;

        private Modification(Object element, boolean isAddition) {
            this.myElement = element;
            this.myIsAddition = isAddition;
        }

        Object getElement() {
            return this.myElement;
        }

        boolean isAddition() {
            return this.myIsAddition;
        }

        @Override
        public int compareTo(Modification o) {
            if (this.myIsAddition == o.isAddition()) {
                return 0;
            }
            return this.myIsAddition ? 1 : -1;
        }
    }

    static class MyClassVisitor
    extends ClassVisitor {
        private final String myClsName;

        private MyClassVisitor(String clsName, int api, ClassVisitor cv) {
            super(api, cv);
            this.myClsName = clsName;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            boolean shouldProcess;
            if (myClassesToTransform.contains(this.myClsName) && !myClassesToTransform.contains(name)) {
                myUnprocessedNestedMembers.add(name);
            }
            boolean isNonStatic = (access & 8) == 0;
            boolean bl = shouldProcess = myCollectionsToTransform.containsKey(this.myClsName) && !myCollectionsToTransform.containsKey(name);
            if (isNonStatic && shouldProcess) {
                myUnprocessedNestedMembers.add(name);
            }
            super.visitInnerClass(name, outerName, innerName, access);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            boolean isBridgeMethod;
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            boolean bl = isBridgeMethod = (access & 0x40) != 0;
            if (!isBridgeMethod && name != null && desc != null) {
                if (myClassesToTransform.contains(this.myClsName)) {
                    mv = new CaptureFieldsMethodVisitor(this.api, mv);
                }
                boolean isNonStaticMethod = (access & 8) == 0;
                boolean isNonSynthetic = (access & 0x1000) == 0;
                boolean isConstructor = name.equals(CollectionBreakpointInstrumentor.CONSTRUCTOR_METHOD_NAME);
                if (isNonStaticMethod && isNonSynthetic && !isConstructor && myCollectionsToTransform.containsKey(this.myClsName)) {
                    CollectionMethodVisitor collectionMethodVisitor = new CollectionMethodVisitor(this.api, access, name, desc, mv);
                    mv = new TryCatchAdapter(this.api, access, name, desc, signature, exceptions, collectionMethodVisitor);
                }
            }
            return mv;
        }

        private boolean shouldCaptureModifications(String methodFullDesc) {
            KnownMethodsSet knownMethods = (KnownMethodsSet)myCollectionsToTransform.get(this.myClsName);
            if (knownMethods == null) {
                return false;
            }
            KnownMethod method = knownMethods.get(methodFullDesc);
            return method == null || method.isMutable();
        }

        private boolean shouldOptimizeCapture(String methodFullDesc) {
            KnownMethodsSet knownMethods = (KnownMethodsSet)myCollectionsToTransform.get(this.myClsName);
            if (knownMethods == null) {
                return false;
            }
            return knownMethods.get(methodFullDesc) != null;
        }

        private boolean shouldSynchronize(String methodFullDesc) {
            return !this.shouldOptimizeCapture(methodFullDesc);
        }

        private static boolean isReturnInstruction(int opcode) {
            return opcode == 177 || opcode == 176 || opcode == 172 || opcode == 173 || opcode == 175 || opcode == 174;
        }

        private class CaptureFieldsMethodVisitor
        extends MethodVisitor {
            private int myAdditionalStackSpace;

            private CaptureFieldsMethodVisitor(int api, MethodVisitor methodVisitor) {
                super(api, methodVisitor);
                this.myAdditionalStackSpace = 0;
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                boolean isPutOperation;
                boolean bl = isPutOperation = opcode == 181 || opcode == 179;
                if (isPutOperation) {
                    this.visitPutField(this.mv, opcode, MyClassVisitor.this.myClsName, owner, name);
                }
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }

            private void visitPutField(MethodVisitor mv, int opcode, String clsName, String owner, String fieldName) {
                Set fieldNames = (Set)myFieldsToCapture.get(owner);
                if (fieldNames != null && fieldNames.contains(fieldName)) {
                    boolean isStaticField = opcode == 179;
                    this.addCaptureFieldModificationCode(mv, clsName, owner, fieldName, isStaticField);
                }
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                super.visitMaxs(maxStack + this.myAdditionalStackSpace, maxLocals);
            }

            private void addCaptureFieldModificationCode(MethodVisitor mv, String clsName, String fieldOwner, String fieldName, boolean isStaticField) {
                this.putThisObjOnStack(mv, clsName, fieldOwner, isStaticField);
                mv.visitLdcInsn(fieldOwner);
                mv.visitLdcInsn(fieldName);
                mv.visitLdcInsn(true);
                mv.visitMethodInsn(184, CollectionBreakpointInstrumentor.getInstrumentorClassName(), CollectionBreakpointInstrumentor.CAPTURE_FIELD_MODIFICATION_METHOD_NAME, CollectionBreakpointInstrumentor.CAPTURE_FIELD_MODIFICATION_METHOD_DESC, false);
                this.myAdditionalStackSpace += 3;
            }

            private void putThisObjOnStack(MethodVisitor mv, String clsName, String fieldOwner, boolean isStaticField) {
                if (isStaticField) {
                    mv.visitInsn(89);
                    mv.visitInsn(1);
                } else if (clsName.equals(fieldOwner)) {
                    mv.visitInsn(89);
                    mv.visitVarInsn(25, 0);
                } else {
                    mv.visitInsn(92);
                    mv.visitInsn(95);
                }
                this.myAdditionalStackSpace += 2;
            }
        }

        private class CollectionMethodVisitor
        extends LocalVariablesSorter {
            private final String myMethodFullDesc;
            private int myCollectionCopyVar;
            private int myShouldCaptureVar;
            private int myAdditionalStackSpace;
            private int myNumberOfAdditionalLocalVars;

            protected CollectionMethodVisitor(int api, int access, String name, String descriptor, MethodVisitor methodVisitor) {
                super(api, access, descriptor, methodVisitor);
                this.myAdditionalStackSpace = 0;
                this.myNumberOfAdditionalLocalVars = 0;
                this.myMethodFullDesc = name + descriptor;
            }

            @Override
            public void visitCode() {
                super.visitCode();
                if (MyClassVisitor.this.shouldCaptureModifications(this.myMethodFullDesc)) {
                    this.addStartCaptureCode();
                    if (!MyClassVisitor.this.shouldOptimizeCapture(this.myMethodFullDesc)) {
                        this.addCaptureCollectionCopyCode();
                    }
                }
            }

            @Override
            public void visitInsn(int opcode) {
                if (MyClassVisitor.this.shouldCaptureModifications(this.myMethodFullDesc) && MyClassVisitor.isReturnInstruction(opcode)) {
                    this.addCaptureCollectionModificationCode();
                    this.addEndCaptureCode();
                }
                super.visitInsn(opcode);
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                super.visitMaxs(maxStack + this.myAdditionalStackSpace, maxLocals + this.myNumberOfAdditionalLocalVars);
            }

            private void addEndCaptureCode() {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn(MyClassVisitor.this.shouldSynchronize(this.myMethodFullDesc));
                this.mv.visitMethodInsn(184, CollectionBreakpointInstrumentor.getInstrumentorClassName(), CollectionBreakpointInstrumentor.ON_CAPTURE_END_METHOD_NAME, CollectionBreakpointInstrumentor.ON_CAPTURE_END_METHOD_DESC, false);
                ++this.myAdditionalStackSpace;
            }

            private void addStartCaptureCode() {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitLdcInsn(MyClassVisitor.this.shouldSynchronize(this.myMethodFullDesc));
                this.mv.visitMethodInsn(184, CollectionBreakpointInstrumentor.getInstrumentorClassName(), CollectionBreakpointInstrumentor.ON_CAPTURE_START_METHOD_NAME, CollectionBreakpointInstrumentor.ON_CAPTURE_START_METHOD_DESC, false);
                this.myShouldCaptureVar = this.newLocal(Type.BOOLEAN_TYPE);
                this.mv.visitVarInsn(54, this.myShouldCaptureVar);
                this.myAdditionalStackSpace += 2;
                ++this.myNumberOfAdditionalLocalVars;
            }

            private void addCaptureCollectionCopyCode() {
                this.mv.visitVarInsn(21, this.myShouldCaptureVar);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(184, CollectionBreakpointInstrumentor.getInstrumentorClassName(), CollectionBreakpointInstrumentor.CAPTURE_COLLECTION_COPY_METHOD_NAME, CollectionBreakpointInstrumentor.CAPTURE_COLLECTION_COPY_METHOD_DESC, false);
                this.myCollectionCopyVar = this.newLocal(Type.getType(CollectionBreakpointInstrumentor.MULTISET_TYPE));
                this.mv.visitVarInsn(58, this.myCollectionCopyVar);
                this.myAdditionalStackSpace += 3;
                ++this.myNumberOfAdditionalLocalVars;
            }

            private void addCaptureCollectionModificationDefaultCode() {
                this.mv.visitVarInsn(25, this.myCollectionCopyVar);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(184, CollectionBreakpointInstrumentor.getInstrumentorClassName(), "captureCollectionModification", CollectionBreakpointInstrumentor.CAPTURE_COLLECTION_MODIFICATION_DEFAULT_METHOD_DESC, false);
                this.myAdditionalStackSpace += 2;
            }

            private void addCaptureCollectionModificationCode() {
                KnownMethodsSet knownMethods = (KnownMethodsSet)myCollectionsToTransform.get(MyClassVisitor.this.myClsName);
                KnownMethod knownMethod = knownMethods.get(this.myMethodFullDesc);
                if (knownMethod == null) {
                    this.addCaptureCollectionModificationDefaultCode();
                } else {
                    this.myAdditionalStackSpace += knownMethod.addCaptureModificationCode(this.mv, this.myShouldCaptureVar);
                }
            }
        }

        private class TryCatchAdapter
        extends MethodNode {
            private final String myMethodFullDesc;

            private TryCatchAdapter(int api, int access, String name, String desc, String signature, String[] exceptions, MethodVisitor mv) {
                super(api, access, name, desc, signature, exceptions);
                this.mv = mv;
                this.myMethodFullDesc = name + desc;
            }

            @Override
            public void visitEnd() {
                super.visitEnd();
                if (MyClassVisitor.this.shouldCaptureModifications(this.myMethodFullDesc)) {
                    this.addTryCatchCode();
                }
                this.accept(this.mv);
            }

            private void addTryCatchCode() {
                LabelNode startTryCatch = new LabelNode();
                LabelNode endTryCatch = new LabelNode();
                LabelNode handlerTryCatch = new LabelNode();
                AbstractInsnNode firstIns = this.instructions.getFirst();
                if (firstIns != null) {
                    this.instructions.insertBefore(firstIns, startTryCatch);
                } else {
                    this.instructions.add(startTryCatch);
                }
                InsnList additionalInstructions = new InsnList();
                additionalInstructions.add(endTryCatch);
                additionalInstructions.add(handlerTryCatch);
                this.addEndCaptureInstructions(additionalInstructions);
                additionalInstructions.add(new InsnNode(191));
                this.instructions.add(additionalInstructions);
                TryCatchBlockNode tryCatchBlockNode = new TryCatchBlockNode(startTryCatch, endTryCatch, handlerTryCatch, null);
                this.tryCatchBlocks.add(tryCatchBlockNode);
            }

            private void addEndCaptureInstructions(InsnList insnList) {
                insnList.add(new VarInsnNode(25, 0));
                insnList.add(new LdcInsnNode(MyClassVisitor.this.shouldSynchronize(this.myMethodFullDesc)));
                insnList.add(new MethodInsnNode(184, CollectionBreakpointInstrumentor.getInstrumentorClassName(), CollectionBreakpointInstrumentor.ON_CAPTURE_END_METHOD_NAME, CollectionBreakpointInstrumentor.ON_CAPTURE_END_METHOD_DESC, false));
                ++this.maxStack;
            }
        }
    }

    private static class CollectionBreakpointTransformer
    implements ClassFileTransformer {
        private CollectionBreakpointTransformer() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            if (className == null) {
                return null;
            }
            if (myCollectionsToTransform.containsKey(className) || myClassesToTransform.contains(className)) {
                try {
                    ClassTransformer transformer = new ClassTransformer(className, classfileBuffer, 2, loader);
                    return transformer.accept(new MyClassVisitor(className, 589824, transformer.writer), 8, true);
                }
                catch (Exception e) {
                    CollectionBreakpointInstrumentor.processFailedToInstrumentError(className, e);
                }
            }
            return null;
        }
    }
}

