/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

public class CollectionBreakpointStorage {
    private static final ConcurrentMap<CapturedField, FieldHistory> FIELD_MODIFICATIONS_STORAGE;
    private static final ConcurrentMap<CollectionWrapper, CollectionHistory> COLLECTION_MODIFICATIONS_STORAGE;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static boolean ENABLED;

    public static void saveFieldModification(String internalClsName, String fieldName, Object clsInstance, Object collectionInstance, boolean shouldSaveStack) {
        if (!ENABLED) {
            return;
        }
        String clsName = CaptureAgent.getClassName(internalClsName);
        CapturedField field = new CapturedField(clsName, fieldName, clsInstance);
        FIELD_MODIFICATIONS_STORAGE.putIfAbsent(field, new FieldHistory());
        FieldHistory history = (FieldHistory)FIELD_MODIFICATIONS_STORAGE.get(field);
        Throwable exception = shouldSaveStack ? new Throwable() : null;
        history.add(new FieldModificationInfo(exception, collectionInstance));
    }

    public static void saveCollectionModification(Object collectionInstance, Object elem, boolean isAddition) {
        if (!ENABLED) {
            return;
        }
        CollectionWrapper wrapper = new CollectionWrapper(collectionInstance);
        COLLECTION_MODIFICATIONS_STORAGE.putIfAbsent(wrapper, new CollectionHistory());
        CollectionHistory history = (CollectionHistory)COLLECTION_MODIFICATIONS_STORAGE.get(wrapper);
        Throwable exception = new Throwable();
        history.add(new CollectionModificationInfo(exception, elem, isAddition));
    }

    public static Object[] getCollectionModifications(Object collectionInstance) {
        CollectionWrapper wrapper = new CollectionWrapper(collectionInstance);
        CollectionHistory history = (CollectionHistory)COLLECTION_MODIFICATIONS_STORAGE.get(wrapper);
        return history == null ? EMPTY_OBJECT_ARRAY : history.get();
    }

    public static Object[] getFieldModifications(String clsName, String fieldName, Object clsInstance) {
        CapturedField field = new CapturedField(clsName, fieldName, clsInstance);
        FieldHistory history = (FieldHistory)FIELD_MODIFICATIONS_STORAGE.get(field);
        return history == null ? EMPTY_OBJECT_ARRAY : history.getCollectionInstances();
    }

    public static String getStack(Object collectionInstance, int modificationIndex) throws IOException {
        CollectionWrapper wrapper = new CollectionWrapper(collectionInstance);
        CollectionHistory history = (CollectionHistory)COLLECTION_MODIFICATIONS_STORAGE.get(wrapper);
        return history == null ? "" : CollectionBreakpointStorage.wrapInString(history.get(modificationIndex));
    }

    public static String getStack(String clsName, String fieldName, Object clsInstance, int modificationIndex) throws IOException {
        CapturedField field = new CapturedField(clsName, fieldName, clsInstance);
        FieldHistory history = (FieldHistory)FIELD_MODIFICATIONS_STORAGE.get(field);
        return history == null ? "" : CollectionBreakpointStorage.wrapInString(history.get(modificationIndex));
    }

    private static String wrapInString(CapturedStackInfo info) throws IOException {
        if (info == null) {
            return "";
        }
        try (ByteArrayOutputStream bas = new ByteArrayOutputStream();){
            String string;
            try (DataOutputStream dos = new DataOutputStream(bas);){
                for (StackTraceElement stackTraceElement : info.getStackTrace()) {
                    if (stackTraceElement == null) continue;
                    dos.writeUTF(stackTraceElement.getClassName());
                    dos.writeUTF(stackTraceElement.getMethodName());
                    dos.writeInt(stackTraceElement.getLineNumber());
                }
                string = bas.toString(StandardCharsets.ISO_8859_1.name());
            }
            return string;
        }
    }

    static {
        EMPTY_OBJECT_ARRAY = new Object[0];
        FIELD_MODIFICATIONS_STORAGE = new ConcurrentHashMap<CapturedField, FieldHistory>();
        COLLECTION_MODIFICATIONS_STORAGE = new ConcurrentHashMap<CollectionWrapper, CollectionHistory>();
    }

    private static class CapturedField {
        final String myClsName;
        final String myFieldName;
        final Object myClsInstance;

        private CapturedField(String clsName, String fieldName, Object clsInstance) {
            this.myClsName = clsName;
            this.myFieldName = fieldName;
            this.myClsInstance = clsInstance;
        }

        public boolean equals(Object obj) {
            return obj instanceof CapturedField && this.myClsInstance == ((CapturedField)obj).myClsInstance && this.myFieldName.equals(((CapturedField)obj).myFieldName) && this.myClsName.equals(((CapturedField)obj).myClsName);
        }

        public int hashCode() {
            return 31 * this.myFieldName.hashCode() + 13 * this.myClsName.hashCode() + System.identityHashCode(this.myClsInstance);
        }
    }

    private static class CollectionWrapper {
        private final Object myCollectionInstance;

        private CollectionWrapper(Object collectionInstance) {
            this.myCollectionInstance = collectionInstance;
        }

        public boolean equals(Object obj) {
            return obj instanceof CollectionWrapper && ((CollectionWrapper)obj).myCollectionInstance == this.myCollectionInstance;
        }

        public int hashCode() {
            return System.identityHashCode(this.myCollectionInstance);
        }
    }

    private static class FieldModificationInfo
    extends CapturedStackInfo {
        private final Object myCollectionInstance;

        private FieldModificationInfo(Throwable exception, Object collectionInstance) {
            super(exception);
            this.myCollectionInstance = collectionInstance;
        }
    }

    private static class CollectionModificationInfo
    extends CapturedStackInfo {
        private final Object myElement;
        private final boolean myIsAddition;

        private CollectionModificationInfo(Throwable exception, Object elem, boolean isAddition) {
            super(exception);
            this.myElement = elem;
            this.myIsAddition = isAddition;
        }

        private Object getElement() {
            return this.myElement;
        }

        private boolean isAddition() {
            return this.myIsAddition;
        }
    }

    private static class CapturedStackInfo {
        private final Throwable myException;

        private CapturedStackInfo(Throwable exception) {
            this.myException = exception;
        }

        public List<StackTraceElement> getStackTrace() {
            int startIndex;
            StackTraceElement[] stackTrace = this.myException.getStackTrace();
            int n = startIndex = this instanceof CollectionModificationInfo ? 3 : 2;
            if (startIndex > stackTrace.length - 1) {
                return Collections.emptyList();
            }
            return Arrays.asList(stackTrace).subList(startIndex, stackTrace.length);
        }
    }

    private static class CollectionHistory {
        private final ArrayList<CollectionModificationInfo> myOperations = new ArrayList();
        private final ReentrantLock myLock = new ReentrantLock();

        private CollectionHistory() {
        }

        private void add(CollectionModificationInfo info) {
            this.myLock.lock();
            try {
                this.myOperations.add(info);
            }
            finally {
                this.myLock.unlock();
            }
        }

        private Object[] get() {
            this.myLock.lock();
            try {
                Object[] objectArray = this.myOperations.toArray();
                return objectArray;
            }
            finally {
                this.myLock.unlock();
            }
        }

        private CollectionModificationInfo get(int operationIndex) {
            this.myLock.lock();
            try {
                CollectionModificationInfo collectionModificationInfo = this.myOperations.get(operationIndex);
                return collectionModificationInfo;
            }
            finally {
                this.myLock.unlock();
            }
        }
    }

    private static class FieldHistory {
        private final ArrayList<FieldModificationInfo> myModifications = new ArrayList();
        private final ReentrantLock myLock = new ReentrantLock();

        private FieldHistory() {
        }

        private void add(FieldModificationInfo info) {
            this.myLock.lock();
            try {
                this.myModifications.add(info);
            }
            finally {
                this.myLock.unlock();
            }
        }

        private FieldModificationInfo get(int modificationIndex) {
            this.myLock.lock();
            try {
                FieldModificationInfo fieldModificationInfo = this.myModifications.get(modificationIndex);
                return fieldModificationInfo;
            }
            finally {
                this.myLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] getCollectionInstances() {
            this.myLock.lock();
            try {
                ArrayList<Object> collectionInstances = new ArrayList<Object>();
                for (FieldModificationInfo info : this.myModifications) {
                    collectionInstances.add(info.myCollectionInstance);
                }
                Object[] objectArray = collectionInstances.toArray();
                return objectArray;
            }
            finally {
                this.myLock.unlock();
            }
        }
    }
}

