/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdater;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.InvalidPsi;
import com.intellij.codeInsight.daemon.impl.ManagedHighlighterRecycler;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextHighlightingUtil;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.SweepProcessor;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.ReferenceQueueable;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class HighlightInfoUpdaterImpl
extends HighlightInfoUpdater
implements Disposable {
    @ApiStatus.Internal
    static final int FILE_LEVEL_FAKE_LAYER = -4094;
    private static final Logger LOG = Logger.getInstance(HighlightInfoUpdaterImpl.class);
    private static final Object UNKNOWN_ID = "unknownId";
    @ApiStatus.Internal
    public static final int MANAGED_HIGHLIGHT_INFO_GROUP = -6;
    private static final Key<Map<FileViewProvider, Map<Object, ToolHighlights>>> VISITED_PSI_ELEMENTS = Key.create((String)"VISITED_PSI_ELEMENTS");
    private static final Key<Collection<HighlightInfo>> EVICTED_PSI_ELEMENTS = Key.create((String)"EVICTED_PSI_ELEMENTS");
    private boolean ASSERT_INVARIANTS;
    private final CollectionFactory.EvictionListener<PsiElement, List<? extends HighlightInfo>, List<? extends HighlightInfo>> psiElementEvictionListener = (__, hash, evicted) -> {
        if (LOG.isTraceEnabled()) {
            LOG.trace("psiElementEvictionListener: {" + hash + "} -> (" + (evicted == null ? 0 : evicted.size()) + "): " + String.valueOf(evicted));
        }
        if (evicted != null) {
            this.addEvictedInfos((List<? extends HighlightInfo>)evicted);
        }
    };
    @VisibleForTesting
    public static final Comparator<HighlightInfo> BY_OFFSETS_AND_HASH_ERRORS_FIRST = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        int r = Segment.BY_START_OFFSET_THEN_END_OFFSET.compare(o1, o2);
        if (r != 0) {
            return r;
        }
        r = o2.getSeverity().compareTo(o1.getSeverity());
        if (r != 0) {
            return r;
        }
        r = HighlightInfoUpdaterImpl.compareNaturalNullable(o1.getDescription(), o2.getDescription());
        if (r != 0) {
            return r;
        }
        RangeHighlighterEx h1 = o1.getHighlighter();
        RangeHighlighterEx h2 = o2.getHighlighter();
        return Integer.compare(System.identityHashCode(h1), System.identityHashCode(h2));
    };
    @ApiStatus.Internal
    public static final PsiElement FAKE_ELEMENT = HighlightInfoUpdaterImpl.createFakePsiElement("inspectionFinished");

    HighlightInfoUpdaterImpl(Project project) {
        Disposer.register((Disposable)this, () -> {
            FileDocumentManager patt0$temp = FileDocumentManager.getInstance();
            if (patt0$temp instanceof FileDocumentManagerBase) {
                FileDocumentManagerBase managerBase = (FileDocumentManagerBase)patt0$temp;
                managerBase.forEachCachedDocument(document -> {
                    Project docProject;
                    Map map = (Map)document.getUserData(VISITED_PSI_ELEMENTS);
                    FileViewProvider[] array = (map == null ? Map.of() : map).keySet().toArray(new FileViewProvider[0]);
                    Project project2 = docProject = array.length == 0 ? null : array[0].getManager().getProject();
                    if (docProject == project) {
                        document.putUserData(VISITED_PSI_ELEMENTS, null);
                    }
                });
            }
        });
    }

    private boolean isAssertInvariants() {
        return this.ASSERT_INVARIANTS;
    }

    @TestOnly
    public void runAssertingInvariants(@NotNull Runnable runnable) {
        if (runnable == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(0);
        }
        assert (ApplicationManagerEx.getApplicationEx().isUnitTestMode());
        boolean old = this.ASSERT_INVARIANTS;
        try {
            this.ASSERT_INVARIANTS = true;
            runnable.run();
        }
        finally {
            this.ASSERT_INVARIANTS = old;
        }
    }

    @NotNull
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CollectionFactory.EvictionListener<@NotNull FileViewProvider, Map<Object, ToolHighlights>, Map<Object, ToolHighlights>> psiFileEvictionListener(@NotNull Document document) {
        if (document == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(1);
        }
        CollectionFactory.EvictionListener evictionListener = (__, hash, oldMap) -> {
            if (LOG.isTraceEnabled()) {
                List infos = ContainerUtil.flatten((Iterable)ContainerUtil.map(ContainerUtil.notNullize((Map)oldMap).values(), t -> ContainerUtil.flatten(t.elementHighlights.values())));
                LOG.trace("psiFileEvictionListener: {" + hash + "} -> (" + (oldMap == null ? 0 : oldMap.size()) + "): \noldMap:" + String.valueOf(oldMap) + "\nall infos:(" + infos.size() + "): " + String.valueOf(infos));
            }
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)project, (boolean)false);
                if (markupModel == null) continue;
                List allInfos = ContainerUtil.mapNotNull((Object[])markupModel.getAllHighlighters(), h -> HighlightInfo.fromRangeHighlighter(h));
                List infos = ContainerUtil.filter((Collection)allInfos, h -> h.toolId != null);
                this.addEvictedInfos(infos);
            }
        };
        if (evictionListener == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(2);
        }
        return evictionListener;
    }

    public void dispose() {
    }

    private synchronized void addEvictedInfos(@NotNull List<? extends HighlightInfo> infos) {
        if (infos == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(3);
        }
        if (!infos.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("addEvictedInfos: " + StringUtil.join(infos, i -> String.valueOf(i) + (String)(i.getHighlighter() == null ? "" : "; rh:" + String.valueOf(i.getHighlighter().getTextRange())), (String)", ") + HighlightInfoUpdaterImpl.currentProgressInfo());
            }
            for (HighlightInfo highlightInfo : infos) {
                RangeHighlighterEx highlighter = highlightInfo.getHighlighter();
                if (highlighter == null) continue;
                Document hostDocument = highlighter.getDocument();
                Collection evictedInfos = (Collection)ConcurrencyUtil.computeIfAbsent((UserDataHolder)hostDocument, EVICTED_PSI_ELEMENTS, () -> new HashSet());
                evictedInfos.addAll(infos);
            }
        }
    }

    @NotNull
    private Map<Object, ToolHighlights> getData(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(4);
        }
        Document hostDocument = PsiDocumentManagerBase.getTopLevelDocument((Document)psiFile.getViewProvider().getDocument());
        return this.getData(psiFile, hostDocument);
    }

    @NotNull
    private Map<Object, ToolHighlights> getData(@NotNull PsiFile psiFile, @NotNull Document hostDocument) {
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(5);
        }
        if (hostDocument == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(6);
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        Map<FileViewProvider, Map<Object, ToolHighlights>> map = this.getOrCreateHostMap(hostDocument);
        Map result = map.get(viewProvider);
        if (result == null) {
            result = map.computeIfAbsent(viewProvider, __ -> new ConcurrentHashMap());
        }
        Map map2 = result;
        if (map2 == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(7);
        }
        return map2;
    }

    @NotNull
    private Map<FileViewProvider, Map<Object, ToolHighlights>> getOrCreateHostMap(@NotNull Document hostDocument) {
        Map data;
        if (hostDocument == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(8);
        }
        if ((data = (Map)hostDocument.getUserData(VISITED_PSI_ELEMENTS)) == null) {
            HashingStrategy<FileViewProvider> strategy = new HashingStrategy<FileViewProvider>(this){

                public int hashCode(FileViewProvider provider) {
                    return provider == null ? 0 : provider.hashCode();
                }

                public boolean equals(FileViewProvider o1, FileViewProvider o2) {
                    if (o1 == null || o2 == null) {
                        return o1 == null == (o2 == null);
                    }
                    if (o1 instanceof InjectedFileViewProvider) {
                        InjectedFileViewProvider viewProvider1 = (InjectedFileViewProvider)o1;
                        if (o2 instanceof InjectedFileViewProvider) {
                            InjectedFileViewProvider viewProvider2 = (InjectedFileViewProvider)o2;
                            return viewProvider1.getDocument().equals((Object)viewProvider2.getDocument());
                        }
                        return false;
                    }
                    return o1 == o2;
                }
            };
            data = (Map)((UserDataHolderEx)hostDocument).putUserDataIfAbsent(VISITED_PSI_ELEMENTS, (Object)CollectionFactory.createConcurrentSoftMap((HashingStrategy)strategy, this.psiFileEvictionListener(hostDocument)));
        }
        Map map = data;
        if (map == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(9);
        }
        return map;
    }

    private static void invokeProcessQueueToTriggerEvictedListener(@NotNull Map<? extends PsiElement, ?> map) {
        if (map == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(10);
        }
        ((ReferenceQueueable)map).processQueue();
    }

    @Override
    public synchronized void removeInfosForInjectedFilesOtherThan(@NotNull PsiFile hostPsiFile, @NotNull TextRange restrictRange, @NotNull HighlightingSession highlightingSession, @NotNull Collection<? extends FileViewProvider> liveInjectedFiles) {
        if (hostPsiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(11);
        }
        if (restrictRange == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(12);
        }
        if (highlightingSession == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(13);
        }
        if (liveInjectedFiles == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(14);
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)hostPsiFile.getProject());
        Document hostDocument = hostPsiFile.getFileDocument();
        Map<FileViewProvider, Map<Object, ToolHighlights>> hostMap = this.getOrCreateHostMap(hostDocument);
        hostMap.entrySet().removeIf(entry -> {
            boolean shouldRemove;
            FileViewProvider viewProvider = (FileViewProvider)entry.getKey();
            Map toolMap = (Map)entry.getValue();
            Document document = viewProvider.getDocument();
            TextRange textRange = TextRange.from((int)0, (int)document.getTextLength());
            if (document instanceof DocumentWindow) {
                DocumentWindow w = (DocumentWindow)document;
                textRange = w.injectedToHost(textRange);
            }
            boolean bl = shouldRemove = injectedLanguageManager.isInjectedViewProvider(viewProvider) && !liveInjectedFiles.contains(viewProvider) && restrictRange.contains(textRange);
            if (shouldRemove) {
                HighlightInfoUpdaterImpl.removeAllHighlighterInsideFile(viewProvider, this, highlightingSession, toolMap);
                return true;
            }
            return false;
        });
    }

    synchronized void incinerateAndRemoveFromDataAtomically(@NotNull ManagedHighlighterRecycler recycler) {
        if (recycler == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(15);
        }
        Collection<InvalidPsi> psiElements = recycler.forAllInGarbageBin();
        HighlightingSession session = recycler.myHighlightingSession;
        if (!psiElements.isEmpty() && LOG.isTraceEnabled()) {
            LOG.trace("incinerateAndRemoveFromDataAtomically: psiElements (" + psiElements.size() + "): " + String.valueOf(psiElements) + " " + String.valueOf(session.getProgressIndicator()));
        }
        Map<Object, ToolHighlights> data = this.getData(session.getPsiFile(), session.getDocument());
        HighlightInfoUpdaterImpl.removeFromDataAtomically(data, psiElements, session);
        recycler.incinerateAndClear();
    }

    @NotNull
    static String currentProgressInfo() {
        ProgressIndicator original;
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        String string = "; progress=" + (indicator == (original = ProgressWrapper.unwrap((ProgressIndicator)indicator)) ? "" : "wrapped:") + String.valueOf(indicator == null ? "null\n" + ExceptionUtil.getThrowableText((Throwable)new Throwable()) : indicator);
        if (string == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static int compareNaturalNullable(@Nullable String o1, @Nullable String o2) {
        return o1 == o2 ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : o1.compareTo(o2)));
    }

    private static boolean removeFromDataAtomically(@NotNull Map<Object, ToolHighlights> data, @NotNull @Unmodifiable Collection<? extends InvalidPsi> psis, @NotNull HighlightingSession session) {
        if (data == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(17);
        }
        if (psis == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(18);
        }
        if (session == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(19);
        }
        if (psis.isEmpty()) {
            return true;
        }
        HashMap<Object, Map> byPsiElement = new HashMap<Object, Map>();
        for (InvalidPsi invalidPsi : psis) {
            Object toolId = invalidPsi.info().toolId;
            List infos = byPsiElement.computeIfAbsent(toolId, __ -> new HashMap()).computeIfAbsent(invalidPsi.psiElement(), __ -> new ArrayList());
            infos.add(invalidPsi.info());
        }
        boolean removed = true;
        for (Map.Entry entry : byPsiElement.entrySet()) {
            Object toolId = entry.getKey();
            ToolHighlights toolHighlights = data.get(toolId);
            if (toolHighlights == null) {
                removed = false;
                continue;
            }
            Map byPsiMap = (Map)entry.getValue();
            for (Map.Entry byPsiEntry : byPsiMap.entrySet()) {
                PsiElement psiElement = (PsiElement)byPsiEntry.getKey();
                List<? extends HighlightInfo> oldL = toolHighlights.elementHighlights.get(psiElement);
                List oldInfos = oldL == null ? List.of() : ContainerUtil.sorted(oldL, BY_OFFSETS_AND_HASH_ERRORS_FIRST);
                List toRemove = ContainerUtil.sorted((Collection)((Collection)byPsiEntry.getValue()), BY_OFFSETS_AND_HASH_ERRORS_FIRST);
                ArrayList resultInfos = new ArrayList();
                ContainerUtil.processSortedListsInOrder((List)oldInfos, (List)toRemove, BY_OFFSETS_AND_HASH_ERRORS_FIRST, (boolean)true, (info, result) -> {
                    if (result == ContainerUtil.MergeResult.COPIED_FROM_LIST1) {
                        resultInfos.add(info);
                    }
                });
                removed &= oldInfos.size() - toRemove.size() == resultInfos.size();
                if (resultInfos.isEmpty()) {
                    toolHighlights.elementHighlights.remove(psiElement);
                } else {
                    toolHighlights.elementHighlights.put(psiElement, List.copyOf(resultInfos));
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("removeFromDataAtomically: " + HighlightInfoUpdaterImpl.debugPsiInfo(psiElement) + (String)(removed ? "" : "; removed=" + removed) + ": old=" + oldInfos.size() + (String)(oldInfos.size() == resultInfos.size() ? "; " + StringUtil.join((Iterable)oldInfos, (String)"\n   ") + "\n  " : "") + "; new=" + resultInfos.size() + (String)(oldInfos.size() == resultInfos.size() ? "; " + StringUtil.join(resultInfos, (String)"\n   ") + "\n  toRemove=(" + toRemove.size() + ") " + StringUtil.join((Iterable)toRemove, (String)"\n   ") : "") + " " + String.valueOf(session.getProgressIndicator()));
            }
        }
        return removed;
    }

    private synchronized void recycleInvalidPsiElements(@NotNull PsiFile psiFile, @NotNull Object requestor, @NotNull HighlightingSession session, @NotNull ManagedHighlighterRecycler invalidPsiRecycler, @NotNull WhatTool toolIdPredicate) {
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(20);
        }
        if (requestor == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(21);
        }
        if (session == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(22);
        }
        if (invalidPsiRecycler == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(23);
        }
        if (toolIdPredicate == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(24);
        }
        this.disposeEvictedInfos(session, toolIdPredicate);
        this.collectPsiElements(psiFile, requestor, session, toolIdPredicate, psiElement -> psiElement != FAKE_ELEMENT && !psiElement.isValid(), (info, psiElement) -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace("recycleInvalidPsiElements (predicate=" + String.valueOf((Object)toolIdPredicate) + ") " + String.valueOf(info.getHighlighter()) + "; toolIdPredicate=" + String.valueOf((Object)toolIdPredicate) + " for invalid " + HighlightInfoUpdaterImpl.debugPsiInfo(psiElement) + " from " + String.valueOf(requestor) + " " + String.valueOf(session.getProgressIndicator()));
            }
            if (info.getHighlighter() != null) {
                invalidPsiRecycler.recycleHighlighter((PsiElement)psiElement, (HighlightInfo)info);
            }
        });
        if (LOG.isTraceEnabled() && !invalidPsiRecycler.forAllInGarbageBin().isEmpty()) {
            Collection<InvalidPsi> psis = invalidPsiRecycler.forAllInGarbageBin();
            LOG.trace("recycleInvalidPsiElements: found " + psis.size() + " invalid psi elements in " + psiFile.getName() + " for " + String.valueOf((Object)toolIdPredicate) + (String)(psis.isEmpty() ? "" : ":\n" + StringUtil.join(psis, (String)"\n    ")) + " " + String.valueOf(session.getProgressIndicator()));
        }
    }

    @NotNull
    static String debugPsiInfo(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(25);
        }
        String string = String.valueOf(psiElement) + String.valueOf(psiElement.getTextRange()) + (psiElement.isValid() ? "" : " (invalid)") + " {" + System.identityHashCode(psiElement) + "}" + String.valueOf(psiElement.getClass());
        if (string == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(26);
        }
        return string;
    }

    private void disposeEvictedInfos(@NotNull HighlightingSession session, @NotNull WhatTool predicate) {
        if (session == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(27);
        }
        if (predicate == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(28);
        }
        Document document = session.getDocument();
        Map<FileViewProvider, Map<Object, ToolHighlights>> hostMap = this.getOrCreateHostMap(document);
        ((ReferenceQueueable)hostMap).processQueue();
        hostMap.values().stream().flatMap(m -> m.values().stream()).forEach(toolHighlights -> ((ReferenceQueueable)toolHighlights.elementHighlights).processQueue());
        Collection evictedInfos = (Collection)document.getUserData(EVICTED_PSI_ELEMENTS);
        if (evictedInfos != null) {
            int size = evictedInfos.size();
            if (LOG.isTraceEnabled()) {
                LOG.trace("disposeEvictedInfos: disposing " + size + " entries");
            }
            evictedInfos.removeIf(info -> {
                boolean matches = predicate.matches(info.toolId);
                if (matches) {
                    if (LOG.isTraceEnabled() && size < 200) {
                        LOG.trace("disposeEvictedInfos: " + String.valueOf(info));
                    }
                    UpdateHighlightersUtil.disposeWithFileLevelIgnoreErrors(info, session);
                }
                return matches;
            });
        }
    }

    private synchronized void collectPsiElements(@NotNull PsiFile psiFile, @NotNull Object requestor, @NotNull HighlightingSession session, @NotNull WhatTool toolPredicate, @NotNull Predicate<? super PsiElement> psiElementPredicate, @NotNull BiConsumer<? super HighlightInfo, ? super PsiElement> rangeHighlighterConsumer) {
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(29);
        }
        if (requestor == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(30);
        }
        if (session == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(31);
        }
        if (toolPredicate == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(32);
        }
        if (psiElementPredicate == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(33);
        }
        if (rangeHighlighterConsumer == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(34);
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)psiFile.getProject());
        PsiFile hostFile = injectedLanguageManager.getTopLevelFile((PsiElement)psiFile);
        Document hostDocument = hostFile.getFileDocument();
        Map<FileViewProvider, Map<Object, ToolHighlights>> hostMap = this.getOrCreateHostMap(hostDocument);
        ArrayList maps = new ArrayList();
        hostMap.entrySet().removeIf(entry -> {
            FileViewProvider viewProvider = (FileViewProvider)entry.getKey();
            PsiFile psi = viewProvider.getStubBindingRoot();
            Map toolMap = (Map)entry.getValue();
            if (psi.isValid()) {
                Document topLevelDocument = PsiDocumentManagerBase.getTopLevelDocument((Document)viewProvider.getDocument());
                if (topLevelDocument == hostDocument) {
                    maps.add(toolMap);
                }
                return false;
            }
            if (psi == psiFile) {
                return false;
            }
            HighlightInfoUpdaterImpl.removeAllHighlighterInsideFile(viewProvider, requestor, session, toolMap);
            return true;
        });
        for (Map map : maps) {
            if (map.isEmpty()) continue;
            for (Map.Entry toolEntry : map.entrySet()) {
                ToolHighlights toolHighlights = (ToolHighlights)toolEntry.getValue();
                Object toolId = toolEntry.getKey();
                HighlightInfoUpdaterImpl.invokeProcessQueueToTriggerEvictedListener(toolHighlights.elementHighlights);
                if (!toolPredicate.matches(toolId)) continue;
                for (Map.Entry<PsiElement, List<? extends HighlightInfo>> entry2 : toolHighlights.elementHighlights.entrySet()) {
                    PsiElement psiElement = entry2.getKey();
                    ProgressManager.checkCanceled();
                    if (!psiElementPredicate.test((PsiElement)psiElement)) continue;
                    List<? extends HighlightInfo> oldInfos = entry2.getValue();
                    for (HighlightInfo highlightInfo : oldInfos) {
                        rangeHighlighterConsumer.accept(highlightInfo, (PsiElement)psiElement);
                    }
                }
            }
        }
    }

    private static void removeAllHighlighterInsideFile(@NotNull FileViewProvider psiFile, @NotNull Object requestor, @NotNull HighlightingSession session, @NotNull @Unmodifiable Map<Object, ToolHighlights> toolMap) {
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(35);
        }
        if (requestor == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(36);
        }
        if (session == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(37);
        }
        if (toolMap == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(38);
        }
        int removed = 0;
        for (ToolHighlights highlights : toolMap.values()) {
            for (List<? extends HighlightInfo> list : highlights.elementHighlights.values()) {
                for (HighlightInfo highlightInfo : list) {
                    UpdateHighlightersUtil.disposeWithFileLevelIgnoreErrors(highlightInfo, session);
                    ++removed;
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("removeAllHighlighterInsideFile: removed invalid file: " + String.valueOf(psiFile) + " (" + removed + " highlighters removed); from " + String.valueOf(requestor) + " " + String.valueOf(session.getProgressIndicator()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ApiStatus.Internal
    public void psiElementVisited(@NotNull Object toolId, @NotNull PsiElement visitedPsiElement, @NotNull List<? extends HighlightInfo> newInfos, @NotNull Document hostDocument, @NotNull PsiFile psiFile, @NotNull Project project, @NotNull HighlightingSession session, @NotNull ManagedHighlighterRecycler invalidElementRecycler) {
        ToolHighlights toolHighlights0;
        List oldInfos0;
        if (toolId == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(39);
        }
        if (visitedPsiElement == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(40);
        }
        if (newInfos == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(41);
        }
        if (hostDocument == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(42);
        }
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(43);
        }
        if (project == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(44);
        }
        if (session == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(45);
        }
        if (invalidElementRecycler == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(46);
        }
        if (newInfos.isEmpty() && (oldInfos0 = ContainerUtil.notNullize((toolHighlights0 = this.getData(psiFile, hostDocument).get(toolId)) == null ? null : toolHighlights0.elementHighlights.get(visitedPsiElement))).isEmpty()) {
            return;
        }
        long psiTimeStamp = PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount();
        for (HighlightInfo highlightInfo : newInfos) {
            if (highlightInfo.getHighlighter() != null) {
                String message = "Highlighter must not be set, but got: " + String.valueOf(highlightInfo);
                UpdateHighlightersUtil.disposeWithFileLevelIgnoreErrors(highlightInfo, session);
                LOG.error(message);
            }
            highlightInfo.updateLazyFixesPsiTimeStamp(psiTimeStamp);
        }
        HighlightInfoUpdaterImpl highlightInfoUpdaterImpl = this;
        synchronized (highlightInfoUpdaterImpl) {
            this.assertMarkupConsistentWithData(psiFile, HighlightInfoUpdaterImpl.isInspectionToolId(toolId) ? WhatTool.INSPECTION : WhatTool.ANNOTATOR_OR_VISITOR);
            Map<Object, ToolHighlights> map = this.getData(psiFile, hostDocument);
            ToolHighlights toolHighlights = map.get(toolId);
            List oldInfos = ContainerUtil.notNullize(toolHighlights == null ? null : toolHighlights.elementHighlights.get(visitedPsiElement));
            if (oldInfos.isEmpty() && newInfos.isEmpty()) {
                return;
            }
            ProgressManager.getInstance().executeNonCancelableSection(() -> ManagedHighlighterRecycler.runWithRecycler(session, recycler -> {
                ToolHighlights notNullToolHighlights;
                for (HighlightInfo oldInfo : oldInfos) {
                    RangeHighlighterEx highlighter = oldInfo.getHighlighter();
                    if (highlighter == null) continue;
                    recycler.recycleHighlighter(visitedPsiElement, oldInfo);
                }
                List<? extends HighlightInfo> newInfosToStore = this.assignRangeHighlighters(visitedPsiElement, oldInfos, newInfos, toolId, session, psiFile, hostDocument, invalidElementRecycler, (ManagedHighlighterRecycler)recycler, data);
                ToolHighlights toolHighlights2 = notNullToolHighlights = toolHighlights == null ? data.computeIfAbsent(toolId, __ -> new ToolHighlights()) : toolHighlights;
                if (newInfosToStore.isEmpty()) {
                    notNullToolHighlights.elementHighlights.remove(visitedPsiElement);
                } else {
                    notNullToolHighlights.elementHighlights.put(visitedPsiElement, newInfosToStore);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("psiElementVisited: " + HighlightInfoUpdaterImpl.debugPsiInfo(visitedPsiElement) + (String)(psiFile.getViewProvider() instanceof InjectedFileViewProvider ? " injected in " + String.valueOf(InjectedLanguageManager.getInstance((Project)project).injectedToHost((PsiElement)psiFile, psiFile.getTextRange())) : "") + "; tool:" + String.valueOf(toolId) + "; infos:" + String.valueOf(HighlightInfoUpdaterImpl.head(newInfosToStore)) + "; oldInfos:" + String.valueOf(HighlightInfoUpdaterImpl.head(oldInfos)) + " " + String.valueOf(session.getProgressIndicator()));
                }
                this.assertNoDuplicates(psiFile, newInfosToStore, "psiElementVisited ");
            }));
        }
        this.assertMarkupConsistentWithData(psiFile, HighlightInfoUpdaterImpl.isInspectionToolId(toolId) ? WhatTool.INSPECTION : WhatTool.ANNOTATOR_OR_VISITOR);
        Reference.reachabilityFence(visitedPsiElement);
    }

    @NotNull
    private static Object head(@NotNull List<? extends HighlightInfo> infos) {
        if (infos == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(47);
        }
        Object object = infos.size() < 10 ? infos : "(" + infos.size() + "):" + String.valueOf(ContainerUtil.getFirstItems(infos, (int)10)) + "...";
        if (object == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(48);
        }
        return object;
    }

    private void assertNoDuplicates(@NotNull PsiFile psiFile, @NotNull Collection<? extends HighlightInfo> infos, @NotNull String cause) {
        record HI(TextRange range, String desc, TextAttributes attributes) {
        }
        List filtered;
        List map2;
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(49);
        }
        if (infos == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(50);
        }
        if (cause == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(51);
        }
        if (!this.isAssertInvariants()) {
            return;
        }
        List map = ContainerUtil.map(infos, h -> new HI(TextRange.create((Segment)h), h.getDescription(), h.getTextAttributes((PsiElement)psiFile, EditorColorsUtil.getGlobalOrDefaultColorScheme())));
        if (new HashSet(map).size() != infos.size() && new HashSet(map2 = ContainerUtil.map((Collection)(filtered = ContainerUtil.filter(infos, info -> {
            Map.Entry<PsiElement, List<? extends HighlightInfo>> entry = this.findInData((HighlightInfo)info, psiFile);
            return entry != null && entry.getKey().isValid();
        })), h -> new HI(TextRange.create((Segment)h), h.getDescription(), h.getTextAttributes((PsiElement)psiFile, EditorColorsUtil.getGlobalOrDefaultColorScheme())))).size() != filtered.size()) {
            List sorted = ContainerUtil.sorted((Collection)filtered, UpdateHighlightersUtil.BY_ACTUAL_START_OFFSET_NO_DUPS);
            LOG.error(cause + "Duplicates found: \n" + StringUtil.join((Collection)sorted, h -> h.toString() + ": textAttributes=" + String.valueOf(h.getTextAttributes((PsiElement)psiFile, EditorColorsUtil.getGlobalOrDefaultColorScheme())), (String)"\n"));
        }
    }

    private void assertRangeHighlightersAreConsistentWithData(@NotNull PsiFile psiFile, @NotNull Collection<? extends HighlightInfo> newInfos, @NotNull Document hostDocument, @NotNull Object toolId, @NotNull PsiElement visitedPsiElement) {
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(52);
        }
        if (newInfos == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(53);
        }
        if (hostDocument == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(54);
        }
        if (toolId == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(55);
        }
        if (visitedPsiElement == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(56);
        }
        if (!this.isAssertInvariants()) {
            return;
        }
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)hostDocument, (Project)psiFile.getProject(), (boolean)true);
        for (HighlightInfo highlightInfo : newInfos) {
            model.processRangeHighlightersOverlappingWith(highlightInfo.getStartOffset(), highlightInfo.getEndOffset(), r -> {
                HighlightInfo i = HighlightInfo.fromRangeHighlighter((RangeHighlighter)r);
                if (i != null && this.findInData(i, psiFile) == null) {
                    LOG.error("Inconsistent RH found: " + String.valueOf(r) + "; info=" + String.valueOf(i) + "; During " + String.valueOf(toolId) + "; " + String.valueOf(visitedPsiElement) + "; " + String.valueOf(newInfos));
                }
                return true;
            });
        }
    }

    private Map.Entry<PsiElement, List<? extends HighlightInfo>> findInData(@NotNull HighlightInfo info, @NotNull PsiFile psiFile) {
        ToolHighlights highlights;
        if (info == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(57);
        }
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(58);
        }
        if ((highlights = this.getData(psiFile).get(info.toolId)) != null) {
            for (Map.Entry<PsiElement, List<? extends HighlightInfo>> entry : highlights.elementHighlights.entrySet()) {
                if (!ContainerUtil.containsIdentity((Iterable)entry.getValue(), (Object)info)) continue;
                return entry;
            }
        }
        return null;
    }

    @NotNull
    private Collection<HighlightInfo> getInfosFromMarkup(@NotNull PsiFile psiFile, @NotNull WhatTool toolIdPredicate) {
        Document hostDocument;
        TextRange hostRange;
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(59);
        }
        if (toolIdPredicate == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(60);
        }
        if (!this.isAssertInvariants()) {
            Set<HighlightInfo> set = Set.of();
            if (set == null) {
                HighlightInfoUpdaterImpl.$$$reportNull$$$0(61);
            }
            return set;
        }
        Project project = psiFile.getProject();
        boolean isInjected = psiFile.getViewProvider() instanceof InjectedFileViewProvider;
        if (isInjected) {
            PsiFile hostPsiFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)psiFile);
            hostRange = InjectedLanguageManager.getInstance((Project)project).injectedToHost((PsiElement)psiFile, psiFile.getTextRange());
            hostDocument = hostPsiFile.getFileDocument();
        } else {
            hostDocument = psiFile.getFileDocument();
            hostRange = TextRange.from((int)0, (int)hostDocument.getTextLength());
        }
        Collection collection = Arrays.stream(DocumentMarkupModel.forDocument((Document)hostDocument, (Project)project, (boolean)true).getAllHighlighters()).map(m -> HighlightInfo.fromRangeHighlighter(m)).filter(Objects::nonNull).filter(h -> h.toolId != null).filter(h -> toolIdPredicate.matches(h.toolId)).filter(h -> h.isFromInjection() == isInjected && h.getHighlighter() != null && hostRange.intersects((Segment)h.getHighlighter())).collect(Collectors.toList());
        if (collection == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(62);
        }
        return collection;
    }

    private synchronized void assertMarkupConsistentWithData(@NotNull PsiFile psiFile, @NotNull WhatTool toolIdPredicate) {
        HashSet<HighlightInfo> fromData;
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(63);
        }
        if (toolIdPredicate == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(64);
        }
        if (!this.isAssertInvariants()) {
            return;
        }
        Collection<HighlightInfo> fromMarkup = this.getInfosFromMarkup(psiFile, toolIdPredicate);
        if (!new HashSet<HighlightInfo>(fromMarkup).equals(fromData = new HashSet<HighlightInfo>(this.getAllData(psiFile, toolIdPredicate)))) {
            Comparator<Object> toString = Comparator.comparing(o -> o.toString());
            List ds = ContainerUtil.sorted(fromData, toString);
            List ms = ContainerUtil.sorted(fromMarkup, toString);
            String fromDataStr = StringUtil.join((Iterable)ds, (String)"\n");
            String fromMarkupStr = StringUtil.join((Iterable)ms, (String)"\n");
            LOG.error("data inconsistent with markup: data:\n" + fromDataStr + "\n---------------markup:\n" + fromMarkupStr + "\n=========");
        }
    }

    @NotNull
    private Collection<HighlightInfo> getAllData(@NotNull PsiFile psiFile, @NotNull WhatTool toolIdPredicate) {
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(65);
        }
        if (toolIdPredicate == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(66);
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)psiFile.getProject());
        PsiFile hostFile = injectedLanguageManager.getTopLevelFile((PsiElement)psiFile);
        Document hostDocument = hostFile.getFileDocument();
        Map<FileViewProvider, Map<Object, ToolHighlights>> hostMap = this.getOrCreateHostMap(hostDocument);
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        TextRange psiFileHostRange = injectedLanguageManager.injectedToHost((PsiElement)psiFile, psiFile.getTextRange());
        boolean isPsiFileInjected = injectedLanguageManager.isInjectedFragment(psiFile);
        Document document = psiFile.getFileDocument();
        for (Map.Entry<FileViewProvider, Map<Object, ToolHighlights>> entry : hostMap.entrySet()) {
            TextRange keyHostRange;
            FileViewProvider viewProvider = entry.getKey();
            Document keyDocument = viewProvider.getDocument();
            boolean isFileKeyInjected = injectedLanguageManager.isInjectedViewProvider(viewProvider);
            if (keyDocument instanceof DocumentWindow) {
                DocumentWindow w = (DocumentWindow)keyDocument;
                v0 = w.injectedToHost(TextRange.from((int)0, (int)keyDocument.getTextLength()));
            } else {
                v0 = keyHostRange = TextRange.from((int)0, (int)keyDocument.getTextLength());
            }
            if (isFileKeyInjected != isPsiFileInjected || !keyHostRange.intersects(psiFileHostRange) || !document.equals((Object)keyDocument)) continue;
            Map<Object, ToolHighlights> map = entry.getValue();
            List<HighlightInfo> list = map.entrySet().stream().filter(e -> toolIdPredicate.matches(e.getKey())).flatMap(e -> ((ToolHighlights)e.getValue()).elementHighlights.values().stream()).flatMap(l -> l.stream()).filter(h -> h.getHighlighter() != null && h.getHighlighter().isValid()).filter(h -> keyHostRange.intersects((Segment)h)).toList();
            result.addAll(list);
        }
        Collection evicted = (Collection)hostDocument.getUserData(EVICTED_PSI_ELEMENTS);
        if (evicted != null) {
            result.addAll(evicted);
        }
        ArrayList<HighlightInfo> arrayList = result;
        if (arrayList == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(67);
        }
        return arrayList;
    }

    @ApiStatus.Internal
    public synchronized void removeHighlightsForObsoleteTools(@NotNull HighlightingSession highlightingSession, @NotNull List<? extends PsiFile> injectedFragments, @NotNull BiPredicate<? super Object, ? super PsiFile> keepToolIdPredicate) {
        if (highlightingSession == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(68);
        }
        if (injectedFragments == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(69);
        }
        if (keepToolIdPredicate == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(70);
        }
        for (PsiFile psiFile : ContainerUtil.append(injectedFragments, (Object[])new PsiFile[]{highlightingSession.getPsiFile()})) {
            Map<Object, ToolHighlights> data = this.getData(psiFile, highlightingSession.getDocument());
            data.entrySet().removeIf(entry -> {
                Object toolId = entry.getKey();
                if (UNKNOWN_ID.equals(toolId)) {
                    return false;
                }
                if (keepToolIdPredicate.test(toolId, psiFile)) {
                    return false;
                }
                ToolHighlights toolHighlights = (ToolHighlights)entry.getValue();
                for (Map.Entry<PsiElement, List<? extends HighlightInfo>> tentry : toolHighlights.elementHighlights.entrySet()) {
                    List<? extends HighlightInfo> infos = tentry.getValue();
                    if (LOG.isTraceEnabled()) {
                        PsiElement psiElement = tentry.getKey();
                        LOG.trace("removeHighlightsForObsoleteTools: " + HighlightInfoUpdaterImpl.debugPsiInfo(psiElement) + "; infos(" + infos.size() + "): " + String.valueOf(infos));
                    }
                    for (HighlightInfo highlightInfo : infos) {
                        UpdateHighlightersUtil.disposeWithFileLevelIgnoreErrors(highlightInfo, highlightingSession);
                    }
                }
                return true;
            });
        }
    }

    @ApiStatus.Internal
    public static boolean isInspectionToolId(Object toolId) {
        return toolId instanceof String;
    }

    static boolean isAnnotatorToolId(Object toolId) {
        Class c;
        return toolId instanceof Class && Annotator.class.isAssignableFrom(c = (Class)toolId);
    }

    static boolean isHighlightVisitorToolId(Object toolId) {
        Class c;
        return toolId instanceof Class && HighlightVisitor.class.isAssignableFrom(c = (Class)toolId);
    }

    static boolean isInjectionRelated(Object toolId) {
        return InjectedLanguageManagerImpl.isInjectionRelated(toolId);
    }

    @ApiStatus.Internal
    public synchronized void removeWarningsInsideErrors(@NotNull List<? extends PsiFile> injectedFragments, @NotNull Document hostDocument, @NotNull HighlightingSession session) {
        if (injectedFragments == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(71);
        }
        if (hostDocument == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(72);
        }
        if (session == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(73);
        }
        ManagedHighlighterRecycler.runWithRecycler(session, recycler -> {
            for (PsiFile psiFile : ContainerUtil.append((List)injectedFragments, (Object[])new PsiFile[]{session.getPsiFile()})) {
                Map<Object, ToolHighlights> map = this.getData(psiFile, hostDocument);
                if (map.isEmpty()) continue;
                List<HighlightInfo> sorted = map.entrySet().stream().filter(e -> HighlightInfoUpdaterImpl.isInspectionToolId(e.getKey())).flatMap(e -> ((ToolHighlights)e.getValue()).elementHighlights.values().stream()).flatMap(l -> l.stream()).sorted(BY_OFFSETS_AND_HASH_ERRORS_FIRST).toList();
                SweepProcessor.Generator generator = processor -> ContainerUtil.process((List)sorted, (Processor)processor);
                SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(session.getProject());
                SweepProcessor.sweep(generator, (__, info, atStart, overlappingIntervals) -> {
                    RangeHighlighterEx highlighter;
                    if (!atStart) {
                        return true;
                    }
                    if (info.isFileLevelAnnotation()) {
                        return true;
                    }
                    if (UpdateHighlightersUtil.isWarningCoveredByError(info, severityRegistrar, overlappingIntervals) && (highlighter = info.getHighlighter()) != null) {
                        ToolHighlights elementHighlights = (ToolHighlights)map.get(info.toolId);
                        for (Map.Entry<PsiElement, List<? extends HighlightInfo>> elementEntry : elementHighlights.elementHighlights.entrySet()) {
                            List<? extends HighlightInfo> infos = elementEntry.getValue();
                            int i = infos.indexOf(info);
                            if (i == -1) continue;
                            PsiElement psiElement = elementEntry.getKey();
                            recycler.recycleHighlighter(psiElement, (HighlightInfo)info);
                            HighlightInfo toRemove = infos.get(i);
                            List listMinusInfo = ContainerUtil.filter(infos, h -> h != toRemove);
                            if (listMinusInfo.isEmpty()) {
                                elementHighlights.elementHighlights.remove(psiElement);
                            } else {
                                elementEntry.setValue(listMinusInfo);
                            }
                            if (!LOG.isTraceEnabled()) break;
                            LOG.trace("removeWarningsInsideErrors: " + HighlightInfoUpdaterImpl.debugPsiInfo(psiElement) + "; removed " + String.valueOf(info) + "; now infos(" + listMinusInfo.size() + "): " + String.valueOf(listMinusInfo));
                            break;
                        }
                    }
                    return true;
                });
            }
            Collection<InvalidPsi> warns = recycler.forAllInGarbageBin();
            if (LOG.isTraceEnabled() && !warns.isEmpty()) {
                LOG.trace("removeWarningsInsideErrors: found " + String.valueOf(warns) + " " + String.valueOf(session.getProgressIndicator()));
            }
        });
    }

    @ApiStatus.Internal
    public synchronized void saveLatencies(@NotNull PsiFile psiFile, @NotNull @Unmodifiable Map<Object, ToolLatencies> latencies) {
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(74);
        }
        if (latencies == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(75);
        }
        if (!psiFile.getViewProvider().isPhysical()) {
            return;
        }
        Map<Object, ToolHighlights> map = this.getData(psiFile);
        if (map.isEmpty()) {
            return;
        }
        for (Map.Entry<Object, ToolLatencies> entry : latencies.entrySet()) {
            Object toolId = entry.getKey();
            ToolHighlights toolHighlights = map.get(toolId);
            if (toolHighlights == null) continue;
            ToolLatencies lats = entry.getValue();
            toolHighlights.latencies = new ToolLatencies(HighlightInfoUpdaterImpl.merge(toolHighlights.latencies.errorLatency, lats.errorLatency), HighlightInfoUpdaterImpl.merge(toolHighlights.latencies.warningLatency, lats.warningLatency), HighlightInfoUpdaterImpl.merge(toolHighlights.latencies.otherLatency, lats.otherLatency));
        }
    }

    private static long merge(long oldL, long newL) {
        return oldL == 0L || newL == 0L ? oldL + newL : Math.min(oldL, newL);
    }

    @ApiStatus.Internal
    public synchronized int compareLatencies(@NotNull PsiFile psiFile, @NotNull String toolId1, @NotNull String toolId2) {
        Map<Object, ToolHighlights> map;
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(76);
        }
        if (toolId1 == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(77);
        }
        if (toolId2 == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(78);
        }
        if ((map = this.getData(psiFile)).isEmpty()) {
            return 0;
        }
        ToolHighlights toolHighlights1 = map.get(toolId1);
        ToolHighlights toolHighlights2 = map.get(toolId2);
        if (toolHighlights1 == null) {
            return toolHighlights2 == null ? 0 : 1;
        }
        if (toolHighlights2 == null) {
            return -1;
        }
        return toolHighlights1.latencies.compareLatencies(toolHighlights2.latencies);
    }

    @ApiStatus.Internal
    @NotNull
    public @Unmodifiable List<? extends PsiElement> sortByPsiElementFertility(@NotNull PsiFile psiFile, @NotNull LocalInspectionToolWrapper toolWrapper, @NotNull List<? extends PsiElement> elements) {
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(79);
        }
        if (toolWrapper == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(80);
        }
        if (elements == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(81);
        }
        String toolId = toolWrapper.getShortName();
        Map<Object, ToolHighlights> map = this.getData(psiFile);
        if (map.isEmpty()) {
            List<? extends PsiElement> list = elements;
            if (list == null) {
                HighlightInfoUpdaterImpl.$$$reportNull$$$0(82);
            }
            return list;
        }
        ToolHighlights toolHighlights = map.get(toolId);
        if (toolHighlights == null) {
            List<? extends PsiElement> list = elements;
            if (list == null) {
                HighlightInfoUpdaterImpl.$$$reportNull$$$0(83);
            }
            return list;
        }
        Map<PsiElement, List<? extends HighlightInfo>> highlights = toolHighlights.elementHighlights;
        if (highlights.isEmpty()) {
            List<? extends PsiElement> list = elements;
            if (list == null) {
                HighlightInfoUpdaterImpl.$$$reportNull$$$0(84);
            }
            return list;
        }
        List list = ContainerUtil.sorted(elements, (e1, e2) -> {
            List infos1 = (List)highlights.get(e1);
            List infos2 = (List)highlights.get(e2);
            if (infos1 == null || infos2 == null) {
                if (infos1 != null) {
                    return -1;
                }
                if (infos2 != null) {
                    return 1;
                }
                return Integer.compare(System.identityHashCode(e1), System.identityHashCode(e2));
            }
            return HighlightInfoUpdaterImpl.maxSeverity(infos2).compareTo(HighlightInfoUpdaterImpl.maxSeverity(infos1));
        });
        if (list == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(85);
        }
        return list;
    }

    @NotNull
    private static HighlightSeverity maxSeverity(@NotNull List<? extends HighlightInfo> infos) {
        if (infos == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(86);
        }
        HighlightSeverity max = HighlightSeverity.INFORMATION;
        for (HighlightInfo highlightInfo : infos) {
            HighlightSeverity severity = highlightInfo.getSeverity();
            if (severity.compareTo(max) <= 0) continue;
            max = severity;
        }
        HighlightSeverity highlightSeverity = max;
        if (highlightSeverity == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(87);
        }
        return highlightSeverity;
    }

    @ApiStatus.Internal
    public void runWithInvalidPsiRecycler(@NotNull HighlightingSession session, @NotNull WhatTool toolIdPredicate, @NotNull java.util.function.Consumer<? super ManagedHighlighterRecycler> invalidPsiRecyclerConsumer) {
        if (session == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(88);
        }
        if (toolIdPredicate == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(89);
        }
        if (invalidPsiRecyclerConsumer == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(90);
        }
        ManagedHighlighterRecycler.runWithRecycler(session, invalidPsiRecycler -> {
            this.recycleInvalidPsiElements(session.getPsiFile(), this, session, (ManagedHighlighterRecycler)invalidPsiRecycler, toolIdPredicate);
            ScheduledFuture<?> future = invalidPsiRecycler.forAllInGarbageBin().isEmpty() ? null : AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
                if (session.isCanceled() || session.getProgressIndicator().isCanceled()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("runWithInvalidPsiRecycler: recycler(" + String.valueOf((Object)toolIdPredicate) + ") abandoned because the session was canceled: " + String.valueOf(invalidPsiRecycler) + " " + String.valueOf(session.getProgressIndicator()));
                    }
                } else {
                    this.incinerateAndRemoveFromDataAtomically((ManagedHighlighterRecycler)invalidPsiRecycler);
                }
            }), session.getProgressIndicator()), (long)Registry.intValue((String)"highlighting.delay.invalid.psi.info.kill.ms"), TimeUnit.MILLISECONDS);
            try {
                invalidPsiRecyclerConsumer.accept((ManagedHighlighterRecycler)invalidPsiRecycler);
            }
            finally {
                if (future != null) {
                    future.cancel(false);
                }
            }
        });
    }

    @NotNull
    static PsiElement createFakePsiElement(final @NotNull String debugString) {
        if (debugString == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(91);
        }
        return new PsiElement(){

            @NotNull
            public Project getProject() {
                throw this.createException();
            }

            @NotNull
            public Language getLanguage() {
                throw this.createException();
            }

            public PsiManager getManager() {
                throw this.createException();
            }

            public PsiElement @NotNull [] getChildren() {
                if (EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(0);
                }
                return EMPTY_ARRAY;
            }

            public PsiElement getParent() {
                return null;
            }

            @Nullable
            public PsiElement getFirstChild() {
                return null;
            }

            @Nullable
            public PsiElement getLastChild() {
                return null;
            }

            @Nullable
            public PsiElement getNextSibling() {
                return null;
            }

            @Nullable
            public PsiElement getPrevSibling() {
                return null;
            }

            public PsiFile getContainingFile() {
                return null;
            }

            public TextRange getTextRange() {
                return TextRange.EMPTY_RANGE;
            }

            public int getStartOffsetInParent() {
                return -1;
            }

            public int getTextLength() {
                return 0;
            }

            public PsiElement findElementAt(int offset) {
                return null;
            }

            @Nullable
            public PsiReference findReferenceAt(int offset) {
                return null;
            }

            public int getTextOffset() {
                return 0;
            }

            public String getText() {
                return "";
            }

            public char @NotNull [] textToCharArray() {
                if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
                    2.$$$reportNull$$$0(1);
                }
                return ArrayUtil.EMPTY_CHAR_ARRAY;
            }

            public PsiElement getNavigationElement() {
                return null;
            }

            public PsiElement getOriginalElement() {
                return null;
            }

            public boolean textMatches(@NotNull CharSequence text) {
                if (text == null) {
                    2.$$$reportNull$$$0(2);
                }
                return false;
            }

            public boolean textMatches(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(3);
                }
                return false;
            }

            public boolean textContains(char c) {
                return false;
            }

            public void accept(@NotNull PsiElementVisitor visitor) {
                if (visitor == null) {
                    2.$$$reportNull$$$0(4);
                }
            }

            public void acceptChildren(@NotNull PsiElementVisitor visitor) {
                if (visitor == null) {
                    2.$$$reportNull$$$0(5);
                }
            }

            public PsiElement copy() {
                return null;
            }

            public PsiElement add(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(6);
                }
                throw this.createException();
            }

            public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) {
                if (element == null) {
                    2.$$$reportNull$$$0(7);
                }
                throw this.createException();
            }

            public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) {
                if (element == null) {
                    2.$$$reportNull$$$0(8);
                }
                throw this.createException();
            }

            public void checkAdd(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(9);
                }
                throw this.createException();
            }

            public PsiElement addRange(PsiElement first, PsiElement last) {
                throw this.createException();
            }

            public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) {
                if (first == null) {
                    2.$$$reportNull$$$0(10);
                }
                if (last == null) {
                    2.$$$reportNull$$$0(11);
                }
                throw this.createException();
            }

            public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) {
                throw this.createException();
            }

            public void delete() {
                throw this.createException();
            }

            public void checkDelete() {
                throw this.createException();
            }

            public void deleteChildRange(PsiElement first, PsiElement last) {
                throw this.createException();
            }

            public PsiElement replace(@NotNull PsiElement newElement) {
                if (newElement == null) {
                    2.$$$reportNull$$$0(12);
                }
                throw this.createException();
            }

            public boolean isValid() {
                return true;
            }

            public boolean isWritable() {
                return false;
            }

            PsiInvalidElementAccessException createException() {
                return new PsiInvalidElementAccessException((PsiElement)this, this.toString(), null);
            }

            @Nullable
            public PsiReference getReference() {
                return null;
            }

            public PsiReference @NotNull [] getReferences() {
                if (PsiReference.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(13);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            public <T> T getCopyableUserData(@NotNull Key<T> key) {
                if (key == null) {
                    2.$$$reportNull$$$0(14);
                }
                throw this.createException();
            }

            public <T> void putCopyableUserData(@NotNull Key<T> key, T value) {
                if (key == null) {
                    2.$$$reportNull$$$0(15);
                }
                throw this.createException();
            }

            public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
                if (processor == null) {
                    2.$$$reportNull$$$0(16);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(17);
                }
                if (place == null) {
                    2.$$$reportNull$$$0(18);
                }
                return false;
            }

            public PsiElement getContext() {
                return null;
            }

            public boolean isPhysical() {
                return true;
            }

            @NotNull
            public GlobalSearchScope getResolveScope() {
                throw this.createException();
            }

            @NotNull
            public SearchScope getUseScope() {
                throw this.createException();
            }

            public ASTNode getNode() {
                throw this.createException();
            }

            public <T> T getUserData(@NotNull Key<T> key) {
                if (key == null) {
                    2.$$$reportNull$$$0(19);
                }
                throw this.createException();
            }

            public <T> void putUserData(@NotNull Key<T> key, T value) {
                if (key == null) {
                    2.$$$reportNull$$$0(20);
                }
                throw this.createException();
            }

            public Icon getIcon(int flags) {
                throw this.createException();
            }

            public boolean isEquivalentTo(PsiElement another) {
                return this == another;
            }

            public String toString() {
                return "FAKE_PSI_ELEMENT: " + debugString;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 20 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfoUpdaterImpl$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "visitor";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "first";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "last";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElement";
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 19: 
                    case 20: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processor";
                        break;
                    }
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 18: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "textToCharArray";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfoUpdaterImpl$2";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferences";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "textMatches";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "accept";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "acceptChildren";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "add";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "addBefore";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "addAfter";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "checkAdd";
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "addRangeBefore";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "replace";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray;
                        objectArray[2] = "getCopyableUserData";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray;
                        objectArray[2] = "putCopyableUserData";
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 18: {
                        objectArray = objectArray;
                        objectArray[2] = "processDeclarations";
                        break;
                    }
                    case 19: {
                        objectArray = objectArray;
                        objectArray[2] = "getUserData";
                        break;
                    }
                    case 20: {
                        objectArray = objectArray;
                        objectArray[2] = "putUserData";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 20 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @NotNull
    private @Unmodifiable List<? extends HighlightInfo> assignRangeHighlighters(@NotNull PsiElement visitedPsiElement, @NotNull List<? extends HighlightInfo> oldInfos, @NotNull List<? extends HighlightInfo> newInfos, @NotNull Object toolId, @NotNull HighlightingSession session, @NotNull PsiFile psiFile, @NotNull Document hostDocument, @NotNull ManagedHighlighterRecycler invalidElementRecycler, @NotNull ManagedHighlighterRecycler recycler, @NotNull Map<Object, ToolHighlights> data) {
        if (visitedPsiElement == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(92);
        }
        if (oldInfos == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(93);
        }
        if (newInfos == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(94);
        }
        if (toolId == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(95);
        }
        if (session == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(96);
        }
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(97);
        }
        if (hostDocument == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(98);
        }
        if (invalidElementRecycler == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(99);
        }
        if (recycler == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(100);
        }
        if (data == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(101);
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)hostDocument, (Project)session.getProject(), (boolean)true);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(session.getProject());
        Long2ObjectOpenHashMap range2markerCache = new Long2ObjectOpenHashMap(10);
        ArrayList<HighlightInfo> newInfosToStore = new ArrayList<HighlightInfo>(newInfos.size());
        ArrayList<InvalidPsi> toRemove = new ArrayList<InvalidPsi>(newInfos.size());
        for (int i = 0; i < newInfos.size(); ++i) {
            String from;
            long finalInfoRange;
            HighlightInfo newInfo = newInfos.get(i);
            boolean isFileLevel = newInfo.isFileLevelAnnotation();
            long l = finalInfoRange = isFileLevel ? TextRangeScalarUtil.toScalarRange((int)0, (int)psiFile.getTextLength()) : BackgroundUpdateHighlightersUtil.getRangeToCreateHighlighter(newInfo, hostDocument);
            if (finalInfoRange == -1L) continue;
            newInfo = newInfo.copy(true).createUnconditionally();
            assert (toolId.equals(newInfo.toolId)) : "HighlightInfo generated by " + String.valueOf(toolId) + "(" + String.valueOf(toolId.getClass()) + ") must have consistent toolId, but got:" + String.valueOf(newInfo);
            newInfosToStore.add(newInfo);
            int layer = isFileLevel ? -4094 : UpdateHighlightersUtil.getLayer(newInfo, severityRegistrar);
            int infoStartOffset = TextRangeScalarUtil.startOffset((long)finalInfoRange);
            int infoEndOffset = TextRangeScalarUtil.endOffset((long)finalInfoRange);
            InvalidPsi recycled = recycler.pickupHighlighterFromGarbageBin(infoStartOffset, infoEndOffset, layer, newInfo.getDescription());
            if (recycled == null) {
                recycled = invalidElementRecycler.pickupHighlighterFromGarbageBin(infoStartOffset, infoEndOffset, layer, newInfo.getDescription());
                from = "invalidElementRecycler";
            } else {
                from = "recycler";
            }
            if (recycled != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("assignRangeHighlighters: pickedup " + String.valueOf(recycled) + " from " + from + " " + String.valueOf(session.getProgressIndicator()));
                }
                toRemove.add(recycled);
            }
            List existingInfos = List.of();
            if (recycled == null && LOG.isTraceEnabled()) {
                ArrayList<RangeHighlighterEx> dups = new ArrayList<RangeHighlighterEx>();
                markup.processRangeHighlightersOverlappingWith(newInfo.getStartOffset(), newInfo.getEndOffset(), (Processor)new CommonProcessors.CollectProcessor(dups));
                String description = newInfo.getDescription();
                TextAttributesKey infoTextAttributesKey = newInfo.forcedTextAttributesKey == null ? newInfo.type.getAttributesKey() : newInfo.forcedTextAttributesKey;
                dups.removeIf(r -> {
                    HighlightInfo hi;
                    return !r.getTextRange().equalsToRange(infoStartOffset, infoEndOffset) || !Objects.equals(r.getTextAttributesKey(), infoTextAttributesKey) || (hi = HighlightInfo.fromRangeHighlighter((RangeHighlighter)r)) == null || !Objects.equals(hi.getDescription(), description);
                });
                existingInfos = ContainerUtil.map(dups, dup -> {
                    HighlightInfo info = HighlightInfo.fromRangeHighlighter((RangeHighlighter)dup);
                    return info == null ? "no HI" : (info.getHighlighter() != dup ? "inconsistent HI" : "duplicate: " + String.valueOf(dup) + ":" + String.valueOf(this.findInData(info, psiFile)));
                });
            }
            RangeHighlighterEx newHighlighter = HighlightInfoUpdaterImpl.changeRangeHighlighterAttributes(session, psiFile, markup, newInfo, (Long2ObjectMap<RangeMarker>)range2markerCache, finalInfoRange, recycled, isFileLevel, infoStartOffset, infoEndOffset, layer, severityRegistrar);
            if (recycled != null) {
                recycled.info().invalidate();
                continue;
            }
            if (!LOG.isTraceEnabled() || existingInfos.isEmpty()) continue;
            LOG.trace("assignRangeHighlighters duplicates: " + String.valueOf(newInfo) + "\ndups(" + existingInfos.size() + "): " + String.valueOf(existingInfos) + "\nnew: " + String.valueOf(newHighlighter) + "\nrecycler: " + String.valueOf(recycler) + ":" + String.valueOf(recycler.forAllInGarbageBin()) + "\ninvalidRecycler:" + String.valueOf(invalidElementRecycler) + ":" + String.valueOf(invalidElementRecycler.forAllInGarbageBin()) + "\nold infos(" + oldInfos.size() + "): " + String.valueOf(oldInfos) + "\nvisitedPsiElement:" + HighlightInfoUpdaterImpl.debugPsiInfo(visitedPsiElement) + "\n " + String.valueOf(session.getProgressIndicator()));
        }
        HighlightInfoUpdaterImpl.removeFromDataAtomically(data, toRemove, session);
        List sorted = ContainerUtil.sorted(newInfosToStore, BY_OFFSETS_AND_HASH_ERRORS_FIRST);
        for (int i = 0; i < sorted.size(); ++i) {
            HighlightInfo info = (HighlightInfo)sorted.get(i);
            assert (toolId.equals(info.toolId)) : String.valueOf(info) + "; " + String.valueOf(toolId) + "(" + String.valueOf(toolId.getClass()) + ")";
            assert (info.getHighlighter() != null) : info;
            assert (info.getHighlighter().isValid()) : info;
            HighlightInfo assignedInfo = HighlightInfo.fromRangeHighlighter((RangeHighlighter)info.getHighlighter());
            assert (assignedInfo == info) : "from RH: " + String.valueOf(assignedInfo) + "(" + System.identityHashCode(assignedInfo) + "); but expected: " + String.valueOf(info) + "(" + System.identityHashCode(info) + ")";
            if (i <= 0) continue;
            int compare = BY_OFFSETS_AND_HASH_ERRORS_FIRST.compare((HighlightInfo)sorted.get(i - 1), (HighlightInfo)sorted.get(i));
            assert (compare <= 0) : "assignRangeHighlighters returned unsorted list: " + String.valueOf(sorted) + "; " + compare;
        }
        List list = sorted;
        if (list == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(102);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static RangeHighlighterEx changeRangeHighlighterAttributes(@NotNull HighlightingSession session, @NotNull PsiFile psiFile, @NotNull MarkupModelEx markup, @NotNull HighlightInfo newInfo, @NotNull Long2ObjectMap<RangeMarker> range2markerCache, long finalInfoRange, @Nullable InvalidPsi recycled, boolean isFileLevel, int infoStartOffset, int infoEndOffset, int newLayer, @NotNull SeverityRegistrar severityRegistrar) {
        RangeHighlighterEx highlighter;
        if (session == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(103);
        }
        if (psiFile == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(104);
        }
        if (markup == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(105);
        }
        if (newInfo == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(106);
        }
        if (range2markerCache == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(107);
        }
        if (severityRegistrar == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(108);
        }
        CodeInsightContext context = session.getCodeInsightContext();
        TextAttributes infoAttributes = newInfo.getTextAttributes((PsiElement)psiFile, session.getColorsScheme());
        Consumer changeAttributes = finalHighlighter -> BackgroundUpdateHighlightersUtil.changeAttributes(finalHighlighter, newInfo, session.getColorsScheme(), psiFile, infoAttributes, context);
        if (recycled == null) {
            if (isFileLevel) {
                highlighter = HighlightInfoUpdaterImpl.createOrReuseFakeFileLevelHighlighter(-6, newInfo, null, markup, session.getProject(), context);
                ((HighlightingSessionImpl)session).addFileLevelHighlight(newInfo, highlighter);
            } else {
                highlighter = markup.addRangeHighlighterAndChangeAttributes(null, infoStartOffset, infoEndOffset, newLayer, HighlighterTargetArea.EXACT_RANGE, false, changeAttributes);
                newInfo.updateQuickFixFields(session.getDocument(), range2markerCache, finalInfoRange);
            }
        } else {
            void severityRegistrar2;
            HighlightInfo oldInfo = recycled.info();
            HighlightSeverity oldSeverity = oldInfo.getSeverity();
            int oldLayer = isFileLevel ? -4094 : UpdateHighlightersUtil.getLayer(oldInfo, (SeverityRegistrar)severityRegistrar2);
            highlighter = oldInfo.getHighlighter();
            if (isFileLevel) {
                highlighter = HighlightInfoUpdaterImpl.createOrReuseFakeFileLevelHighlighter(-6, newInfo, highlighter, markup, session.getProject(), context);
                ((HighlightingSessionImpl)session).replaceFileLevelHighlight(oldInfo, newInfo, highlighter);
            } else {
                markup.changeAttributesInBatch(highlighter, changeAttributes);
                newInfo.updateQuickFixFields(session.getDocument(), range2markerCache, finalInfoRange);
            }
            oldInfo.copyComputedLazyFixesTo(newInfo, session.getDocument());
            assert (oldInfo.getGroup() == -6) : oldInfo;
            assert (newLayer == oldLayer) : "Trying to to change the severity/layer of existing range highlighter: " + String.valueOf(highlighter) + "; oldInfo=" + String.valueOf(oldInfo) + "; newInfo=" + String.valueOf(newInfo) + "; oldSeverity=" + String.valueOf(oldSeverity) + "(oldLayer=" + oldLayer + "); newSeverity=" + String.valueOf(newInfo.getSeverity()) + "(newLayer=" + newLayer + ")";
        }
        range2markerCache.put(finalInfoRange, (Object)highlighter);
        if (LOG.isTraceEnabled()) {
            LOG.trace("changeRangeHighlighterAttributes: " + (recycled == null ? "(create new RH)" : "(recycled)") + String.valueOf(newInfo) + " " + String.valueOf(session.getProgressIndicator()));
        }
        RangeHighlighterEx rangeHighlighterEx = highlighter;
        if (rangeHighlighterEx == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(109);
        }
        return rangeHighlighterEx;
    }

    @NotNull
    public static RangeHighlighterEx createOrReuseFakeFileLevelHighlighter(int group, @NotNull HighlightInfo info, @Nullable RangeHighlighterEx toReuse, @NotNull MarkupModelEx markupModel, @NotNull Project project, @Nullable CodeInsightContext context) {
        RangeHighlighterEx highlighter;
        if (info == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(110);
        }
        if (markupModel == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(111);
        }
        if (project == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(112);
        }
        Document document = markupModel.getDocument();
        if (toReuse != null && toReuse.isValid()) {
            highlighter = toReuse;
            BackgroundUpdateHighlightersUtil.associateInfoAndHighlighter(info, highlighter);
        } else {
            highlighter = markupModel.addRangeHighlighterAndChangeAttributes(null, 0, document.getTextLength(), -4094, HighlighterTargetArea.EXACT_RANGE, false, ex -> BackgroundUpdateHighlightersUtil.associateInfoAndHighlighter(info, ex));
        }
        highlighter.setGreedyToLeft(true);
        highlighter.setGreedyToRight(true);
        info.setGroup(group);
        if (context != null) {
            CodeInsightContextHighlightingUtil.installCodeInsightContext((RangeHighlighter)highlighter, project, context);
        }
        RangeHighlighterEx rangeHighlighterEx = highlighter;
        if (rangeHighlighterEx == null) {
            HighlightInfoUpdaterImpl.$$$reportNull$$$0(113);
        }
        return rangeHighlighterEx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 9, 16, 26, 48, 61, 62, 67, 82, 83, 84, 85, 87, 102, 109, 113 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 16: 
            case 26: 
            case 48: 
            case 61: 
            case 62: 
            case 67: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 102: 
            case 109: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfoUpdaterImpl";
                break;
            }
            case 3: 
            case 47: 
            case 50: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 4: 
            case 5: 
            case 20: 
            case 29: 
            case 35: 
            case 43: 
            case 49: 
            case 52: 
            case 58: 
            case 59: 
            case 63: 
            case 65: 
            case 74: 
            case 76: 
            case 79: 
            case 97: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: 
            case 8: 
            case 42: 
            case 54: 
            case 72: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 13: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingSession";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "liveInjectedFiles";
                break;
            }
            case 15: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recycler";
                break;
            }
            case 17: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psis";
                break;
            }
            case 19: 
            case 22: 
            case 27: 
            case 31: 
            case 37: 
            case 45: 
            case 73: 
            case 88: 
            case 96: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 21: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidPsiRecycler";
                break;
            }
            case 24: 
            case 60: 
            case 64: 
            case 66: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolIdPredicate";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolPredicate";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementPredicate";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeHighlighterConsumer";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolMap";
                break;
            }
            case 39: 
            case 55: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 40: 
            case 56: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedPsiElement";
                break;
            }
            case 41: 
            case 53: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfos";
                break;
            }
            case 44: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 46: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidElementRecycler";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 57: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFragments";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keepToolIdPredicate";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "latencies";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId1";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId2";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidPsiRecyclerConsumer";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugString";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInfos";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range2markerCache";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfoUpdaterImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "psiFileEvictionListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateHostMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "currentProgressInfo";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "debugPsiInfo";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "head";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfosFromMarkup";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllData";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "sortByPsiElementFertility";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "maxSeverity";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "assignRangeHighlighters";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "changeRangeHighlighterAttributes";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrReuseFakeFileLevelHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runAssertingInvariants";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "psiFileEvictionListener";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 16: 
            case 26: 
            case 48: 
            case 61: 
            case 62: 
            case 67: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 102: 
            case 109: 
            case 113: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addEvictedInfos";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateHostMap";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invokeProcessQueueToTriggerEvictedListener";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeInfosForInjectedFilesOtherThan";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "incinerateAndRemoveFromDataAtomically";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeFromDataAtomically";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "recycleInvalidPsiElements";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "debugPsiInfo";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "disposeEvictedInfos";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "collectPsiElements";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeAllHighlighterInsideFile";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "psiElementVisited";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "head";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "assertNoDuplicates";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "assertRangeHighlightersAreConsistentWithData";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findInData";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getInfosFromMarkup";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "assertMarkupConsistentWithData";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getAllData";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlightsForObsoleteTools";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "removeWarningsInsideErrors";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "saveLatencies";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "compareLatencies";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "sortByPsiElementFertility";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "maxSeverity";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "runWithInvalidPsiRecycler";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "createFakePsiElement";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "assignRangeHighlighters";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "changeRangeHighlighterAttributes";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "createOrReuseFakeFileLevelHighlighter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 9, 16, 26, 48, 61, 62, 67, 82, 83, 84, 85, 87, 102, 109, 113 -> new IllegalStateException(string);
        };
    }

    private final class ToolHighlights {
        @NotNull
        final Map<PsiElement, List<? extends HighlightInfo>> elementHighlights;
        @NotNull
        ToolLatencies latencies;

        private ToolHighlights() {
            this.elementHighlights = CollectionFactory.createConcurrentSoftMap(HighlightInfoUpdaterImpl.this.psiElementEvictionListener);
            this.latencies = new ToolLatencies(0L, 0L, 0L);
        }

        public String toString() {
            return "(" + this.elementHighlights.size() + ") " + String.valueOf(this.elementHighlights);
        }
    }

    @ApiStatus.Internal
    public static final class WhatTool
    extends Enum<WhatTool> {
        public static final /* enum */ WhatTool INSPECTION = new WhatTool();
        public static final /* enum */ WhatTool ANNOTATOR_OR_VISITOR = new WhatTool();
        private static final /* synthetic */ WhatTool[] $VALUES;

        public static WhatTool[] values() {
            return (WhatTool[])$VALUES.clone();
        }

        public static WhatTool valueOf(String name) {
            return Enum.valueOf(WhatTool.class, name);
        }

        private boolean matches(@NotNull Object toolId) {
            if (toolId == null) {
                WhatTool.$$$reportNull$$$0(0);
            }
            if (HighlightInfoUpdaterImpl.isInspectionToolId(toolId)) {
                return this == INSPECTION;
            }
            if (HighlightInfoUpdaterImpl.isAnnotatorToolId(toolId) || HighlightInfoUpdaterImpl.isHighlightVisitorToolId(toolId)) {
                return this == ANNOTATOR_OR_VISITOR;
            }
            if (toolId == InjectedLanguageManagerImpl.INJECTION_BACKGROUND_TOOL_ID || toolId == InjectedLanguageManagerImpl.INJECTION_SYNTAX_TOOL_ID) {
                return false;
            }
            assert (false) : "unknown tool id type: " + String.valueOf(toolId) + "(" + String.valueOf(toolId.getClass()) + ")";
            return false;
        }

        private static /* synthetic */ WhatTool[] $values() {
            return new WhatTool[]{INSPECTION, ANNOTATOR_OR_VISITOR};
        }

        static {
            $VALUES = WhatTool.$values();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInsight/daemon/impl/HighlightInfoUpdaterImpl$WhatTool", "matches"));
        }
    }

    @ApiStatus.Internal
    public record ToolLatencies(long errorLatency, long warningLatency, long otherLatency) {
        int compareLatencies(@NotNull ToolLatencies other) {
            int o;
            if (other == null) {
                ToolLatencies.$$$reportNull$$$0(0);
            }
            if ((o = ToolLatencies.cmp(this.errorLatency, other.errorLatency)) != 0) {
                return o;
            }
            o = ToolLatencies.cmp(this.warningLatency, other.warningLatency);
            if (o != 0) {
                return o;
            }
            o = ToolLatencies.cmp(this.otherLatency, other.otherLatency);
            return o;
        }

        static int cmp(long lat1, long lat2) {
            return Long.compare(lat1 == 0L ? Long.MAX_VALUE : lat1, lat2 == 0L ? Long.MAX_VALUE : lat2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/codeInsight/daemon/impl/HighlightInfoUpdaterImpl$ToolLatencies", "compareLatencies"));
        }
    }
}

