/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class InconsistentLineSeparatorsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            InconsistentLineSeparatorsInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(this){

            public void visitFile(@NotNull PsiFile psiFile) {
                if (psiFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!psiFile.getLanguage().equals(psiFile.getViewProvider().getBaseLanguage())) {
                    return;
                }
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile == null || !AbstractConvertLineSeparatorsAction.shouldProcess((VirtualFile)virtualFile)) {
                    return;
                }
                Project project = holder.getProject();
                String projectLineSeparator = FileDocumentManager.getInstance().getLineSeparator(null, project);
                Set allLineSeparators = LoadTextUtil.detectAllLineSeparators((VirtualFile)virtualFile);
                if (allLineSeparators.size() > 1 || !allLineSeparators.isEmpty() && !allLineSeparators.contains(projectLineSeparator)) {
                    List allSorted = ContainerUtil.sorted((Collection)allLineSeparators);
                    String presentableSeparators = StringUtil.join((Collection)allSorted, sep -> StringUtil.escapeStringCharacters((String)sep), (String)", ");
                    holder.registerProblem((PsiElement)psiFile, AnalysisBundle.message((String)"inspection.message.line.separators.in.current.file.differ.from.project.defaults", (Object[])new Object[]{presentableSeparators, StringUtil.escapeStringCharacters((String)projectLineSeparator)}), new LocalQuickFix[]{new ChangeLineSeparatorFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/openapi/fileEditor/impl/InconsistentLineSeparatorsInspection$1", "visitFile"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/openapi/fileEditor/impl/InconsistentLineSeparatorsInspection", "buildVisitor"));
    }

    private static class ChangeLineSeparatorFix
    implements LocalQuickFix {
        private ChangeLineSeparatorFix() {
        }

        @NotNull
        @IntentionFamilyName
        public String getFamilyName() {
            String string = AnalysisBundle.message((String)"intention.family.name.convert.to.project.line.separators", (Object[])new Object[0]);
            if (string == null) {
                ChangeLineSeparatorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                ChangeLineSeparatorFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ChangeLineSeparatorFix.$$$reportNull$$$0(2);
            }
            if (!((psiElement = descriptor.getPsiElement()) instanceof PsiFile)) {
                return;
            }
            PsiFile psiFile = (PsiFile)psiElement;
            String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(null, project);
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null) {
                AbstractConvertLineSeparatorsAction.changeLineSeparators((Project)project, (VirtualFile)virtualFile, (String)lineSeparator);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/InconsistentLineSeparatorsInspection$ChangeLineSeparatorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/InconsistentLineSeparatorsInspection$ChangeLineSeparatorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

