/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.module.impl.scopes.LibraryRuntimeClasspathScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependentsScope;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ExtensionsKt;
import com.intellij.platform.workspace.jps.entities.InheritedSdkDependency;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.ModuleDependencyItem;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.SdkEntity;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.jps.entities.SdkRoot;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.impl.legacyBridge.sdk.SdkBridgeImplKt;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class LibraryScopeCache {
    private final LibrariesOnlyScope myLibrariesOnlyScope;
    private final Project myProject;
    private final Map<List<? extends Module>, GlobalSearchScope> myLibraryScopes;
    private final ConcurrentMap<String, GlobalSearchScope> mySdkScopes;
    @Deprecated
    private final Map<List<? extends OrderEntry>, GlobalSearchScope> myOrderEntriesToLibraryResolveScopeCache;
    private final Map<VirtualFile, GlobalSearchScope> myFileToLibraryResolveScopeCache;
    @Deprecated
    private final Map<List<? extends OrderEntry>, GlobalSearchScope> myOrderEntriesToLibraryUseScopeCache;
    private final Map<VirtualFile, GlobalSearchScope> myFileToLibraryUseScopeCache;

    public static LibraryScopeCache getInstance(@NotNull Project project) {
        if (project == null) {
            LibraryScopeCache.$$$reportNull$$$0(0);
        }
        return (LibraryScopeCache)project.getService(LibraryScopeCache.class);
    }

    public LibraryScopeCache(@NotNull Project project) {
        if (project == null) {
            LibraryScopeCache.$$$reportNull$$$0(1);
        }
        this.myLibraryScopes = new ConcurrentHashMap<List<? extends Module>, GlobalSearchScope>();
        this.mySdkScopes = new ConcurrentHashMap<String, GlobalSearchScope>();
        this.myOrderEntriesToLibraryResolveScopeCache = ConcurrentFactoryMap.createMap(key -> this.calcLibraryScope((List<? extends OrderEntry>)key));
        this.myFileToLibraryResolveScopeCache = ConcurrentFactoryMap.createMap(key -> this.calcLibraryScope((VirtualFile)key));
        this.myOrderEntriesToLibraryUseScopeCache = ConcurrentFactoryMap.createMap(key -> this.calcLibraryUseScope((List<? extends OrderEntry>)key));
        this.myFileToLibraryUseScopeCache = ConcurrentFactoryMap.createMap(key -> this.calcLibraryUseScope((VirtualFile)key));
        this.myProject = project;
        this.myLibrariesOnlyScope = new LibrariesOnlyScope(GlobalSearchScope.allScope((Project)this.myProject), this.myProject);
    }

    @ApiStatus.Internal
    public void clear() {
        this.myLibraryScopes.clear();
        this.mySdkScopes.clear();
        this.myOrderEntriesToLibraryResolveScopeCache.clear();
        this.myFileToLibraryResolveScopeCache.clear();
        this.myOrderEntriesToLibraryUseScopeCache.clear();
        this.myFileToLibraryUseScopeCache.clear();
    }

    @NotNull
    public GlobalSearchScope getLibrariesOnlyScope() {
        LibrariesOnlyScope librariesOnlyScope = this.myLibrariesOnlyScope;
        if (librariesOnlyScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(2);
        }
        return librariesOnlyScope;
    }

    @NotNull
    private GlobalSearchScope getScopeForLibraryUsedIn(@NotNull List<? extends Module> modulesLibraryIsUsedIn) {
        if (modulesLibraryIsUsedIn == null) {
            LibraryScopeCache.$$$reportNull$$$0(3);
        }
        List<? extends Module> list = List.copyOf(modulesLibraryIsUsedIn);
        GlobalSearchScope globalSearchScope = this.myLibraryScopes.computeIfAbsent(list, modules -> new LibraryRuntimeClasspathScope(this.myProject, (Collection<? extends Module>)modules));
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @Deprecated
    @NotNull
    public GlobalSearchScope getLibraryScope(@NotNull List<? extends OrderEntry> orderEntries) {
        if (orderEntries == null) {
            LibraryScopeCache.$$$reportNull$$$0(5);
        }
        GlobalSearchScope globalSearchScope = this.myOrderEntriesToLibraryResolveScopeCache.get(orderEntries);
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(6);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getLibraryScope(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            LibraryScopeCache.$$$reportNull$$$0(7);
        }
        GlobalSearchScope globalSearchScope = this.myFileToLibraryResolveScopeCache.get(virtualFile);
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    @Deprecated
    @NotNull
    public GlobalSearchScope getLibraryUseScope(@NotNull List<? extends OrderEntry> orderEntries) {
        if (orderEntries == null) {
            LibraryScopeCache.$$$reportNull$$$0(9);
        }
        GlobalSearchScope globalSearchScope = this.myOrderEntriesToLibraryUseScopeCache.get(orderEntries);
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getLibraryUseScope(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            LibraryScopeCache.$$$reportNull$$$0(11);
        }
        GlobalSearchScope globalSearchScope = this.myFileToLibraryUseScopeCache.get(vFile);
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope calcLibraryScope(@NotNull List<? extends OrderEntry> orderEntries) {
        if (orderEntries == null) {
            LibraryScopeCache.$$$reportNull$$$0(13);
        }
        ArrayList<Module> modulesLibraryUsedIn = new ArrayList<Module>();
        LibraryOrderEntry lib = null;
        for (OrderEntry orderEntry : orderEntries) {
            if (orderEntry instanceof JdkOrderEntry) {
                JdkOrderEntry jdkOrderEntry = (JdkOrderEntry)orderEntry;
                GlobalSearchScope globalSearchScope = this.getScopeForSdk(jdkOrderEntry);
                if (globalSearchScope == null) {
                    LibraryScopeCache.$$$reportNull$$$0(14);
                }
                return globalSearchScope;
            }
            if (orderEntry instanceof LibraryOrderEntry) {
                LibraryOrderEntry libraryOrderEntry;
                lib = libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                modulesLibraryUsedIn.add(orderEntry.getOwnerModule());
                continue;
            }
            if (!(orderEntry instanceof ModuleOrderEntry)) continue;
            modulesLibraryUsedIn.add(orderEntry.getOwnerModule());
        }
        GlobalSearchScope globalSearchScope = this.getScopeForLibrary(modulesLibraryUsedIn, lib == null ? null : new LibraryRuntimeClasspathScope(this.myProject, lib));
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope calcLibraryScope(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            LibraryScopeCache.$$$reportNull$$$0(16);
        }
        if (Registry.is((String)"use.workspace.model.for.calculation.library.scope")) {
            ProjectFileIndex index = ProjectFileIndex.getInstance((Project)this.myProject);
            Collection sdks = index.findContainingSdks(virtualFile);
            Iterator iterator = sdks.iterator();
            if (iterator.hasNext()) {
                SdkEntity sdk = (SdkEntity)iterator.next();
                return this.getScopeForSdk(sdk);
            }
            Collection libraries = index.findContainingLibraries(virtualFile);
            ImmutableEntityStorage currentSnapshot = WorkspaceModel.getInstance((Project)this.myProject).getCurrentSnapshot();
            LibraryEntity lib = null;
            ArrayList<Module> modulesLibraryUsedIn = new ArrayList<Module>();
            Iterator iterator2 = libraries.iterator();
            while (iterator2.hasNext()) {
                LibraryEntity library;
                lib = library = (LibraryEntity)iterator2.next();
                modulesLibraryUsedIn.addAll(LibraryScopeCache.modulesWithLibraryId(library.getSymbolicId(), currentSnapshot));
            }
            if (lib != null) {
                VirtualFile[] roots = (VirtualFile[])lib.getRoots().stream().map(LibraryRoot::getUrl).map(VirtualFileUrls::getVirtualFile).toArray(VirtualFile[]::new);
                GlobalSearchScope globalSearchScope = this.getScopeForLibrary(modulesLibraryUsedIn, new LibraryRuntimeClasspathScope(this.myProject, roots));
                if (globalSearchScope == null) {
                    LibraryScopeCache.$$$reportNull$$$0(17);
                }
                return globalSearchScope;
            }
            GlobalSearchScope globalSearchScope = this.getScopeForLibrary(modulesLibraryUsedIn, null);
            if (globalSearchScope == null) {
                LibraryScopeCache.$$$reportNull$$$0(18);
            }
            return globalSearchScope;
        }
        List orderEntries = ProjectFileIndex.getInstance((Project)this.myProject).getOrderEntriesForFile(virtualFile);
        return this.calcLibraryScope(orderEntries);
    }

    @NotNull
    public GlobalSearchScope getScopeForSdk(@NotNull JdkOrderEntry jdkOrderEntry) {
        String jdkName;
        if (jdkOrderEntry == null) {
            LibraryScopeCache.$$$reportNull$$$0(19);
        }
        if ((jdkName = jdkOrderEntry.getJdkName()) == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                LibraryScopeCache.$$$reportNull$$$0(20);
            }
            return globalSearchScope;
        }
        GlobalSearchScope scope = (GlobalSearchScope)this.mySdkScopes.get(jdkName);
        if (scope == null) {
            scope = new JdkScope(this.myProject, jdkOrderEntry);
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)ConcurrencyUtil.cacheOrGet(this.mySdkScopes, (Object)jdkName, (Object)scope);
            if (globalSearchScope == null) {
                LibraryScopeCache.$$$reportNull$$$0(21);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(22);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope getScopeForSdk(@NotNull SdkEntity sdkEntity) {
        String name;
        GlobalSearchScope scope;
        if (sdkEntity == null) {
            LibraryScopeCache.$$$reportNull$$$0(23);
        }
        if ((scope = (GlobalSearchScope)this.mySdkScopes.get(name = sdkEntity.getName())) == null) {
            String sdkSourcesRootTypeName = SdkBridgeImplKt.getCustomName((OrderRootType)OrderRootType.SOURCES);
            String sdkClassesRootTypeName = SdkBridgeImplKt.getCustomName((OrderRootType)OrderRootType.CLASSES);
            List roots = sdkEntity.getRoots();
            VirtualFile[] sources = (VirtualFile[])roots.stream().filter(root -> Objects.equals(root.getType().getName(), sdkSourcesRootTypeName)).map(SdkRoot::getUrl).map(VirtualFileUrls::getVirtualFile).toArray(VirtualFile[]::new);
            VirtualFile[] classes = (VirtualFile[])roots.stream().filter(root -> Objects.equals(root.getType().getName(), sdkClassesRootTypeName)).map(SdkRoot::getUrl).map(VirtualFileUrls::getVirtualFile).toArray(VirtualFile[]::new);
            scope = new JdkScope(this.myProject, classes, sources, sdkEntity.getName());
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)ConcurrencyUtil.cacheOrGet(this.mySdkScopes, (Object)name, (Object)scope);
            if (globalSearchScope == null) {
                LibraryScopeCache.$$$reportNull$$$0(24);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(25);
        }
        return globalSearchScope;
    }

    private GlobalSearchScope getScopeForLibrary(List<Module> modulesLibraryUsedIn, final @Nullable LibraryRuntimeClasspathScope libraryScope) {
        LibrariesOnlyScope allCandidates;
        Comparator<Module> comparator = Comparator.comparing(Module::getName);
        modulesLibraryUsedIn.sort(comparator);
        List uniquesList = ContainerUtil.removeDuplicatesFromSorted(modulesLibraryUsedIn, comparator);
        LibrariesOnlyScope librariesOnlyScope = allCandidates = uniquesList.isEmpty() ? this.myLibrariesOnlyScope : this.getScopeForLibraryUsedIn(uniquesList);
        if (libraryScope != null) {
            return new DelegatingGlobalSearchScope(this, (GlobalSearchScope)allCandidates, new Object[]{libraryScope}){

                public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                    if (file1 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    boolean c1 = libraryScope.contains(file1);
                    boolean c2 = libraryScope.contains(file2);
                    if (c1 && !c2) {
                        return 1;
                    }
                    if (c2 && !c1) {
                        return -1;
                    }
                    return super.compare(file1, file2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file2";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/roots/impl/LibraryScopeCache$1";
                    objectArray[2] = "compare";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return allCandidates;
    }

    @NotNull
    private GlobalSearchScope calcLibraryUseScope(@NotNull List<? extends OrderEntry> entries) {
        if (entries == null) {
            LibraryScopeCache.$$$reportNull$$$0(26);
        }
        HashSet<Module> modulesWithLibrary = new HashSet<Module>(entries.size());
        HashSet<Module> modulesWithSdk = new HashSet<Module>(entries.size());
        for (OrderEntry orderEntry : entries) {
            (orderEntry instanceof JdkOrderEntry ? modulesWithSdk : modulesWithLibrary).add(orderEntry.getOwnerModule());
        }
        return this.calcLibraryUseScope(modulesWithLibrary, modulesWithSdk);
    }

    @NotNull
    private GlobalSearchScope calcLibraryUseScope(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            LibraryScopeCache.$$$reportNull$$$0(27);
        }
        if (Registry.is((String)"use.workspace.model.for.calculation.library.scope")) {
            ProjectFileIndex index = ProjectFileIndex.getInstance((Project)this.myProject);
            ImmutableEntityStorage currentSnapshot = WorkspaceModel.getInstance((Project)this.myProject).getCurrentSnapshot();
            Collection sdks = index.findContainingSdks(virtualFile);
            Collection libraries = index.findContainingLibraries(virtualFile);
            HashSet<Module> modulesWithSdk = new HashSet<Module>();
            for (SdkEntity sdk : sdks) {
                SdkId sdkId = sdk.getSymbolicId();
                for (ModuleEntity module : SequencesKt.toList((Sequence)currentSnapshot.referrers((SymbolicEntityId)sdkId, ModuleEntity.class))) {
                    Module moduleBridge = ModuleBridges.findModule((ModuleEntity)module, (EntityStorage)currentSnapshot);
                    if (moduleBridge == null) continue;
                    modulesWithSdk.add(moduleBridge);
                }
                this.addModulesInheritingProjectSdk(sdkId, currentSnapshot, modulesWithSdk);
            }
            HashSet<Module> modulesWithLibrary = new HashSet<Module>();
            for (LibraryEntity library : libraries) {
                modulesWithLibrary.addAll(LibraryScopeCache.modulesWithLibraryId(library.getSymbolicId(), currentSnapshot));
            }
            modulesWithLibrary.addAll(index.getModulesForFile(virtualFile, false));
            return this.calcLibraryUseScope(modulesWithLibrary, modulesWithSdk);
        }
        List entries = ProjectFileIndex.getInstance((Project)this.myProject).getOrderEntriesForFile(virtualFile);
        return this.calcLibraryUseScope(entries);
    }

    @NotNull
    private GlobalSearchScope calcLibraryUseScope(Set<Module> modulesWithLibrary, Set<Module> modulesWithSdk) {
        modulesWithSdk.removeAll(modulesWithLibrary);
        if (modulesWithSdk.size() + modulesWithLibrary.size() == ModuleManager.getInstance((Project)this.myProject).getModules().length) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                LibraryScopeCache.$$$reportNull$$$0(28);
            }
            return globalSearchScope;
        }
        ArrayList<Object> united = new ArrayList<Object>();
        if (!modulesWithSdk.isEmpty()) {
            united.add((Object)new ModulesScope(modulesWithSdk, this.myProject));
            united.add(this.myLibrariesOnlyScope.intersectWith(new LibraryRuntimeClasspathScope(this.myProject, modulesWithSdk)));
        } else {
            united.add((Object)this.myLibrariesOnlyScope);
        }
        if (!modulesWithLibrary.isEmpty()) {
            united.add((Object)new ModuleWithDependentsScope(this.myProject, modulesWithLibrary));
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])united.toArray(GlobalSearchScope.EMPTY_ARRAY));
        if (globalSearchScope == null) {
            LibraryScopeCache.$$$reportNull$$$0(29);
        }
        return globalSearchScope;
    }

    private void addModulesInheritingProjectSdk(SdkId sdkId, ImmutableEntityStorage currentSnapshot, Set<Module> result) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        if (projectSdk == null || !projectSdk.getName().equals(sdkId.getName())) {
            return;
        }
        block0: for (ModuleEntity moduleEntity : SequencesKt.toList((Sequence)currentSnapshot.entities(ModuleEntity.class))) {
            for (ModuleDependencyItem dep : moduleEntity.getDependencies()) {
                if (!(dep instanceof InheritedSdkDependency)) continue;
                Module moduleBridge = ModuleBridges.findModule((ModuleEntity)moduleEntity, (EntityStorage)currentSnapshot);
                if (moduleBridge == null) continue block0;
                result.add(moduleBridge);
                continue block0;
            }
        }
    }

    private static Set<Module> modulesWithLibraryId(LibraryId libraryId, ImmutableEntityStorage currentSnapshot) {
        HashSet<Module> modulesWithLibrary = new HashSet<Module>();
        List ownerModules = SequencesKt.toList((Sequence)currentSnapshot.referrers((SymbolicEntityId)libraryId, ModuleEntity.class));
        for (ModuleEntity module : ownerModules) {
            Module moduleBridge = ModuleBridges.findModule((ModuleEntity)module, (EntityStorage)currentSnapshot);
            if (moduleBridge != null) {
                modulesWithLibrary.add(moduleBridge);
            }
            if (!LibraryScopeCache.exportsLibrary(module, libraryId)) continue;
            Set transitiveModules = ExtensionsKt.collectTransitivelyDependentModules((ModuleEntity)module, (EntityStorage)currentSnapshot);
            for (ModuleEntity depModule : transitiveModules) {
                Module depModuleBridge = ModuleBridges.findModule((ModuleEntity)depModule, (EntityStorage)currentSnapshot);
                if (depModuleBridge == null) continue;
                modulesWithLibrary.add(depModuleBridge);
            }
        }
        return modulesWithLibrary;
    }

    private static boolean exportsLibrary(ModuleEntity module, LibraryId libraryId) {
        for (ModuleDependencyItem moduleDependency : module.getDependencies()) {
            LibraryDependency libraryDependency;
            if (!(moduleDependency instanceof LibraryDependency) || !(libraryDependency = (LibraryDependency)moduleDependency).getLibrary().equals((Object)libraryId) || !libraryDependency.getExported()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 10, 12, 14, 15, 17, 18, 20, 21, 22, 24, 25, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/LibraryScopeCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesLibraryIsUsedIn";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 7: 
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkOrderEntry";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkEntity";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/LibraryScopeCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrariesOnlyScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForLibraryUsedIn";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryScope";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryUseScope";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLibraryScope";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeForSdk";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLibraryUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForLibraryUsedIn";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryScope";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryUseScope";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calcLibraryScope";
                break;
            }
            case 19: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForSdk";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "calcLibraryUseScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8, 10, 12, 14, 15, 17, 18, 20, 21, 22, 24, 25, 28, 29 -> new IllegalStateException(string);
        };
    }

    private static final class LibrariesOnlyScope
    extends DelegatingGlobalSearchScope {
        private final ProjectFileIndex myIndex;

        private LibrariesOnlyScope(@NotNull GlobalSearchScope original, @NotNull Project project) {
            if (original == null) {
                LibrariesOnlyScope.$$$reportNull$$$0(0);
            }
            if (project == null) {
                LibrariesOnlyScope.$$$reportNull$$$0(1);
            }
            super(original);
            this.myIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                LibrariesOnlyScope.$$$reportNull$$$0(2);
            }
            return super.contains(file) && this.myIndex.isInLibrary(file);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                LibrariesOnlyScope.$$$reportNull$$$0(3);
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }

        public String toString() {
            return "Libraries only in (" + String.valueOf(this.myBaseScope) + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/impl/LibraryScopeCache$LibrariesOnlyScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

