/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.util.PsiUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInspection/IllegalDependencyOnInternalPackage;", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.jvm.analysis.impl"})
final class IllegalDependencyOnInternalPackage
extends PsiElementVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public IllegalDependencyOnInternalPackage(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public void visitFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.MODULES, (PsiElement)((PsiElement)psiFile)) || JavaModuleGraphUtil.findDescriptorByElement((PsiElement)((PsiElement)psiFile)) != null) {
            return;
        }
        DependenciesBuilder.analyzeFileDependencies((PsiFile)psiFile, (arg_0, arg_1) -> IllegalDependencyOnInternalPackage.visitFile$lambda$0(this, arg_0, arg_1));
    }

    private static final void visitFile$lambda$0(IllegalDependencyOnInternalPackage this$0, PsiElement place, PsiElement dependency) {
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        if (!(dependency instanceof PsiClass)) {
            return;
        }
        PsiFile dependencyFile = ((PsiClass)dependency).getContainingFile();
        if (!(dependencyFile instanceof PsiClassOwner) || !((PsiClassOwner)dependencyFile).isPhysical() || ((PsiClassOwner)dependencyFile).getVirtualFile() == null) {
            return;
        }
        PsiJavaModule javaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)((PsiElement)dependencyFile));
        if (javaModule == null || javaModule instanceof LightJavaModule) {
            return;
        }
        String string = javaModule.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String moduleName = string;
        if (StringsKt.startsWith$default((String)moduleName, (String)"java.", (boolean)false, (int)2, null)) {
            return;
        }
        String packageName = ((PsiClassOwner)dependencyFile).getPackageName();
        if (JavaPsiModuleUtil.exports((PsiJavaModule)javaModule, (String)packageName, null)) {
            return;
        }
        Object[] objectArray = new Object[]{moduleName, packageName};
        this$0.holder.registerProblem(place, JvmAnalysisBundle.message("inspection.message.illegal.dependency.module.doesn.t.export", objectArray), new LocalQuickFix[0]);
    }
}

