/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.codeVision.settings;

import com.intellij.codeInsight.codeVision.CodeVisionAnchorKind;
import com.intellij.codeInsight.codeVision.settings.CodeVisionSettingsDefaults;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.Storage;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="CodeVisionSettings", storages={@Storage(value="editor.xml")}, category=SettingsCategory.CODE)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\r\b\u0007\u0018\u0000 72\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003789B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0013J\u000e\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020$J\u0016\u0010*\u001a\u00020&2\u0006\u0010)\u001a\u00020$2\u0006\u0010+\u001a\u00020\rJ\u000e\u00100\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0013J\u0016\u00101\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u0019J\b\u00103\u001a\u00020\u0002H\u0016J\u0010\u00104\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\b\u00105\u001a\u00020\u0013H\u0002J\u0006\u00106\u001a\u00020&R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020$0-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006:"}, d2={"Lcom/intellij/codeInsight/codeVision/settings/CodeVisionSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/codeInsight/codeVision/settings/CodeVisionSettings$State;", "<init>", "()V", "state", "stateLock", "", "listener", "Lcom/intellij/codeInsight/codeVision/settings/CodeVisionSettings$CodeVisionSettingsListener;", "getListener", "()Lcom/intellij/codeInsight/codeVision/settings/CodeVisionSettings$CodeVisionSettingsListener;", "value", "", "codeVisionEnabled", "getCodeVisionEnabled", "()Z", "setCodeVisionEnabled", "(Z)V", "Lcom/intellij/codeInsight/codeVision/CodeVisionAnchorKind;", "defaultPosition", "getDefaultPosition", "()Lcom/intellij/codeInsight/codeVision/CodeVisionAnchorKind;", "setDefaultPosition", "(Lcom/intellij/codeInsight/codeVision/CodeVisionAnchorKind;)V", "", "visibleMetricsAboveDeclarationCount", "getVisibleMetricsAboveDeclarationCount", "()I", "setVisibleMetricsAboveDeclarationCount", "(I)V", "visibleMetricsNextToDeclarationCount", "getVisibleMetricsNextToDeclarationCount", "setVisibleMetricsNextToDeclarationCount", "getPositionForGroup", "groupName", "", "setPositionForGroup", "", "position", "isProviderEnabled", "id", "setProviderEnabled", "isEnabled", "disabledCodeVisionProviderIds", "", "getDisabledCodeVisionProviderIds", "()Ljava/util/Set;", "getAnchorLimit", "setAnchorLimit", "i", "getState", "loadState", "defaultPositionValue", "resetDefaultPosition", "Companion", "State", "CodeVisionSettingsListener", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nCodeVisionSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeVisionSettings.kt\ncom/intellij/codeInsight/codeVision/settings/CodeVisionSettings\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n507#2,7:187\n777#3:194\n873#3,2:195\n1#4:197\n*S KotlinDebug\n*F\n+ 1 CodeVisionSettings.kt\ncom/intellij/codeInsight/codeVision/settings/CodeVisionSettings\n*L\n132#1:187,7\n134#1:194\n134#1:195,2\n*E\n"})
public final class CodeVisionSettings
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State state = new State();
    @NotNull
    private final Object stateLock = new Object();
    @Topic.AppLevel
    @NotNull
    private static final Topic<CodeVisionSettingsListener> CODE_LENS_SETTINGS_CHANGED = new Topic(CodeVisionSettingsListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);

    private final CodeVisionSettingsListener getListener() {
        return (CodeVisionSettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(CODE_LENS_SETTINGS_CHANGED);
    }

    public final boolean getCodeVisionEnabled() {
        return this.state.isEnabled();
    }

    public final void setCodeVisionEnabled(boolean value) {
        this.state.setEnabled(value);
        this.getListener().globalEnabledChanged(value);
    }

    @NotNull
    public final CodeVisionAnchorKind getDefaultPosition() {
        return this.defaultPositionValue();
    }

    public final void setDefaultPosition(@NotNull CodeVisionAnchorKind value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.state.setDefaultPosition(value.name());
        this.getListener().defaultPositionChanged(value);
    }

    public final int getVisibleMetricsAboveDeclarationCount() {
        return this.state.getVisibleMetricsAboveDeclarationCount();
    }

    public final void setVisibleMetricsAboveDeclarationCount(int value) {
        this.state.setVisibleMetricsAboveDeclarationCount(value);
        this.getListener().visibleMetricsAboveDeclarationCountChanged(value);
    }

    public final int getVisibleMetricsNextToDeclarationCount() {
        return this.state.getVisibleMetricsNextToDeclarationCount();
    }

    public final void setVisibleMetricsNextToDeclarationCount(int value) {
        this.state.setVisibleMetricsNextToDeclarationCount(value);
        this.getListener().visibleMetricsNextToDeclarationCountChanged(value);
    }

    @Nullable
    public final CodeVisionAnchorKind getPositionForGroup(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        String string = this.state.getCodeVisionGroupToPosition().get(groupName);
        if (string == null) {
            return null;
        }
        String position = string;
        return CodeVisionAnchorKind.valueOf(position);
    }

    public final void setPositionForGroup(@NotNull String groupName, @NotNull CodeVisionAnchorKind position) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        this.state.getCodeVisionGroupToPosition().put(groupName, position.name());
        this.getListener().groupPositionChanged(groupName, position);
    }

    public final boolean isProviderEnabled(@NotNull String id) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.state.getDisabledCodeVisionProviderIds().contains(id)) {
            bl = false;
        } else if (this.state.getEnabledCodeVisionProviderIds().contains(id)) {
            bl = true;
        } else {
            Boolean bl2 = CodeVisionSettingsDefaults.Companion.getInstance().getDefaultEnablementForProviderId().get(id);
            bl = bl2 != null ? bl2 : true;
        }
        return bl;
    }

    public final void setProviderEnabled(@NotNull String id, boolean isEnabled) {
        boolean isEnabledByDefault;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Boolean bl = CodeVisionSettingsDefaults.Companion.getInstance().getDefaultEnablementForProviderId().get(id);
        boolean bl2 = isEnabledByDefault = bl != null ? bl : true;
        if (isEnabled == isEnabledByDefault) {
            this.state.getDisabledCodeVisionProviderIds().remove(id);
            v2 = this.state.getEnabledCodeVisionProviderIds().remove(id);
        } else if (isEnabled) {
            this.state.getDisabledCodeVisionProviderIds().remove(id);
            v2 = this.state.getEnabledCodeVisionProviderIds().add(id);
        } else {
            this.state.getDisabledCodeVisionProviderIds().add(id);
            v2 = this.state.getEnabledCodeVisionProviderIds().remove(id);
        }
        this.getListener().providerAvailabilityChanged(id, isEnabled);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getDisabledCodeVisionProviderIds() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable $this$filterValues$iv;
        Set set;
        Set $this$_get_disabledCodeVisionProviderIds__u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$_get_disabledCodeVisionProviderIds__u24lambda_u240.addAll((Collection)this.state.getDisabledCodeVisionProviderIds());
        Map<String, Boolean> map = CodeVisionSettingsDefaults.Companion.getInstance().getDefaultEnablementForProviderId();
        Set set2 = $this$_get_disabledCodeVisionProviderIds__u24lambda_u240;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            boolean enabled = (Boolean)entry$iv.getValue();
            boolean bl2 = false;
            if (!(!enabled)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = ((Map)result$iv).keySet();
        boolean $i$f$filter = false;
        result$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String id = (String)element$iv$iv;
            boolean bl3 = false;
            if (!(!this.state.getEnabledCodeVisionProviderIds().contains(id))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        set2.addAll((List)destination$iv$iv);
        return SetsKt.build((Set)set);
    }

    public final int getAnchorLimit(@NotNull CodeVisionAnchorKind position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        return switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
            case 1 -> this.getVisibleMetricsAboveDeclarationCount();
            case 2 -> this.getVisibleMetricsNextToDeclarationCount();
            case 3 -> this.getAnchorLimit(this.defaultPositionValue());
            default -> this.getAnchorLimit(this.defaultPositionValue());
        };
    }

    public final void setAnchorLimit(@NotNull CodeVisionAnchorKind defaultPosition, int i) {
        Intrinsics.checkNotNullParameter((Object)((Object)defaultPosition), (String)"defaultPosition");
        switch (WhenMappings.$EnumSwitchMapping$0[defaultPosition.ordinal()]) {
            case 1: {
                this.setVisibleMetricsAboveDeclarationCount(i);
                break;
            }
            case 2: {
                this.setVisibleMetricsNextToDeclarationCount(i);
                break;
            }
            case 3: {
                this.setAnchorLimit(this.defaultPositionValue(), i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public State getState() {
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            State state = this.state;
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            this.state = state;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final CodeVisionAnchorKind defaultPositionValue() {
        Object object;
        block3: {
            block2: {
                object = this.state.getDefaultPosition();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                CodeVisionAnchorKind codeVisionAnchorKind = CodeVisionAnchorKind.valueOf(it);
                object = codeVisionAnchorKind;
                if (codeVisionAnchorKind != null) break block3;
            }
            object = CodeVisionSettingsDefaults.Companion.getInstance().getDefaultPosition();
        }
        return object;
    }

    public final void resetDefaultPosition() {
        this.state.setDefaultPosition(null);
    }

    @JvmStatic
    @NotNull
    public static final CodeVisionSettings getInstance() {
        return Companion.getInstance();
    }

    @NotNull
    public static final Topic<CodeVisionSettingsListener> getCODE_LENS_SETTINGS_CHANGED() {
        return Companion.getCODE_LENS_SETTINGS_CHANGED();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0010H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lcom/intellij/codeInsight/codeVision/settings/CodeVisionSettings$CodeVisionSettingsListener;", "", "globalEnabledChanged", "", "newValue", "", "providerAvailabilityChanged", "id", "", "isEnabled", "groupPositionChanged", "position", "Lcom/intellij/codeInsight/codeVision/CodeVisionAnchorKind;", "defaultPositionChanged", "newDefaultPosition", "visibleMetricsAboveDeclarationCountChanged", "", "visibleMetricsNextToDeclarationCountChanged", "intellij.platform.lang"})
    public static interface CodeVisionSettingsListener {
        default public void globalEnabledChanged(boolean newValue) {
        }

        default public void providerAvailabilityChanged(@NotNull String id, boolean isEnabled) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        }

        public void groupPositionChanged(@NotNull String var1, @NotNull CodeVisionAnchorKind var2);

        default public void defaultPositionChanged(@NotNull CodeVisionAnchorKind newDefaultPosition) {
            Intrinsics.checkNotNullParameter((Object)((Object)newDefaultPosition), (String)"newDefaultPosition");
        }

        default public void visibleMetricsAboveDeclarationCountChanged(int newValue) {
        }

        default public void visibleMetricsNextToDeclarationCountChanged(int newValue) {
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/codeVision/settings/CodeVisionSettings$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/codeInsight/codeVision/settings/CodeVisionSettings;", "instance", "CODE_LENS_SETTINGS_CHANGED", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/codeInsight/codeVision/settings/CodeVisionSettings$CodeVisionSettingsListener;", "getCODE_LENS_SETTINGS_CHANGED$annotations", "getCODE_LENS_SETTINGS_CHANGED", "()Lcom/intellij/util/messages/Topic;", "intellij.platform.lang"})
    @SourceDebugExtension(value={"SMAP\nCodeVisionSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeVisionSettings.kt\ncom/intellij/codeInsight/codeVision/settings/CodeVisionSettings$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,186:1\n30#2,2:187\n*S KotlinDebug\n*F\n+ 1 CodeVisionSettings.kt\ncom/intellij/codeInsight/codeVision/settings/CodeVisionSettings$Companion\n*L\n18#1:187,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CodeVisionSettings getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<CodeVisionSettings> serviceClass$iv = CodeVisionSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CodeVisionSettings)object;
        }

        @Deprecated(message="Use CodeVisionSettings.getInstance()", replaceWith=@ReplaceWith(expression="getInstance()", imports={}))
        @NotNull
        public final CodeVisionSettings instance() {
            return this.getInstance();
        }

        @NotNull
        public final Topic<CodeVisionSettingsListener> getCODE_LENS_SETTINGS_CHANGED() {
            return CODE_LENS_SETTINGS_CHANGED;
        }

        @JvmStatic
        public static /* synthetic */ void getCODE_LENS_SETTINGS_CHANGED$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR&\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/intellij/codeInsight/codeVision/settings/CodeVisionSettings$State;", "", "<init>", "()V", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "defaultPosition", "", "getDefaultPosition", "()Ljava/lang/String;", "setDefaultPosition", "(Ljava/lang/String;)V", "visibleMetricsAboveDeclarationCount", "", "getVisibleMetricsAboveDeclarationCount", "()I", "setVisibleMetricsAboveDeclarationCount", "(I)V", "visibleMetricsNextToDeclarationCount", "getVisibleMetricsNextToDeclarationCount", "setVisibleMetricsNextToDeclarationCount", "disabledCodeVisionProviderIds", "Ljava/util/TreeSet;", "getDisabledCodeVisionProviderIds", "()Ljava/util/TreeSet;", "setDisabledCodeVisionProviderIds", "(Ljava/util/TreeSet;)V", "enabledCodeVisionProviderIds", "getEnabledCodeVisionProviderIds", "setEnabledCodeVisionProviderIds", "codeVisionGroupToPosition", "", "getCodeVisionGroupToPosition", "()Ljava/util/Map;", "setCodeVisionGroupToPosition", "(Ljava/util/Map;)V", "intellij.platform.lang"})
    public static final class State {
        private boolean isEnabled = true;
        @Nullable
        private String defaultPosition;
        private int visibleMetricsAboveDeclarationCount = 5;
        private int visibleMetricsNextToDeclarationCount = 5;
        @NotNull
        private TreeSet<String> disabledCodeVisionProviderIds = SetsKt.sortedSetOf((Object[])new String[0]);
        @NotNull
        private TreeSet<String> enabledCodeVisionProviderIds = SetsKt.sortedSetOf((Object[])new String[0]);
        @NotNull
        private Map<String, String> codeVisionGroupToPosition = new LinkedHashMap();

        public final boolean isEnabled() {
            return this.isEnabled;
        }

        public final void setEnabled(boolean bl) {
            this.isEnabled = bl;
        }

        @Nullable
        public final String getDefaultPosition() {
            return this.defaultPosition;
        }

        public final void setDefaultPosition(@Nullable String string) {
            this.defaultPosition = string;
        }

        public final int getVisibleMetricsAboveDeclarationCount() {
            return this.visibleMetricsAboveDeclarationCount;
        }

        public final void setVisibleMetricsAboveDeclarationCount(int n) {
            this.visibleMetricsAboveDeclarationCount = n;
        }

        public final int getVisibleMetricsNextToDeclarationCount() {
            return this.visibleMetricsNextToDeclarationCount;
        }

        public final void setVisibleMetricsNextToDeclarationCount(int n) {
            this.visibleMetricsNextToDeclarationCount = n;
        }

        @NotNull
        public final TreeSet<String> getDisabledCodeVisionProviderIds() {
            return this.disabledCodeVisionProviderIds;
        }

        public final void setDisabledCodeVisionProviderIds(@NotNull TreeSet<String> treeSet) {
            Intrinsics.checkNotNullParameter(treeSet, (String)"<set-?>");
            this.disabledCodeVisionProviderIds = treeSet;
        }

        @NotNull
        public final TreeSet<String> getEnabledCodeVisionProviderIds() {
            return this.enabledCodeVisionProviderIds;
        }

        public final void setEnabledCodeVisionProviderIds(@NotNull TreeSet<String> treeSet) {
            Intrinsics.checkNotNullParameter(treeSet, (String)"<set-?>");
            this.enabledCodeVisionProviderIds = treeSet;
        }

        @NotNull
        public final Map<String, String> getCodeVisionGroupToPosition() {
            return this.codeVisionGroupToPosition;
        }

        public final void setCodeVisionGroupToPosition(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.codeVisionGroupToPosition = map;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CodeVisionAnchorKind.values().length];
            try {
                nArray[CodeVisionAnchorKind.Top.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeVisionAnchorKind.Right.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeVisionAnchorKind.Default.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

