/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseElementAtCaretIntentionAction
extends BaseIntentionAction {
    private volatile boolean useElementToTheLeft;

    public final boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        PsiElement elementToTheLeft;
        if (project == null) {
            BaseElementAtCaretIntentionAction.$$$reportNull$$$0(0);
        }
        if (editor == null || psiFile == null || !this.checkFile(psiFile)) {
            return false;
        }
        this.useElementToTheLeft = false;
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementToTheRight = psiFile.findElementAt(offset);
        if (elementToTheRight != null && this.isAvailable(project, editor, elementToTheRight)) {
            return true;
        }
        PsiElement psiElement = elementToTheLeft = offset > 0 ? psiFile.findElementAt(offset - 1) : null;
        if (elementToTheLeft != null && this.isAvailable(project, editor, elementToTheLeft)) {
            this.useElementToTheLeft = true;
            return true;
        }
        return false;
    }

    protected boolean checkFile(@NotNull PsiFile file) {
        if (file == null) {
            BaseElementAtCaretIntentionAction.$$$reportNull$$$0(1);
        }
        return BaseElementAtCaretIntentionAction.canModify((PsiElement)file);
    }

    public abstract boolean isAvailable(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiElement var3);

    public final void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            BaseElementAtCaretIntentionAction.$$$reportNull$$$0(2);
        }
        if (editor == null || psiFile == null) {
            return;
        }
        PsiElement element = this.getElement(editor, psiFile);
        if (element == null) {
            return;
        }
        this.invoke(project, editor, element);
    }

    public abstract void invoke(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiElement var3) throws IncorrectOperationException;

    @Nullable
    protected PsiElement getElement(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            BaseElementAtCaretIntentionAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            BaseElementAtCaretIntentionAction.$$$reportNull$$$0(4);
        }
        int position = editor.getCaretModel().getOffset();
        return file.findElementAt(this.useElementToTheLeft ? position - 1 : position);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/intention/BaseElementAtCaretIntentionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

