/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.processor;

import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.values.ClassSerializer;
import com.intellij.psi.codeStyle.extractor.values.Value;
import com.intellij.psi.codeStyle.extractor.values.ValuesExtractionResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CodeStyleDeriveProcessor {
    protected final LangCodeStyleExtractor myLangExtractor;

    protected CodeStyleDeriveProcessor(@NotNull LangCodeStyleExtractor langExtractor) {
        if (langExtractor == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(0);
        }
        this.myLangExtractor = langExtractor;
    }

    public abstract ValuesExtractionResult runWithProgress(Project var1, CodeStyleSettings var2, PsiFile var3, ProgressIndicator var4);

    @NotNull
    public Map<Value, Object> backupValues(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        if (settings == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(1);
        }
        if (language == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(2);
        }
        List<Value> baseValues = this.getFormattingValues(settings, language);
        HashMap<Value, Object> res = new HashMap<Value, Object>();
        for (Value baseValue : baseValues) {
            res.put(baseValue, baseValue.value);
        }
        HashMap<Value, Object> hashMap = res;
        if (hashMap == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    private Collection<Value.VAR_KIND> getVarKinds() {
        LinkedList<Value.VAR_KIND> varKinds = new LinkedList<Value.VAR_KIND>();
        varKinds.addAll(this.myLangExtractor.getCustomVarKinds());
        varKinds.addAll(Arrays.asList(Value.VAR_KIND.defaultKinds));
        LinkedList<Value.VAR_KIND> linkedList = varKinds;
        if (linkedList == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(4);
        }
        return linkedList;
    }

    @NotNull
    private Value.VAR_KIND getVarKind(@NotNull String name, @NotNull Object value) {
        if (name == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(5);
        }
        if (value == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(6);
        }
        for (Value.VAR_KIND varKind : this.getVarKinds()) {
            if (!varKind.accepts(name, value)) continue;
            Value.VAR_KIND vAR_KIND = varKind;
            if (vAR_KIND == null) {
                CodeStyleDeriveProcessor.$$$reportNull$$$0(7);
            }
            return vAR_KIND;
        }
        Value.VAR_KIND vAR_KIND = Value.VAR_KIND.NOTHING;
        if (vAR_KIND == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(8);
        }
        return vAR_KIND;
    }

    @NotNull
    private List<Value> readAll(@NotNull String instanceName, @NotNull Object instance) {
        if (instanceName == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(9);
        }
        if (instance == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(10);
        }
        Class<?> cls = instance.getClass();
        ArrayList<Value> ret = new ArrayList<Value>();
        ClassSerializer serializer2 = new ClassSerializer(instanceName, instance);
        for (Field field : cls.getFields()) {
            if ((field = ClassSerializer.getPreparedField(field)) == null || field.getName().endsWith("_FORCE")) continue;
            try {
                ret.add(this.buildFValue(field, instance, serializer2));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        ArrayList<Value> arrayList = ret;
        if (arrayList == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private Value buildFValue(@NotNull Field field, @NotNull Object instance, @NotNull ClassSerializer serializer2) throws IllegalAccessException {
        if (field == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(12);
        }
        if (instance == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(13);
        }
        if (serializer2 == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(14);
        }
        String name = field.getName();
        Object value = field.get(instance);
        Value.VAR_KIND varKind = this.getVarKind(name, value);
        return new Value(name, value, serializer2, varKind);
    }

    @NotNull
    protected List<Value> getFormattingValues(CodeStyleSettings settings, Language language) {
        LanguageCodeStyleSettingsProvider provider;
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(language);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        if (indentOptions == null) {
            Utils.logError("IndentOptions from common settings are null; using indent options from settings.");
            indentOptions = settings.getIndentOptions();
        }
        CustomCodeStyleSettings languageSettings = Utils.getLanguageSettings(settings, language);
        List<Value> values = this.readAll("commonSettings", commonSettings);
        if (languageSettings != null) {
            values.addAll(this.readAll("languageSettings", languageSettings));
        }
        if ((provider = LanguageCodeStyleSettingsProvider.forLanguage(language)) != null) {
            Set<String> supportedFields = provider.getSupportedFields();
            ArrayList<Value> cvalues = new ArrayList<Value>(values.size());
            for (Value value : values) {
                if (!supportedFields.contains(value.name)) continue;
                cvalues.add(value);
            }
            values = cvalues;
        }
        List<Value> valuesOrder = this.readAll("indentOptions", indentOptions);
        valuesOrder.addAll(values);
        List<Value> list = valuesOrder;
        if (list == null) {
            CodeStyleDeriveProcessor.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public abstract String getHTMLReport();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langExtractor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceName";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/extractor/processor/CodeStyleDeriveProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "backupValues";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarKinds";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarKind";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readAll";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattingValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "backupValues";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 15: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVarKind";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readAll";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildFValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8, 11, 15 -> new IllegalStateException(string);
        };
    }
}

