/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.analysis.AbstractJavaErrorFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddFinallyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.InsertMissingTokenFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameUnderscoreFix;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableAccessFromInnerClassJava10Fix;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInspection.ImplicitToExplicitClassBackwardMigrationInspection;
import com.intellij.codeInspection.MigrateFromJavaLangIoInspection;
import com.intellij.codeInspection.streamMigration.SimplifyForEachInspection;
import com.intellij.core.JavaPsiBundle;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class AdditionalJavaErrorFixProvider
extends AbstractJavaErrorFixProvider {
    public AdditionalJavaErrorFixProvider() {
        this.fix((JavaErrorKind)JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL_LAMBDA, error -> new SimplifyForEachInspection.ForEachNonFinalFix(error.psi()));
        this.fix((JavaErrorKind)JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL_LAMBDA, error -> new VariableAccessFromInnerClassJava10Fix(error.psi()));
        this.fix((JavaErrorKind)JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL_GUARD, error -> new VariableAccessFromInnerClassJava10Fix(error.psi()));
        this.fixes((JavaErrorKind)JavaErrorKinds.SYNTAX_ERROR, (error, info) -> AdditionalJavaErrorFixProvider.registerErrorElementFixes(info, (PsiErrorElement)error.psi()));
        this.fix((JavaErrorKind)JavaErrorKinds.UNDERSCORE_IDENTIFIER_UNNAMED, error -> {
            PsiReferenceExpression ref;
            PsiElement patt0$temp = ((PsiIdentifier)error.psi()).getParent();
            return patt0$temp instanceof PsiReferenceExpression && "_".equals((ref = (PsiReferenceExpression)patt0$temp).getReferenceName()) ? new RenameUnderscoreFix(ref) : null;
        });
        this.fix((JavaErrorKind)JavaErrorKinds.UNSUPPORTED_FEATURE, error -> {
            if (error.context() != JavaFeature.IMPLICIT_CLASSES) {
                return null;
            }
            return ImplicitToExplicitClassBackwardMigrationInspection.createFix(error.psi());
        });
        this.fix((JavaErrorKind)JavaErrorKinds.REFERENCE_UNRESOLVED, error -> {
            PsiJavaCodeReferenceElement psi = (PsiJavaCodeReferenceElement)error.psi();
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.IMPLICIT_CLASSES, (PsiElement)psi)) {
                return null;
            }
            return MigrateFromJavaLangIoInspection.createCanBeIOFix(error.psi());
        });
    }

    private static void registerErrorElementFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiErrorElement errorElement) {
        PsiSwitchBlock switchBlock;
        if (info == null) {
            AdditionalJavaErrorFixProvider.$$$reportNull$$$0(0);
        }
        if (errorElement == null) {
            AdditionalJavaErrorFixProvider.$$$reportNull$$$0(1);
        }
        PsiElement parent = errorElement.getParent();
        String description = errorElement.getErrorDescription();
        if (description.equals(JavaPsiBundle.message((String)"expected.semicolon", (Object[])new Object[0]))) {
            info.accept((CommonIntentionAction)new InsertMissingTokenFix(";"));
            HighlightFixUtil.registerFixesForExpressionStatement(info, (PsiElement)parent);
        }
        if (parent instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            if (description.equals(JavaPsiBundle.message((String)"expected.catch.or.finally", (Object[])new Object[0]))) {
                info.accept((CommonIntentionAction)new AddExceptionToCatchFix(false));
                info.accept((CommonIntentionAction)new AddFinallyFix(tryStatement));
            }
        }
        if (parent instanceof PsiSwitchLabelStatementBase && description.equals(JavaPsiBundle.message((String)"expected.colon.or.arrow", (Object[])new Object[0])) && (switchBlock = (PsiSwitchBlock)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiSwitchBlock.class)) != null && switchBlock.getBody() != null) {
            boolean isOld = false;
            boolean isRule = false;
            for (PsiElement child : switchBlock.getBody().getChildren()) {
                if (child instanceof PsiSwitchLabeledRuleStatement) {
                    isRule = true;
                }
                if (!(child instanceof PsiSwitchLabelStatement) || PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)parent, (boolean)false)) continue;
                isOld = true;
            }
            if (isOld) {
                info.accept((CommonIntentionAction)new InsertMissingTokenFix(":", true));
            }
            if (isRule) {
                info.accept((CommonIntentionAction)new InsertMissingTokenFix(" ->", true));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "errorElement";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/AdditionalJavaErrorFixProvider";
        objectArray[2] = "registerErrorElementFixes";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

