/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BulkFileAttributesReadInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Map<String, String> ATTR_REPLACEMENTS = Map.of("lastModified", "lastModifiedTime().toMillis", "isFile", "isRegularFile", "isDirectory", "isDirectory", "length", "size");
    private static final CallMatcher FILE_ATTR_CALL_MATCHER = CallMatcher.instanceCall((String)"java.io.File", (String[])ArrayUtil.toStringArray(ATTR_REPLACEMENTS.keySet())).parameterCount(0);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            BulkFileAttributesReadInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                BulkFileAttributesReadInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(this){

            public void visitMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethod(method);
                PsiCodeBlock methodBody = method.getBody();
                if (methodBody == null) {
                    return;
                }
                CallReporter reporter = new CallReporter((PsiElement)methodBody, isOnTheFly, holder);
                FileAttributeCallsVisitor visitor = new FileAttributeCallsVisitor((PsiElement)methodBody, reporter);
                methodBody.accept((PsiElementVisitor)visitor);
                reporter.accept(visitor.myCalls);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/BulkFileAttributesReadInspection$1", "visitMethod"));
            }
        };
    }

    private static long distinctCalls(@NotNull List<? extends PsiMethodCallExpression> calls) {
        if (calls == null) {
            BulkFileAttributesReadInspection.$$$reportNull$$$0(2);
        }
        return ((StreamEx)StreamEx.of(calls).distinct(call -> call.getMethodExpression().getReferenceName())).count();
    }

    private static boolean needsTryCatchBlock(@NotNull PsiElement anchor) {
        PsiClassType ioExceptionType;
        if (anchor == null) {
            BulkFileAttributesReadInspection.$$$reportNull$$$0(3);
        }
        return !ExceptionUtil.isHandled((PsiClassType)(ioExceptionType = TypeUtils.getType((String)"java.io.IOException", (PsiElement)anchor)), (PsiElement)anchor);
    }

    @Nullable
    private static PsiVariable getFileVariable(@NotNull PsiMethodCallExpression call) {
        PsiReferenceExpression ref;
        PsiElement qualifier;
        if (call == null) {
            BulkFileAttributesReadInspection.$$$reportNull$$$0(4);
        }
        if ((qualifier = call.getMethodExpression().getQualifier()) instanceof PsiParenthesizedExpression) {
            qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)qualifier));
        }
        if ((ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)qualifier, PsiReferenceExpression.class)) == null) {
            return null;
        }
        return (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/BulkFileAttributesReadInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calls";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/BulkFileAttributesReadInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "distinctCalls";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "needsTryCatchBlock";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class ReplaceWithBulkCallFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithBulkCallFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.replace.with.bulk.file.attributes.read.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiDeclarationStatement declaration;
            PsiMethodCallExpression call;
            if (project == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(3);
            }
            if (!FILE_ATTR_CALL_MATCHER.test(call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element, PsiMethodCallExpression.class))) {
                return;
            }
            FileVariableModel fileVariable = FileVariableModel.create(call);
            if (fileVariable == null) {
                return;
            }
            PsiElement anchor = fileVariable.findAnchor();
            if (anchor == null) {
                return;
            }
            PsiElement parent = anchor.getParent();
            if (parent == null) {
                return;
            }
            String fileVarName = fileVariable.getName();
            if (fileVarName == null) {
                return;
            }
            AttributesVariableModel attributesVariable = AttributesVariableModel.create(fileVarName, fileVariable.myScope, anchor);
            if (attributesVariable == null) {
                return;
            }
            List names = new VariableNameGenerator(anchor, VariableKind.LOCAL_VARIABLE).byType(attributesVariable.myType).byName(new String[]{attributesVariable.myName}).generateAll(true);
            String name = (String)names.getFirst();
            if (!attributesVariable.myNeedsTryCatch) {
                declaration = ReplaceWithBulkCallFix.addDeclaration(parent, anchor, name, attributesVariable.myType, attributesVariable.myInitializer);
            } else {
                declaration = ReplaceWithBulkCallFix.addDeclaration(parent, anchor, name, attributesVariable.myType, null);
                PsiExpressionStatement assignment = ReplaceWithBulkCallFix.addAssignment(parent, anchor, name, attributesVariable.myInitializer);
                if ((assignment = ReplaceWithBulkCallFix.surroundWithTryCatch(assignment)) == null) {
                    return;
                }
                PsiExpression lhs = ReplaceWithBulkCallFix.getLhs(assignment);
                if (lhs == null) {
                    return;
                }
                PsiReference lhsRef = lhs.getReference();
                if (lhsRef == null) {
                    return;
                }
            }
            List<PsiMethodCallExpression> attrCalls = fileVariable.myAttributeCalls;
            for (int i = 0; i < attrCalls.size(); ++i) {
                PsiMethodCallExpression attrCall = attrCalls.get(i);
                String replacement = ReplaceWithBulkCallFix.getBulkCallReplacement(name, attrCall);
                PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)attrCall, (String)replacement, (CommentTracker)new CommentTracker());
            }
            PsiVariable attrsVariable = (PsiVariable)declaration.getDeclaredElements()[0];
            updater.rename((PsiNameIdentifierOwner)attrsVariable, names);
        }

        @NotNull
        private static PsiExpressionStatement addAssignment(@NotNull PsiElement parent, @NotNull PsiElement anchor, @NotNull String varName, @NotNull PsiExpression initializer) {
            if (parent == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(4);
            }
            if (anchor == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(5);
            }
            if (varName == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(6);
            }
            if (initializer == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(7);
            }
            PsiElementFactory elementFactory = PsiElementFactory.getInstance((Project)parent.getProject());
            String assignmentText = varName + "=" + initializer.getText() + ";";
            PsiExpressionStatement assignment = (PsiExpressionStatement)elementFactory.createStatementFromText(assignmentText, parent);
            assignment = (PsiExpressionStatement)parent.addBefore((PsiElement)assignment, anchor);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)parent.getProject());
            PsiExpressionStatement psiExpressionStatement = (PsiExpressionStatement)codeStyleManager.shortenClassReferences((PsiElement)assignment);
            if (psiExpressionStatement == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(8);
            }
            return psiExpressionStatement;
        }

        @Nullable
        private static PsiExpressionStatement surroundWithTryCatch(@NotNull PsiExpressionStatement assignment) {
            if (assignment == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(9);
            }
            String tryCatchText = "try{" + assignment.getText() + "}catch(java.io.IOException e){throw new java.io.UncheckedIOException(e);}";
            PsiTryStatement tryStatement = (PsiTryStatement)PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)assignment, (String)tryCatchText, (CommentTracker)new CommentTracker());
            return (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.getOnlyStatementInBlock((PsiCodeBlock)tryStatement.getTryBlock()), PsiExpressionStatement.class);
        }

        @Nullable
        private static PsiExpression getLhs(@NotNull PsiExpressionStatement statement) {
            PsiAssignmentExpression assignmentExpression;
            if (statement == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(10);
            }
            if ((assignmentExpression = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)statement.getExpression(), PsiAssignmentExpression.class)) == null) {
                return null;
            }
            return assignmentExpression.getLExpression();
        }

        @NotNull
        private static PsiDeclarationStatement addDeclaration(@NotNull PsiElement parent, @NotNull PsiElement anchor, @NotNull String varName, @NotNull PsiType type, @Nullable PsiExpression initializer) {
            if (parent == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(11);
            }
            if (anchor == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(12);
            }
            if (varName == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(13);
            }
            if (type == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(14);
            }
            PsiElementFactory elementFactory = PsiElementFactory.getInstance((Project)parent.getProject());
            Object displayType = initializer != null && parent.getContext() != null && PsiUtil.isAvailable((JavaFeature)JavaFeature.LVTI, (PsiElement)parent) && JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_VAR_TYPE != false ? TypeUtils.getType((String)"var", (PsiElement)parent.getContext()) : type;
            PsiDeclarationStatement declaration = elementFactory.createVariableDeclarationStatement(varName, displayType, initializer);
            declaration = (PsiDeclarationStatement)parent.addBefore((PsiElement)declaration, anchor);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)parent.getProject());
            PsiDeclarationStatement psiDeclarationStatement = (PsiDeclarationStatement)codeStyleManager.shortenClassReferences((PsiElement)declaration);
            if (psiDeclarationStatement == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(15);
            }
            return psiDeclarationStatement;
        }

        @NotNull
        private static String getBulkCallReplacement(@NotNull String attrsVarName, @NotNull PsiMethodCallExpression attrCall) {
            if (attrsVarName == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(16);
            }
            if (attrCall == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(17);
            }
            String attrMethodName = Objects.requireNonNull(attrCall.getMethodExpression().getReferenceName());
            String string = attrsVarName + "." + ATTR_REPLACEMENTS.get(attrMethodName) + "()";
            if (string == null) {
                ReplaceWithBulkCallFix.$$$reportNull$$$0(18);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 16, 17 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/BulkFileAttributesReadInspection$ReplaceWithBulkCallFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 6: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attrsVarName";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attrCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/BulkFileAttributesReadInspection$ReplaceWithBulkCallFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addAssignment";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addDeclaration";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBulkCallReplacement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addAssignment";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "surroundWithTryCatch";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getLhs";
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "addDeclaration";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getBulkCallReplacement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 16, 17 -> new IllegalArgumentException(string);
            };
        }

        private static class FileVariableModel {
            private final PsiVariable myFileVariable;
            private final PsiElement myScope;
            private List<PsiMethodCallExpression> myAttributeCalls;

            private FileVariableModel(@NotNull List<PsiMethodCallExpression> attributeCalls, @NotNull PsiVariable fileVariable, @NotNull PsiElement scope) {
                if (attributeCalls == null) {
                    FileVariableModel.$$$reportNull$$$0(0);
                }
                if (fileVariable == null) {
                    FileVariableModel.$$$reportNull$$$0(1);
                }
                if (scope == null) {
                    FileVariableModel.$$$reportNull$$$0(2);
                }
                this.myAttributeCalls = attributeCalls;
                this.myFileVariable = fileVariable;
                this.myScope = scope;
            }

            @Nullable
            private String getName() {
                return this.myFileVariable.getName();
            }

            @Nullable
            private PsiElement findAnchor() {
                PsiExpression[] occurrences = this.myAttributeCalls.toArray(PsiExpression.EMPTY_ARRAY);
                PsiElement anchor = CommonJavaRefactoringUtil.getAnchorElementForMultipleExpressions((PsiExpression[])occurrences, (PsiElement)this.myScope);
                if (anchor == null) {
                    return null;
                }
                PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)anchor.getParent()), PsiLambdaExpression.class);
                if (lambda == null) {
                    return anchor;
                }
                PsiCodeBlock codeBlock = CommonJavaRefactoringUtil.expandExpressionLambdaToCodeBlock((PsiLambdaExpression)lambda);
                this.myAttributeCalls = FileVariableModel.findAttributeCalls(this.myFileVariable, this.myScope);
                return ControlFlowUtils.getOnlyStatementInBlock((PsiCodeBlock)codeBlock);
            }

            @NotNull
            private static List<PsiMethodCallExpression> findAttributeCalls(@NotNull PsiVariable fileVar, @NotNull PsiElement scope) {
                if (fileVar == null) {
                    FileVariableModel.$$$reportNull$$$0(3);
                }
                if (scope == null) {
                    FileVariableModel.$$$reportNull$$$0(4);
                }
                Collection calls = ReferencesSearch.search((PsiElement)fileVar, (SearchScope)new LocalSearchScope(scope)).filtering(ref -> scope == FileVariableModel.findScope(ref.getElement())).mapping(ref -> (PsiReferenceExpression)ObjectUtils.tryCast((Object)ref, PsiReferenceExpression.class)).mapping(ref -> ref == null ? null : ExpressionUtils.getCallForQualifier((PsiExpression)ref)).filtering((Predicate)FILE_ATTR_CALL_MATCHER).findAll();
                return new ArrayList<PsiMethodCallExpression>(calls);
            }

            @Nullable
            private static FileVariableModel create(@NotNull PsiMethodCallExpression variableUsage) {
                PsiElement scope;
                if (variableUsage == null) {
                    FileVariableModel.$$$reportNull$$$0(5);
                }
                if ((scope = FileVariableModel.findScope((PsiElement)variableUsage)) == null) {
                    return null;
                }
                PsiVariable psiVariable = BulkFileAttributesReadInspection.getFileVariable(variableUsage);
                if (psiVariable == null) {
                    return null;
                }
                List<PsiMethodCallExpression> attributeCalls = FileVariableModel.findAttributeCalls(psiVariable, scope);
                if (BulkFileAttributesReadInspection.distinctCalls(attributeCalls) < 2L) {
                    return null;
                }
                return new FileVariableModel(attributeCalls, psiVariable, scope);
            }

            @Nullable
            private static PsiElement findScope(@NotNull PsiElement element) {
                PsiElement scope;
                if (element == null) {
                    FileVariableModel.$$$reportNull$$$0(6);
                }
                if ((scope = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiLoopStatement.class})) instanceof PsiLoopStatement) {
                    scope = ((PsiLoopStatement)scope).getBody();
                }
                return scope;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attributeCalls";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileVariable";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileVar";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variableUsage";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/BulkFileAttributesReadInspection$ReplaceWithBulkCallFix$FileVariableModel";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findAttributeCalls";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "create";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findScope";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class AttributesVariableModel {
            private final PsiType myType;
            private final String myName;
            private final PsiExpression myInitializer;
            private final boolean myNeedsTryCatch;

            private AttributesVariableModel(@NotNull PsiType type, @NotNull String name, @NotNull PsiExpression initializer, boolean needsTryCatch) {
                if (type == null) {
                    AttributesVariableModel.$$$reportNull$$$0(0);
                }
                if (name == null) {
                    AttributesVariableModel.$$$reportNull$$$0(1);
                }
                if (initializer == null) {
                    AttributesVariableModel.$$$reportNull$$$0(2);
                }
                this.myType = type;
                this.myName = name;
                this.myInitializer = initializer;
                this.myNeedsTryCatch = needsTryCatch;
            }

            @Nullable
            private static AttributesVariableModel create(@NotNull String fileVarName, @NotNull PsiElement context, @NotNull PsiElement anchor) {
                PsiExpression initializer;
                PsiClassType psiType;
                String name;
                if (fileVarName == null) {
                    AttributesVariableModel.$$$reportNull$$$0(3);
                }
                if (context == null) {
                    AttributesVariableModel.$$$reportNull$$$0(4);
                }
                if (anchor == null) {
                    AttributesVariableModel.$$$reportNull$$$0(5);
                }
                if ((name = AttributesVariableModel.getSuggestedName((PsiType)(psiType = TypeUtils.getType((String)"java.nio.file.attribute.BasicFileAttributes", (PsiElement)context)), initializer = AttributesVariableModel.createInitializer(context, (PsiType)psiType, fileVarName), anchor)) == null) {
                    return null;
                }
                boolean needsTryCatch = BulkFileAttributesReadInspection.needsTryCatchBlock(anchor);
                return new AttributesVariableModel((PsiType)psiType, name, initializer, needsTryCatch);
            }

            @NotNull
            private static PsiExpression createInitializer(@NotNull PsiElement context, @NotNull PsiType psiType, @NotNull String fileVarName) {
                if (context == null) {
                    AttributesVariableModel.$$$reportNull$$$0(6);
                }
                if (psiType == null) {
                    AttributesVariableModel.$$$reportNull$$$0(7);
                }
                if (fileVarName == null) {
                    AttributesVariableModel.$$$reportNull$$$0(8);
                }
                String initializerText = "java.nio.file.Files.readAttributes(" + fileVarName + ".toPath()," + psiType.getCanonicalText() + ".class)";
                PsiExpression psiExpression = PsiElementFactory.getInstance((Project)context.getProject()).createExpressionFromText(initializerText, context);
                if (psiExpression == null) {
                    AttributesVariableModel.$$$reportNull$$$0(9);
                }
                return psiExpression;
            }

            @Nullable
            private static String getSuggestedName(@NotNull PsiType type, @NotNull PsiExpression initializer, @NotNull PsiElement anchor) {
                if (type == null) {
                    AttributesVariableModel.$$$reportNull$$$0(10);
                }
                if (initializer == null) {
                    AttributesVariableModel.$$$reportNull$$$0(11);
                }
                if (anchor == null) {
                    AttributesVariableModel.$$$reportNull$$$0(12);
                }
                SuggestedNameInfo nameInfo = CommonJavaRefactoringUtil.getSuggestedName((PsiType)type, (PsiExpression)initializer, (PsiElement)anchor);
                String[] names = nameInfo.names;
                return names.length == 0 ? null : names[0];
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 9 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "initializer";
                        break;
                    }
                    case 3: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileVarName";
                        break;
                    }
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 5: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "anchor";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiType";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/BulkFileAttributesReadInspection$ReplaceWithBulkCallFix$AttributesVariableModel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/BulkFileAttributesReadInspection$ReplaceWithBulkCallFix$AttributesVariableModel";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createInitializer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "createInitializer";
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "getSuggestedName";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 9 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static class FileAttributeCallsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiElement myScope;
        private final Map<PsiVariable, List<PsiMethodCallExpression>> myCalls;
        private final Consumer<? super Map<PsiVariable, List<PsiMethodCallExpression>>> myReporter;

        private FileAttributeCallsVisitor(@NotNull PsiElement scope, @NotNull Consumer<? super Map<PsiVariable, List<PsiMethodCallExpression>>> reporter) {
            if (scope == null) {
                FileAttributeCallsVisitor.$$$reportNull$$$0(0);
            }
            if (reporter == null) {
                FileAttributeCallsVisitor.$$$reportNull$$$0(1);
            }
            this.myCalls = new HashMap<PsiVariable, List<PsiMethodCallExpression>>();
            this.myScope = scope;
            this.myReporter = reporter;
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                FileAttributeCallsVisitor.$$$reportNull$$$0(2);
            }
            this.doVisitLoop((PsiLoopStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                FileAttributeCallsVisitor.$$$reportNull$$$0(3);
            }
            this.doVisitLoop((PsiLoopStatement)statement);
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                FileAttributeCallsVisitor.$$$reportNull$$$0(4);
            }
            this.doVisitLoop((PsiLoopStatement)statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                FileAttributeCallsVisitor.$$$reportNull$$$0(5);
            }
            this.doVisitLoop((PsiLoopStatement)statement);
        }

        private void doVisitLoop(@NotNull PsiLoopStatement loop) {
            PsiStatement loopBody;
            if (loop == null) {
                FileAttributeCallsVisitor.$$$reportNull$$$0(6);
            }
            if ((loopBody = loop.getBody()) == null) {
                return;
            }
            FileAttributeCallsVisitor visitor = new FileAttributeCallsVisitor(this.myScope, this.myReporter);
            loopBody.accept((PsiElementVisitor)visitor);
            this.myReporter.accept(visitor.myCalls);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                FileAttributeCallsVisitor.$$$reportNull$$$0(7);
            }
            super.visitMethodCallExpression(call);
            if (!FILE_ATTR_CALL_MATCHER.test(call)) {
                return;
            }
            PsiVariable variable = BulkFileAttributesReadInspection.getFileVariable(call);
            if (variable == null || !ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)this.myScope)) {
                return;
            }
            List varCalls = this.myCalls.computeIfAbsent(variable, __ -> new SmartList());
            varCalls.add(call);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reporter";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loop";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/BulkFileAttributesReadInspection$FileAttributeCallsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doVisitLoop";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CallReporter
    implements Consumer<Map<PsiVariable, List<PsiMethodCallExpression>>> {
        private final PsiElement myScope;
        private final boolean myIsOnTheFly;
        private final ProblemsHolder myHolder;

        private CallReporter(@NotNull PsiElement scope, boolean isOnTheFly, @NotNull ProblemsHolder holder) {
            if (scope == null) {
                CallReporter.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                CallReporter.$$$reportNull$$$0(1);
            }
            this.myScope = scope;
            this.myIsOnTheFly = isOnTheFly;
            this.myHolder = holder;
        }

        @Override
        public void accept(Map<PsiVariable, List<PsiMethodCallExpression>> calls) {
            calls.forEach((variable, varCalls) -> {
                if (BulkFileAttributesReadInspection.distinctCalls(varCalls) < 2L) {
                    return;
                }
                PsiExpression[] occurrences = varCalls.toArray(PsiExpression.EMPTY_ARRAY);
                PsiElement anchor = CommonJavaRefactoringUtil.getAnchorElementForMultipleExpressions((PsiExpression[])occurrences, (PsiElement)this.myScope);
                if (anchor == null) {
                    return;
                }
                boolean needsTryCatchBlock = BulkFileAttributesReadInspection.needsTryCatchBlock(anchor);
                if (!needsTryCatchBlock) {
                    varCalls.forEach(call -> this.myHolder.registerProblem((PsiElement)call, JavaBundle.message((String)"inspection.bulk.file.attributes.read.message", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithBulkCallFix()}));
                    return;
                }
                if (this.myIsOnTheFly) {
                    varCalls.forEach(call -> this.myHolder.registerProblem((PsiElement)call, JavaBundle.message((String)"inspection.bulk.file.attributes.read.message", (Object[])new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new ReplaceWithBulkCallFix()}));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "holder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/BulkFileAttributesReadInspection$CallReporter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

