/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteMultiCatchFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.module.JdkApiCompatibilityService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharsetObjectCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private static final CharsetCallMatcher[] MATCHERS = new CharsetCallMatcher[]{new CharsetConstructorMatcher("java.io.InputStreamReader", "java.io.InputStream", ""), new CharsetConstructorMatcher("java.io.OutputStreamWriter", "java.io.OutputStream", ""), new CharsetConstructorMatcher("java.lang.String", "byte[]", "int", "int", ""), new CharsetConstructorMatcher("java.lang.String", "byte[]", ""), new CharsetMethodMatcher("java.lang.String", "getBytes", new String[]{""}), new CharsetConstructorMatcher("java.util.Scanner", "java.io.InputStream", ""), new CharsetConstructorMatcher("java.util.Scanner", "java.io.File", ""), new CharsetConstructorMatcher("java.util.Scanner", "java.nio.file.Path", ""), new CharsetConstructorMatcher("java.util.Scanner", "java.nio.channels.ReadableByteChannel", ""), new CharsetConstructorMatcher("java.io.PrintStream", "java.io.OutputStream", "boolean", ""), new CharsetConstructorMatcher("java.io.PrintStream", "java.lang.String", ""), new CharsetConstructorMatcher("java.io.PrintStream", "java.io.File", ""), new CharsetConstructorMatcher("java.io.PrintWriter", "java.io.OutputStream", "boolean", ""), new CharsetConstructorMatcher("java.io.PrintWriter", "java.lang.String", ""), new CharsetConstructorMatcher("java.io.PrintWriter", "java.io.File", ""), new CharsetMethodMatcher("java.io.ByteArrayOutputStream", "toString", new String[]{""}), new CharsetMethodMatcher("java.net.URLDecoder", "decode", new String[]{"java.lang.String", ""}), new CharsetMethodMatcher("java.net.URLEncoder", "encode", new String[]{"java.lang.String", ""}), new CharsetMethodMatcher("java.nio.channels.Channels", "newReader", new String[]{"java.nio.channels.ReadableByteChannel", ""}), new CharsetMethodMatcher("java.nio.channels.Channels", "newWriter", new String[]{"java.nio.channels.WritableByteChannel", ""}), new CharsetMethodMatcher("java.util.Properties", "storeToXML", new String[]{"java.io.OutputStream", "java.lang.String", ""}), new CharsetMethodMatcher("org.apache.commons.io.IOUtils", "toString", new String[]{"java.io.InputStream", ""}), new CharsetMethodMatcher("org.apache.commons.io.IOUtils", "toString", new String[]{"java.net.URI", ""}), new CharsetMethodMatcher("org.apache.commons.io.IOUtils", "toString", new String[]{"java.net.URL", ""})};
    private static final CallMatcher FOR_NAME_MATCHER = CallMatcher.staticCall((String)"java.nio.charset.Charset", (String[])new String[]{"forName"}).parameterTypes(new String[]{"java.lang.String"});
    private static final CallMatcher CHARSET_NAME = CallMatcher.instanceCall((String)"java.nio.charset.Charset", (String[])new String[]{"name", "toString"}).parameterCount(0);
    private static final Map<String, String> SUPPORTED_CHARSETS = Map.ofEntries(Map.entry("US-ASCII", "US_ASCII"), Map.entry("ASCII", "US_ASCII"), Map.entry("ISO646-US", "US_ASCII"), Map.entry("ISO-8859-1", "ISO_8859_1"), Map.entry("8859_1", "ISO_8859_1"), Map.entry("UTF-8", "UTF_8"), Map.entry("UTF8", "UTF_8"), Map.entry("UTF-16BE", "UTF_16BE"), Map.entry("UTF16BE", "UTF_16BE"), Map.entry("UTF-16LE", "UTF_16LE"), Map.entry("UTF16LE", "UTF_16LE"), Map.entry("UTF-16", "UTF_16"), Map.entry("UTF16", "UTF_16"));

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        LanguageLevel languageLevel;
        if (holder == null) {
            CharsetObjectCanBeUsedInspection.$$$reportNull$$$0(0);
        }
        if (!(languageLevel = PsiUtil.getLanguageLevel((PsiElement)holder.getFile())).isAtLeast(LanguageLevel.JDK_1_7)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                CharsetObjectCanBeUsedInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(this){

            public void visitCallExpression(@NotNull PsiCallExpression call) {
                CharsetMatch match;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((match = (CharsetMatch)StreamEx.of((Object[])MATCHERS).map(matcher -> matcher.extractCharsetMatch(languageLevel, call)).nonNull().findFirst().orElse(null)) == null) {
                    return;
                }
                this.addCharsetReplacement((PsiElement)match.myStringCharset, match.myStringCharset);
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitMethodCallExpression(call);
                if (!FOR_NAME_MATCHER.matches((PsiExpression)call)) {
                    return;
                }
                PsiExpressionList arguments = call.getArgumentList();
                PsiExpression charset = arguments.getExpressions()[0];
                this.addCharsetReplacement((PsiElement)call, charset);
            }

            private void addCharsetReplacement(@NotNull PsiElement place, @NotNull PsiExpression charset) {
                String charsetString;
                if (place == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (charset == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((charsetString = 1.getCharsetString(charset)) == null) {
                    return;
                }
                holder.registerProblem(place, JavaBundle.message((String)"inspection.charset.object.can.be.used.message", (Object[])new Object[]{CharsetObjectCanBeUsedInspection.sanitizeExpression(charsetString)}), new LocalQuickFix[]{new CharsetObjectCanBeUsedFix(charsetString)});
            }

            @Nullable
            private static String getCharsetString(PsiExpression charsetExpression) {
                PsiExpression qualifier;
                String charsetString = (String)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression((PsiExpression)(charsetExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)charsetExpression))), String.class);
                if (charsetString == null && charsetExpression instanceof PsiMethodCallExpression && CHARSET_NAME.matches(charsetExpression) && (qualifier = ((PsiMethodCallExpression)charsetExpression).getMethodExpression().getQualifierExpression()) != null) {
                    return qualifier.getText();
                }
                if (charsetString == null) {
                    return null;
                }
                String constantName = SUPPORTED_CHARSETS.get(charsetString = StringUtil.toUpperCase((String)charsetString));
                if (constantName == null) {
                    return null;
                }
                String finalExpression = "java.nio.charset.StandardCharsets." + constantName;
                if (charsetExpression instanceof PsiLiteralExpression) {
                    return finalExpression;
                }
                if (charsetExpression instanceof PsiReferenceExpression) {
                    String baseCharset;
                    String name = ((PsiReferenceExpression)charsetExpression).getReferenceName();
                    if (name == null) {
                        return null;
                    }
                    String baseName = StringUtil.toLowerCase((String)name.replaceAll("[^A-Z0-9]", ""));
                    if (!baseName.contains(baseCharset = StringUtil.toLowerCase((String)charsetString.replaceAll("[^A-Z0-9]", "")))) {
                        return null;
                    }
                    return finalExpression;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "charset";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addCharsetReplacement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static String sanitizeExpression(String expression) {
        if (expression.startsWith("java.nio.charset.StandardCharsets.")) {
            String string = expression.substring("java.nio.charset.".length());
            if (string == null) {
                CharsetObjectCanBeUsedInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = expression;
        if (string == null) {
            CharsetObjectCanBeUsedInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    static abstract class CharsetCallMatcher {
        @NotNull
        final String myClassName;
        final String @NotNull [] myParameters;
        final int myCharsetParameterIndex;

        CharsetCallMatcher(@NotNull String className, String ... parameters) {
            if (className == null) {
                CharsetCallMatcher.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                CharsetCallMatcher.$$$reportNull$$$0(1);
            }
            this.myClassName = className;
            this.myParameters = parameters;
            int index = -1;
            for (int i = 0; i < parameters.length; ++i) {
                if (!parameters[i].isEmpty()) continue;
                if (index == -1) {
                    index = i;
                    continue;
                }
                throw new IllegalArgumentException("Empty parameter type must be specified exactly once");
            }
            if (index == -1) {
                throw new IllegalArgumentException("No empty parameter type is specified");
            }
            this.myCharsetParameterIndex = index;
        }

        @Contract(value="null,_ -> false")
        final boolean checkMethod(PsiMethod method, @NotNull String charsetType) {
            if (charsetType == null) {
                CharsetCallMatcher.$$$reportNull$$$0(2);
            }
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !this.myClassName.equals(containingClass.getQualifiedName())) {
                return false;
            }
            PsiParameterList list = method.getParameterList();
            if (list.getParametersCount() != this.myParameters.length) {
                return false;
            }
            PsiParameter[] parameters = list.getParameters();
            for (int i = 0; i < this.myParameters.length; ++i) {
                PsiType parameterType = parameters[i].getType();
                if (parameterType.equalsToText(this.myParameters[i].isEmpty() ? charsetType : this.myParameters[i])) continue;
                return false;
            }
            return true;
        }

        @Nullable
        final CharsetMatch createMatch(LanguageLevel languageLevel, PsiMethod method, PsiExpressionList arguments) {
            PsiExpression argument = arguments.getExpressions()[this.myCharsetParameterIndex];
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return null;
            }
            PsiMethod[] candidates = method.isConstructor() ? aClass.getConstructors() : aClass.findMethodsByName(method.getName(), false);
            PsiMethod charsetMethod = Arrays.stream(candidates).filter(psiMethod -> this.checkMethod((PsiMethod)psiMethod, "java.nio.charset.Charset")).filter(psiMethod -> JdkApiCompatibilityService.getInstance().firstCompatibleLanguageLevel((PsiMember)psiMethod, languageLevel) == null).findFirst().orElse(null);
            if (charsetMethod == null) {
                return null;
            }
            return new CharsetMatch(argument, method, charsetMethod);
        }

        @Nullable
        abstract CharsetMatch extractCharsetMatch(LanguageLevel var1, PsiCallExpression var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charsetType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$CharsetCallMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CharsetConstructorMatcher
    extends CharsetCallMatcher {
        CharsetConstructorMatcher(@NotNull String className, String ... parameters) {
            if (className == null) {
                CharsetConstructorMatcher.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                CharsetConstructorMatcher.$$$reportNull$$$0(1);
            }
            super(className, parameters);
        }

        @Override
        CharsetMatch extractCharsetMatch(LanguageLevel languageLevel, PsiCallExpression call) {
            if (!(call instanceof PsiNewExpression)) {
                return null;
            }
            PsiNewExpression newExpression = (PsiNewExpression)call;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null || argumentList.getExpressionCount() != this.myParameters.length) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (!this.checkMethod(method, "java.lang.String") || !method.isConstructor()) {
                return null;
            }
            return this.createMatch(languageLevel, method, argumentList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$CharsetConstructorMatcher";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CharsetMethodMatcher
    extends CharsetCallMatcher {
        @NotNull
        private final String myMethodName;

        CharsetMethodMatcher(@NotNull String className, @NotNull String methodName, String ... parameters) {
            if (className == null) {
                CharsetMethodMatcher.$$$reportNull$$$0(0);
            }
            if (methodName == null) {
                CharsetMethodMatcher.$$$reportNull$$$0(1);
            }
            if (parameters == null) {
                CharsetMethodMatcher.$$$reportNull$$$0(2);
            }
            super(className, parameters);
            this.myMethodName = methodName;
        }

        @Override
        CharsetMatch extractCharsetMatch(LanguageLevel languageLevel, PsiCallExpression call) {
            if (!(call instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)call;
            if (!this.myMethodName.equals(methodCallExpression.getMethodExpression().getReferenceName())) {
                return null;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList.getExpressionCount() != this.myParameters.length) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (!this.checkMethod(method, "java.lang.String")) {
                return null;
            }
            return this.createMatch(languageLevel, method, argumentList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$CharsetMethodMatcher";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class CharsetObjectCanBeUsedFix
    extends PsiUpdateModCommandQuickFix {
        private final String myCharsetExpression;

        CharsetObjectCanBeUsedFix(String charsetExpression) {
            this.myCharsetExpression = charsetExpression;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{CharsetObjectCanBeUsedInspection.sanitizeExpression(this.myCharsetExpression)});
            if (string == null) {
                CharsetObjectCanBeUsedFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.charset.object.can.be.used.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                CharsetObjectCanBeUsedFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiTryStatement tryStatement;
            PsiExpression expression;
            if (project == null) {
                CharsetObjectCanBeUsedFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                CharsetObjectCanBeUsedFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                CharsetObjectCanBeUsedFix.$$$reportNull$$$0(4);
            }
            if ((expression = (PsiExpression)ObjectUtils.tryCast((Object)startElement, PsiExpression.class)) == null) {
                return;
            }
            PsiElement anchor = FOR_NAME_MATCHER.matches(expression) ? null : PsiTreeUtil.getParentOfType((PsiElement)expression, PsiCallExpression.class);
            CommentTracker ct = new CommentTracker();
            PsiExpression ref = (PsiExpression)ct.replaceAndRestoreComments((PsiElement)expression, this.myCharsetExpression);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)ref);
            if (anchor == null) {
                return;
            }
            while ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)anchor, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class})) != null) {
                PsiCodeBlock tryBlock = tryStatement.getTryBlock();
                boolean inTry = PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)anchor, (boolean)true);
                PsiResourceList resourceList = tryStatement.getResourceList();
                boolean inResource = PsiTreeUtil.isAncestor((PsiElement)resourceList, (PsiElement)anchor, (boolean)true);
                if (inTry || inResource) {
                    for (PsiParameter parameter : tryStatement.getCatchBlockParameters()) {
                        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter);
                        for (PsiTypeElement element : typeElements) {
                            PsiType type = element.getType();
                            if (type.equalsToText("java.io.UnsupportedEncodingException") || type.equalsToText("java.io.IOException")) {
                                Set unhandledExceptions = StreamEx.of((Object[])new PsiElement[]{tryBlock, resourceList}).nonNull().flatCollection(block -> ExceptionUtil.collectUnhandledExceptions((PsiElement)block, (PsiElement)block)).toSet();
                                if (!ContainerUtil.exists((Iterable)unhandledExceptions, ue -> ue.isAssignableFrom(type) || type.isAssignableFrom((PsiType)ue))) {
                                    if (parameter.getType() instanceof PsiDisjunctionType) {
                                        DeleteMultiCatchFix.deleteCaughtExceptionType((PsiTypeElement)element);
                                    } else {
                                        DeleteCatchFix.deleteCatch((PsiParameter)parameter);
                                    }
                                }
                                return;
                            }
                            if (!type.equalsToText("java.lang.Exception") && !type.equalsToText("java.lang.Throwable")) continue;
                            return;
                        }
                    }
                }
                anchor = tryStatement;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$CharsetObjectCanBeUsedFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$CharsetObjectCanBeUsedFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    static class CharsetMatch {
        @NotNull
        final PsiExpression myStringCharset;
        @NotNull
        final PsiMethod myStringMethod;
        @NotNull
        final PsiMethod myCharsetMethod;

        CharsetMatch(@NotNull PsiExpression charset, @NotNull PsiMethod stringMethod, @NotNull PsiMethod charsetMethod) {
            if (charset == null) {
                CharsetMatch.$$$reportNull$$$0(0);
            }
            if (stringMethod == null) {
                CharsetMatch.$$$reportNull$$$0(1);
            }
            if (charsetMethod == null) {
                CharsetMatch.$$$reportNull$$$0(2);
            }
            this.myStringCharset = charset;
            this.myStringMethod = stringMethod;
            this.myCharsetMethod = charsetMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charset";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stringMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "charsetMethod";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/CharsetObjectCanBeUsedInspection$CharsetMatch";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

