/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class EndlessStreamInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Set<String> ALL_CONSUMING_OPERATIONS = Set.of("sorted", "count", "reduce", "max", "min", "sum", "average", "collect", "toArray", "forEach", "summaryStatistics");
    private static final Set<String> NON_LIMITING_OPERATIONS = Set.of("filter", "map", "distinct", "flatMap", "flatMapToInt", "flatMapToLong", "flatMapToDouble", "flatMapToObj", "onClose", "peek", "skip", "dropWhile", "mapToDouble", "mapToLong", "mapToObj", "mapToInt", "parallel", "boxed", "sequential", "unordered", "asLongStream", "asDoubleStream");
    private static final CallMatcher INFINITE_SOURCE = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.util.stream.IntStream", (String[])new String[]{"generate"}).parameterCount(1), CallMatcher.staticCall((String)"java.util.stream.IntStream", (String[])new String[]{"iterate"}).parameterCount(2), CallMatcher.staticCall((String)"java.util.stream.LongStream", (String[])new String[]{"generate"}).parameterCount(1), CallMatcher.staticCall((String)"java.util.stream.LongStream", (String[])new String[]{"iterate"}).parameterCount(2), CallMatcher.staticCall((String)"java.util.stream.DoubleStream", (String[])new String[]{"generate"}).parameterCount(1), CallMatcher.staticCall((String)"java.util.stream.DoubleStream", (String[])new String[]{"iterate"}).parameterCount(2), CallMatcher.staticCall((String)"java.util.stream.Stream", (String[])new String[]{"generate"}).parameterCount(1), CallMatcher.staticCall((String)"java.util.stream.Stream", (String[])new String[]{"iterate"}).parameterCount(2), CallMatcher.instanceCall((String)"java.util.Random", (String[])new String[]{"ints", "longs", "doubles"}).parameterCount(2), CallMatcher.instanceCall((String)"java.util.Random", (String[])new String[]{"ints", "longs", "doubles"}).parameterCount(0)});

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            EndlessStreamInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            EndlessStreamInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!INFINITE_SOURCE.test(call)) {
                    return;
                }
                PsiMethodCallExpression allConsumingCall = StreamApiUtil.findSubsequentCall((PsiMethodCallExpression)call, name -> ALL_CONSUMING_OPERATIONS.contains(name), name -> NON_LIMITING_OPERATIONS.contains(name));
                if (allConsumingCall == null) {
                    return;
                }
                PsiElement nameElement = allConsumingCall.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                holder.registerProblem(nameElement, JavaBundle.message((String)"inspection.endless.stream.description", (Object[])new Object[0]), new LocalQuickFix[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/EndlessStreamInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/EndlessStreamInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/EndlessStreamInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

