/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.IndexedContainer;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExplicitArrayFillingInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ExplicitArrayFillingInspection.class);
    public boolean mySuggestSetAll = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"mySuggestSetAll", (String)JavaBundle.message((String)"inspection.explicit.array.filling.suggest.set.all", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ExplicitArrayFillingInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ExplicitArrayFillingInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitForStatement(@NotNull PsiForStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitForStatement(statement);
                CountingLoop loop = CountingLoop.from((PsiForStatement)statement);
                if (loop == null || loop.isIncluding() || loop.isDescending()) {
                    return;
                }
                if (!ExpressionUtils.isZero((PsiExpression)loop.getInitializer())) {
                    return;
                }
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)ControlFlowUtils.stripBraces((PsiStatement)statement.getBody()));
                if (assignment == null) {
                    return;
                }
                IndexedContainer container = ExplicitArrayFillingInspection.getContainer(loop, assignment);
                if (container == null || !(container.getQualifier().getType() instanceof PsiArrayType)) {
                    return;
                }
                PsiExpression index = container.extractIndexFromGetExpression(assignment.getLExpression());
                if (!ExpressionUtils.isReferenceTo((PsiExpression)index, (PsiVariable)loop.getCounter())) {
                    return;
                }
                PsiExpression rValue = assignment.getRExpression();
                if (rValue == null) {
                    return;
                }
                if (!1.isChangedInLoop(loop, rValue)) {
                    PsiType lType = container.getElementType();
                    Object defaultValue = PsiTypesUtil.getDefaultValue((PsiType)lType);
                    if (1.isDefaultValue(rValue, defaultValue, lType) && 1.isFilledWithDefaultValues(container.getQualifier(), statement, defaultValue)) {
                        holder.registerProblem((PsiElement)statement, this.getRange(statement, ProblemHighlightType.WARNING), JavaBundle.message((String)"inspection.explicit.array.filling.redundant.loop.description", (Object[])new Object[0]), new LocalQuickFix[]{QuickFixFactory.getInstance().createDeleteFix((PsiElement)statement, CommonQuickFixBundle.message((String)"fix.remove.statement", (Object[])new Object[]{"for"}))});
                        return;
                    }
                    this.registerProblem(statement, false);
                    return;
                }
                if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.ADVANCED_COLLECTIONS_API, (PsiElement)holder.getFile())) {
                    return;
                }
                if (!StreamApiUtil.isSupportedStreamElement((PsiType)container.getElementType())) {
                    return;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)rValue, Predicate.isEqual(loop.getCounter()))) {
                    return;
                }
                this.registerProblem(statement, true);
            }

            private static boolean isChangedInLoop(@NotNull CountingLoop loop, @NotNull PsiExpression rValue) {
                if (loop == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (rValue == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (VariableAccessUtils.collectUsedVariables((PsiElement)rValue).contains(loop.getCounter()) || SideEffectChecker.mayHaveSideEffects((PsiExpression)rValue)) {
                    return true;
                }
                return ExpressionUtils.nonStructuralChildren((PsiExpression)rValue).filter(c -> c instanceof PsiCallExpression).anyMatch(call -> !ClassUtils.isImmutable((PsiType)call.getType()) && !ConstructionUtils.isEmptyArrayInitializer((PsiExpression)call));
            }

            private static boolean isDefaultValue(@NotNull PsiExpression expression, @Nullable Object defaultValue, @Nullable PsiType lType) {
                if (expression == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (ExpressionUtils.isNullLiteral((PsiExpression)expression) && defaultValue == null) {
                    return true;
                }
                Object constantValue = ExpressionUtils.computeConstantExpression((PsiExpression)expression);
                PsiType rType = expression.getType();
                if (rType instanceof PsiPrimitiveType && lType instanceof PsiPrimitiveType && defaultValue instanceof Number && constantValue instanceof Number) {
                    return ((Number)defaultValue).doubleValue() == ((Number)constantValue).doubleValue();
                }
                return constantValue != null && constantValue.equals(defaultValue);
            }

            private static boolean isFilledWithDefaultValues(@NotNull PsiExpression expression, @NotNull PsiForStatement statement, @Nullable Object defaultValue) {
                PsiReferenceExpression arrayRef;
                if (expression == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (statement == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((arrayRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression), PsiReferenceExpression.class)) == null) {
                    return false;
                }
                PsiVariable arrayVar = (PsiVariable)ObjectUtils.tryCast((Object)arrayRef.resolve(), PsiVariable.class);
                if (arrayVar == null) {
                    return false;
                }
                PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)PsiUtil.getVariableCodeBlock((PsiVariable)arrayVar, null), PsiCodeBlock.class);
                if (block == null) {
                    return false;
                }
                ControlFlow flow = 1.createControlFlow(block);
                if (flow == null) {
                    return false;
                }
                int statementStart = flow.getStartOffset((PsiElement)statement);
                if (statementStart == -1) {
                    return false;
                }
                int statementEnd = flow.getEndOffset((PsiElement)statement);
                if (statementEnd == -1) {
                    return false;
                }
                Object[] defs = 1.getDefs(block, arrayVar, arrayRef, defaultValue);
                if (defs == null) {
                    return false;
                }
                Set<Integer> exclude = 1.getDefsOffsets(flow, (PsiElement[])defs);
                if (exclude == null) {
                    return false;
                }
                for (int i = statementStart; i < statementEnd; ++i) {
                    exclude.add(i);
                }
                return !ContainerUtil.exists((Object[])defs, def -> ControlFlowUtils.isVariableReferencedBeforeStatementEntry((ControlFlow)flow, (int)(flow.getEndOffset(def) + 1), (PsiElement)statement, (PsiVariable)arrayVar, (Set)exclude));
            }

            @Nullable
            private static ControlFlow createControlFlow(@NotNull PsiCodeBlock block) {
                if (block == null) {
                    1.$$$reportNull$$$0(6);
                }
                try {
                    return ControlFlowFactory.getInstance((Project)block.getProject()).getControlFlow((PsiElement)block, (ControlFlowPolicy)LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                }
                catch (AnalysisCanceledException ignored) {
                    return null;
                }
            }

            private static PsiElement @Nullable [] getDefs(@NotNull PsiCodeBlock block, @NotNull PsiVariable arrayVar, @NotNull PsiReferenceExpression arrayRef, @Nullable Object defaultValue) {
                if (block == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (arrayVar == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (arrayRef == null) {
                    1.$$$reportNull$$$0(9);
                }
                PsiElement[] defs = DefUseUtil.getDefs((PsiCodeBlock)block, (PsiVariable)arrayVar, (PsiElement)arrayRef);
                PsiExpression[] expressions = new PsiExpression[defs.length];
                for (int i = 0; i < defs.length; ++i) {
                    PsiElement def = defs[i];
                    PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)def, PsiVariable.class);
                    if (variable != null) {
                        PsiExpression initializer = variable.getInitializer();
                        if (!1.isNewArrayCreation(initializer, defaultValue)) {
                            return null;
                        }
                        expressions[i] = initializer;
                        continue;
                    }
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)def, PsiAssignmentExpression.class);
                    if (assignment != null) {
                        if (!1.isNewArrayCreation(assignment.getRExpression(), defaultValue)) {
                            return null;
                        }
                        expressions[i] = assignment;
                        continue;
                    }
                    return null;
                }
                return expressions;
            }

            private static boolean isNewArrayCreation(@Nullable PsiExpression expression, @Nullable Object defaultValue) {
                PsiArrayInitializerExpression initializer;
                PsiExpression arrInitExpr = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
                PsiNewExpression newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)arrInitExpr, PsiNewExpression.class);
                if (newExpression == null) {
                    initializer = (PsiArrayInitializerExpression)ObjectUtils.tryCast((Object)arrInitExpr, PsiArrayInitializerExpression.class);
                    if (initializer == null) {
                        return false;
                    }
                } else {
                    initializer = newExpression.getArrayInitializer();
                }
                if (initializer == null) {
                    return true;
                }
                return ContainerUtil.and((Object[])initializer.getInitializers(), init -> 1.isDefaultValue(init, defaultValue, init.getType()));
            }

            @Nullable
            private static Set<Integer> getDefsOffsets(@NotNull ControlFlow flow, PsiElement @NotNull [] defs) {
                if (flow == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (defs == null) {
                    1.$$$reportNull$$$0(11);
                }
                HashSet<Integer> set = new HashSet<Integer>();
                for (PsiElement def : defs) {
                    int start = flow.getStartOffset(def);
                    if (start == -1) {
                        return null;
                    }
                    int end = flow.getEndOffset(def);
                    if (end == -1) {
                        return null;
                    }
                    for (int i = start; i < end; ++i) {
                        set.add(i);
                    }
                }
                return set;
            }

            private void registerProblem(@NotNull PsiForStatement statement, boolean isSetAll) {
                if (statement == null) {
                    1.$$$reportNull$$$0(12);
                }
                String message = JavaBundle.message((String)"inspection.explicit.array.filling.description", (Object[])new Object[]{isSetAll ? "setAll" : "fill"});
                ReplaceWithArraysCallFix fix = new ReplaceWithArraysCallFix(!isSetAll);
                ProblemHighlightType type = ProblemHighlightType.WARNING;
                if (isSetAll && !ExplicitArrayFillingInspection.this.mySuggestSetAll) {
                    if (!isOnTheFly) {
                        return;
                    }
                    type = ProblemHighlightType.INFORMATION;
                }
                TextRange range = this.getRange(statement, type);
                if (isSetAll && ExplicitArrayFillingInspection.this.mySuggestSetAll && isOnTheFly) {
                    UpdateInspectionOptionFix disableForSetAllFix = new UpdateInspectionOptionFix((InspectionProfileEntry)ExplicitArrayFillingInspection.this, "mySuggestSetAll", JavaBundle.message((String)"inspection.explicit.array.filling.no.suggestion.for.set.all", (Object[])new Object[0]), false);
                    holder.problem((PsiElement)statement, message).highlight(type).range(range).fix((LocalQuickFix)fix).fix((ModCommandAction)disableForSetAllFix).register();
                    return;
                }
                holder.registerProblem((PsiElement)statement, message, type, range, new LocalQuickFix[]{fix});
            }

            @NotNull
            private TextRange getRange(@NotNull PsiForStatement statement, @NotNull ProblemHighlightType type) {
                PsiStatement initialization;
                if (statement == null) {
                    1.$$$reportNull$$$0(13);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(14);
                }
                LOG.assertTrue((initialization = statement.getInitialization()) != null);
                TextRange range = TextRange.from((int)initialization.getStartOffsetInParent(), (int)initialization.getTextLength());
                boolean wholeStatement = isOnTheFly && (InspectionProjectProfileManager.isInformationLevel((String)ExplicitArrayFillingInspection.this.getShortName(), (PsiElement)statement) || type == ProblemHighlightType.INFORMATION);
                PsiJavaToken rParenth = statement.getRParenth();
                if (wholeStatement && rParenth != null) {
                    range = new TextRange(0, rParenth.getStartOffsetInParent() + 1);
                }
                TextRange textRange = range;
                if (textRange == null) {
                    1.$$$reportNull$$$0(15);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 15 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "loop";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rValue";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "block";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayVar";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayRef";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flow";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "defs";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/ExplicitArrayFillingInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/ExplicitArrayFillingInspection$1";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRange";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitForStatement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isChangedInLoop";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isDefaultValue";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "isFilledWithDefaultValues";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "createControlFlow";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "getDefs";
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "getDefsOffsets";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "registerProblem";
                        break;
                    }
                    case 13: 
                    case 14: {
                        objectArray = objectArray;
                        objectArray[2] = "getRange";
                        break;
                    }
                    case 15: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 15 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Nullable
    private static IndexedContainer getContainer(CountingLoop loop, PsiAssignmentExpression assignment) {
        IndexedContainer container = IndexedContainer.fromLengthExpression((PsiExpression)loop.getBound());
        if (container == null) {
            PsiExpression psiExpression = assignment.getLExpression();
            if (!(psiExpression instanceof PsiArrayAccessExpression)) {
                return null;
            }
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)psiExpression;
            container = IndexedContainer.arrayContainerWithBound((PsiArrayAccessExpression)arrayAccessExpression, (PsiExpression)loop.getBound());
        }
        return container;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ExplicitArrayFillingInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ExplicitArrayFillingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class ReplaceWithArraysCallFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myIsRhsConstant;

        private ReplaceWithArraysCallFix(boolean isRhsConstant) {
            this.myIsRhsConstant = isRhsConstant;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.explicit.array.filling.fix.family.name", (Object[])new Object[]{this.myIsRhsConstant ? "fill" : "setAll"});
            if (string == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement result;
            PsiForStatement statement;
            if (project == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(3);
            }
            if ((statement = (PsiForStatement)ObjectUtils.tryCast((Object)element, PsiForStatement.class)) == null) {
                return;
            }
            CountingLoop loop = CountingLoop.from((PsiForStatement)statement);
            if (loop == null) {
                return;
            }
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)ControlFlowUtils.stripBraces((PsiStatement)statement.getBody()));
            if (assignment == null) {
                return;
            }
            IndexedContainer container = ExplicitArrayFillingInspection.getContainer(loop, assignment);
            if (container == null) {
                return;
            }
            PsiExpression rValue = assignment.getRExpression();
            if (rValue == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            if (this.myIsRhsConstant) {
                String cast = ReplaceWithArraysCallFix.getCast((PsiElement)statement, container.getElementType(), rValue.getType());
                String replacement = "java.util.Arrays.fill(" + ct.text((PsiElement)container.getQualifier()) + ", " + cast + ct.text((PsiElement)rValue) + ");";
                result = ct.replaceAndRestoreComments((PsiElement)statement, replacement);
            } else {
                String replacement = "java.util.Arrays.setAll(" + ct.text((PsiElement)container.getQualifier()) + ", " + loop.getCounter().getName() + "->" + ct.text((PsiElement)rValue) + ");";
                result = ct.replaceAndRestoreComments((PsiElement)statement, replacement);
                LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
            }
            result = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        @NotNull
        private static String getCast(@NotNull PsiElement context, @Nullable PsiType elementType, @Nullable PsiType rType) {
            if (context == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(4);
            }
            if (elementType == null || rType == null) {
                return "";
            }
            PsiType assignTo = (PsiType)ObjectUtils.tryCast((Object)elementType, PsiPrimitiveType.class);
            if (assignTo == null) {
                assignTo = TypeUtils.getObjectType((PsiElement)context);
            }
            Object object = TypeConversionUtil.isAssignable((PsiType)assignTo, (PsiType)rType) ? "" : "(" + elementType.getCanonicalText() + ")";
            if (object == null) {
                ReplaceWithArraysCallFix.$$$reportNull$$$0(5);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ExplicitArrayFillingInspection$ReplaceWithArraysCallFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ExplicitArrayFillingInspection$ReplaceWithArraysCallFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCast";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCast";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

