/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiLiteralUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class InconsistentTextBlockIndentInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.TEXT_BLOCKS);
        if (set == null) {
            InconsistentTextBlockIndentInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            InconsistentTextBlockIndentInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
                String[] lines;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((lines = PsiLiteralUtil.getTextBlockLines((PsiLiteralExpression)expression)) == null || lines.length == 1) {
                    return;
                }
                int indentLength = PsiLiteralUtil.getTextBlockIndent((PsiLiteralExpression)expression);
                int indexToReport = -1;
                int offset = 0;
                String indent = null;
                for (String line : lines) {
                    if (line.length() >= indentLength) {
                        if (indent == null) {
                            indent = line.substring(0, indentLength);
                        } else {
                            int mismatched = InconsistentTextBlockIndentInspection.mismatch(indent, line.substring(0, indentLength));
                            if (mismatched >= 0) {
                                indexToReport = offset + mismatched;
                                break;
                            }
                        }
                    }
                    offset += line.length() + 1;
                }
                if (indexToReport < 0) {
                    return;
                }
                CodeStyleSettings styleSettings = CodeStyle.getSettings((Project)expression.getProject());
                int tabSize = styleSettings.getTabSize((FileType)JavaFileType.INSTANCE);
                if (tabSize == 1) {
                    return;
                }
                int start = expression.getText().indexOf(10);
                if (start == -1) {
                    return;
                }
                boolean useTabCharacter = styleSettings.getIndentOptions((FileType)JavaFileType.INSTANCE).USE_TAB_CHARACTER;
                holder.registerProblem((PsiElement)expression, new TextRange(++start + indexToReport, start + indexToReport + 1), JavaBundle.message((String)"inspection.inconsistent.text.block.indent.message", (Object[])new Object[0]), new LocalQuickFix[]{new MakeIndentConsistentFix(useTabCharacter)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/InconsistentTextBlockIndentInspection$1", "visitLiteralExpression"));
            }
        };
    }

    private static int mismatch(@NotNull String a, @NotNull String b) {
        if (a == null) {
            InconsistentTextBlockIndentInspection.$$$reportNull$$$0(2);
        }
        if (b == null) {
            InconsistentTextBlockIndentInspection.$$$reportNull$$$0(3);
        }
        int length = Math.min(a.length(), b.length());
        for (int i = 0; i < length; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InconsistentTextBlockIndentInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InconsistentTextBlockIndentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mismatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class MakeIndentConsistentFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myUseTabs;

        private MakeIndentConsistentFix(boolean useTabs) {
            this.myUseTabs = useTabs;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.myUseTabs ? JavaBundle.message((String)"inspection.inconsistent.text.block.indent.tabs", (Object[])new Object[0]) : JavaBundle.message((String)"inspection.inconsistent.text.block.indent.spaces", (Object[])new Object[0]);
            if (string == null) {
                MakeIndentConsistentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                MakeIndentConsistentFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MakeIndentConsistentFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MakeIndentConsistentFix.$$$reportNull$$$0(3);
            }
            CodeStyleManager.getInstance((Project)project).reformat(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/InconsistentTextBlockIndentInspection$MakeIndentConsistentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/InconsistentTextBlockIndentInspection$MakeIndentConsistentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

