/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class MeaninglessRecordAnnotationInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Set<PsiAnnotation.TargetType> RECORD_TARGETS = EnumSet.of(PsiAnnotation.TargetType.RECORD_COMPONENT, PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.METHOD, PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.TYPE_USE);
    private static final Set<PsiAnnotation.TargetType> ALWAYS_USEFUL_RECORD_TARGETS = EnumSet.of(PsiAnnotation.TargetType.RECORD_COMPONENT, PsiAnnotation.TargetType.FIELD, PsiAnnotation.TargetType.TYPE_USE);

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.RECORDS);
        if (set == null) {
            MeaninglessRecordAnnotationInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MeaninglessRecordAnnotationInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitRecordComponent(@NotNull PsiRecordComponent recordComponent) {
                PsiClass recordClass;
                if (recordComponent == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((recordClass = recordComponent.getContainingClass()) == null) {
                    return;
                }
                String name = recordComponent.getName();
                for (PsiAnnotation annotation : recordComponent.getAnnotations()) {
                    this.processAnnotation(recordClass, name, annotation);
                }
            }

            private void processAnnotation(PsiClass recordClass, String name, PsiAnnotation annotation) {
                String message;
                PsiMethod constructor;
                EnumSet targets;
                block16: {
                    block15: {
                        PsiClass annotationType = annotation.resolveAnnotationType();
                        if (annotationType == null) {
                            return;
                        }
                        targets = AnnotationTargetUtil.getAnnotationTargets((PsiClass)annotationType);
                        if (targets == null || targets.isEmpty()) {
                            return;
                        }
                        targets = EnumSet.copyOf(targets);
                        targets.retainAll(RECORD_TARGETS);
                        if (targets.isEmpty()) break block15;
                        if (!ContainerUtil.exists(ALWAYS_USEFUL_RECORD_TARGETS, targets::contains)) break block16;
                    }
                    return;
                }
                boolean hasAccessor = false;
                boolean hasCanonicalConstructor = false;
                if (targets.contains(PsiAnnotation.TargetType.METHOD)) {
                    for (PsiMethod method : recordClass.findMethodsByName(name, false)) {
                        if (!method.getParameterList().isEmpty() || !method.isPhysical()) continue;
                        hasAccessor = true;
                        targets.remove(PsiAnnotation.TargetType.METHOD);
                        break;
                    }
                }
                if (targets.contains(PsiAnnotation.TargetType.PARAMETER) && (constructor = JavaPsiRecordUtil.findCanonicalConstructor((PsiClass)recordClass)) != null && JavaPsiRecordUtil.isExplicitCanonicalConstructor((PsiMethod)constructor)) {
                    hasCanonicalConstructor = true;
                    targets.remove(PsiAnnotation.TargetType.PARAMETER);
                }
                if (!targets.isEmpty()) {
                    return;
                }
                if (hasAccessor && hasCanonicalConstructor) {
                    message = JavaBundle.message((String)"inspection.meaningless.record.annotation.message.method.and.parameter", (Object[])new Object[0]);
                } else if (hasAccessor) {
                    message = JavaBundle.message((String)"inspection.meaningless.record.annotation.message.method", (Object[])new Object[0]);
                } else if (hasCanonicalConstructor) {
                    message = JavaBundle.message((String)"inspection.meaningless.record.annotation.message.parameter", (Object[])new Object[0]);
                } else {
                    return;
                }
                holder.problem((PsiElement)annotation, message).fix((ModCommandAction)new DeleteElementFix((PsiElement)annotation)).register();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordComponent", "com/intellij/codeInspection/MeaninglessRecordAnnotationInspection$1", "visitRecordComponent"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/MeaninglessRecordAnnotationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/MeaninglessRecordAnnotationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

