/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.MigrateToJavaLangIoInspection;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MigrateFromJavaLangIoInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher CAN_BE_IO_PRINT = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.lang.IO", (String[])new String[]{"println"}).parameterCount(0).allowStaticUnresolved(), CallMatcher.staticCall((String)"java.lang.IO", (String[])new String[]{"println", "print"}).parameterCount(1).allowStaticUnresolved()});
    private static final CallMatcher IO_PRINT = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.lang.IO", (String[])new String[]{"println"}).parameterCount(0), CallMatcher.staticCall((String)"java.lang.IO", (String[])new String[]{"println", "print"}).parameterCount(1)});

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MigrateFromJavaLangIoInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(expression);
                String referenceName = expression.getMethodExpression().getReferenceName();
                if (referenceName == null) {
                    return;
                }
                if (!MigrateFromJavaLangIoInspection.isIOPrint(expression)) {
                    return;
                }
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                ConvertIOToSystemOutFix fix = new ConvertIOToSystemOutFix(expression, referenceName);
                holder.problem((PsiElement)methodExpression, JavaBundle.message((String)"inspection.migrate.from.java.lang.io.name", (Object[])new Object[0])).fix((ModCommandAction)fix).register();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/MigrateFromJavaLangIoInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    @Nullable
    public static ModCommandAction createCanBeIOFix(@NotNull PsiElement psi) {
        if (psi == null) {
            MigrateFromJavaLangIoInspection.$$$reportNull$$$0(1);
        }
        if (!(psi instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement psiElement = psi.getParent();
        if (!(psiElement instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression parentReference = (PsiReferenceExpression)psiElement;
        PsiElement psiElement2 = parentReference.getParent();
        if (!(psiElement2 instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)psiElement2;
        if (!MigrateFromJavaLangIoInspection.canBeIOPrint(methodCallExpression)) {
            return null;
        }
        String referenceName = methodCallExpression.getMethodExpression().getReferenceName();
        if (referenceName == null) {
            return null;
        }
        return new ConvertIOToSystemOutFix(methodCallExpression, referenceName).withPresentation(presentation -> presentation.withPriority(PriorityAction.Priority.HIGH));
    }

    private static void replaceToSystemOut(@NotNull PsiMethodCallExpression methodCall) {
        PsiReferenceExpression methodExpr;
        String methodName;
        if (methodCall == null) {
            MigrateFromJavaLangIoInspection.$$$reportNull$$$0(2);
        }
        if ((methodName = (methodExpr = methodCall.getMethodExpression()).getReferenceName()) == null) {
            return;
        }
        PsiElement replaced = new CommentTracker().replaceAndRestoreComments((PsiElement)methodExpr, "java.lang.System.out." + methodName);
        if (replaced instanceof PsiReferenceExpression) {
            PsiReferenceExpression replacedReferenceExpression = (PsiReferenceExpression)replaced;
            JavaCodeStyleManager.getInstance((Project)replacedReferenceExpression.getProject()).shortenClassReferences((PsiElement)replacedReferenceExpression);
        }
    }

    private static boolean isIOPrint(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            MigrateFromJavaLangIoInspection.$$$reportNull$$$0(3);
        }
        if (!IO_PRINT.test(expression)) {
            return false;
        }
        return MigrateToJavaLangIoInspection.callIOAndSystemIdentical(expression.getArgumentList());
    }

    private static boolean canBeIOPrint(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            MigrateFromJavaLangIoInspection.$$$reportNull$$$0(4);
        }
        if (!CAN_BE_IO_PRINT.test(expression)) {
            return false;
        }
        return MigrateToJavaLangIoInspection.callIOAndSystemIdentical(expression.getArgumentList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/MigrateFromJavaLangIoInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createCanBeIOFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceToSystemOut";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isIOPrint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeIOPrint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ConvertIOToSystemOutFix
    extends PsiUpdateModCommandAction<PsiMethodCallExpression> {
        @NotNull
        private final String methodName;

        private ConvertIOToSystemOutFix(@NotNull PsiMethodCallExpression expression, @NotNull String name) {
            if (expression == null) {
                ConvertIOToSystemOutFix.$$$reportNull$$$0(0);
            }
            if (name == null) {
                ConvertIOToSystemOutFix.$$$reportNull$$$0(1);
            }
            super((PsiElement)expression);
            this.methodName = name;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.migrate.from.java.lang.io.fix.family", (Object[])new Object[0]);
            if (string == null) {
                ConvertIOToSystemOutFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiMethodCallExpression element) {
            if (context == null) {
                ConvertIOToSystemOutFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                ConvertIOToSystemOutFix.$$$reportNull$$$0(4);
            }
            return Presentation.of((String)JavaBundle.message((String)"inspection.migrate.from.java.lang.io.fix.name", (Object[])new Object[]{"System.out." + this.methodName + "()"}));
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiMethodCallExpression element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                ConvertIOToSystemOutFix.$$$reportNull$$$0(5);
            }
            if (element == null) {
                ConvertIOToSystemOutFix.$$$reportNull$$$0(6);
            }
            if (updater == null) {
                ConvertIOToSystemOutFix.$$$reportNull$$$0(7);
            }
            MigrateFromJavaLangIoInspection.replaceToSystemOut(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/MigrateFromJavaLangIoInspection$ConvertIOToSystemOutFix";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/MigrateFromJavaLangIoInspection$ConvertIOToSystemOutFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

