/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatternVariablesCanBeReplacedWithCastInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean tryToPreserveUnusedVariables = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"tryToPreserveUnusedVariables", (String)JavaBundle.message((String)"inspection.message.pattern.variables.can.be.replaced.with.cast.preserve.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PatternVariablesCanBeReplacedWithCastInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PatternVariablesCanBeReplacedWithCastInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
                PsiTypeTestPattern typeTestPattern;
                PsiPrimaryPattern pattern;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((pattern = expression.getPattern()) == null) {
                    return;
                }
                if (1.assignedVariablesInCondition(expression) || !(pattern instanceof PsiTypeTestPattern) || (typeTestPattern = (PsiTypeTestPattern)pattern).getPatternVariable() == null) {
                    return;
                }
                ConvertInstanceOfPatternToCastFix quickFix = new ConvertInstanceOfPatternToCastFix((PsiElement)pattern, PatternVariablesCanBeReplacedWithCastInspection.this.tryToPreserveUnusedVariables);
                if (InspectionProjectProfileManager.isInformationLevel((String)PatternVariablesCanBeReplacedWithCastInspection.this.getShortName(), (PsiElement)pattern)) {
                    holder.registerProblem((PsiElement)expression, TextRange.create((int)expression.getOperand().getStartOffsetInParent(), (int)(pattern.getStartOffsetInParent() + pattern.getTextLength())), JavaBundle.message((String)"inspection.message.pattern.variables.can.be.replaced.with.cast", (Object[])new Object[0]), new LocalQuickFix[]{quickFix});
                } else {
                    holder.registerProblem((PsiElement)expression, TextRange.create((int)pattern.getStartOffsetInParent(), (int)(pattern.getStartOffsetInParent() + pattern.getTextLength())), JavaBundle.message((String)"inspection.message.pattern.variables.can.be.replaced.with.cast", (Object[])new Object[0]), new LocalQuickFix[]{quickFix});
                }
            }

            private static boolean assignedVariablesInCondition(PsiInstanceOfExpression psiInstanceOfExpression) {
                List variables = JavaPsiPatternUtil.getExposedPatternVariables((PsiExpression)psiInstanceOfExpression);
                PsiElement upperLevel = 1.getUpperLevelOfCondition((PsiExpression)psiInstanceOfExpression);
                for (PsiPatternVariable variable : variables) {
                    if (!VariableAccessUtils.variableIsAssigned((PsiVariable)variable, (PsiElement)upperLevel)) continue;
                    return true;
                }
                PsiConditionalLoopStatement conditionalLoopStatement = (PsiConditionalLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)psiInstanceOfExpression, PsiConditionalLoopStatement.class);
                if (conditionalLoopStatement instanceof PsiForStatement) {
                    PsiForStatement forStatement = (PsiForStatement)conditionalLoopStatement;
                    PsiStatement update = forStatement.getUpdate();
                    for (PsiPatternVariable variable : variables) {
                        if (!VariableAccessUtils.variableIsAssigned((PsiVariable)variable, (PsiElement)update)) continue;
                        return true;
                    }
                }
                return false;
            }

            private static PsiElement getUpperLevelOfCondition(PsiExpression expression) {
                PsiExpression current = expression;
                PsiElement parent = current.getParent();
                while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPolyadicExpression || parent instanceof PsiPrefixExpression || parent instanceof PsiConditionalExpression) {
                    current = parent;
                    parent = current.getParent();
                }
                return current;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/PatternVariablesCanBeReplacedWithCastInspection$1", "visitInstanceOfExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/PatternVariablesCanBeReplacedWithCastInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/PatternVariablesCanBeReplacedWithCastInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ConvertInstanceOfPatternToCastFix
    extends PsiUpdateModCommandQuickFix {
        private final String myName;
        private final boolean tryToPreserveUnusedVariables;

        private ConvertInstanceOfPatternToCastFix(@NotNull PsiElement psiElement, boolean tryToPreserveUnusedVariables) {
            if (psiElement == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(0);
            }
            this.myName = psiElement.getText();
            this.tryToPreserveUnusedVariables = tryToPreserveUnusedVariables;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.message.pattern.variables.can.be.replaced.with.cast.fix.name", (Object[])new Object[]{this.myName});
            if (string == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.message.pattern.variables.can.be.replaced.with.cast.family.name", (Object[])new Object[0]);
            if (string == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(5);
            }
            if (!(element instanceof PsiInstanceOfExpression)) {
                return;
            }
            PsiInstanceOfExpression expression = (PsiInstanceOfExpression)element;
            PsiPrimaryPattern pattern = expression.getPattern();
            if (!(pattern instanceof PsiTypeTestPattern)) {
                return;
            }
            PsiTypeTestPattern typeTestPattern = (PsiTypeTestPattern)pattern;
            PsiPatternVariable variable = typeTestPattern.getPatternVariable();
            if (variable == null) {
                return;
            }
            List references = VariableAccessUtils.getVariableReferences((PsiVariable)variable);
            this.processReferences(references, variable, expression);
            ConvertInstanceOfPatternToCastFix.deletePatternFromInstanceOf(expression);
        }

        private void processReferences(@NotNull List<PsiReferenceExpression> references, @NotNull PsiPatternVariable variable, @NotNull PsiInstanceOfExpression psiInstanceOfExpression) {
            PsiIfStatement ifStatement;
            if (references == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(6);
            }
            if (variable == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(7);
            }
            if (psiInstanceOfExpression == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(8);
            }
            if ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)psiInstanceOfExpression, PsiIfStatement.class)) != null && PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)psiInstanceOfExpression, (boolean)false)) {
                this.processReferencesForIfStatement(ifStatement, variable, psiInstanceOfExpression, references);
                return;
            }
            PsiConditionalLoopStatement conditionalLoopStatement = (PsiConditionalLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)psiInstanceOfExpression, PsiConditionalLoopStatement.class);
            if (conditionalLoopStatement != null && PsiTreeUtil.isAncestor((PsiElement)conditionalLoopStatement.getCondition(), (PsiElement)psiInstanceOfExpression, (boolean)false)) {
                this.processReferencesForLoopStatement(conditionalLoopStatement, variable, psiInstanceOfExpression, references);
                return;
            }
            ConvertInstanceOfPatternToCastFix.replaceWithCast(variable, references);
        }

        private void processReferencesForIfStatement(@NotNull PsiIfStatement ifStatement, @NotNull PsiPatternVariable variable, @NotNull PsiInstanceOfExpression psiInstanceOfExpression, @NotNull List<PsiReferenceExpression> references) {
            Map<Boolean, List<PsiReferenceExpression>> collectedOutside;
            if (ifStatement == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(9);
            }
            if (variable == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(10);
            }
            if (psiInstanceOfExpression == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(11);
            }
            if (references == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(12);
            }
            ArrayList<PsiReferenceExpression> unusedReferences = new ArrayList<PsiReferenceExpression>(references);
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (this.tryToPreserveUnusedVariables) {
                PsiIfStatement parentIf;
                PsiElement psiElement;
                ConditionState conditionState = ConvertInstanceOfPatternToCastFix.getConditionIfInstanceOfTrue(psiInstanceOfExpression, ifStatement.getCondition());
                if (conditionState == ConditionState.TRUE && thenBranch != null && !(thenBranch instanceof PsiEmptyStatement) && ifStatement.getElseBranch() == null) {
                    List referencesForThenBranch = ContainerUtil.filter(unusedReferences, t -> PsiTreeUtil.isAncestor((PsiElement)thenBranch, (PsiElement)t, (boolean)false));
                    unusedReferences.removeAll(referencesForThenBranch);
                    ConvertInstanceOfPatternToCastFix.addDeclarationInsideBlock(thenBranch, variable);
                }
                if (!(!conditionState.equals((Object)ConditionState.FALSE) || ControlFlowUtils.statementMayCompleteNormally((PsiStatement)thenBranch) || ifStatement.getElseBranch() != null || (psiElement = ifStatement.getParent()) instanceof PsiIfStatement && (parentIf = (PsiIfStatement)psiElement).getElseBranch() == ifStatement)) {
                    List referencesForOutsideIf = ContainerUtil.filter(unusedReferences, t -> !PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)t, (boolean)false));
                    unusedReferences.removeAll(referencesForOutsideIf);
                    ConvertInstanceOfPatternToCastFix.addDeclarationOutsideBlock((PsiStatement)ifStatement, variable);
                }
            }
            Map<Boolean, List<PsiReferenceExpression>> collectedInsideThenBranch = unusedReferences.stream().collect(Collectors.groupingBy(referenceExpression -> PsiTreeUtil.isAncestor((PsiElement)thenBranch, (PsiElement)referenceExpression, (boolean)false)));
            if (thenBranch != null && !(thenBranch instanceof PsiEmptyStatement) && collectedInsideThenBranch.get(Boolean.TRUE) != null) {
                ConvertInstanceOfPatternToCastFix.addDeclarationInsideBlock(thenBranch, variable);
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            Map<Boolean, List<PsiReferenceExpression>> collectedInsideElseBlock = collectedInsideThenBranch.getOrDefault(Boolean.FALSE, List.of()).stream().collect(Collectors.groupingBy(referenceExpression -> PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)referenceExpression, (boolean)false)));
            if (elseBranch != null && collectedInsideElseBlock.get(Boolean.TRUE) != null) {
                if (elseBranch instanceof PsiIfStatement) {
                    PsiIfStatement elseIfStatement = (PsiIfStatement)elseBranch;
                    this.processReferencesForIfStatement(elseIfStatement, variable, psiInstanceOfExpression, collectedInsideElseBlock.get(Boolean.TRUE));
                } else {
                    ConvertInstanceOfPatternToCastFix.addDeclarationInsideBlock(elseBranch, variable);
                }
            }
            if ((collectedOutside = collectedInsideElseBlock.getOrDefault(Boolean.FALSE, List.of()).stream().collect(Collectors.groupingBy(referenceExpression -> !PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)referenceExpression, (boolean)false)))).get(Boolean.TRUE) != null) {
                ConvertInstanceOfPatternToCastFix.addDeclarationOutsideBlock((PsiStatement)ifStatement, variable);
            }
            ConvertInstanceOfPatternToCastFix.replaceWithCast(variable, collectedOutside.get(Boolean.FALSE));
        }

        private void processReferencesForLoopStatement(@NotNull PsiConditionalLoopStatement statement, @NotNull PsiPatternVariable variable, @NotNull PsiInstanceOfExpression psiInstanceOfExpression, @NotNull List<PsiReferenceExpression> references) {
            if (statement == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(13);
            }
            if (variable == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(14);
            }
            if (psiInstanceOfExpression == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(15);
            }
            if (references == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(16);
            }
            ConditionState conditionState = ConvertInstanceOfPatternToCastFix.getConditionIfInstanceOfTrue(psiInstanceOfExpression, statement.getCondition());
            ArrayList<PsiReferenceExpression> unusedReferences = new ArrayList<PsiReferenceExpression>(references);
            List referencesForInsideBlock = ContainerUtil.filter(unusedReferences, t -> PsiTreeUtil.isAncestor((PsiElement)statement.getBody(), (PsiElement)t, (boolean)false));
            unusedReferences.removeAll(referencesForInsideBlock);
            if (statement.getBody() != null && !(statement.getBody() instanceof PsiEmptyStatement) && (this.tryToPreserveUnusedVariables && conditionState == ConditionState.TRUE && !(statement instanceof PsiDoWhileStatement) || !referencesForInsideBlock.isEmpty())) {
                ConvertInstanceOfPatternToCastFix.addDeclarationInsideBlock(statement.getBody(), variable);
            }
            List referencesOutsideLoop = ContainerUtil.filter(unusedReferences, t -> !PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)t, (boolean)false));
            unusedReferences.removeAll(referencesOutsideLoop);
            boolean noBreak = PsiTreeUtil.processElements((PsiElement)statement, e -> !(e instanceof PsiBreakStatement) || ((PsiBreakStatement)e).findExitedStatement() != statement);
            if (this.tryToPreserveUnusedVariables && conditionState == ConditionState.FALSE && noBreak || !referencesOutsideLoop.isEmpty()) {
                ConvertInstanceOfPatternToCastFix.addDeclarationOutsideBlock((PsiStatement)statement, variable);
            }
            ConvertInstanceOfPatternToCastFix.replaceWithCast(variable, unusedReferences);
        }

        private static ConditionState getConditionIfInstanceOfTrue(PsiInstanceOfExpression expression, PsiExpression condition) {
            if (condition == null || PsiTreeUtil.skipParentsOfType((PsiElement)expression, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiPrefixExpression.class, PsiPolyadicExpression.class}) != condition.getParent()) {
                return ConditionState.UNKNOWN;
            }
            PsiElement current = expression.getParent();
            boolean currentState = true;
            while (current != condition.getParent()) {
                if (current instanceof PsiParenthesizedExpression) {
                    current = current.getParent();
                    continue;
                }
                if (current instanceof PsiPrefixExpression) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)current;
                    if (!prefixExpression.getOperationTokenType().equals(JavaTokenType.EXCL)) {
                        return ConditionState.UNKNOWN;
                    }
                    currentState = !currentState;
                    current = current.getParent();
                    continue;
                }
                if (!(current instanceof PsiPolyadicExpression)) continue;
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)current;
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                if (tokenType.equals(JavaTokenType.ANDAND) && currentState) {
                    current = current.getParent();
                    continue;
                }
                if (tokenType.equals(JavaTokenType.OROR) && !currentState) {
                    current = current.getParent();
                    continue;
                }
                return ConditionState.UNKNOWN;
            }
            return currentState ? ConditionState.TRUE : ConditionState.FALSE;
        }

        private static void addDeclarationOutsideBlock(PsiStatement statement, PsiPatternVariable variable) {
            if (statement.getNextSibling() == null) {
                return;
            }
            String text = ConvertInstanceOfPatternToCastFix.getDeclarationStatement(variable);
            if (text == null) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent == null) {
                return;
            }
            Project project = statement.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiStatement declarationStatement = factory.createStatementFromText(text, statement.getNextSibling());
            PsiElement newDeclarationStatement = parent.addAfter((PsiElement)declarationStatement, (PsiElement)statement);
            CodeStyleManager.getInstance((Project)project).reformat(newDeclarationStatement);
        }

        private static void addDeclarationInsideBlock(@NotNull PsiStatement statement, @NotNull PsiPatternVariable variable) {
            String text;
            if (statement == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(17);
            }
            if (variable == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(18);
            }
            if ((text = ConvertInstanceOfPatternToCastFix.getDeclarationStatement(variable)) == null) {
                return;
            }
            Project project = statement.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiStatement declarationStatement = factory.createStatementFromText(text, (PsiElement)statement);
            BlockUtils.addBefore((PsiStatement)statement, (PsiStatement[])new PsiStatement[]{declarationStatement});
        }

        @Nullable
        private static String getDeclarationStatement(@NotNull PsiPatternVariable variable) {
            Object text;
            if (variable == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(19);
            }
            if ((text = JavaPsiPatternUtil.getEffectiveInitializerText((PsiPatternVariable)variable)) == null) {
                return null;
            }
            text = variable.getTypeElement().getText() + " " + variable.getName() + " = " + (String)text + ";";
            PsiModifierList modifierList = variable.getModifierList();
            if (modifierList != null && StringUtil.isNotEmpty((String)modifierList.getText())) {
                text = modifierList.getText() + " " + (String)text;
            }
            return text;
        }

        private static void deletePatternFromInstanceOf(@NotNull PsiInstanceOfExpression expression) {
            PsiPrimaryPattern psiPrimaryPattern;
            if (expression == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(20);
            }
            if (!((psiPrimaryPattern = expression.getPattern()) instanceof PsiTypeTestPattern)) {
                return;
            }
            PsiTypeTestPattern typeTestPattern = (PsiTypeTestPattern)psiPrimaryPattern;
            PsiPatternVariable variable = typeTestPattern.getPatternVariable();
            if (variable == null) {
                return;
            }
            Object text = expression.getText();
            text = ((String)text).substring(0, ((String)text).length() - typeTestPattern.getTextLength()) + variable.getTypeElement().getText();
            CommentTracker tracker = new CommentTracker();
            for (PsiElement element : expression.getChildren()) {
                if (element == typeTestPattern) continue;
                tracker.markUnchanged(element);
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, (String)text, (CommentTracker)tracker);
        }

        private static void replaceWithCast(@NotNull PsiPatternVariable variable, @Nullable List<PsiReferenceExpression> references) {
            if (variable == null) {
                ConvertInstanceOfPatternToCastFix.$$$reportNull$$$0(21);
            }
            if (references == null || references.isEmpty()) {
                return;
            }
            String text = JavaPsiPatternUtil.getEffectiveInitializerText((PsiPatternVariable)variable);
            if (text == null) {
                return;
            }
            references.forEach(reference -> PsiReplacementUtil.replaceExpression((PsiExpression)reference, (String)text, (CommentTracker)new CommentTracker()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/PatternVariablesCanBeReplacedWithCastInspection$ConvertInstanceOfPatternToCastFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 6: 
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "references";
                    break;
                }
                case 7: 
                case 10: 
                case 14: 
                case 18: 
                case 19: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 8: 
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiInstanceOfExpression";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 13: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/PatternVariablesCanBeReplacedWithCastInspection$ConvertInstanceOfPatternToCastFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "processReferences";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "processReferencesForIfStatement";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "processReferencesForLoopStatement";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "addDeclarationInsideBlock";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getDeclarationStatement";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "deletePatternFromInstanceOf";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceWithCast";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static enum ConditionState {
        TRUE,
        FALSE,
        UNKNOWN;

    }
}

