/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedundantExplicitCloseInspection
extends AbstractBaseJavaLocalInspectionTool {
    CallMatcher CLOSE = CallMatcher.instanceCall((String)"java.lang.AutoCloseable", (String[])new String[]{"close"}).parameterCount(0);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantExplicitCloseInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitTryStatement(@NotNull PsiTryStatement statement) {
                PsiResourceList resourceList;
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((resourceList = statement.getResourceList()) == null) {
                    return;
                }
                PsiCodeBlock tryBlock = statement.getTryBlock();
                if (tryBlock == null) {
                    return;
                }
                List<PsiStatement> terminatingStatements = RedundantExplicitCloseInspection.getTerminatingStatements((PsiStatement)ArrayUtil.getLastElement((Object[])tryBlock.getStatements()));
                for (PsiStatement last : terminatingStatements) {
                    PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)last, PsiExpressionStatement.class);
                    if (expressionStatement == null) {
                        return;
                    }
                    PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiMethodCallExpression.class);
                    if (!RedundantExplicitCloseInspection.this.CLOSE.test(call)) {
                        return;
                    }
                    PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                    PsiReferenceExpression reference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier), PsiReferenceExpression.class);
                    if (reference == null) {
                        return;
                    }
                    PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
                    if (variable == null) {
                        return;
                    }
                    boolean isReferenceToResourceVariable = StreamEx.of((Iterator)resourceList.iterator()).anyMatch(element -> variable == element || element instanceof PsiResourceExpression && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)reference, ((PsiResourceExpression)element).getExpression()));
                    if (!isReferenceToResourceVariable) {
                        return;
                    }
                    holder.problem((PsiElement)last, JavaBundle.message((String)"inspection.redundant.explicit.close", (Object[])new Object[0])).fix((ModCommandAction)new DeleteElementFix((PsiElement)last, CommonQuickFixBundle.message((String)"fix.remove.redundant", (Object[])new Object[]{"close()"}))).register();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/RedundantExplicitCloseInspection$1", "visitTryStatement"));
            }
        };
    }

    @NotNull
    private static List<PsiStatement> getTerminatingStatements(@Nullable PsiStatement last) {
        if (last == null) {
            List<PsiStatement> list = Collections.emptyList();
            if (list == null) {
                RedundantExplicitCloseInspection.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<PsiStatement> terminatingStatements = new ArrayList<PsiStatement>();
        PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)last, PsiIfStatement.class);
        if (ifStatement != null) {
            Object[] thenStatements = ControlFlowUtils.unwrapBlock((PsiStatement)ifStatement.getThenBranch());
            terminatingStatements.addAll(RedundantExplicitCloseInspection.getTerminatingStatements((PsiStatement)ArrayUtil.getLastElement((Object[])thenStatements)));
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch != null) {
                Object[] elseStatements = ControlFlowUtils.unwrapBlock((PsiStatement)elseBranch);
                terminatingStatements.addAll(RedundantExplicitCloseInspection.getTerminatingStatements((PsiStatement)ArrayUtil.getLastElement((Object[])elseStatements)));
            }
        } else {
            terminatingStatements.add(last);
        }
        ArrayList<PsiStatement> arrayList = terminatingStatements;
        if (arrayList == null) {
            RedundantExplicitCloseInspection.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantExplicitCloseInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantExplicitCloseInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminatingStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

