/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedundantRecordConstructorInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.RECORDS);
        if (set == null) {
            RedundantRecordConstructorInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantRecordConstructorInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitMethod(@NotNull PsiMethod method) {
                PsiClass aClass;
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((aClass = method.getContainingClass()) == null || !aClass.isRecord()) {
                    return;
                }
                if (JavaPsiRecordUtil.isCompactConstructor((PsiMethod)method)) {
                    this.checkCompact(method);
                } else {
                    this.checkCanonical(method);
                }
            }

            private void checkCanonical(PsiMethod ctor) {
                ConstructorSimplifier simplifier = RedundantRecordConstructorInspection.createCtorSimplifier(ctor);
                if (simplifier instanceof RemoveRedundantCtorSimplifier) {
                    PsiIdentifier nameIdentifier = ctor.getNameIdentifier();
                    if (nameIdentifier == null) {
                        return;
                    }
                    holder.registerProblem((PsiElement)nameIdentifier, JavaBundle.message((String)"inspection.redundant.record.constructor.canonical.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{simplifier});
                } else if (simplifier instanceof MakeCtorCompactSimplifier) {
                    holder.registerProblem((PsiElement)ctor.getParameterList(), JavaBundle.message((String)"inspection.redundant.record.constructor.can.be.compact.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{simplifier});
                }
            }

            private void checkCompact(PsiMethod ctor) {
                PsiCodeBlock body = ctor.getBody();
                if (body == null) {
                    return;
                }
                PsiIdentifier ctorNameIdentifier = ctor.getNameIdentifier();
                if (ctorNameIdentifier == null) {
                    return;
                }
                PsiStatement[] statements = body.getStatements();
                if (statements.length > 0) {
                    PsiParameter[] parameters = ctor.getParameterList().getParameters();
                    PsiRecordComponent[] components = Objects.requireNonNull(ctor.getContainingClass()).getRecordComponents();
                    int count = RedundantRecordConstructorInspection.getAssignedComponentsCount(components, parameters, statements);
                    if (count < statements.length) {
                        for (int i = statements.length - count; i < statements.length; ++i) {
                            holder.problem((PsiElement)statements[i], JavaBundle.message((String)"inspection.redundant.record.constructor.statement.message", (Object[])new Object[0])).fix((ModCommandAction)new DeleteElementFix((PsiElement)statements[i])).register();
                        }
                        return;
                    }
                }
                if (!ctor.hasAnnotations() && ctor.getDocComment() == null) {
                    holder.registerProblem((PsiElement)ctorNameIdentifier, JavaBundle.message((String)"inspection.redundant.record.constructor.compact.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveRedundantCtorSimplifier()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/RedundantRecordConstructorInspection$1", "visitMethod"));
            }
        };
    }

    @Nullable
    public static ConstructorSimplifier createCtorSimplifier(@NotNull PsiMethod ctor) {
        if (ctor == null) {
            RedundantRecordConstructorInspection.$$$reportNull$$$0(2);
        }
        if (!JavaPsiRecordUtil.isExplicitCanonicalConstructor((PsiMethod)ctor)) {
            return null;
        }
        PsiCodeBlock body = ctor.getBody();
        if (body == null) {
            return null;
        }
        if (!ctor.getThrowsList().getText().isEmpty()) {
            return null;
        }
        PsiIdentifier nameIdentifier = ctor.getNameIdentifier();
        if (nameIdentifier == null) {
            return null;
        }
        Object[] components = Objects.requireNonNull(ctor.getContainingClass()).getRecordComponents();
        Object[] parameters = ctor.getParameterList().getParameters();
        PsiAnnotation.TargetType[] targets = new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER, PsiAnnotation.TargetType.TYPE_USE};
        if (!EntryStream.zip((Object[])components, (Object[])parameters).mapKeys(c -> ContainerUtil.filter((Object[])c.getAnnotations(), anno -> AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)anno, (PsiAnnotation.TargetType[])targets) != null)).mapValues(p -> Arrays.asList(p.getAnnotations())).allMatch((compAnnotations, paramAnnotations) -> compAnnotations.size() == paramAnnotations.size() && EntryStream.zip((List)compAnnotations, (List)paramAnnotations).allMatch(PsiEquivalenceUtil::areElementsEquivalent))) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        int assignedCount = RedundantRecordConstructorInspection.getAssignedComponentsCount((PsiRecordComponent[])components, (PsiParameter[])parameters, statements);
        if (statements.length == components.length && assignedCount == components.length && !ctor.hasAnnotations() && ctor.getDocComment() == null) {
            return new RemoveRedundantCtorSimplifier();
        }
        if (PsiUtil.findReturnStatements((PsiCodeBlock)body).length > 0) {
            return null;
        }
        if (assignedCount != components.length) {
            return null;
        }
        return new MakeCtorCompactSimplifier();
    }

    private static int getAssignedComponentsCount(PsiRecordComponent @NotNull [] components, PsiParameter @NotNull [] parameters, PsiStatement @NotNull [] statements) {
        PsiReferenceExpression rValue;
        PsiParameter parameter;
        PsiRecordComponent component;
        PsiField field;
        PsiReferenceExpression lValue;
        PsiAssignmentExpression assignment;
        if (components == null) {
            RedundantRecordConstructorInspection.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            RedundantRecordConstructorInspection.$$$reportNull$$$0(4);
        }
        if (statements == null) {
            RedundantRecordConstructorInspection.$$$reportNull$$$0(5);
        }
        assert (parameters.length == components.length);
        HashSet unprocessed = ContainerUtil.newHashSet((Object[])components);
        for (int i = statements.length - 1; i >= 0 && !unprocessed.isEmpty() && (assignment = ExpressionUtils.getAssignment((PsiElement)statements[i])) != null && (lValue = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression()), PsiReferenceExpression.class)) != null && ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)lValue) && (field = (PsiField)ObjectUtils.tryCast((Object)lValue.resolve(), PsiField.class)) != null && (component = JavaPsiRecordUtil.getComponentForField((PsiField)field)) != null && unprocessed.contains(component) && (parameter = parameters[ArrayUtil.indexOf((Object[])components, (Object)component)]).getName().equals(component.getName()) && (rValue = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()), PsiReferenceExpression.class)) != null && rValue.getQualifierExpression() == null && parameter.getName().equals(rValue.getReferenceName()); --i) {
            unprocessed.remove(component);
        }
        return components.length - unprocessed.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantRecordConstructorInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantRecordConstructorInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCtorSimplifier";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedComponentsCount";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static class RemoveRedundantCtorSimplifier
    extends ConstructorSimplifier {
        private RemoveRedundantCtorSimplifier() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.remove.title", (Object[])new Object[]{JavaElementKind.CONSTRUCTOR.object()});
            if (string == null) {
                RemoveRedundantCtorSimplifier.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void simplify(@NotNull PsiMethod ctor) {
            if (ctor == null) {
                RemoveRedundantCtorSimplifier.$$$reportNull$$$0(1);
            }
            new CommentTracker().deleteAndRestoreComments((PsiElement)ctor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantRecordConstructorInspection$RemoveRedundantCtorSimplifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantRecordConstructorInspection$RemoveRedundantCtorSimplifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "simplify";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MakeCtorCompactSimplifier
    extends ConstructorSimplifier {
        private MakeCtorCompactSimplifier() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.redundant.record.constructor.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MakeCtorCompactSimplifier.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void simplify(@NotNull PsiMethod ctor) {
            PsiStatement[] statements;
            PsiParameterList parameterList;
            PsiParameter[] parameters;
            if (ctor == null) {
                MakeCtorCompactSimplifier.$$$reportNull$$$0(1);
            }
            if (!JavaPsiRecordUtil.isExplicitCanonicalConstructor((PsiMethod)ctor)) {
                return;
            }
            PsiClass record = ctor.getContainingClass();
            if (record == null) {
                return;
            }
            PsiCodeBlock body = ctor.getBody();
            if (body == null) {
                return;
            }
            PsiRecordComponent[] components = record.getRecordComponents();
            int assignedComponents = RedundantRecordConstructorInspection.getAssignedComponentsCount(components, parameters = (parameterList = ctor.getParameterList()).getParameters(), statements = body.getStatements());
            PsiStatement firstStatementToDelete = assignedComponents == 0 ? null : statements[statements.length - assignedComponents];
            StringBuilder resultText = new StringBuilder();
            for (PsiElement child : ctor.getChildren()) {
                if (child == parameterList) continue;
                if (child == body) break;
                resultText.append(child.getText());
            }
            boolean skipStatements = false;
            CommentTracker ct = new CommentTracker();
            for (PsiElement child : body.getChildren()) {
                if (child == firstStatementToDelete) {
                    skipStatements = true;
                }
                if (skipStatements && child.getNextSibling() != null) {
                    ct.grabComments(child);
                    continue;
                }
                resultText.append(child.getText());
            }
            PsiMethod compactCtor = JavaPsiFacade.getElementFactory((Project)record.getProject()).createMethodFromText(resultText.toString(), (PsiElement)ctor);
            PsiMethod result = (PsiMethod)ctor.replace((PsiElement)compactCtor);
            ct.insertCommentsBefore((PsiElement)Objects.requireNonNull(Objects.requireNonNull(result.getBody()).getRBrace()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantRecordConstructorInspection$MakeCtorCompactSimplifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantRecordConstructorInspection$MakeCtorCompactSimplifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "simplify";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static abstract class ConstructorSimplifier
    extends PsiUpdateModCommandQuickFix {
        public abstract void simplify(@NotNull PsiMethod var1);

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiMethod ctor;
            if (project == null) {
                ConstructorSimplifier.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ConstructorSimplifier.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                ConstructorSimplifier.$$$reportNull$$$0(2);
            }
            if ((ctor = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) != null) {
                this.simplify(ctor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "updater";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/RedundantRecordConstructorInspection$ConstructorSimplifier";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

