/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FunctionalExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedundantStreamOptionalCallInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(RedundantStreamOptionalCallInspection.class);
    private static final CallMatcher NATURAL_OR_REVERSED_COMPARATOR = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.util.Comparator", (String[])new String[]{"naturalOrder", "reverseOrder"}).parameterCount(0), CallMatcher.staticCall((String)"java.util.Collections", (String[])new String[]{"reverseOrder"}).parameterCount(0)});
    private static final CallMatcher COMPARATOR_REVERSE = CallMatcher.instanceCall((String)"java.util.Comparator", (String[])new String[]{"reversed"}).parameterCount(0);
    private static final Set<String> INTERESTING_NAMES = Set.of("map", "filter", "distinct", "sorted", "sequential", "parallel", "unordered", "flatMap");
    private static final Set<String> CALLS_MAKING_SORT_USELESS = Set.of("sorted", "anyMatch", "allMatch", "noneMatch", "count", "min", "max");
    private static final Map<String, String> CALLS_MAKING_SORT_USELESS_PARALLEL = Map.of("findAny", "findFirst", "forEach", "forEachOrdered");
    private static final Set<String> CALLS_KEEPING_SORT_ORDER = Set.of("filter", "distinct", "boxed", "asLongStream", "asDoubleStream");
    private static final Set<String> CALLS_KEEPING_ELEMENTS_DISTINCT = Set.of("filter", "boxed", "asLongStream", "limit", "skip", "sorted", "takeWhile", "dropWhile");
    private static final Set<String> CALLS_AFFECTING_PARALLELIZATION = Set.of("sequential", "parallel");
    private static final Set<String> CALLS_USELESS_FOR_SINGLE_ELEMENT_STREAM = Set.of("sorted", "distinct");
    private static final Set<String> BOX_UNBOX_NAMES = Set.of("valueOf", "booleanValue", "byteValue", "charValue", "shortValue", "intValue", "longValue", "floatValue", "doubleValue");
    private static final Set<String> STANDARD_STREAM_INTERMEDIATE_OPERATIONS = Set.of("asDoubleStream", "asLongStream", "boxed", "distinct", "dropWhile", "filter", "flatMap", "flatMapToDouble", "flatMapToInt", "flatMapToLong", "flatMapToObj", "limit", "map", "mapToDouble", "mapToInt", "mapToLong", "mapToObj", "onClose", "parallel", "peek", "sequential", "skip", "takeWhile", "unordered");
    private static final Set<String> STANDARD_STREAM_TERMINAL_OPERATIONS = Set.of("allMatch", "anyMatch", "average", "collect", "count", "findAny", "findFirst", "forEach", "forEachOrdered", "max", "min", "noneMatch", "reduce", "sum", "summaryStatistics", "toArray");
    private static final CallMatcher COLLECTOR_TO_SET = CallMatcher.staticCall((String)"java.util.stream.Collectors", (String[])new String[]{"toSet", "toUnmodifiableSet"}).parameterCount(0);
    private static final CallMatcher COLLECTOR_TO_COLLECTION = CallMatcher.staticCall((String)"java.util.stream.Collectors", (String[])new String[]{"toCollection"}).parameterCount(1);
    private static final CallMatcher COLLECTOR_TO_MAP = CallMatcher.staticCall((String)"java.util.stream.Collectors", (String[])new String[]{"toMap", "toUnmodifiableMap"}).parameterTypes(new String[]{"java.util.function.Function", "java.util.function.Function"});
    private static final CallMatcher UNORDERED_COLLECTORS = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{COLLECTOR_TO_MAP, COLLECTOR_TO_SET});
    private static final Predicate<PsiMethodCallExpression> UNORDERED_COLLECTOR = UNORDERED_COLLECTORS.or(RedundantStreamOptionalCallInspection::isUnorderedToCollection);
    private static final CallMatcher STREAM_OF_SINGLE = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.util.stream.Stream", (String[])new String[]{"of"}).parameterTypes(new String[]{"T"}), CallMatcher.staticCall((String)"java.util.stream.IntStream", (String[])new String[]{"of"}).parameterTypes(new String[]{"int"}), CallMatcher.staticCall((String)"java.util.stream.LongStream", (String[])new String[]{"of"}).parameterTypes(new String[]{"long"}), CallMatcher.staticCall((String)"java.util.stream.DoubleStream", (String[])new String[]{"of"}).parameterTypes(new String[]{"double"})});
    private static final CallMatcher STREAM_MAP = CallMatcher.instanceCall((String)"java.util.stream.Stream", (String[])new String[]{"map"}).parameterTypes(new String[]{"java.util.function.Function"});
    private static final CallMatcher COLLECTION_STREAM_SOURCE = CallMatcher.instanceCall((String)"java.util.Collection", (String[])new String[]{"parallelStream", "stream"}).parameterCount(0);
    private static final CallMatcher PARALLEL_STREAM_SOURCE = CallMatcher.instanceCall((String)"java.util.Collection", (String[])new String[]{"parallelStream"}).parameterCount(0);
    public boolean USELESS_BOXING_IN_STREAM_MAP = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"USELESS_BOXING_IN_STREAM_MAP", (String)JavaBundle.message((String)"inspection.redundant.stream.optional.call.option.streamboxing", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RedundantStreamOptionalCallInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STREAM_OPTIONAL);
        if (set == null) {
            RedundantStreamOptionalCallInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantStreamOptionalCallInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                PsiMethodCallExpression qualifierCall;
                PsiReferenceExpression methodExpression;
                String name;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (STREAM_OF_SINGLE.test(call)) {
                    this.handleSingleElementStream(call);
                }
                if ((name = (methodExpression = call.getMethodExpression()).getReferenceName()) == null || !INTERESTING_NAMES.contains(name)) {
                    return;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return;
                }
                String className = aClass.getQualifiedName();
                if (className == null) {
                    return;
                }
                boolean optional = OptionalUtil.isJdkOptionalClassName((String)className);
                boolean stream = InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream");
                if (!optional && !stream) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (name.equals("flatMap") && args.length == 1 && RedundantStreamOptionalCallInspection.isIdentityMapping(args[0], false) && STREAM_MAP.test(qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call)) && qualifierCall.getMethodExpression().getTypeParameters().length == 0 && !RedundantStreamOptionalCallInspection.isIdentityMapping(qualifierCall.getArgumentList().getExpressions()[0], false)) {
                    String message = JavaBundle.message((String)"inspection.call.message", (Object[])new Object[]{name}) + ": " + JavaBundle.message((String)"inspection.redundant.stream.optional.call.explanation.map.flatMap", (Object[])new Object[0]);
                    holder.registerProblem((PsiElement)call, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, RedundantStreamOptionalCallInspection.getRange(call), new LocalQuickFix[]{new RemoveCallFix(name, "map")});
                }
                if (!EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(qualifier.getType(), call.getType())) {
                    return;
                }
                block10 : switch (name) {
                    case "filter": {
                        if (args.length != 1 || !RedundantStreamOptionalCallInspection.isTruePredicate(args[0])) break;
                        this.register(call, JavaBundle.message((String)"inspection.redundant.stream.optional.call.explanation.filter", (Object[])new Object[0]), new LocalQuickFix[0]);
                        break;
                    }
                    case "map": {
                        boolean allowBoxUnbox;
                        boolean bl = allowBoxUnbox = RedundantStreamOptionalCallInspection.this.USELESS_BOXING_IN_STREAM_MAP || optional || StreamApiUtil.getStreamElementType((PsiType)call.getType()) instanceof PsiPrimitiveType;
                        if (args.length != 1 || !RedundantStreamOptionalCallInspection.isIdentityMapping(args[0], allowBoxUnbox)) break;
                        this.register(call, null, new LocalQuickFix[0]);
                        break;
                    }
                    case "flatMap": {
                        if (args.length != 1) break;
                        if (optional) {
                            if (!FunctionalExpressionUtils.isFunctionalReferenceTo((PsiExpression)args[0], (String)"java.util.Optional", null, (String)"of", (PsiType[])new PsiType[1]) && !FunctionalExpressionUtils.isFunctionalReferenceTo((PsiExpression)args[0], (String)"java.util.Optional", null, (String)"ofNullable", (PsiType[])new PsiType[1])) break;
                            this.register(call, null, new LocalQuickFix[0]);
                            break;
                        }
                        if (!FunctionalExpressionUtils.isFunctionalReferenceTo((PsiExpression)args[0], (String)"java.util.stream.Stream", null, (String)"of", (PsiType[])new PsiType[1])) break;
                        this.register(call, null, new LocalQuickFix[0]);
                        break;
                    }
                    case "sorted": {
                        PsiMethodCallExpression furtherCall;
                        if (args.length > 1 || (furtherCall = RedundantStreamOptionalCallInspection.findCallThatSpoilsSorting(call)) == null) break;
                        String furtherCallName = furtherCall.getMethodExpression().getReferenceName();
                        String terminalReplacement = CALLS_MAKING_SORT_USELESS_PARALLEL.get(furtherCallName);
                        if (terminalReplacement != null && !1.isParallelStream(call)) {
                            return;
                        }
                        if (("max".equals(furtherCallName) || "min".equals(furtherCallName)) && !RedundantStreamOptionalCallInspection.sortingCancelsPreviousSorting(call, furtherCall)) {
                            return;
                        }
                        PsiUpdateModCommandQuickFix additionalFix = null;
                        if ("toSet".equals(furtherCallName) || "toCollection".equals(furtherCallName)) {
                            additionalFix = new CollectToOrderedSetFix();
                        } else if (terminalReplacement != null) {
                            additionalFix = new ReplaceTerminalCallFix(terminalReplacement);
                        }
                        String message = "sorted".equals(furtherCallName) ? JavaBundle.message((String)"inspection.redundant.stream.optional.call.explanation.sorted.twice", (Object[])new Object[0]) : (terminalReplacement != null ? JavaBundle.message((String)"inspection.redundant.stream.optional.call.explanation.sorted.parallel", (Object[])new Object[]{furtherCallName}) : JavaBundle.message((String)"inspection.redundant.stream.optional.call.explanation.sorted", (Object[])new Object[]{furtherCallName}));
                        this.register(call, message, LocalQuickFix.notNullElements((LocalQuickFix)additionalFix));
                        break;
                    }
                    case "distinct": {
                        if (args.length != 0) break;
                        PsiMethodCallExpression furtherCall = StreamApiUtil.findSubsequentCall((PsiMethodCallExpression)call, Predicate.isEqual("distinct"), CALLS_KEEPING_ELEMENTS_DISTINCT::contains);
                        if (furtherCall != null && furtherCall.getArgumentList().isEmpty()) {
                            this.register(furtherCall, JavaBundle.message((String)"inspection.redundant.stream.optional.call.explanation.distinct", (Object[])new Object[0]), new LocalQuickFix[0]);
                        }
                        Predicate setCollector = COLLECTOR_TO_SET.or(RedundantStreamOptionalCallInspection::isToCollectionSet);
                        if (StreamApiUtil.findSubsequentCall((PsiMethodCallExpression)call, c -> false, (Predicate)setCollector, Set.of("unordered", "parallel", "sequential", "sorted")::contains) == null) break;
                        this.register(call, JavaBundle.message((String)"inspection.redundant.stream.optional.call.explanation.distinct.set", (Object[])new Object[0]), new LocalQuickFix[0]);
                        break;
                    }
                    case "unordered": {
                        PsiMethodCallExpression furtherCall;
                        if (args.length != 0 || (furtherCall = StreamApiUtil.findSubsequentCall((PsiMethodCallExpression)call, Predicate.isEqual("unordered"), n -> !n.equals("sorted"))) == null || !furtherCall.getArgumentList().isEmpty()) break;
                        this.register(furtherCall, JavaBundle.message((String)"inspection.redundant.stream.optional.call.explanation.unordered", (Object[])new Object[0]), new LocalQuickFix[0]);
                        break;
                    }
                    case "sequential": 
                    case "parallel": {
                        String prevName;
                        if (args.length != 0) break;
                        PsiMethodCallExpression furtherCall = StreamApiUtil.findSubsequentCall((PsiMethodCallExpression)call, CALLS_AFFECTING_PARALLELIZATION::contains, n -> true);
                        if (furtherCall != null && furtherCall.getArgumentList().isEmpty()) {
                            this.register(call, JavaBundle.message((String)"inspection.redundant.stream.optional.call.explanation.parallel", (Object[])new Object[]{furtherCall.getMethodExpression().getReferenceName()}), new LocalQuickFix[0]);
                            break;
                        }
                        PsiMethodCallExpression previousCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                        while (previousCall != null && (prevName = previousCall.getMethodExpression().getReferenceName()) != null && !CALLS_AFFECTING_PARALLELIZATION.contains(prevName)) {
                            boolean curParallel;
                            boolean previousParallel;
                            if (COLLECTION_STREAM_SOURCE.test(previousCall) && (previousParallel = prevName.equals("parallelStream")) == (curParallel = name.equals("parallel"))) {
                                this.register(call, JavaBundle.message((String)(curParallel ? "inspection.redundant.stream.optional.call.explanation.parallel.source" : "inspection.redundant.stream.optional.call.explanation.sequential.source"), (Object[])new Object[0]), new LocalQuickFix[0]);
                                break block10;
                            }
                            if (StreamApiUtil.getStreamElementType((PsiType)previousCall.getType()) == null) break block10;
                            previousCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)previousCall);
                        }
                        break;
                    }
                }
            }

            private static boolean isParallelStream(PsiMethodCallExpression call) {
                PsiExpression qualifier;
                while ((qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression())) != null) {
                    if (StreamApiUtil.getStreamElementType((PsiType)qualifier.getType()) == null) {
                        return false;
                    }
                    String name = call.getMethodExpression().getReferenceName();
                    if (name == null) {
                        return false;
                    }
                    if (name.equals("sequential")) {
                        return false;
                    }
                    if (name.equals("parallel")) {
                        return true;
                    }
                    if (!(qualifier instanceof PsiMethodCallExpression)) {
                        return false;
                    }
                    PsiMethodCallExpression qualifierCall = (PsiMethodCallExpression)qualifier;
                    if (PARALLEL_STREAM_SOURCE.test(qualifierCall)) {
                        return true;
                    }
                    call = qualifierCall;
                }
                return false;
            }

            private void handleSingleElementStream(PsiMethodCallExpression call) {
                PsiMethodCallExpression subsequentCall = StreamApiUtil.findSubsequentCall((PsiMethodCallExpression)call, CALLS_USELESS_FOR_SINGLE_ELEMENT_STREAM::contains, name -> STANDARD_STREAM_INTERMEDIATE_OPERATIONS.contains(name) && !name.startsWith("flatMap"));
                if (subsequentCall != null) {
                    this.register(subsequentCall, JavaBundle.message((String)"inspection.redundant.stream.optional.call.explanation.at.most.one", (Object[])new Object[0]), new LocalQuickFix[0]);
                    return;
                }
                Predicate<String> standardNoSorted = name -> STANDARD_STREAM_INTERMEDIATE_OPERATIONS.contains(name) && !name.equals("sorted");
                PsiMethodCallExpression parallelCall = StreamApiUtil.findSubsequentCall((PsiMethodCallExpression)call, "parallel"::equals, standardNoSorted);
                if (parallelCall != null) {
                    if (StreamApiUtil.findSubsequentCall((PsiMethodCallExpression)call, STANDARD_STREAM_TERMINAL_OPERATIONS::contains, standardNoSorted) != null) {
                        this.register(parallelCall, JavaBundle.message((String)"inspection.redundant.stream.optional.call.explanation.parallel.single", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }

            private void register(PsiMethodCallExpression call, @Nls String explanation, LocalQuickFix ... additionalFixes) {
                if (additionalFixes == null) {
                    1.$$$reportNull$$$0(1);
                }
                String methodName = Objects.requireNonNull(call.getMethodExpression().getReferenceName());
                String message = explanation != null ? JavaBundle.message((String)"inspection.redundant.stream.optional.call.message.with.explanation", (Object[])new Object[]{methodName, explanation}) : JavaBundle.message((String)"inspection.call.message", (Object[])new Object[]{methodName});
                holder.registerProblem((PsiElement)call, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, RedundantStreamOptionalCallInspection.getRange(call), (LocalQuickFix[])ArrayUtil.prepend((Object)((Object)new RemoveCallFix(methodName)), (Object[])additionalFixes));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "additionalFixes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "register";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static PsiMethodCallExpression findCallThatSpoilsSorting(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            RedundantStreamOptionalCallInspection.$$$reportNull$$$0(3);
        }
        PsiMethodCallExpression furtherCall = call;
        while ((furtherCall = StreamApiUtil.findSubsequentCall((PsiMethodCallExpression)furtherCall, o -> CALLS_MAKING_SORT_USELESS.contains(o) || CALLS_MAKING_SORT_USELESS_PARALLEL.containsKey(o), UNORDERED_COLLECTOR, CALLS_KEEPING_SORT_ORDER::contains)) != null && "sorted".equals(furtherCall.getMethodExpression().getReferenceName()) && !RedundantStreamOptionalCallInspection.sortingCancelsPreviousSorting(call, furtherCall)) {
        }
        return furtherCall;
    }

    private static boolean sortingCancelsPreviousSorting(PsiMethodCallExpression call, PsiMethodCallExpression furtherCall) {
        PsiExpression comparator = RedundantStreamOptionalCallInspection.skipReversed((PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions()));
        PsiExpression nextComparator = RedundantStreamOptionalCallInspection.skipReversed((PsiExpression)ArrayUtil.getFirstElement((Object[])furtherCall.getArgumentList().getExpressions()));
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(comparator, nextComparator)) {
            return true;
        }
        boolean isNatural = comparator == null || NATURAL_OR_REVERSED_COMPARATOR.matches(comparator);
        boolean isNextNatural = nextComparator == null || NATURAL_OR_REVERSED_COMPARATOR.matches(nextComparator);
        return isNatural && isNextNatural;
    }

    private static PsiExpression skipReversed(PsiExpression comparator) {
        comparator = PsiUtil.skipParenthesizedExprDown((PsiExpression)comparator);
        while (comparator instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)comparator;
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (!COMPARATOR_REVERSE.test(call) || qualifier == null) break;
            comparator = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier);
        }
        return comparator;
    }

    static boolean isUnorderedToCollection(PsiMethodCallExpression call) {
        if (!COLLECTOR_TO_COLLECTION.test(call)) {
            return false;
        }
        PsiClass aClass = FunctionalExpressionUtils.getClassOfDefaultConstructorFunction((PsiExpression)call.getArgumentList().getExpressions()[0]);
        return aClass != null && "java.util.HashSet".equals(aClass.getQualifiedName());
    }

    static boolean isToCollectionSet(PsiMethodCallExpression call) {
        if (!COLLECTOR_TO_COLLECTION.test(call)) {
            return false;
        }
        PsiClass aClass = FunctionalExpressionUtils.getClassOfDefaultConstructorFunction((PsiExpression)call.getArgumentList().getExpressions()[0]);
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Set");
    }

    @NotNull
    static TextRange getRange(PsiMethodCallExpression call) {
        PsiReferenceExpression expression = call.getMethodExpression();
        PsiElement nameElement = expression.getReferenceNameElement();
        LOG.assertTrue(nameElement != null);
        return new TextRange(nameElement.getStartOffsetInParent(), call.getTextLength());
    }

    static boolean isIdentityMapping(PsiExpression expression, boolean allowBoxUnbox) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiMethodCallExpression && MethodCallUtils.isCallToStaticMethod((PsiMethodCallExpression)((PsiMethodCallExpression)expression), (String)"java.util.function.Function", (String)"identity", (int)0)) {
            return true;
        }
        if (expression instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)expression;
            PsiType functionalInterfaceType = lambda.getFunctionalInterfaceType();
            PsiParameterList parameterList = lambda.getParameterList();
            if (functionalInterfaceType != null && parameterList.getParametersCount() == 1) {
                PsiType functionalInterfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
                PsiParameter parameter = parameterList.getParameter(0);
                assert (parameter != null);
                PsiType parameterType = parameter.getType();
                if (functionalInterfaceReturnType != null) {
                    Nullability returnTypeNullability = functionalInterfaceReturnType.getNullability().nullability();
                    Nullability parameterNullability = parameterType.getNullability().nullability();
                    if (!returnTypeNullability.equals((Object)Nullability.UNKNOWN) && !returnTypeNullability.equals((Object)parameterNullability)) {
                        return false;
                    }
                }
            }
            if (LambdaUtil.isIdentityLambda((PsiLambdaExpression)lambda)) {
                return true;
            }
            if (!allowBoxUnbox) {
                return false;
            }
            PsiExpression body = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody());
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length != 1) {
                return false;
            }
            PsiParameter parameter = parameters[0];
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)body), PsiMethodCallExpression.class);
            if (call == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null || !BOX_UNBOX_NAMES.contains(referenceName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (ExpressionUtils.isReferenceTo((PsiExpression)qualifier, (PsiVariable)parameter) && args.length > 0) {
                return false;
            }
            if (args.length != 1 || !ExpressionUtils.isReferenceTo((PsiExpression)args[0], (PsiVariable)parameter)) {
                return false;
            }
            return RedundantStreamOptionalCallInspection.isBoxUnboxMethod(call.resolveMethod());
        }
        if (!allowBoxUnbox || !(expression instanceof PsiMethodReferenceExpression)) {
            return false;
        }
        PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression;
        String referenceName = methodRef.getReferenceName();
        if (referenceName == null || !BOX_UNBOX_NAMES.contains(referenceName)) {
            return false;
        }
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
        return RedundantStreamOptionalCallInspection.isBoxUnboxMethod(method);
    }

    @Contract(value="null -> false")
    private static boolean isBoxUnboxMethod(PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        PsiType primitiveCandidate = null;
        PsiParameterList list = method.getParameterList();
        if (list.isEmpty()) {
            primitiveCandidate = method.getReturnType();
        } else if (list.getParametersCount() == 1) {
            primitiveCandidate = list.getParameters()[0].getType();
        }
        if (!(primitiveCandidate instanceof PsiPrimitiveType)) {
            return false;
        }
        return Objects.equals(((PsiPrimitiveType)primitiveCandidate).getBoxedTypeName(), aClass.getQualifiedName());
    }

    static boolean isTruePredicate(PsiExpression expression) {
        PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression), PsiLambdaExpression.class);
        if (lambda != null) {
            PsiExpression body = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody());
            return ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)body), (Object)Boolean.TRUE);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCallThatSpoilsSorting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class CollectToOrderedSetFix
    extends PsiUpdateModCommandQuickFix {
        private CollectToOrderedSetFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.redundant.stream.optional.call.fix.collect.to.ordered.family.name", (Object[])new Object[0]);
            if (string == null) {
                CollectToOrderedSetFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression sortCall;
            if (project == null) {
                CollectToOrderedSetFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                CollectToOrderedSetFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                CollectToOrderedSetFix.$$$reportNull$$$0(3);
            }
            if ((sortCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element, PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiMethodCallExpression collector = StreamApiUtil.findSubsequentCall((PsiMethodCallExpression)sortCall, c -> false, UNORDERED_COLLECTOR, CALLS_KEEPING_SORT_ORDER::contains);
            if (collector == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String replacementText = "java.util.stream.Collectors.toCollection(java.util.LinkedHashSet::new)";
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)collector, replacementText);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$CollectToOrderedSetFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$CollectToOrderedSetFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class ReplaceTerminalCallFix
    extends PsiUpdateModCommandQuickFix
    implements HighPriorityAction {
        private final String myNewName;

        private ReplaceTerminalCallFix(String newName) {
            this.myNewName = newName;
        }

        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.redundant.stream.optional.call.fix.replace.terminal.text", (Object[])new Object[]{this.myNewName});
            if (string == null) {
                ReplaceTerminalCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.redundant.stream.optional.call.fix.replace.terminal", (Object[])new Object[0]);
            if (string == null) {
                ReplaceTerminalCallFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceTerminalCallFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceTerminalCallFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceTerminalCallFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)element;
            PsiMethodCallExpression furtherCall = RedundantStreamOptionalCallInspection.findCallThatSpoilsSorting(call);
            if (furtherCall == null) {
                return;
            }
            String name = furtherCall.getMethodExpression().getReferenceName();
            if (name == null || !this.myNewName.equals(CALLS_MAKING_SORT_USELESS_PARALLEL.get(name))) {
                return;
            }
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)furtherCall, (String)this.myNewName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$ReplaceTerminalCallFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$ReplaceTerminalCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    static class RemoveCallFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final String myMethodName;
        @Nullable
        private final String myBindPreviousCall;

        RemoveCallFix(@NotNull String methodName) {
            if (methodName == null) {
                RemoveCallFix.$$$reportNull$$$0(0);
            }
            this(methodName, null);
        }

        RemoveCallFix(@NotNull String methodName, @Nullable String bindPreviousCall) {
            if (methodName == null) {
                RemoveCallFix.$$$reportNull$$$0(1);
            }
            this.myMethodName = methodName;
            this.myBindPreviousCall = bindPreviousCall;
        }

        @Nls
        @NotNull
        public String getName() {
            if (this.myBindPreviousCall != null) {
                String string = JavaBundle.message((String)"inspection.redundant.stream.optional.call.fix.bind.name", (Object[])new Object[]{this.myMethodName, this.myBindPreviousCall});
                if (string == null) {
                    RemoveCallFix.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = JavaBundle.message((String)"inspection.redundant.stream.optional.call.fix.name", (Object[])new Object[]{this.myMethodName});
            if (string == null) {
                RemoveCallFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.redundant.stream.optional.call.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                RemoveCallFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression call;
            if (project == null) {
                RemoveCallFix.$$$reportNull$$$0(5);
            }
            if (element == null) {
                RemoveCallFix.$$$reportNull$$$0(6);
            }
            if (updater == null) {
                RemoveCallFix.$$$reportNull$$$0(7);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethodCallExpression.class})) == null) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (this.myBindPreviousCall != null) {
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                if (qualifierCall == null) {
                    return;
                }
                ExpressionUtils.bindCallTo((PsiMethodCallExpression)qualifierCall, (String)this.myMethodName);
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$RemoveCallFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/RedundantStreamOptionalCallInspection$RemoveCallFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

