/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplaceNullCheckInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final EquivalenceChecker ourEquivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
    private static final int MINIMAL_WARN_DELTA_SIZE = 30;
    private static final CallMatcher STREAM_EMPTY = CallMatcher.staticCall((String)"java.util.stream.Stream", (String[])new String[]{"empty"}).parameterCount(0);
    private static final CallMatcher STREAM_OF = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.util.stream.Stream", (String[])new String[]{"ofNullable"}).parameterCount(1), CallMatcher.staticCall((String)"java.util.stream.Stream", (String[])new String[]{"of"}).parameterTypes(new String[]{"T"})});
    public boolean noWarningReplacementBigger = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"noWarningReplacementBigger", (String)JavaBundle.message((String)"inspection.require.non.null.no.warning.replacement.bigger", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ReplaceNullCheckInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            ReplaceNullCheckInspection.$$$reportNull$$$0(1);
        }
        if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)(file = holder.getFile()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ReplaceNullCheckInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
                NotNullContext context;
                if (ifStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((context = NotNullContext.from(ifStatement)) == null) {
                    return;
                }
                String method = ReplaceNullCheckInspection.getMethodWithClass(context.myExpressionToReplace, context.myIsStream);
                PsiStatement nextToDelete = context.myNextToDelete;
                int maybeImplicitElseLength = nextToDelete != null ? nextToDelete.getTextLength() : 0;
                boolean isInfoLevel = ReplaceNullCheckInspection.this.noWarningReplacementBigger && ifStatement.getTextLength() + maybeImplicitElseLength - context.getLenAfterReplace() < 30;
                ProblemHighlightType highlight = 1.getHighlight(context, isInfoLevel);
                if (!isOnTheFly && highlight == ProblemHighlightType.INFORMATION) {
                    return;
                }
                holder.registerProblem(ifStatement.getFirstChild(), JavaBundle.message((String)"inspection.require.non.null.message", (Object[])new Object[]{1, method}), highlight, new LocalQuickFix[]{new ReplaceWithRequireNonNullFix(method, false)});
            }

            @NotNull
            private static ProblemHighlightType getHighlight(NotNullContext context, boolean isInfoLevel) {
                if (context.myIsStream) {
                    ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    if (problemHighlightType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return problemHighlightType;
                }
                if (isInfoLevel) {
                    ProblemHighlightType problemHighlightType = ProblemHighlightType.INFORMATION;
                    if (problemHighlightType == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return problemHighlightType;
                }
                ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                if (problemHighlightType == null) {
                    1.$$$reportNull$$$0(3);
                }
                return problemHighlightType;
            }

            public void visitConditionalExpression(@NotNull PsiConditionalExpression ternary) {
                ProblemHighlightType highlightType;
                TernaryNotNullContext context;
                if (ternary == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((context = TernaryNotNullContext.from(ternary)) == null) {
                    return;
                }
                String method = ReplaceNullCheckInspection.getMethodWithClass(context.myNullExpr, false);
                String name = context.myReferenceExpression.getText();
                boolean replacementShorter = name != null && context.myNullExpr.getTextLength() + method.length() + name.length() < context.myTernary.getTextLength() + 30;
                boolean isInfoLevel = ReplaceNullCheckInspection.this.noWarningReplacementBigger && replacementShorter;
                ProblemHighlightType problemHighlightType = highlightType = isInfoLevel ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                if (!isOnTheFly && highlightType == ProblemHighlightType.INFORMATION) {
                    return;
                }
                holder.registerProblem((PsiElement)ternary, JavaBundle.message((String)"inspection.require.non.null.message", (Object[])new Object[]{2, method}), highlightType, new LocalQuickFix[]{new ReplaceWithRequireNonNullFix(method, true)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ifStatement";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/ReplaceNullCheckInspection$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ternary";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/ReplaceNullCheckInspection$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHighlight";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitIfStatement";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitConditionalExpression";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static PsiExpression createRequireExpression(@NotNull CommentTracker tracker, @NotNull PsiExpression expression, @NotNull Project project, @NotNull PsiReferenceExpression nullableReference, @NotNull PsiElement context) {
        if (tracker == null) {
            ReplaceNullCheckInspection.$$$reportNull$$$0(3);
        }
        if (expression == null) {
            ReplaceNullCheckInspection.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ReplaceNullCheckInspection.$$$reportNull$$$0(5);
        }
        if (nullableReference == null) {
            ReplaceNullCheckInspection.$$$reportNull$$$0(6);
        }
        if (context == null) {
            ReplaceNullCheckInspection.$$$reportNull$$$0(7);
        }
        boolean isSimple = ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)expression);
        Object expr = tracker.text((PsiElement)expression);
        if (!isSimple) {
            expr = "()->" + (String)expr;
        }
        String varName = nullableReference.getText();
        String requireCallText = "java.util.Objects." + ReplaceNullCheckInspection.getMethod(expression) + "(" + varName + "," + (String)expr + ")";
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiExpression psiExpression = factory.createExpressionFromText(requireCallText, context);
        if (psiExpression == null) {
            ReplaceNullCheckInspection.$$$reportNull$$$0(8);
        }
        return psiExpression;
    }

    @NotNull
    private static String getMethod(PsiExpression expression) {
        return ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)expression) ? "requireNonNullElse" : "requireNonNullElseGet";
    }

    @NotNull
    private static String getMethodWithClass(PsiExpression expression, boolean isStream) {
        Object object = isStream ? "Stream.ofNullable" : "Objects." + ReplaceNullCheckInspection.getMethod(expression);
        if (object == null) {
            ReplaceNullCheckInspection.$$$reportNull$$$0(9);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ReplaceNullCheckInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullableReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ReplaceNullCheckInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequireExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodWithClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRequireExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static final class TopmostQualifierDiff {
        @Nullable
        private final PsiExpression myLeft;
        @Nullable
        private final PsiExpression myRight;

        private TopmostQualifierDiff(@Nullable PsiExpression left, @Nullable PsiExpression right) {
            this.myLeft = left;
            this.myRight = right;
        }

        @Nullable
        public PsiExpression getRight() {
            return this.myRight;
        }

        @Nullable
        public PsiExpression getLeft() {
            return this.myLeft;
        }

        @Nullable
        static TopmostQualifierDiff from(@Nullable PsiExpression left, @Nullable PsiExpression right) {
            PsiExpression rightQualifier;
            PsiExpression leftQualifier;
            PsiMethodCallExpression leftCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)left, PsiMethodCallExpression.class);
            PsiMethodCallExpression rightCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)right, PsiMethodCallExpression.class);
            if (leftCall == null || rightCall == null) {
                return null;
            }
            do {
                PsiExpression[] rightExpressions;
                PsiReferenceExpression leftMethodExpression = leftCall.getMethodExpression();
                PsiReferenceExpression rightMethodExpression = rightCall.getMethodExpression();
                if (ObjectUtils.tryCast((Object)leftMethodExpression.resolve(), PsiMethod.class) != ObjectUtils.tryCast((Object)rightMethodExpression.resolve(), PsiMethod.class)) {
                    return null;
                }
                PsiExpression[] leftExpressions = leftCall.getArgumentList().getExpressions();
                int length = leftExpressions.length;
                if (length != (rightExpressions = rightCall.getArgumentList().getExpressions()).length) {
                    return null;
                }
                for (int i = 0; i < length; ++i) {
                    if (ourEquivalence.expressionsAreEquivalent(leftExpressions[i], rightExpressions[i])) continue;
                    return null;
                }
                leftQualifier = leftMethodExpression.getQualifierExpression();
                leftCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)leftQualifier, PsiMethodCallExpression.class);
                rightQualifier = rightMethodExpression.getQualifierExpression();
                rightCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)rightQualifier, PsiMethodCallExpression.class);
            } while (leftCall != null && rightCall != null);
            return new TopmostQualifierDiff(leftQualifier, rightQualifier);
        }
    }

    private static final class TernaryNotNullContext {
        @NotNull
        private final PsiConditionalExpression myTernary;
        @NotNull
        private final PsiExpression myNullExpr;
        @NotNull
        private final PsiReferenceExpression myReferenceExpression;

        private TernaryNotNullContext(@NotNull PsiConditionalExpression ternary, @NotNull PsiExpression nullExpr, @NotNull PsiReferenceExpression expression) {
            if (ternary == null) {
                TernaryNotNullContext.$$$reportNull$$$0(0);
            }
            if (nullExpr == null) {
                TernaryNotNullContext.$$$reportNull$$$0(1);
            }
            if (expression == null) {
                TernaryNotNullContext.$$$reportNull$$$0(2);
            }
            this.myTernary = ternary;
            this.myNullExpr = nullExpr;
            this.myReferenceExpression = expression;
        }

        @Nullable
        static TernaryNotNullContext from(@NotNull PsiConditionalExpression ternary) {
            PsiExpression nonNullBranch;
            PsiExpression nullBranch;
            PsiBinaryExpression binOp;
            if (ternary == null) {
                TernaryNotNullContext.$$$reportNull$$$0(3);
            }
            if ((binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)ternary.getCondition()), PsiBinaryExpression.class)) == null) {
                return null;
            }
            PsiExpression value = ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)binOp);
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)value), PsiReferenceExpression.class);
            if (referenceExpression == null) {
                return null;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiVariable.class);
            if (variable == null) {
                return null;
            }
            boolean negated = binOp.getOperationTokenType() == JavaTokenType.NE;
            PsiExpression psiExpression = nullBranch = negated ? ternary.getElseExpression() : ternary.getThenExpression();
            if (ClassUtils.isPrimitive((PsiType)variable.getType())) {
                return null;
            }
            PsiExpression psiExpression2 = nonNullBranch = negated ? ternary.getThenExpression() : ternary.getElseExpression();
            if (!ExpressionUtils.isReferenceTo((PsiExpression)nonNullBranch, (PsiVariable)variable)) {
                return null;
            }
            if (NullabilityUtil.getExpressionNullability((PsiExpression)nullBranch, (boolean)true) != Nullability.NOT_NULL) {
                return null;
            }
            if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)nullBranch)) {
                return null;
            }
            return new TernaryNotNullContext(ternary, nullBranch, referenceExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ternary";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullExpr";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ReplaceNullCheckInspection$TernaryNotNullContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class NotNullContext {
        @NotNull
        private final PsiExpression myExpressionToReplace;
        @NotNull
        private final PsiExpression myDiff;
        @NotNull
        private final PsiStatement myNullBranchStmt;
        @NotNull
        private final PsiReferenceExpression myReference;
        @NotNull
        private final PsiIfStatement myIfStatement;
        @Nullable
        private final PsiStatement myNextToDelete;
        private final boolean myIsStream;

        private NotNullContext(@NotNull PsiExpression expressionToReplace, @NotNull PsiExpression diff, @NotNull PsiStatement nullBranchStmt, @NotNull PsiReferenceExpression reference, @NotNull PsiIfStatement statement, @Nullable PsiStatement nextToDelete, boolean isStream) {
            if (expressionToReplace == null) {
                NotNullContext.$$$reportNull$$$0(0);
            }
            if (diff == null) {
                NotNullContext.$$$reportNull$$$0(1);
            }
            if (nullBranchStmt == null) {
                NotNullContext.$$$reportNull$$$0(2);
            }
            if (reference == null) {
                NotNullContext.$$$reportNull$$$0(3);
            }
            if (statement == null) {
                NotNullContext.$$$reportNull$$$0(4);
            }
            this.myExpressionToReplace = expressionToReplace;
            this.myDiff = diff;
            this.myNullBranchStmt = nullBranchStmt;
            this.myReference = reference;
            this.myIfStatement = statement;
            this.myNextToDelete = nextToDelete;
            this.myIsStream = isStream;
        }

        int getLenAfterReplace() {
            int lengthAfterReplace = this.myExpressionToReplace.getTextLength() + ReplaceNullCheckInspection.getMethodWithClass(this.myExpressionToReplace, this.myIsStream).length();
            if (!this.myIsStream) {
                lengthAfterReplace += this.myNullBranchStmt.getTextLength() + 6;
            }
            return lengthAfterReplace;
        }

        @Nullable
        static NotNullContext from(@NotNull PsiIfStatement ifStatement) {
            PsiExpression condition;
            if (ifStatement == null) {
                NotNullContext.$$$reportNull$$$0(5);
            }
            if ((condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)ifStatement.getCondition())) == null) {
                return null;
            }
            PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)condition, PsiBinaryExpression.class);
            if (binOp == null) {
                return null;
            }
            PsiExpression value = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)binOp));
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)value, PsiReferenceExpression.class);
            if (referenceExpression == null) {
                return null;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiVariable.class);
            if (variable == null) {
                return null;
            }
            if (ClassUtils.isPrimitive((PsiType)variable.getType())) {
                return null;
            }
            boolean inverted = binOp.getOperationTokenType() == JavaTokenType.NE;
            PsiStatement elseBranch = ControlFlowUtils.stripBraces((PsiStatement)ifStatement.getElseBranch());
            PsiStatement thenBranch = ControlFlowUtils.stripBraces((PsiStatement)ifStatement.getThenBranch());
            if (elseBranch != null) {
                PsiStatement nullBranch = inverted ? thenBranch : elseBranch;
                PsiStatement nonNullBranch = inverted ? elseBranch : thenBranch;
                return NotNullContext.extractContext(ifStatement, variable, referenceExpression, nullBranch, nonNullBranch, null);
            }
            PsiReturnStatement nextReturn = (PsiReturnStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ifStatement), PsiReturnStatement.class);
            if (nextReturn == null) {
                return null;
            }
            if (thenBranch instanceof PsiReturnStatement) {
                PsiStatement nullBranch = inverted ? thenBranch : nextReturn;
                PsiReturnStatement nonNullBranch = inverted ? nextReturn : thenBranch;
                return NotNullContext.extractContext(ifStatement, variable, referenceExpression, nullBranch, (PsiStatement)nonNullBranch, nextReturn);
            }
            return null;
        }

        @Contract(value="_, _, _, null, _, _ -> null")
        private static NotNullContext extractContext(@NotNull PsiIfStatement ifStatement, @NotNull PsiVariable variable, @NotNull PsiReferenceExpression reference, @Nullable PsiStatement nullBranch, @Nullable PsiStatement nonNullBranch, @Nullable PsiReturnStatement toDelete) {
            if (ifStatement == null) {
                NotNullContext.$$$reportNull$$$0(6);
            }
            if (variable == null) {
                NotNullContext.$$$reportNull$$$0(7);
            }
            if (reference == null) {
                NotNullContext.$$$reportNull$$$0(8);
            }
            if (nullBranch == null) {
                return null;
            }
            EquivalenceChecker.Match match = ourEquivalence.statementsMatch(nullBranch, nonNullBranch);
            PsiExpression nullDiff = (PsiExpression)ObjectUtils.tryCast((Object)match.getLeftDiff(), PsiExpression.class);
            PsiExpression nonNullDiff = (PsiExpression)ObjectUtils.tryCast((Object)match.getRightDiff(), PsiExpression.class);
            if (!ExpressionUtils.isReferenceTo((PsiExpression)nullDiff, (PsiVariable)variable)) {
                TopmostQualifierDiff qualifierDiff = TopmostQualifierDiff.from(nullDiff, nonNullDiff);
                if (qualifierDiff == null) {
                    PsiMethodCallExpression nullCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)nullDiff, PsiMethodCallExpression.class);
                    PsiMethodCallExpression nonNullCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)nonNullDiff, PsiMethodCallExpression.class);
                    if (nullCall == null || nonNullCall == null) {
                        return null;
                    }
                    if (!STREAM_EMPTY.test(nonNullCall) || !STREAM_OF.test(nullCall)) {
                        return null;
                    }
                    PsiExpression maybeRef = nullCall.getArgumentList().getExpressions()[0];
                    if (!ExpressionUtils.isReferenceTo((PsiExpression)maybeRef, (PsiVariable)variable)) {
                        return null;
                    }
                    return new NotNullContext((PsiExpression)nullCall, maybeRef, nullBranch, reference, ifStatement, null, true);
                }
                nullDiff = qualifierDiff.getLeft();
                nonNullDiff = qualifierDiff.getRight();
                if (!ExpressionUtils.isReferenceTo((PsiExpression)nullDiff, (PsiVariable)variable)) {
                    return null;
                }
            }
            if (NullabilityUtil.getExpressionNullability((PsiExpression)nonNullDiff, (boolean)true) != Nullability.NOT_NULL) {
                return null;
            }
            if (nonNullDiff instanceof PsiSuperExpression) {
                return null;
            }
            if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)nonNullDiff)) {
                return null;
            }
            return new NotNullContext(nonNullDiff, nullDiff, nullBranch, reference, ifStatement, (PsiStatement)toDelete, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionToReplace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diff";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullBranchStmt";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ReplaceNullCheckInspection$NotNullContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extractContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ReplaceWithRequireNonNullFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final String myMethod;
        private final boolean myIsTernary;

        private ReplaceWithRequireNonNullFix(@NotNull String method, boolean ternary) {
            if (method == null) {
                ReplaceWithRequireNonNullFix.$$$reportNull$$$0(0);
            }
            this.myMethod = method;
            this.myIsTernary = ternary;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.require.non.null.quickfix", (Object[])new Object[]{this.myIsTernary ? 2 : 1, this.myMethod});
            if (string == null) {
                ReplaceWithRequireNonNullFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.require.non.null", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithRequireNonNullFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiElement result;
            PsiElement element;
            if (project == null) {
                ReplaceWithRequireNonNullFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ReplaceWithRequireNonNullFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                ReplaceWithRequireNonNullFix.$$$reportNull$$$0(5);
            }
            PsiElement psiElement = element = this.myIsTernary ? startElement : startElement.getParent();
            if (element instanceof PsiIfStatement) {
                NotNullContext context = NotNullContext.from((PsiIfStatement)element);
                if (context == null) {
                    return;
                }
                CommentTracker tracker = new CommentTracker();
                PsiExpression expression = context.myExpressionToReplace;
                if (!context.myIsStream) {
                    PsiExpression requireCall = ReplaceNullCheckInspection.createRequireExpression(tracker, expression, project, context.myReference, (PsiElement)context.myDiff);
                    context.myDiff.replace((PsiElement)requireCall);
                } else {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                    String streamOfNullableText = "java.util.stream.Stream.ofNullable(" + context.myReference.getText() + ")";
                    PsiExpression streamOfNullable = factory.createExpressionFromText(streamOfNullableText, (PsiElement)expression);
                    expression.replace((PsiElement)streamOfNullable);
                }
                result = tracker.replaceAndRestoreComments((PsiElement)context.myIfStatement, (PsiElement)context.myNullBranchStmt);
                if (context.myNextToDelete != null) {
                    context.myNextToDelete.delete();
                }
            } else if (element instanceof PsiConditionalExpression) {
                TernaryNotNullContext context = TernaryNotNullContext.from((PsiConditionalExpression)element);
                if (context == null) {
                    return;
                }
                CommentTracker tracker = new CommentTracker();
                PsiExpression requireCall = ReplaceNullCheckInspection.createRequireExpression(tracker, context.myNullExpr, project, context.myReferenceExpression, (PsiElement)context.myNullExpr);
                result = tracker.replaceAndRestoreComments((PsiElement)context.myTernary, (PsiElement)requireCall);
            } else {
                return;
            }
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
            CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ReplaceNullCheckInspection$ReplaceWithRequireNonNullFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ReplaceNullCheckInspection$ReplaceWithRequireNonNullFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

