/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SlowAbstractSetRemoveAllInspection;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class SlowListContainsAllInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher LIST_CONTAINS_ALL = CallMatcher.instanceCall((String)"java.util.List", (String[])new String[]{"containsAll"}).parameterTypes(new String[]{"java.util.Collection"});

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SlowListContainsAllInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(call);
                if (!LIST_CONTAINS_ALL.test(call)) {
                    return;
                }
                PsiReferenceExpression expression = call.getMethodExpression();
                PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)expression);
                if (qualifier == null) {
                    return;
                }
                LongRangeSet listSizeRange = SlowAbstractSetRemoveAllInspection.getSizeRangeOfCollection(qualifier);
                if (listSizeRange.isEmpty() || listSizeRange.max() <= 5L || TestUtils.isInTestCode((PsiElement)call)) {
                    return;
                }
                holder.registerProblem((PsiElement)call, JavaBundle.message((String)"inspection.slow.list.contains.all.description", (Object[])new Object[0]), ProblemHighlightType.WARNING, expression.getTextRangeInParent(), new LocalQuickFix[]{new ReplaceWithHashSetContainsAllFix(qualifier.getText())});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/SlowListContainsAllInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SlowListContainsAllInspection", "buildVisitor"));
    }

    private static class ReplaceWithHashSetContainsAllFix
    extends PsiUpdateModCommandQuickFix {
        private final String myCollectionText;

        ReplaceWithHashSetContainsAllFix(String collectionText) {
            this.myCollectionText = collectionText;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = JavaBundle.message((String)"inspection.slow.list.contains.all.fix.name", (Object[])new Object[]{this.myCollectionText});
            if (string == null) {
                ReplaceWithHashSetContainsAllFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.slow.list.contains.all.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithHashSetContainsAllFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression call;
            if (project == null) {
                ReplaceWithHashSetContainsAllFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceWithHashSetContainsAllFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithHashSetContainsAllFix.$$$reportNull$$$0(4);
            }
            if ((call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element, PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiExpression strippedQualifier = PsiUtil.deparenthesizeExpression((PsiExpression)qualifier);
            if (strippedQualifier == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiElement result = ct.replace((PsiElement)qualifier, "new java.util.HashSet<>(" + ct.text((PsiElement)strippedQualifier) + ")");
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SlowListContainsAllInspection$ReplaceWithHashSetContainsAllFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SlowListContainsAllInspection$ReplaceWithHashSetContainsAllFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

