/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ipp.psiutils.ErrorUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringRepeatCanBeUsedInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher APPEND = CallMatcher.instanceCall((String)"java.lang.AbstractStringBuilder", (String[])new String[]{"append"}).parameterCount(1);
    private static final CallMatcher REPEAT = CallMatcher.instanceCall((String)"java.lang.String", (String[])new String[]{"repeat"}).parameterCount(1);
    public boolean ADD_MATH_MAX = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ADD_MATH_MAX", (String)JavaBundle.message((String)"label.add.math.max.0.count.to.avoid.possible.semantics.change", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            StringRepeatCanBeUsedInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        LanguageLevel languageLevel;
        if (holder == null) {
            StringRepeatCanBeUsedInspection.$$$reportNull$$$0(1);
        }
        if (!(languageLevel = PsiUtil.getLanguageLevel((PsiElement)holder.getFile())).isAtLeast(LanguageLevel.JDK_11)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                StringRepeatCanBeUsedInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitForStatement(@NotNull PsiForStatement statement) {
                PsiMethodCallExpression call;
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((call = StringRepeatCanBeUsedInspection.findAppendCall(statement)) == null) {
                    return;
                }
                if (ErrorUtil.containsDeepError((PsiElement)call)) {
                    return;
                }
                PsiReferenceExpression qualifier = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression()), PsiReferenceExpression.class);
                if (qualifier == null || !ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)qualifier)) {
                    return;
                }
                CountingLoop loop = CountingLoop.from((PsiForStatement)statement);
                if (loop == null) {
                    return;
                }
                PsiLocalVariable var = loop.getCounter();
                if (var.getType().equals(PsiTypes.longType()) || VariableAccessUtils.variableIsUsed((PsiVariable)var, (PsiElement)call)) {
                    return;
                }
                PsiExpression arg = call.getArgumentList().getExpressions()[0];
                if (SideEffectChecker.mayHaveSideEffects((PsiExpression)arg)) {
                    return;
                }
                if (languageLevel.isAtLeast(LanguageLevel.JDK_21)) {
                    PsiType type = qualifier.getType();
                    if (type == null) {
                        return;
                    }
                    String builderClassName = type.getPresentableText();
                    holder.registerProblem(statement.getFirstChild(), 1.messageForCanBeReplacedWithBuilderRepeat(builderClassName), new LocalQuickFix[]{new ConvertForLoopToStringBuilderRepeatFix(StringRepeatCanBeUsedInspection.this.ADD_MATH_MAX, builderClassName)});
                } else {
                    holder.registerProblem(statement.getFirstChild(), JavaBundle.message((String)"inspection.message.can.be.replaced.with.string.repeat", (Object[])new Object[0]), new LocalQuickFix[]{new ConvertForLoopToStringRepeatFix(StringRepeatCanBeUsedInspection.this.ADD_MATH_MAX)});
                }
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!languageLevel.isAtLeast(LanguageLevel.JDK_21)) {
                    return;
                }
                if (!APPEND.test(call)) {
                    return;
                }
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (args.length != 1) {
                    return;
                }
                PsiMethodCallExpression repeatCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiMethodCallExpression.class);
                if (repeatCall == null) {
                    return;
                }
                if (!REPEAT.test(repeatCall)) {
                    return;
                }
                if (ErrorUtil.containsDeepError((PsiElement)call)) {
                    return;
                }
                PsiType type = qualifier.getType();
                if (type == null) {
                    return;
                }
                String builderClassName = type.getPresentableText();
                PsiElement reference = call.getMethodExpression().getReferenceNameElement();
                if (reference == null) {
                    return;
                }
                holder.registerProblem(reference, 1.messageForCanBeReplacedWithBuilderRepeat(builderClassName), new LocalQuickFix[]{new ConvertStringRepeatToStringBuilderRepeatFix(builderClassName)});
            }

            @Nls
            @NotNull
            private static String messageForCanBeReplacedWithBuilderRepeat(String builderClassName) {
                String string = JavaBundle.message((String)"inspection.message.can.be.replaced.with.builder.repeat", (Object[])new Object[]{builderClassName + ".repeat()"});
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/StringRepeatCanBeUsedInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/StringRepeatCanBeUsedInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "messageForCanBeReplacedWithBuilderRepeat";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitForStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Nullable
    private static PsiMethodCallExpression findAppendCall(PsiForStatement statement) {
        PsiExpressionStatement body = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces((PsiStatement)statement.getBody()), PsiExpressionStatement.class);
        if (body == null) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)body.getExpression(), PsiMethodCallExpression.class);
        if (!APPEND.test(call)) {
            return null;
        }
        return call;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/StringRepeatCanBeUsedInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/StringRepeatCanBeUsedInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class ConvertStringRepeatToStringBuilderRepeatFix
    extends PsiUpdateModCommandQuickFix {
        private final String builderClassShortName;

        private ConvertStringRepeatToStringBuilderRepeatFix(String builderClassShortName) {
            this.builderClassShortName = builderClassShortName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.builderClassShortName + ".repeat()"});
            if (string == null) {
                ConvertStringRepeatToStringBuilderRepeatFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiMethodCallExpression appendCall;
            if (project == null) {
                ConvertStringRepeatToStringBuilderRepeatFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ConvertStringRepeatToStringBuilderRepeatFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ConvertStringRepeatToStringBuilderRepeatFix.$$$reportNull$$$0(3);
            }
            if ((appendCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) == null || !APPEND.test(appendCall)) {
                return;
            }
            if (ErrorUtil.containsDeepError((PsiElement)appendCall)) {
                return;
            }
            PsiExpression qualifierExpression = appendCall.getMethodExpression().getQualifierExpression();
            if (qualifierExpression == null) {
                return;
            }
            PsiExpression[] args = appendCall.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiMethodCallExpression repeatCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiMethodCallExpression.class);
            if (repeatCall == null) {
                return;
            }
            PsiExpression[] repeatArgs = repeatCall.getArgumentList().getExpressions();
            if (repeatArgs.length != 1) {
                return;
            }
            PsiExpression count = repeatArgs[0];
            PsiExpression stringExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)repeatCall.getMethodExpression().getQualifierExpression());
            if (stringExpression == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String replacement = ct.text((PsiElement)qualifierExpression) + ".repeat(" + ConvertStringRepeatToStringBuilderRepeatFix.sanitizedStringExpression(stringExpression, ct) + ", " + ct.text((PsiElement)count) + ")";
            PsiElement replaced = ct.replaceAndRestoreComments((PsiElement)appendCall, replacement);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced);
        }

        private static String sanitizedStringExpression(PsiExpression stringExpression, CommentTracker ct) {
            if (NullabilityUtil.getExpressionNullability((PsiExpression)stringExpression, (boolean)true) == Nullability.NOT_NULL) {
                return ct.text((PsiElement)stringExpression);
            }
            return "java.util.Objects.requireNonNull(" + ct.text((PsiElement)stringExpression) + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/StringRepeatCanBeUsedInspection$ConvertStringRepeatToStringBuilderRepeatFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/StringRepeatCanBeUsedInspection$ConvertStringRepeatToStringBuilderRepeatFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static abstract class ConvertToRepeatFix
    extends PsiUpdateModCommandQuickFix {
        protected final boolean myAddMathMax;

        private ConvertToRepeatFix(boolean addMathMax) {
            this.myAddMathMax = addMathMax;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiExpression to;
            PsiExpression from;
            PsiForStatement forStatement;
            if (project == null) {
                ConvertToRepeatFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ConvertToRepeatFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                ConvertToRepeatFix.$$$reportNull$$$0(2);
            }
            if ((forStatement = (PsiForStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiForStatement.class)) == null) {
                return;
            }
            CountingLoop loop = CountingLoop.from((PsiForStatement)forStatement);
            if (loop == null) {
                return;
            }
            PsiMethodCallExpression appendCall = StringRepeatCanBeUsedInspection.findAppendCall(forStatement);
            if (appendCall == null) {
                return;
            }
            if (ErrorUtil.containsDeepError((PsiElement)appendCall)) {
                return;
            }
            PsiExpression qualifierExpression = appendCall.getMethodExpression().getQualifierExpression();
            if (qualifierExpression == null) {
                return;
            }
            PsiExpression arg = appendCall.getArgumentList().getExpressions()[0];
            if (loop.isDescending()) {
                from = loop.getBound();
                to = loop.getInitializer();
            } else {
                from = loop.getInitializer();
                to = loop.getBound();
            }
            CommentTracker ct = new CommentTracker();
            String repeatedStringExpression = ConvertToRepeatFix.getRepeatedStringExpression(arg, ct);
            Object countText = ConvertToRepeatFix.getCountText(from, to, loop.isIncluding(), ct);
            if (this.myAddMathMax) {
                countText = "java.lang.Math.max(0," + (String)countText + ")";
            }
            this.replaceWithRepeatCall(qualifierExpression, repeatedStringExpression, (String)countText, ct, arg, forStatement, appendCall);
        }

        protected abstract void replaceWithRepeatCall(PsiExpression var1, String var2, String var3, CommentTracker var4, PsiExpression var5, PsiForStatement var6, PsiMethodCallExpression var7);

        protected void simplifyMaxCall(PsiMethodCallExpression maxCall) {
            PsiExpression count = maxCall.getArgumentList().getExpressions()[1];
            LongRangeSet range = CommonDataflow.getExpressionRange((PsiExpression)count);
            if (range != null && !range.isEmpty() && range.min() >= 0L) {
                maxCall.replace((PsiElement)count);
            }
        }

        @NotNull
        private static String getCountText(PsiExpression from, PsiExpression to, boolean including, CommentTracker ct) {
            int origin;
            Object countText = null;
            Number fromNumber = JavaPsiMathUtil.getNumberFromLiteral((PsiExpression)from);
            if (fromNumber instanceof Integer && (origin = fromNumber.intValue()) < Integer.MAX_VALUE) {
                if (including) {
                    --origin;
                }
                countText = JavaPsiMathUtil.add((PsiExpression)to, (int)(-origin), (CommentTracker)ct);
            }
            if (countText == null) {
                countText = ct.text(to, 6) + "-" + ct.text(from, 5);
                if (including) {
                    PsiExpression expr = JavaPsiFacade.getElementFactory((Project)from.getProject()).createExpressionFromText((String)countText, (PsiElement)from);
                    countText = JavaPsiMathUtil.add((PsiExpression)expr, (int)1, (CommentTracker)ct);
                }
            }
            String string = countText;
            if (string == null) {
                ConvertToRepeatFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        private static String getRepeatedStringExpression(PsiExpression arg, CommentTracker ct) {
            boolean isStringType = TypeUtils.isJavaLangString((PsiType)arg.getType());
            if (arg instanceof PsiLiteralExpression) {
                PsiLiteralExpression literal = (PsiLiteralExpression)arg;
                if (!isStringType) {
                    Object value = literal.getValue();
                    if (value instanceof Character) {
                        String string = PsiLiteralUtil.stringForCharLiteral((String)literal.getText());
                        if (string == null) {
                            ConvertToRepeatFix.$$$reportNull$$$0(4);
                        }
                        return string;
                    }
                    String string = StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)String.valueOf(value)));
                    if (string == null) {
                        ConvertToRepeatFix.$$$reportNull$$$0(5);
                    }
                    return string;
                }
            }
            if (isStringType && NullabilityUtil.getExpressionNullability((PsiExpression)arg, (boolean)true) == Nullability.NOT_NULL) {
                String string = ct.text(arg, 1);
                if (string == null) {
                    ConvertToRepeatFix.$$$reportNull$$$0(6);
                }
                return string;
            }
            String string = "java.lang.String.valueOf(" + ct.text((PsiElement)arg) + ")";
            if (string == null) {
                ConvertToRepeatFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/StringRepeatCanBeUsedInspection$ConvertToRepeatFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/StringRepeatCanBeUsedInspection$ConvertToRepeatFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCountText";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRepeatedStringExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ConvertForLoopToStringRepeatFix
    extends ConvertToRepeatFix {
        private ConvertForLoopToStringRepeatFix(boolean addMathMax) {
            super(addMathMax);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"String.repeat()"});
            if (string == null) {
                ConvertForLoopToStringRepeatFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void replaceWithRepeatCall(PsiExpression qualifierExpression, String repeatedStringExpression, String countText, CommentTracker ct, PsiExpression arg, PsiForStatement forStatement, PsiMethodCallExpression call) {
            String replacement = repeatedStringExpression + ".repeat(" + countText + ")";
            ct.replace((PsiElement)arg, replacement);
            PsiExpressionStatement result = (PsiExpressionStatement)ct.replaceAndRestoreComments((PsiElement)forStatement, call.getParent());
            if (this.myAddMathMax) {
                PsiMethodCallExpression appendCall = (PsiMethodCallExpression)result.getExpression();
                PsiMethodCallExpression repeatCall = (PsiMethodCallExpression)appendCall.getArgumentList().getExpressions()[0];
                PsiMethodCallExpression maxCall = (PsiMethodCallExpression)repeatCall.getArgumentList().getExpressions()[0];
                this.simplifyMaxCall(maxCall);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StringRepeatCanBeUsedInspection$ConvertForLoopToStringRepeatFix", "getFamilyName"));
        }
    }

    private static final class ConvertForLoopToStringBuilderRepeatFix
    extends ConvertToRepeatFix {
        private final String builderClassShortName;

        private ConvertForLoopToStringBuilderRepeatFix(boolean addMathMax, String builderClassShortName) {
            super(addMathMax);
            this.builderClassShortName = builderClassShortName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.builderClassShortName + ".repeat()"});
            if (string == null) {
                ConvertForLoopToStringBuilderRepeatFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void replaceWithRepeatCall(PsiExpression qualifierExpression, String repeatedStringExpression, String countText, CommentTracker ct, PsiExpression arg, PsiForStatement forStatement, PsiMethodCallExpression appendCall) {
            String replacement = qualifierExpression.getText() + ".repeat(" + repeatedStringExpression + ", " + countText + ");";
            PsiExpressionStatement result = (PsiExpressionStatement)ct.replaceAndRestoreComments((PsiElement)forStatement, replacement);
            if (this.myAddMathMax) {
                PsiMethodCallExpression repeatCall = (PsiMethodCallExpression)result.getExpression();
                PsiMethodCallExpression maxCall = (PsiMethodCallExpression)repeatCall.getArgumentList().getExpressions()[1];
                this.simplifyMaxCall(maxCall);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StringRepeatCanBeUsedInspection$ConvertForLoopToStringBuilderRepeatFix", "getFamilyName"));
        }
    }
}

