/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiTemplateExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.redundancy.RedundantEmbeddedExpressionInspection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringTemplateMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.STRING_TEMPLATES);
        if (set == null) {
            StringTemplateMigrationInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            StringTemplateMigrationInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (expression.getOperationTokenType() != JavaTokenType.PLUS) {
                    return;
                }
                if (!ExpressionUtils.hasStringType((PsiExpression)expression)) {
                    return;
                }
                ProblemHighlightType type = 1.getProblemHighlightType(expression);
                if (type == null || type == ProblemHighlightType.INFORMATION && !isOnTheFly) {
                    return;
                }
                holder.registerProblem((PsiElement)expression, JavaBundle.message((String)"inspection.string.template.migration.string.message", (Object[])new Object[0]), type, new LocalQuickFix[]{new ReplaceWithStringTemplateFix()});
            }

            @Nullable
            private static ProblemHighlightType getProblemHighlightType(@NotNull PsiPolyadicExpression expression) {
                PsiElement parent;
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression, (Class[])new Class[]{PsiExpression.class})) instanceof PsiNameValuePair || parent instanceof PsiCaseLabelElementList || parent instanceof PsiAnnotationMethod) {
                    return null;
                }
                boolean hasString = false;
                boolean hasNotLiteralExpression = false;
                boolean hasLiteralExpression = false;
                for (PsiExpression operand : expression.getOperands()) {
                    if (operand instanceof PsiTemplateExpression) {
                        return null;
                    }
                    if (operand instanceof PsiLiteralExpression && ExpressionUtils.hasStringType((PsiExpression)operand)) {
                        hasString = true;
                        continue;
                    }
                    if (!1.isOnlyLiterals(operand)) {
                        hasNotLiteralExpression = true;
                        continue;
                    }
                    hasLiteralExpression = true;
                }
                if (hasString && hasNotLiteralExpression) {
                    return ProblemHighlightType.WEAK_WARNING;
                }
                if (hasNotLiteralExpression || hasString && hasLiteralExpression || PsiUtil.isConstantExpression((PsiExpression)expression)) {
                    return ProblemHighlightType.INFORMATION;
                }
                return null;
            }

            private static boolean isOnlyLiterals(@NotNull PsiExpression operand) {
                if (operand == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (operand instanceof PsiLiteralExpression) {
                    return true;
                }
                if (operand instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression polyadic = (PsiPolyadicExpression)operand;
                    for (PsiExpression expression : polyadic.getOperands()) {
                        if (1.isOnlyLiterals(expression)) continue;
                        return false;
                    }
                    return true;
                }
                if (operand instanceof PsiParenthesizedExpression) {
                    PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand);
                    return expression == null || 1.isOnlyLiterals(expression);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operand";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/StringTemplateMigrationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPolyadicExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getProblemHighlightType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isOnlyLiterals";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/StringTemplateMigrationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/StringTemplateMigrationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithStringTemplateFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithStringTemplateFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.replace.with.string.template.fix", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithStringTemplateFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiExpression expression;
            if (project == null) {
                ReplaceWithStringTemplateFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithStringTemplateFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithStringTemplateFix.$$$reportNull$$$0(3);
            }
            if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ObjectUtils.tryCast((Object)element, PsiExpression.class)))) == null) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)expression, PsiPolyadicExpression.class);
            if (polyadicExpression == null || !ExpressionUtils.hasStringType((PsiExpression)polyadicExpression)) {
                return;
            }
            String stringTemplate = ReplaceWithStringTemplateFix.buildReplacementStringTemplate(polyadicExpression);
            if (stringTemplate == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            PsiElement result = tracker.replaceAndRestoreComments((PsiElement)polyadicExpression, stringTemplate);
            result = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
            if (result instanceof PsiTemplateExpression) {
                PsiTemplateExpression template = (PsiTemplateExpression)result;
                ReplaceWithStringTemplateFix.replaceRedundantEmbeddedExpression(template);
            }
        }

        private static String buildReplacementStringTemplate(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                ReplaceWithStringTemplateFix.$$$reportNull$$$0(4);
            }
            StringBuilder content = new StringBuilder();
            boolean isStringFound = false;
            boolean textBlock = ReplaceWithStringTemplateFix.useTextBlockTemplate(expression);
            for (PsiExpression operand : expression.getOperands()) {
                if (!isStringFound && ExpressionUtils.hasStringType((PsiExpression)operand)) {
                    isStringFound = true;
                    if (!content.isEmpty()) {
                        content.insert(0, "\\{").append("}");
                    }
                }
                if (operand instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesized = (PsiParenthesizedExpression)operand;
                    operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)parenthesized);
                }
                if (operand instanceof PsiLiteralExpression) {
                    PsiLiteralExpression literal = (PsiLiteralExpression)operand;
                    Object value = literal.getValue();
                    if (ExpressionUtils.hasStringType((PsiExpression)literal) && value == null) {
                        return null;
                    }
                    if (value instanceof String || value instanceof Character) {
                        String string = String.valueOf(value);
                        String escaped = StringUtil.escapeStringCharacters((String)string);
                        content.append(textBlock ? PsiLiteralUtil.escapeTextBlockCharacters((String)escaped, (boolean)false, (boolean)true, (boolean)false) : escaped);
                        continue;
                    }
                }
                ReplaceWithStringTemplateFix.toTemplateExpression(content, isStringFound, (PsiElement)operand);
            }
            return textBlock ? "java.lang.StringTemplate.STR.\"\"\"\n" + String.valueOf(content) + "\"\"\"" : "java.lang.StringTemplate.STR.\"" + String.valueOf(content) + "\"";
        }

        private static boolean useTextBlockTemplate(PsiPolyadicExpression expression) {
            for (PsiExpression operand : expression.getOperands()) {
                if (!(operand instanceof PsiLiteralExpression)) continue;
                PsiLiteralExpression literal = (PsiLiteralExpression)operand;
                if (!ExpressionUtils.hasStringType((PsiExpression)operand)) continue;
                if (literal.isTextBlock()) {
                    return true;
                }
                String value = (String)literal.getValue();
                if (value == null || !value.contains("\n")) continue;
                return true;
            }
            return false;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private static void replaceRedundantEmbeddedExpression(PsiTemplateExpression template) {
            while (template != null && template.getTemplate() != null) {
                PsiExpression expression;
                @NotNull List expressions = template.getTemplate().getEmbeddedExpressions();
                Iterator iterator = expressions.iterator();
                while (iterator.hasNext() && (!RedundantEmbeddedExpressionInspection.isEmbeddedLiteralRedundant((PsiExpression)(expression = (PsiExpression)iterator.next())) || (template = RedundantEmbeddedExpressionInspection.inlineEmbeddedExpression((PsiExpression)expression)) == null)) {
                    template = null;
                }
            }
        }

        private static void toTemplateExpression(@NotNull StringBuilder result, boolean isEmbeddedExpression, @NotNull PsiElement element) {
            if (result == null) {
                ReplaceWithStringTemplateFix.$$$reportNull$$$0(5);
            }
            if (element == null) {
                ReplaceWithStringTemplateFix.$$$reportNull$$$0(6);
            }
            if (isEmbeddedExpression || result.isEmpty()) {
                if (isEmbeddedExpression) {
                    result.append("\\{").append(element.getText()).append("}");
                } else {
                    result.append(element.getText());
                }
            } else {
                result.append("+").append(element.getText());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/StringTemplateMigrationInspection$ReplaceWithStringTemplateFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/StringTemplateMigrationInspection$ReplaceWithStringTemplateFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "buildReplacementStringTemplate";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "toTemplateExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

