/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextBlockMigrationInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean mySuggestLiteralReplacement = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"mySuggestLiteralReplacement", (String)JavaBundle.message((String)"inspection.text.block.migration.suggest.literal.replacement", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            TextBlockMigrationInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.TEXT_BLOCKS);
        if (set == null) {
            TextBlockMigrationInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            TextBlockMigrationInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
                boolean reportWarning;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ExpressionUtils.hasStringType((PsiExpression)expression)) {
                    return;
                }
                int nNewLines = 0;
                TextRange firstNewLineTextRange = null;
                for (PsiExpression operand : expression.getOperands()) {
                    String text;
                    int newLineIdx;
                    PsiLiteralExpression literal = TextBlockMigrationInspection.getLiteralExpression(operand);
                    if (literal == null) {
                        return;
                    }
                    if (nNewLines > 1 || (newLineIdx = TextBlockMigrationInspection.getNewLineIndex(text = literal.getText(), 0)) == -1) continue;
                    if (firstNewLineTextRange == null) {
                        int operandOffset = literal.getTextOffset() - expression.getTextOffset();
                        firstNewLineTextRange = new TextRange(operandOffset + newLineIdx, operandOffset + newLineIdx + 2);
                    }
                    while (nNewLines <= 1 && newLineIdx != -1) {
                        ++nNewLines;
                        newLineIdx = TextBlockMigrationInspection.getNewLineIndex(text, newLineIdx + 1);
                    }
                }
                boolean hasComments = ContainerUtil.exists((Object[])expression.getChildren(), child -> child instanceof PsiComment);
                boolean bl = reportWarning = nNewLines > 1 && !hasComments;
                if (reportWarning) {
                    boolean quickFixOnly = isOnTheFly && InspectionProjectProfileManager.isInformationLevel((String)TextBlockMigrationInspection.this.getShortName(), (PsiElement)expression);
                    holder.registerProblem((PsiElement)expression, quickFixOnly ? null : firstNewLineTextRange, JavaBundle.message((String)"inspection.text.block.migration.concatenation.message", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithTextBlockFix()});
                } else if (isOnTheFly) {
                    holder.registerProblem((PsiElement)expression, JavaBundle.message((String)"inspection.text.block.migration.string.message", (Object[])new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new ReplaceWithTextBlockFix()});
                }
            }

            public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent()) instanceof PsiPolyadicExpression) {
                    return;
                }
                if (!ExpressionUtils.hasStringType((PsiExpression)expression) || expression.isTextBlock()) {
                    return;
                }
                String text = expression.getText();
                int newLineIdx = TextBlockMigrationInspection.getNewLineIndex(text, 0);
                if (TextBlockMigrationInspection.this.mySuggestLiteralReplacement && newLineIdx != -1 && TextBlockMigrationInspection.getNewLineIndex(text, newLineIdx + 1) != -1) {
                    boolean quickFixOnly = isOnTheFly && InspectionProjectProfileManager.isInformationLevel((String)TextBlockMigrationInspection.this.getShortName(), (PsiElement)expression);
                    holder.registerProblem((PsiElement)expression, quickFixOnly ? null : new TextRange(newLineIdx, newLineIdx + 2), JavaBundle.message((String)"inspection.text.block.migration.string.message", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithTextBlockFix()});
                } else if (isOnTheFly) {
                    holder.registerProblem((PsiElement)expression, JavaBundle.message((String)"inspection.text.block.migration.string.message", (Object[])new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new ReplaceWithTextBlockFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "expression";
                objectArray2[1] = "com/intellij/codeInspection/TextBlockMigrationInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPolyadicExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLiteralExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static int getNewLineIndex(@NotNull String text, int start) {
        if (text == null) {
            TextBlockMigrationInspection.$$$reportNull$$$0(3);
        }
        return TextBlockMigrationInspection.getEscapedCharIndex(text, start, 'n');
    }

    private static int getEscapedCharIndex(@NotNull String text, int start, char escapedChar) {
        if (text == null) {
            TextBlockMigrationInspection.$$$reportNull$$$0(4);
        }
        int i = start;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\\') {
                if (i + 1 < text.length() && text.charAt(i + 1) == escapedChar) {
                    return i;
                }
                i += 2;
                continue;
            }
            ++i;
        }
        return -1;
    }

    @Nullable
    private static PsiLiteralExpression getLiteralExpression(@NotNull PsiExpression expression) {
        PsiLiteralExpression literal;
        if (expression == null) {
            TextBlockMigrationInspection.$$$reportNull$$$0(5);
        }
        return (literal = (PsiLiteralExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression), PsiLiteralExpression.class)) == null || literal.isTextBlock() ? null : literal;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/TextBlockMigrationInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/TextBlockMigrationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNewLineIndex";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEscapedCharIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithTextBlockFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithTextBlockFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.replace.with.text.block.fix", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithTextBlockFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiPolyadicExpression polyadicExpression;
            PsiExpression expression;
            if (project == null) {
                ReplaceWithTextBlockFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithTextBlockFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithTextBlockFix.$$$reportNull$$$0(3);
            }
            if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ObjectUtils.tryCast((Object)element, PsiExpression.class)))) == null) {
                return;
            }
            Document document = expression.getContainingFile().getViewProvider().getDocument();
            if (document == null) {
                return;
            }
            if (expression instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
                ReplaceWithTextBlockFix.replaceWithTextBlock((PsiExpression)literalExpression, new PsiExpression[]{literalExpression});
            } else if (expression instanceof PsiPolyadicExpression && ExpressionUtils.hasStringType((PsiExpression)(polyadicExpression = (PsiPolyadicExpression)expression))) {
                ReplaceWithTextBlockFix.replaceWithTextBlock((PsiExpression)polyadicExpression, polyadicExpression.getOperands());
            }
        }

        private static void replaceWithTextBlock(@NotNull PsiExpression toReplace, PsiExpression @NotNull [] operands) {
            String[] lines;
            if (toReplace == null) {
                ReplaceWithTextBlockFix.$$$reportNull$$$0(4);
            }
            if (operands == null) {
                ReplaceWithTextBlockFix.$$$reportNull$$$0(5);
            }
            if ((lines = ReplaceWithTextBlockFix.getContentLines(operands)) == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            tracker.replaceAndRestoreComments((PsiElement)toReplace, ReplaceWithTextBlockFix.getTextBlock(lines));
        }

        @NotNull
        private static String getTextBlock(String @NotNull [] lines) {
            int indent;
            if (lines == null) {
                ReplaceWithTextBlockFix.$$$reportNull$$$0(6);
            }
            if ((indent = PsiLiteralUtil.getTextBlockIndent((String[])(lines = PsiLiteralUtil.escapeTextBlockCharacters((String)StringUtil.join((String[])lines), (boolean)true, (boolean)true, (boolean)false).split("(?<=\n)")), (boolean)true, (boolean)true)) != 0 && lines.length > 0 && !lines[lines.length - 1].endsWith("\n")) {
                int n = lines.length - 1;
                lines[n] = lines[n] + "\\\n";
            }
            for (int i = 0; i < lines.length - 1; ++i) {
                String line = lines[i];
                if (!line.endsWith("\\\n") || !lines[i + 1].equals("\n")) continue;
                lines[i] = line.substring(0, line.length() - 2);
            }
            Object content = StringUtil.join((String[])lines);
            if (((String)content).endsWith(" ")) {
                content = ((String)content).substring(0, ((String)content).length() - 1) + "\\s";
            }
            String string = "\"\"\"\n" + (String)content + "\"\"\"";
            if (string == null) {
                ReplaceWithTextBlockFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static String @Nullable [] getContentLines(PsiExpression @NotNull [] operands) {
            if (operands == null) {
                ReplaceWithTextBlockFix.$$$reportNull$$$0(8);
            }
            String[] lines = new String[operands.length];
            PsiLiteralExpression previous = null;
            for (int i = 0; i < operands.length; ++i) {
                PsiLiteralExpression literal = TextBlockMigrationInspection.getLiteralExpression(operands[i]);
                if (literal == null) {
                    return null;
                }
                String line = ReplaceWithTextBlockFix.getLiteralText(literal);
                if (line == null) {
                    return null;
                }
                if (previous != null && !ReplaceWithTextBlockFix.onSameLine((PsiElement)previous, (PsiElement)literal) && !lines[i - 1].endsWith("\\n")) {
                    int n = i - 1;
                    lines[n] = lines[n] + "\\\n";
                }
                previous = literal;
                lines[i] = line;
            }
            return lines;
        }

        private static boolean onSameLine(@NotNull PsiElement e1, @NotNull PsiElement e2) {
            PsiFile containingFile;
            if (e1 == null) {
                ReplaceWithTextBlockFix.$$$reportNull$$$0(9);
            }
            if (e2 == null) {
                ReplaceWithTextBlockFix.$$$reportNull$$$0(10);
            }
            if ((containingFile = e1.getContainingFile()) != e2.getContainingFile()) {
                throw new IllegalArgumentException();
            }
            Document document = containingFile.getViewProvider().getDocument();
            return document != null && document.getLineNumber(e1.getTextOffset()) == document.getLineNumber(e2.getTextOffset());
        }

        @Nullable
        private static String getLiteralText(@NotNull PsiLiteralExpression literal) {
            if (literal == null) {
                ReplaceWithTextBlockFix.$$$reportNull$$$0(11);
            }
            if (!literal.isTextBlock() && ExpressionUtils.hasStringType((PsiExpression)literal)) {
                return PsiLiteralUtil.getStringLiteralContent((PsiLiteralExpression)literal);
            }
            Object value = literal.getValue();
            return value == null ? null : value.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/TextBlockMigrationInspection$ReplaceWithTextBlockFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toReplace";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operands";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e1";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e2";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/TextBlockMigrationInspection$ReplaceWithTextBlockFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceWithTextBlock";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTextBlock";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getContentLines";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "onSameLine";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getLiteralText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 8, 9, 10, 11 -> new IllegalArgumentException(string);
            };
        }
    }
}

