/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFragment;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiTemplate;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.java.PsiFragmentImpl;
import com.intellij.psi.util.PsiLiteralUtil;
import com.siyeh.ig.PsiReplacementUtil;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class TrailingWhitespacesInTextBlockInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.TEXT_BLOCKS);
        if (set == null) {
            TrailingWhitespacesInTextBlockInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            TrailingWhitespacesInTextBlockInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitTemplate(@NotNull PsiTemplate template) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitTemplate(template);
                for (PsiFragment fragment : template.getFragments()) {
                    if (!fragment.isTextBlock()) {
                        return;
                    }
                    String suffix = fragment.getTokenType() == JavaTokenType.TEXT_BLOCK_TEMPLATE_END ? "\"\"\"" : "\\{";
                    if (!this.checkTextBlock((PsiElement)fragment, suffix)) continue;
                    return;
                }
            }

            public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitLiteralExpression(expression);
                if (!expression.isTextBlock()) {
                    return;
                }
                this.checkTextBlock((PsiElement)expression, "\"\"\"");
            }

            private boolean checkTextBlock(@NotNull PsiElement textBlock, @NotNull String suffix) {
                if (textBlock == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (suffix == null) {
                    1.$$$reportNull$$$0(3);
                }
                String text = textBlock.getText();
                String[] lines = text.split("\n", -1);
                int indent = TrailingWhitespacesInTextBlockInspection.getIndent(textBlock);
                if (indent == -1) {
                    return false;
                }
                int offset = 0;
                for (int i = 0; i < lines.length; ++i) {
                    char c;
                    int lineEnd;
                    String line = lines[i];
                    if (i != 0) {
                        ++offset;
                    }
                    if (line.startsWith("\"\"\"")) {
                        offset += line.length();
                        continue;
                    }
                    if (line.endsWith(suffix)) {
                        if (suffix.equals("\\{")) {
                            return false;
                        }
                        lineEnd = line.length() - suffix.length();
                    } else {
                        lineEnd = line.length();
                    }
                    boolean fragmentStart = StringUtil.startsWithChar((CharSequence)line, (char)'}');
                    if ((fragmentStart ? lineEnd != 0 : lineEnd > indent) && ((c = line.charAt(lineEnd - 1)) == ' ' || c == '\t')) {
                        for (int j = lineEnd - 2; j >= 0; --j) {
                            c = line.charAt(j);
                            if ((c == ' ' || c == '\t') && (j >= indent || fragmentStart)) continue;
                            holder.registerProblem(textBlock, new TextRange(offset + j + 1, offset + lineEnd), JavaBundle.message((String)"inspection.trailing.whitespaces.in.text.block.message", (Object[])new Object[0]), TrailingWhitespacesInTextBlockInspection.createFixes());
                            return true;
                        }
                    }
                    offset += line.length();
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "template";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "textBlock";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suffix";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/TrailingWhitespacesInTextBlockInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTemplate";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLiteralExpression";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTextBlock";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static LocalQuickFix @NotNull [] createFixes() {
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceTrailingWhiteSpacesFix(JavaBundle.message((String)"inspection.trailing.whitespaces.in.text.block.remove.whitespaces", (Object[])new Object[0]), s -> TrailingWhitespacesInTextBlockInspection.removeWhitespaces(s)), new ReplaceTrailingWhiteSpacesFix(JavaBundle.message((String)"inspection.trailing.whitespaces.in.text.block.replaces.whitespaces.with.escapes", (Object[])new Object[0]), s -> TrailingWhitespacesInTextBlockInspection.replaceWhitespacesWithEscapes(s))};
        if (localQuickFixArray == null) {
            TrailingWhitespacesInTextBlockInspection.$$$reportNull$$$0(2);
        }
        return localQuickFixArray;
    }

    private static int getIndent(@NotNull PsiElement textBlock) {
        if (textBlock == null) {
            TrailingWhitespacesInTextBlockInspection.$$$reportNull$$$0(3);
        }
        return textBlock instanceof PsiFragment ? PsiFragmentImpl.getTextBlockFragmentIndent((PsiFragment)((PsiFragment)textBlock)) : PsiLiteralUtil.getTextBlockIndent((PsiLiteralExpression)((PsiLiteralExpression)textBlock));
    }

    @NotNull
    private static String replaceWhitespacesWithEscapes(@NotNull String contentLine) {
        if (contentLine == null) {
            TrailingWhitespacesInTextBlockInspection.$$$reportNull$$$0(4);
        }
        int len = contentLine.length();
        Object object = switch (contentLine.charAt(len - 1)) {
            case ' ' -> contentLine.substring(0, len - 1) + "\\s";
            case '\t' -> contentLine.substring(0, len - 1) + "\\t";
            default -> contentLine;
        };
        if (object == null) {
            TrailingWhitespacesInTextBlockInspection.$$$reportNull$$$0(5);
        }
        return object;
    }

    @NotNull
    private static String removeWhitespaces(@NotNull String contentLine) {
        if (contentLine == null) {
            TrailingWhitespacesInTextBlockInspection.$$$reportNull$$$0(6);
        }
        for (int i = contentLine.length() - 1; i >= 0; --i) {
            char c = contentLine.charAt(i);
            if (c == ' ' || c == '\t') continue;
            String string = contentLine.substring(0, i + 1);
            if (string == null) {
                TrailingWhitespacesInTextBlockInspection.$$$reportNull$$$0(7);
            }
            return string;
        }
        return "";
    }

    public static boolean hasUnescapedLastQuote(String text) {
        if (!text.endsWith("\"")) {
            return false;
        }
        int i = 0;
        int countBackSlash = 0;
        int length = text.length();
        while (i < length - 1) {
            int nextIdx = PsiLiteralUtil.parseBackSlash((String)text, (int)i);
            if (nextIdx != -1) {
                ++countBackSlash;
                i = nextIdx;
                continue;
            }
            countBackSlash = 0;
            ++i;
        }
        return countBackSlash % 2 == 0;
    }

    static void replaceTextBlock(@NotNull PsiLiteralExpression toReplace, @NotNull String newTextBlock) {
        if (toReplace == null) {
            TrailingWhitespacesInTextBlockInspection.$$$reportNull$$$0(8);
        }
        if (newTextBlock == null) {
            TrailingWhitespacesInTextBlockInspection.$$$reportNull$$$0(9);
        }
        Project project = toReplace.getProject();
        PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newTextBlock, (PsiElement)toReplace);
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> toReplace.replace((PsiElement)replacement));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 6, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/TrailingWhitespacesInTextBlockInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textBlock";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTextBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/TrailingWhitespacesInTextBlockInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWhitespacesWithEscapes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "removeWhitespaces";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceWhitespacesWithEscapes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeWhitespaces";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceTextBlock";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 6, 8, 9 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceTrailingWhiteSpacesFix
    extends PsiUpdateModCommandQuickFix {
        @IntentionFamilyName
        private final String myMessage;
        @NotNull
        private final @NotNull Function<@NotNull String, String> myTransformation;

        private ReplaceTrailingWhiteSpacesFix(@NotNull @IntentionFamilyName String message, @NotNull @NotNull Function<@NotNull String, String> transformation) {
            if (message == null) {
                ReplaceTrailingWhiteSpacesFix.$$$reportNull$$$0(0);
            }
            if (transformation == null) {
                ReplaceTrailingWhiteSpacesFix.$$$reportNull$$$0(1);
            }
            this.myMessage = message;
            this.myTransformation = transformation;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.myMessage;
            if (string == null) {
                ReplaceTrailingWhiteSpacesFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Object object;
            PsiFragment fragment;
            if (project == null) {
                ReplaceTrailingWhiteSpacesFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                ReplaceTrailingWhiteSpacesFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                ReplaceTrailingWhiteSpacesFix.$$$reportNull$$$0(5);
            }
            if (element instanceof PsiLiteralExpression) {
                PsiLiteralExpression expression = (PsiLiteralExpression)element;
                if (!expression.isTextBlock()) {
                    return;
                }
                String text = ReplaceTrailingWhiteSpacesFix.buildReplacementText(element, "\"\"\"", this.myTransformation);
                if (text == null) {
                    return;
                }
                TrailingWhitespacesInTextBlockInspection.replaceTextBlock(expression, text);
            } else if (element instanceof PsiFragment && (fragment = (PsiFragment)element).isTextBlock() && (object = fragment.getParent()) instanceof PsiTemplate) {
                PsiTemplate template = (PsiTemplate)object;
                for (PsiFragment current : template.getFragments().reversed()) {
                    String suffix;
                    String text = ReplaceTrailingWhiteSpacesFix.buildReplacementText((PsiElement)current, suffix = fragment.getTokenType() == JavaTokenType.TEXT_BLOCK_TEMPLATE_END ? "\"\"\"" : "\\{", this.myTransformation);
                    if (text == null) {
                        return;
                    }
                    PsiReplacementUtil.replaceFragment((PsiFragment)current, (String)text);
                    if (fragment != current) continue;
                    break;
                }
            }
        }

        private static String buildReplacementText(PsiElement element, String suffix, Function<String, String> lineTransformation) {
            String[] lines = element.getText().split("\n", -1);
            int indent = TrailingWhitespacesInTextBlockInspection.getIndent(element);
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < lines.length; ++i) {
                String transformed;
                boolean last;
                String line = lines[i];
                if (line.startsWith("\"\"\"")) {
                    result.append("\"\"\"\n");
                    continue;
                }
                boolean bl = last = i == lines.length - 1;
                if (last) {
                    if (suffix.equals("\\{")) {
                        return result.append(line).toString();
                    }
                    line = line.substring(0, line.length() - suffix.length());
                }
                String string = transformed = line.isEmpty() ? line : lineTransformation.apply(line);
                if (transformed == null) {
                    return null;
                }
                if (last && TrailingWhitespacesInTextBlockInspection.hasUnescapedLastQuote(transformed)) {
                    result.append(transformed, 0, transformed.length() - 1).append("\\\"");
                } else if (transformed.isEmpty()) {
                    result.append(line.length() < indent ? line : line.substring(0, indent));
                } else {
                    result.append(transformed);
                }
                result.append(last ? suffix : "\n");
            }
            return result.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transformation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/TrailingWhitespacesInTextBlockInspection$ReplaceTrailingWhiteSpacesFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/TrailingWhitespacesInTextBlockInspection$ReplaceTrailingWhiteSpacesFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

