/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UseHashCodeMethodInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher DOUBLE_TO_LONG_BITS = CallMatcher.staticCall((String)"java.lang.Double", (String[])new String[]{"doubleToLongBits"}).parameterTypes(new String[]{"double"});

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UseHashCodeMethodInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                UseHashCodeMethodInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(this){

            public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
                HashCodeModel model;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((model = UseHashCodeMethodInspection.getHashCodeModel(expression)) != null) {
                    PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)expression);
                    if (containingClass != null && containingClass.getQualifiedName() != null && containingClass.getQualifiedName().startsWith("java.lang.")) {
                        return;
                    }
                    holder.registerProblem((PsiElement)expression, JavaAnalysisBundle.message((String)"inspection.can.be.replaced.with.message", (Object[])new Object[]{model.type + ".hashCode()"}), new LocalQuickFix[]{new ReplaceWithLongHashCodeFix(model.type)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/UseHashCodeMethodInspection$1", "visitTypeCastExpression"));
            }
        };
    }

    @Nullable
    private static HashCodeModel getHashCodeModel(PsiTypeCastExpression cast) {
        if (cast == null) {
            return null;
        }
        if (!PsiTypes.intType().equals((Object)cast.getType())) {
            return null;
        }
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)cast.getOperand());
        if (!(operand instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand;
        PsiJavaToken operationSign = binaryExpression.getOperationSign();
        if (operationSign.getTokenType() != JavaTokenType.XOR) {
            return null;
        }
        PsiExpression leftOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getLOperand());
        PsiExpression rightOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getROperand());
        if (leftOperand == null || rightOperand == null) {
            return null;
        }
        if (!PsiTypes.longType().equals((Object)PsiPrimitiveType.getOptionallyUnboxedType((PsiType)leftOperand.getType()))) {
            return null;
        }
        if (UseHashCodeMethodInspection.isXorShift(leftOperand, rightOperand)) {
            return new HashCodeModel((PsiExpression)cast, leftOperand, null, null, "Long").tryReplaceDouble();
        }
        if (UseHashCodeMethodInspection.isXorShift(rightOperand, leftOperand)) {
            return new HashCodeModel((PsiExpression)cast, rightOperand, null, null, "Long").tryReplaceDouble();
        }
        return null;
    }

    private static boolean isXorShift(@NotNull PsiExpression leftOperand, @NotNull PsiExpression rightOperand) {
        if (leftOperand == null) {
            UseHashCodeMethodInspection.$$$reportNull$$$0(2);
        }
        if (rightOperand == null) {
            UseHashCodeMethodInspection.$$$reportNull$$$0(3);
        }
        if (rightOperand instanceof PsiBinaryExpression) {
            PsiBinaryExpression shiftingExpression = (PsiBinaryExpression)rightOperand;
            if (shiftingExpression.getOperationSign().getTokenType() != JavaTokenType.GTGTGT) {
                return false;
            }
            PsiExpression leftSubOperand = shiftingExpression.getLOperand();
            return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(leftOperand, leftSubOperand) && !SideEffectChecker.mayHaveSideEffects((PsiExpression)leftOperand) && Objects.equals(32, ExpressionUtils.computeConstantExpression((PsiExpression)shiftingExpression.getROperand()));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/UseHashCodeMethodInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightOperand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/UseHashCodeMethodInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isXorShift";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    record HashCodeModel(@NotNull PsiExpression completeExpression, @NotNull PsiExpression argument, @Nullable PsiLocalVariable intermediateVariable, @Nullable PsiExpression definition, @NotNull String type) {
        @NotNull
        private final PsiExpression completeExpression;
        @NotNull
        private final PsiExpression argument;
        @NotNull
        private final String type;

        HashCodeModel(@NotNull PsiExpression completeExpression, @NotNull PsiExpression argument, @Nullable PsiLocalVariable intermediateVariable, @Nullable PsiExpression definition, @NotNull String type) {
            if (completeExpression == null) {
                HashCodeModel.$$$reportNull$$$0(0);
            }
            if (argument == null) {
                HashCodeModel.$$$reportNull$$$0(1);
            }
            if (type == null) {
                HashCodeModel.$$$reportNull$$$0(2);
            }
        }

        @NotNull
        HashCodeModel tryReplaceDouble() {
            @Nullable PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)this.argument);
            if (!(expression instanceof PsiReferenceExpression)) {
                HashCodeModel hashCodeModel = this;
                if (hashCodeModel == null) {
                    HashCodeModel.$$$reportNull$$$0(3);
                }
                return hashCodeModel;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement psiElement = referenceExpression.resolve();
            if (!(psiElement instanceof PsiLocalVariable)) {
                HashCodeModel hashCodeModel = this;
                if (hashCodeModel == null) {
                    HashCodeModel.$$$reportNull$$$0(4);
                }
                return hashCodeModel;
            }
            PsiLocalVariable local = (PsiLocalVariable)psiElement;
            PsiExpression definition = PsiUtil.skipParenthesizedExprDown((PsiExpression)DeclarationSearchUtils.findDefinition((PsiReferenceExpression)referenceExpression, (PsiVariable)local));
            if (!(definition instanceof PsiMethodCallExpression)) {
                HashCodeModel hashCodeModel = this;
                if (hashCodeModel == null) {
                    HashCodeModel.$$$reportNull$$$0(5);
                }
                return hashCodeModel;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)definition;
            if (!DOUBLE_TO_LONG_BITS.matches((PsiExpression)call)) {
                HashCodeModel hashCodeModel = this;
                if (hashCodeModel == null) {
                    HashCodeModel.$$$reportNull$$$0(6);
                }
                return hashCodeModel;
            }
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)definition, PsiStatement.class);
            PsiElement nextStatement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement);
            if (!PsiTreeUtil.isAncestor((PsiElement)nextStatement, (PsiElement)this.completeExpression, (boolean)true)) {
                HashCodeModel hashCodeModel = this;
                if (hashCodeModel == null) {
                    HashCodeModel.$$$reportNull$$$0(7);
                }
                return hashCodeModel;
            }
            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)local, PsiCodeBlock.class);
            if (block == null || DefUseUtil.getRefs((PsiCodeBlock)block, (PsiVariable)local, (PsiElement)definition).length != 2) {
                HashCodeModel hashCodeModel = this;
                if (hashCodeModel == null) {
                    HashCodeModel.$$$reportNull$$$0(8);
                }
                return hashCodeModel;
            }
            return new HashCodeModel(this.completeExpression, call.getArgumentList().getExpressions()[0], local, definition, "Double");
        }

        @NotNull
        public PsiExpression completeExpression() {
            PsiExpression psiExpression = this.completeExpression;
            if (psiExpression == null) {
                HashCodeModel.$$$reportNull$$$0(9);
            }
            return psiExpression;
        }

        @NotNull
        public PsiExpression argument() {
            PsiExpression psiExpression = this.argument;
            if (psiExpression == null) {
                HashCodeModel.$$$reportNull$$$0(10);
            }
            return psiExpression;
        }

        @NotNull
        public String type() {
            String string = this.type;
            if (string == null) {
                HashCodeModel.$$$reportNull$$$0(11);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completeExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/UseHashCodeMethodInspection$HashCodeModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/UseHashCodeMethodInspection$HashCodeModel";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tryReplaceDouble";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "completeExpression";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "argument";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }

    public static class ReplaceWithLongHashCodeFix
    extends PsiUpdateModCommandQuickFix {
        private final String myType;

        public ReplaceWithLongHashCodeFix(String type) {
            this.myType = type;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myType + ".hashCode()"});
            if (string == null) {
                ReplaceWithLongHashCodeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"hashCode()"});
            if (string == null) {
                ReplaceWithLongHashCodeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            HashCodeModel model;
            if (project == null) {
                ReplaceWithLongHashCodeFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                ReplaceWithLongHashCodeFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithLongHashCodeFix.$$$reportNull$$$0(4);
            }
            if ((model = UseHashCodeMethodInspection.getHashCodeModel((PsiTypeCastExpression)startElement)) == null) {
                return;
            }
            PsiExpression argument = model.argument();
            CommentTracker ct = new CommentTracker();
            String call = argument.getType() instanceof PsiPrimitiveType ? "java.lang." + model.type() + ".hashCode(" + ct.text((PsiElement)argument) + ")" : ct.text(argument, 1) + ".hashCode()";
            PsiLocalVariable local = model.intermediateVariable;
            if (local != null && model.definition != null) {
                List references;
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)model.definition, PsiExpressionStatement.class);
                if (expressionStatement != null) {
                    ct.delete((PsiElement)expressionStatement);
                }
                if ((references = VariableAccessUtils.getVariableReferences((PsiVariable)local)).size() == 2) {
                    ct.delete((PsiElement)local);
                }
            }
            ct.replaceAndRestoreComments(startElement, call);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/UseHashCodeMethodInspection$ReplaceWithLongHashCodeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/UseHashCodeMethodInspection$ReplaceWithLongHashCodeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

