/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.classCanBeRecord;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.OrderedBinaryExpression;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EqualsChecker {
    private static final CallMatcher GET_CLASS = CallMatcher.instanceCall((String)"java.lang.Object", (String[])new String[]{"getClass"}).parameterCount(0);
    private static final CallMatcher OBJECTS_EQUALS = CallMatcher.staticCall((String)"java.util.Objects", (String[])new String[]{"equals"}).parameterCount(2);
    private static final CallMatcher BITS = CallMatcher.anyOf((CallMatcher[])new CallMatcher[]{CallMatcher.staticCall((String)"java.lang.Double", (String[])new String[]{"doubleToLongBits", "doubleToRawLongBits"}), CallMatcher.staticCall((String)"java.lang.Float", (String[])new String[]{"floatToIntBits", "floatToRawIntBits"})});

    EqualsChecker() {
    }

    static boolean isStandardEqualsMethod(@Nullable PsiMethod method, @NotNull Set<PsiField> fields) {
        int shift;
        if (fields == null) {
            EqualsChecker.$$$reportNull$$$0(0);
        }
        if (method == null) {
            return false;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        PsiParameter parameter = method.getParameterList().getParameter(0);
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 4) {
            if (!EqualsChecker.isThisCheck(statements[0], parameter)) {
                return false;
            }
            shift = 1;
        } else {
            if (statements.length != 3) {
                return false;
            }
            shift = 0;
        }
        if (!EqualsChecker.isNullClassCheck(statements[shift], parameter)) {
            return false;
        }
        PsiVariable that = EqualsChecker.extractThatVariable(statements[1 + shift], parameter);
        if (that == null) {
            return false;
        }
        PsiStatement psiStatement = statements[2 + shift];
        if (!(psiStatement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)psiStatement;
        PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)returnStatement.getReturnValue());
        if (!(psiExpression instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression poly = (PsiPolyadicExpression)psiExpression;
        if (!poly.getOperationTokenType().equals(JavaTokenType.ANDAND)) {
            return false;
        }
        PsiExpression[] operands = poly.getOperands();
        if (fields.size() != operands.length) {
            return false;
        }
        HashSet<PsiField> comparedFields = new HashSet<PsiField>();
        for (PsiExpression operand : operands) {
            PsiField field = EqualsChecker.getComparedField(operand, that);
            if (field != null && comparedFields.add(field)) continue;
            return false;
        }
        return comparedFields.equals(fields);
    }

    @Nullable
    private static PsiField getComparedField(PsiExpression operand, PsiVariable that) {
        PsiBinaryExpression binOp;
        PsiMethodCallExpression call;
        if ((operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand)) instanceof PsiMethodCallExpression && OBJECTS_EQUALS.test(call = (PsiMethodCallExpression)operand)) {
            PsiExpression[] expressions = call.getArgumentList().getExpressions();
            return EqualsChecker.getField(expressions[0], expressions[1], that);
        }
        if (operand instanceof PsiBinaryExpression && (binOp = (PsiBinaryExpression)operand).getOperationTokenType().equals(JavaTokenType.EQEQ)) {
            PsiType type;
            PsiExpression rOperand;
            PsiExpression lOperand = binOp.getLOperand();
            PsiField field = EqualsChecker.getField(lOperand, rOperand = binOp.getROperand(), that);
            if (field != null && (type = field.getType()) instanceof PsiPrimitiveType && !TypeConversionUtil.isFloatOrDoubleType((PsiType)type)) {
                return field;
            }
            if (lOperand instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression lCall = (PsiMethodCallExpression)lOperand;
                if (rOperand instanceof PsiMethodCallExpression) {
                    PsiType type2;
                    PsiMethodCallExpression rCall = (PsiMethodCallExpression)rOperand;
                    if (BITS.test(lCall) && BITS.test(rCall) && (field = EqualsChecker.getField(lCall.getArgumentList().getExpressions()[0], rCall.getArgumentList().getExpressions()[0], that)) != null && (type2 = field.getType()) instanceof PsiPrimitiveType && TypeConversionUtil.isFloatOrDoubleType((PsiType)type2)) {
                        return field;
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiField getField(PsiExpression left, PsiExpression right, PsiVariable that) {
        PsiThisExpression thisExpression;
        PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)left);
        if (!(psiExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression leftRef = (PsiReferenceExpression)psiExpression;
        PsiExpression psiExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)right);
        if (!(psiExpression2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression rightRef = (PsiReferenceExpression)psiExpression2;
        PsiElement psiElement = leftRef.resolve();
        if (!(psiElement instanceof PsiField)) {
            return null;
        }
        PsiField leftField = (PsiField)psiElement;
        PsiElement psiElement2 = rightRef.resolve();
        if (!(psiElement2 instanceof PsiField)) {
            return null;
        }
        PsiField rightField = (PsiField)psiElement2;
        if (!leftField.isEquivalentTo((PsiElement)rightField)) {
            return null;
        }
        PsiExpression leftQualifier = leftRef.getQualifierExpression();
        PsiExpression rightQualifier = rightRef.getQualifierExpression();
        if (ExpressionUtils.isReferenceTo((PsiExpression)leftQualifier, (PsiVariable)that) && (rightQualifier == null || rightQualifier instanceof PsiThisExpression && (thisExpression = (PsiThisExpression)rightQualifier).getQualifier() == null)) {
            return leftField;
        }
        if (ExpressionUtils.isReferenceTo((PsiExpression)rightQualifier, (PsiVariable)that) && (leftQualifier == null || leftQualifier instanceof PsiThisExpression && (thisExpression = (PsiThisExpression)leftQualifier).getQualifier() == null)) {
            return leftField;
        }
        return null;
    }

    private static PsiVariable extractThatVariable(PsiStatement statement, PsiParameter parameter) {
        PsiElement psiElement;
        if (!(statement instanceof PsiDeclarationStatement)) {
            return null;
        }
        PsiDeclarationStatement decl = (PsiDeclarationStatement)statement;
        PsiElement[] elements = decl.getDeclaredElements();
        if (elements.length != 1 || !((psiElement = elements[0]) instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)psiElement;
        PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)var.getInitializer());
        if (!(psiExpression instanceof PsiTypeCastExpression)) {
            return null;
        }
        PsiTypeCastExpression cast = (PsiTypeCastExpression)psiExpression;
        if (!ExpressionUtils.isReferenceTo((PsiExpression)cast.getOperand(), (PsiVariable)parameter)) {
            return null;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)var.getType());
        if (psiClass == null || !psiClass.isEquivalentTo(PsiTreeUtil.getParentOfType((PsiElement)statement, PsiClass.class))) {
            return null;
        }
        return var;
    }

    private static boolean isThisCheck(PsiStatement statement, PsiParameter parameter) {
        if (!(statement instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)statement;
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        if (!EqualsChecker.returnsBoolean(ifStatement.getThenBranch(), true)) {
            return false;
        }
        PsiExpression condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)ifStatement.getCondition());
        OrderedBinaryExpression expr = OrderedBinaryExpression.from((PsiExpression)condition, PsiThisExpression.class);
        return expr != null && ((PsiThisExpression)expr.getFirstOperand()).getQualifier() == null && expr.getTokenType() == JavaTokenType.EQEQ && ExpressionUtils.isReferenceTo((PsiExpression)expr.getSecondOperand(), (PsiVariable)parameter);
    }

    private static boolean isNullClassCheck(PsiStatement statement, PsiParameter parameter) {
        PsiBinaryExpression disjunction;
        if (!(statement instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)statement;
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        if (!EqualsChecker.returnsBoolean(ifStatement.getThenBranch(), false)) {
            return false;
        }
        PsiExpression condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)ifStatement.getCondition());
        if (!(condition instanceof PsiBinaryExpression) || !(disjunction = (PsiBinaryExpression)condition).getOperationTokenType().equals(JavaTokenType.OROR)) {
            return false;
        }
        if (ExpressionUtils.getVariableFromNullComparison((PsiExpression)disjunction.getLOperand(), (boolean)true) != parameter) {
            return false;
        }
        PsiExpression rOperand = disjunction.getROperand();
        if (rOperand instanceof PsiBinaryExpression) {
            PsiBinaryExpression rightBinOp = (PsiBinaryExpression)rOperand;
            if (!rightBinOp.getOperationTokenType().equals(JavaTokenType.NE)) {
                return false;
            }
            PsiExpression left = rightBinOp.getLOperand();
            PsiExpression right = rightBinOp.getROperand();
            return EqualsChecker.isObjectGetClass(left, parameter) && EqualsChecker.isThisClass(right) || EqualsChecker.isObjectGetClass(right, parameter) && EqualsChecker.isThisClass(left);
        }
        PsiExpression psiExpression = BoolUtils.getNegated((PsiExpression)rOperand);
        if (psiExpression instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)psiExpression;
            return ExpressionUtils.isReferenceTo((PsiExpression)instanceOfExpression.getOperand(), (PsiVariable)parameter) && EqualsChecker.isCurrentType(instanceOfExpression.getCheckType());
        }
        return false;
    }

    private static boolean isThisClass(PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiMethodCallExpression) {
            PsiThisExpression thisExpression;
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (!GET_CLASS.test(call)) {
                return false;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            return qualifier == null || qualifier instanceof PsiThisExpression && (thisExpression = (PsiThisExpression)qualifier).getQualifier() == null;
        }
        if (expression instanceof PsiClassObjectAccessExpression) {
            PsiClassObjectAccessExpression classExpression = (PsiClassObjectAccessExpression)expression;
            return EqualsChecker.isCurrentType(classExpression.getOperand());
        }
        return false;
    }

    private static boolean isCurrentType(PsiTypeElement operand) {
        if (operand == null) {
            return false;
        }
        PsiType type = operand.getType();
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)operand, PsiClass.class);
        return containingClass != null && containingClass.isEquivalentTo((PsiElement)PsiUtil.resolveClassInClassTypeOnly((PsiType)type));
    }

    private static boolean isObjectGetClass(PsiExpression expression, PsiParameter parameter) {
        PsiMethodCallExpression call;
        PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        return psiExpression instanceof PsiMethodCallExpression && GET_CLASS.test(call = (PsiMethodCallExpression)psiExpression) && ExpressionUtils.isReferenceTo((PsiExpression)call.getMethodExpression().getQualifierExpression(), (PsiVariable)parameter);
    }

    private static boolean returnsBoolean(PsiStatement statement, boolean expectedValue) {
        Boolean value;
        PsiLiteralExpression literal;
        PsiReturnStatement returnStatement;
        Object object = ControlFlowUtils.stripBraces((PsiStatement)statement);
        return object instanceof PsiReturnStatement && (object = (returnStatement = (PsiReturnStatement)object).getReturnValue()) instanceof PsiLiteralExpression && (object = (literal = (PsiLiteralExpression)object).getValue()) instanceof Boolean && (value = (Boolean)object).equals(expectedValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fields", "com/intellij/codeInspection/classCanBeRecord/EqualsChecker", "isStandardEqualsMethod"));
    }
}

