/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.classCanBeRecord;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInspection.classCanBeRecord.ConvertToRecordFix;
import com.intellij.java.syntax.parser.DeclarationParser;
import com.intellij.java.syntax.parser.JavaParser;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;

@NotNullByDefault
final class RecordBuilder {
    private final StringBuilder myRecordText = new StringBuilder();
    private final PsiClass myOriginClass;

    RecordBuilder(PsiClass originClass) {
        this.myOriginClass = originClass;
    }

    void addRecordDeclaration() {
        this.myRecordText.append("record");
    }

    void addRecordHeader(@Nullable ConvertToRecordFix.RecordConstructorCandidate canonicalCtorCandidate, Map<PsiField, @Nullable ConvertToRecordFix.FieldAccessorCandidate> fieldToAccessorCandidateMap) {
        this.myRecordText.append("(");
        StringJoiner recordComponentsJoiner = new StringJoiner(",");
        if (canonicalCtorCandidate == null) {
            fieldToAccessorCandidateMap.forEach((field, fieldAccessorCandidate) -> recordComponentsJoiner.add(RecordBuilder.generateComponentText(field.getAnnotations(), field.getName(), field.getType(), fieldAccessorCandidate)));
        } else {
            PsiParameter[] ctorParams;
            for (PsiParameter parameter : ctorParams = canonicalCtorCandidate.constructor().getParameterList().getParameters()) {
                if (!canonicalCtorCandidate.paramsToFields().containsKey(parameter)) continue;
                PsiField field2 = canonicalCtorCandidate.paramsToFields().get(parameter);
                if (field2 == null) {
                    String componentText = RecordBuilder.generateComponentText(PsiAnnotation.EMPTY_ARRAY, parameter.getName(), parameter.getType(), null);
                    recordComponentsJoiner.add(componentText);
                    continue;
                }
                ConvertToRecordFix.FieldAccessorCandidate fieldAccessorCandidate2 = fieldToAccessorCandidateMap.get(field2);
                String componentText = RecordBuilder.generateComponentText(field2, parameter, fieldAccessorCandidate2);
                recordComponentsJoiner.add(componentText);
            }
        }
        this.myRecordText.append(recordComponentsJoiner);
        this.myRecordText.append(")");
    }

    void addCanonicalCtor(PsiMethod ctor) {
        VisibilityUtil.setVisibility((PsiModifierList)ctor.getModifierList(), (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myOriginClass.getModifierList()));
        this.processUncheckedExceptions(ctor);
        this.myRecordText.append(ctor.getText());
    }

    void addDelegatingCtor(PsiMethod canonicalCtor, PsiMethod ctor, Map<String, PsiExpression> fieldNamesToInitializers, Set<PsiStatement> trailingStatements) {
        this.processUncheckedExceptions(ctor);
        PsiCodeBlock body = ctor.getBody();
        assert (body != null);
        PsiStatement[] statements = body.getStatements();
        CommentTracker ct = new CommentTracker();
        for (int i = 0; i < statements.length; ++i) {
            boolean isLastAssignmentStatement;
            PsiStatement nextStatement;
            PsiStatement statement = statements[i];
            PsiStatement psiStatement = nextStatement = i < statements.length - 1 ? statements[i + 1] : null;
            if (trailingStatements.contains(statement)) continue;
            boolean bl = isLastAssignmentStatement = nextStatement == null || trailingStatements.contains(nextStatement);
            if (isLastAssignmentStatement) {
                PsiStatement delegatingCtorCall = RecordBuilder.createDelegatingCtorCall(canonicalCtor, fieldNamesToInitializers);
                ct.replaceAndRestoreComments((PsiElement)statement, (PsiElement)delegatingCtorCall);
                continue;
            }
            ct.delete((PsiElement)statement);
        }
        this.processUncheckedExceptions(ctor);
        this.myRecordText.append(ctor.getText());
    }

    private static PsiStatement createDelegatingCtorCall(PsiMethod canonicalCtor, Map<String, PsiExpression> fieldNamesToInitializers) {
        StringBuilder delegatingCtorInvocationText = new StringBuilder();
        delegatingCtorInvocationText.append("this(");
        ArrayList<PsiExpression> expressionsInCorrectOrder = new ArrayList<PsiExpression>();
        for (PsiParameter canonicalCtorParameter : canonicalCtor.getParameterList().getParameters()) {
            PsiExpression fieldInitializerExpr = fieldNamesToInitializers.get(canonicalCtorParameter.getName());
            if (fieldInitializerExpr == null) continue;
            expressionsInCorrectOrder.add(fieldInitializerExpr);
        }
        delegatingCtorInvocationText.append(expressionsInCorrectOrder.stream().map(PsiElement::getText).collect(Collectors.joining(", ")));
        delegatingCtorInvocationText.append(");");
        PsiElementFactory factory = PsiElementFactory.getInstance((Project)canonicalCtor.getProject());
        return factory.createStatementFromText(delegatingCtorInvocationText.toString(), (PsiElement)canonicalCtor);
    }

    void addCtor(PsiMethod ctor) {
        this.processUncheckedExceptions(ctor);
        this.myRecordText.append(ctor.getText());
    }

    void addFieldAccessor(ConvertToRecordFix.FieldAccessorCandidate fieldAccessorCandidate) {
        PsiMethod fieldAccessor = fieldAccessorCandidate.method();
        if (fieldAccessorCandidate.isDefault()) {
            this.trimEndingWhiteSpaces();
            return;
        }
        PsiModifierList accessorModifiers = fieldAccessor.getModifierList();
        VisibilityUtil.setVisibility((PsiModifierList)accessorModifiers, (String)"public");
        this.processOverrideAnnotation(accessorModifiers);
        this.processUncheckedExceptions(fieldAccessor);
        this.myRecordText.append(fieldAccessor.getText());
    }

    void addModifierList(PsiModifierList modifierList) {
        modifierList.setModifierProperty("static", false);
        modifierList.setModifierProperty("final", false);
        this.addPsiElement((PsiElement)modifierList);
    }

    void addPsiElement(PsiElement psiElement) {
        this.myRecordText.append(psiElement.getText());
    }

    PsiClass build() {
        JavaDummyElement dummyElement = new JavaDummyElement((CharSequence)this.myRecordText.toString(), (builder, languageLevel) -> new JavaParser(languageLevel).getDeclarationParser().parse(builder, DeclarationParser.Context.CLASS), LanguageLevel.JDK_16);
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myOriginClass.getManager(), (TreeElement)dummyElement, (PsiElement)this.myOriginClass);
        return (PsiClass)Objects.requireNonNull(SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode()));
    }

    private static String generateComponentText(PsiField field, PsiParameter ctorParameter, @Nullable ConvertToRecordFix.FieldAccessorCandidate fieldAccessorCandidate) {
        if (field == null) {
            throw new IllegalStateException("no field found to which the constructor parameter '" + ctorParameter.getType().toString() + ctorParameter.getName() + "' is assigned");
        }
        PsiType componentType = field.getType();
        if (ctorParameter.getType() instanceof PsiEllipsisType && componentType instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)componentType;
            componentType = new PsiEllipsisType(arrayType.getComponentType(), arrayType.getAnnotationProvider());
        }
        return RecordBuilder.generateComponentText(field.getAnnotations(), field.getName(), componentType, fieldAccessorCandidate);
    }

    private static String generateComponentText(PsiAnnotation[] fieldAnnotations, String fieldName, PsiType componentType, @Nullable ConvertToRecordFix.FieldAccessorCandidate fieldAccessorCandidate) {
        Object annotationsText;
        String fieldAnnotationsText = Arrays.stream(fieldAnnotations).filter(anno -> !AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)anno)).map(PsiElement::getText).collect(Collectors.joining(" "));
        Object object = annotationsText = fieldAnnotationsText.isEmpty() ? fieldAnnotationsText : fieldAnnotationsText + " ";
        if (fieldAccessorCandidate != null && fieldAccessorCandidate.isDefault()) {
            String accessorAnnotationsText = Arrays.stream(fieldAccessorCandidate.method().getAnnotations()).filter(accessorAnn -> !"java.lang.Override".equals(accessorAnn.getQualifiedName())).filter(anno -> !AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)anno)).filter(accessorAnn -> !ContainerUtil.exists((Object[])fieldAnnotations, fieldAnn -> AnnotationUtil.equal((PsiAnnotation)fieldAnn, (PsiAnnotation)accessorAnn))).map(PsiElement::getText).collect(Collectors.joining(" "));
            annotationsText = accessorAnnotationsText.isEmpty() ? annotationsText : (String)annotationsText + accessorAnnotationsText + " ";
        }
        return (String)annotationsText + componentType.getCanonicalText(true) + " " + fieldName;
    }

    private void processOverrideAnnotation(PsiModifierList accessorModifiers) {
        PsiAnnotation annotation = AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent((String)"java.lang.Override", (PsiNameValuePair[])PsiNameValuePair.EMPTY_ARRAY, (PsiAnnotationOwner)accessorModifiers);
        if (annotation != null) {
            JavaCodeStyleManager.getInstance((Project)this.myOriginClass.getProject()).shortenClassReferences((PsiElement)annotation);
        }
    }

    private void processUncheckedExceptions(PsiMethod fieldAccessor) {
        PsiReferenceList fieldAccessorThrowsList = fieldAccessor.getThrowsList();
        PsiClassType[] throwsReferenceTypes = fieldAccessorThrowsList.getReferencedTypes();
        if (throwsReferenceTypes.length == 0) {
            return;
        }
        PsiDocComment existingComment = fieldAccessor.getDocComment();
        PsiElementFactory parserFacade = JavaPsiFacade.getElementFactory((Project)this.myOriginClass.getProject());
        if (existingComment == null) {
            PsiDocComment newComment = parserFacade.createDocCommentFromText("/***/", (PsiElement)fieldAccessor);
            Arrays.stream(throwsReferenceTypes).forEach(arg_0 -> RecordBuilder.lambda$processUncheckedExceptions$7(newComment, (PsiJavaParserFacade)parserFacade, arg_0));
            fieldAccessor.addBefore((PsiElement)newComment, fieldAccessor.getFirstChild());
        } else {
            Object[] throwsTags = existingComment.findTagsByName("throws");
            for (PsiClassType throwsReferenceType : throwsReferenceTypes) {
                boolean tagAlreadyExists = ContainerUtil.exists((Object[])throwsTags, throwTag -> {
                    PsiClass resolvedClass = JavaDocUtil.resolveClassInTagValue((PsiDocTagValue)throwTag.getValueElement());
                    if (resolvedClass == null) {
                        return false;
                    }
                    return throwsReferenceType.equalsToText(Objects.requireNonNull(resolvedClass.getQualifiedName()));
                });
                if (tagAlreadyExists) continue;
                existingComment.add((PsiElement)RecordBuilder.createDocTag((PsiJavaParserFacade)parserFacade, throwsReferenceType));
            }
        }
        fieldAccessorThrowsList.deleteChildRange(fieldAccessorThrowsList.getFirstChild(), fieldAccessorThrowsList.getLastChild());
    }

    private void trimEndingWhiteSpaces() {
        if (this.myRecordText.isEmpty()) {
            return;
        }
        int endIndex = this.myRecordText.length() - 1;
        if (this.myRecordText.charAt(endIndex) != ' ') {
            return;
        }
        while (endIndex > 0 && (this.myRecordText.charAt(endIndex - 1) == ' ' || this.myRecordText.charAt(endIndex - 1) == '\n')) {
            --endIndex;
        }
        this.myRecordText.setLength(endIndex);
    }

    private static PsiDocTag createDocTag(PsiJavaParserFacade parserFacade, PsiClassType throwsReferenceType) {
        return parserFacade.createDocTagFromText("@throws " + throwsReferenceType.getCanonicalText());
    }

    private static /* synthetic */ void lambda$processUncheckedExceptions$7(PsiDocComment newComment, PsiJavaParserFacade parserFacade, PsiClassType rt) {
        newComment.add((PsiElement)RecordBuilder.createDocTag(parserFacade, rt));
    }
}

