/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAssignmentFix;
import com.intellij.codeInspection.ReplaceWithTrivialLambdaFix;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.TrackingRunner;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.fix.FindDfaProblemCauseFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithConstantValueFix;
import com.intellij.codeInspection.dataFlow.fix.SimplifyToAssignmentFix;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaDfaAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaMethodReferenceReturnAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaPolyadicPartAnchor;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.bugs.EqualsWithItselfInspection;
import com.siyeh.ig.controlflow.PointlessBooleanExpressionInspection;
import com.siyeh.ig.fixes.EqualsToEqualityFix;
import com.siyeh.ig.numeric.ComparisonToNaNInspection;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstantValueInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean DONT_REPORT_TRUE_ASSERT_STATEMENTS;
    public boolean IGNORE_ASSERT_STATEMENTS;
    public boolean REPORT_CONSTANT_REFERENCE_VALUES = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"DONT_REPORT_TRUE_ASSERT_STATEMENTS", (String)JavaBundle.message((String)"inspection.data.flow.true.asserts.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"IGNORE_ASSERT_STATEMENTS", (String)JavaBundle.message((String)"inspection.data.flow.ignore.assert.statements", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"REPORT_CONSTANT_REFERENCE_VALUES", (String)JavaAnalysisBundle.message((String)"inspection.data.flow.warn.when.reading.a.value.guaranteed.to.be.constant", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ConstantValueInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ConstantValueInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.visitExpression((PsiExpression)expression);
            }

            public void visitExpression(@NotNull PsiExpression expression) {
                JavaExpressionAnchor javaExpressionAnchor;
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (expression instanceof PsiLiteralExpression) {
                    return;
                }
                CommonDataflow.DataflowResult dfr = CommonDataflow.getDataflowResult((PsiElement)expression);
                if (dfr == null) {
                    return;
                }
                if (expression instanceof PsiMethodReferenceExpression) {
                    PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression;
                    javaExpressionAnchor = new JavaMethodReferenceReturnAnchor(methodRef);
                } else {
                    javaExpressionAnchor = new JavaExpressionAnchor(expression);
                }
                JavaExpressionAnchor anchor = javaExpressionAnchor;
                ConstantValueInspection.this.processAnchor(dfr, (JavaDfaAnchor)anchor, holder);
                if (expression instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression polyadic = (PsiPolyadicExpression)expression;
                    PsiExpression[] operands = polyadic.getOperands();
                    for (int i = 1; i < operands.length - 1; ++i) {
                        ConstantValueInspection.this.processAnchor(dfr, (JavaDfaAnchor)new JavaPolyadicPartAnchor(polyadic, i), holder);
                    }
                }
            }

            public void visitSwitchLabeledRuleStatement(@NotNull PsiSwitchLabeledRuleStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.checkSwitchCaseGuard(PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getGuardExpression()));
            }

            public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.checkSwitchCaseGuard(PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getGuardExpression()));
            }

            private void checkSwitchCaseGuard(@Nullable PsiExpression guard) {
                if (guard == null) {
                    return;
                }
                if (BoolUtils.isTrue((PsiExpression)guard)) {
                    LocalQuickFix fix = ConstantValueInspection.createSimplifyBooleanExpressionFix((PsiElement)guard, guard.textMatches((CharSequence)"true"));
                    holder.registerProblem((PsiElement)guard, JavaAnalysisBundle.message((String)"dataflow.message.constant.no.ref", (Object[])new Object[]{guard.textMatches((CharSequence)"true") ? 1 : 0}), LocalQuickFix.notNullElements((LocalQuickFix)fix));
                }
            }

            public void visitIfStatement(@NotNull PsiIfStatement statement) {
                PsiExpression condition;
                if (statement == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (BoolUtils.isBooleanLiteral((PsiExpression)(condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getCondition())))) {
                    LocalQuickFix fix = ConstantValueInspection.createSimplifyBooleanExpressionFix((PsiElement)condition, condition.textMatches((CharSequence)"true"));
                    holder.registerProblem((PsiElement)condition, JavaAnalysisBundle.message((String)"dataflow.message.constant.no.ref", (Object[])new Object[]{condition.textMatches((CharSequence)"true") ? 1 : 0}), LocalQuickFix.notNullElements((LocalQuickFix)fix));
                }
            }

            public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
                LocalQuickFix fix;
                PsiExpression condition;
                if (statement == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getCondition())) != null && condition.textMatches((CharSequence)"false") && (fix = ConstantValueInspection.createSimplifyBooleanExpressionFix((PsiElement)condition, false)) != null) {
                    holder.registerProblem((PsiElement)condition, JavaAnalysisBundle.message((String)"dataflow.message.constant.no.ref", (Object[])new Object[]{0}), LocalQuickFix.notNullElements((LocalQuickFix)fix));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ConstantValueInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSwitchLabeledRuleStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSwitchLabelStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIfStatement";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDoWhileStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void processAnchor(@NotNull CommonDataflow.DataflowResult dfr, @NotNull JavaDfaAnchor anchor, @NotNull ProblemsHolder holder) {
        if (dfr == null) {
            ConstantValueInspection.$$$reportNull$$$0(2);
        }
        if (anchor == null) {
            ConstantValueInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            ConstantValueInspection.$$$reportNull$$$0(4);
        }
        DfType dfType = this.IGNORE_ASSERT_STATEMENTS ? dfr.getDfTypeNoAssertions(anchor) : dfr.getDfType(anchor);
        this.processAnchor(dfType, anchor, holder);
    }

    private void processAnchor(@NotNull DfType dfType, @NotNull JavaDfaAnchor anchor, @NotNull ProblemsHolder reporter) {
        List contracts;
        JavaMethodReferenceReturnAnchor methodRefAnchor;
        PsiMethodReferenceExpression methodRef;
        PsiMethod method;
        DfReferenceType refType;
        ConstantResult result;
        if (dfType == null) {
            ConstantValueInspection.$$$reportNull$$$0(5);
        }
        if (anchor == null) {
            ConstantValueInspection.$$$reportNull$$$0(6);
        }
        if (reporter == null) {
            ConstantValueInspection.$$$reportNull$$$0(7);
        }
        if ((result = ConstantResult.fromDfType(dfType)) == ConstantResult.UNKNOWN && dfType instanceof DfReferenceType && (refType = (DfReferenceType)dfType).getSpecialField() == SpecialField.UNBOX && refType.getNullability() == DfaNullability.NOT_NULL) {
            result = ConstantResult.fromDfType(refType.getSpecialFieldType());
        }
        if (result == ConstantResult.UNKNOWN) {
            return;
        }
        Object value = result.value();
        if (anchor instanceof JavaPolyadicPartAnchor) {
            JavaPolyadicPartAnchor polyadicPartAnchor = (JavaPolyadicPartAnchor)anchor;
            if (value instanceof Boolean) {
                Boolean booleanValue = (Boolean)value;
                String message = JavaAnalysisBundle.message((String)"dataflow.message.constant.condition", (Object[])new Object[]{booleanValue != false ? 1 : 0});
                reporter.registerProblem((PsiElement)polyadicPartAnchor.getExpression(), polyadicPartAnchor.getTextRange(), message, new LocalQuickFix[0]);
            }
        } else if (anchor instanceof JavaExpressionAnchor) {
            JavaExpressionAnchor expressionAnchor = (JavaExpressionAnchor)anchor;
            PsiExpression expression = expressionAnchor.getExpression();
            if (ConstantValueInspection.isCondition(expression)) {
                if (value instanceof Boolean) {
                    Boolean booleanValue = (Boolean)value;
                    this.reportConstantBoolean(reporter, (PsiElement)expression, booleanValue);
                }
            } else {
                this.reportConstantReferenceValue(reporter, expression, result);
            }
        } else if (anchor instanceof JavaMethodReferenceReturnAnchor && (method = (PsiMethod)ObjectUtils.tryCast((Object)(methodRef = (methodRefAnchor = (JavaMethodReferenceReturnAnchor)anchor).getMethodReferenceExpression()).resolve(), PsiMethod.class)) != null && JavaMethodContractUtil.isPure((PsiMethod)method) && ((contracts = JavaMethodContractUtil.getMethodContracts((PsiMethod)method)).isEmpty() || !((StandardMethodContract)contracts.getFirst()).isTrivial())) {
            reporter.registerProblem((PsiElement)methodRef, JavaAnalysisBundle.message((String)"dataflow.message.constant.method.reference", (Object[])new Object[]{value}), new LocalQuickFix[]{new ReplaceWithTrivialLambdaFix(value)});
        }
    }

    private static boolean shouldReportZero(PsiExpression ref) {
        PsiElement parent;
        PsiBinaryExpression binOp;
        if (ref instanceof PsiPolyadicExpression) {
            PsiMethod method;
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)ref;
            if (PsiUtil.isConstantExpression((PsiExpression)ref)) {
                return false;
            }
            IElementType tokenType = polyadic.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.ASTERISK) && MethodUtils.isHashCode((PsiMethod)(method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class})))) {
                return false;
            }
        } else if (ref instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)ref;
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (PsiUtil.isConstantExpression((PsiExpression)qualifier) && ContainerUtil.and((Object[])call.getArgumentList().getExpressions(), PsiUtil::isConstantExpression)) {
                return false;
            }
        } else {
            if (ref instanceof PsiTypeCastExpression) {
                PsiExpression operand = ((PsiTypeCastExpression)ref).getOperand();
                return operand != null && TypeConversionUtil.isFloatOrDoubleType((PsiType)operand.getType());
            }
            return false;
        }
        return (binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)(parent = PsiUtil.skipParenthesizedExprUp((PsiElement)ref.getParent())), PsiBinaryExpression.class)) == null || !ComparisonUtils.isEqualityComparison((PsiExpression)binOp) || !ExpressionUtils.isZero((PsiExpression)binOp.getLOperand()) && !ExpressionUtils.isZero((PsiExpression)binOp.getROperand());
    }

    private void reportConstantReferenceValue(ProblemsHolder reporter, PsiExpression ref, ConstantResult constant) {
        String message;
        ProblemHighlightType type;
        if (!this.REPORT_CONSTANT_REFERENCE_VALUES && ref instanceof PsiReferenceExpression) {
            return;
        }
        if (ConstantValueInspection.shouldBeSuppressed((PsiElement)ref) || constant == ConstantResult.UNKNOWN) {
            return;
        }
        String presentableName = constant.toString();
        if (Integer.valueOf(0).equals(constant.value()) && !ConstantValueInspection.shouldReportZero(ref)) {
            return;
        }
        SmartList fixes = new SmartList();
        if (constant.value() instanceof Boolean) {
            fixes.add(ConstantValueInspection.createSimplifyBooleanExpressionFix((PsiElement)ref, (Boolean)constant.value()));
        } else {
            ReplaceWithConstantValueFix action = new ReplaceWithConstantValueFix(ref, presentableName, presentableName);
            fixes.add(LocalQuickFix.from((ModCommandAction)action));
        }
        Object value = constant.value();
        boolean isAssertion = ConstantValueInspection.isAssertionEffectively(ref, constant);
        if (isAssertion && this.DONT_REPORT_TRUE_ASSERT_STATEMENTS) {
            return;
        }
        if (value instanceof Boolean) {
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)ConstantValueInspection.createReplaceWithNullCheckFix((PsiElement)ref, (Boolean)value));
        }
        if (reporter.isOnTheFly()) {
            if (ref instanceof PsiReferenceExpression) {
                fixes.add(LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)this, "REPORT_CONSTANT_REFERENCE_VALUES", JavaAnalysisBundle.message((String)"inspection.data.flow.turn.off.constant.references.quickfix", (Object[])new Object[0]), false)));
            }
            if (isAssertion) {
                fixes.add(LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)this, "DONT_REPORT_TRUE_ASSERT_STATEMENTS", JavaAnalysisBundle.message((String)"inspection.data.flow.turn.off.true.asserts.quickfix", (Object[])new Object[0]), true)));
            }
        }
        ContainerUtil.addIfNotNull((Collection)fixes, (Object)new FindDfaProblemCauseFix(this.IGNORE_ASSERT_STATEMENTS, ref, (TrackingRunner.DfaProblemType)new TrackingRunner.ValueDfaProblemType(value)));
        if (ref instanceof PsiMethodCallExpression || ref instanceof PsiPolyadicExpression || ref instanceof PsiTypeCastExpression) {
            type = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            message = JavaAnalysisBundle.message((String)"dataflow.message.constant.expression", (Object[])new Object[]{presentableName});
        } else {
            type = ProblemHighlightType.WEAK_WARNING;
            message = JavaAnalysisBundle.message((String)"dataflow.message.constant.value", (Object[])new Object[]{presentableName});
        }
        reporter.registerProblem((PsiElement)ref, message, type, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static boolean isCoveredBySurroundingFix(PsiElement anchor, boolean evaluatesToTrue) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)anchor.getParent());
        if (parent instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)parent;
            IElementType tokenType = polyadic.getOperationTokenType();
            return tokenType.equals(JavaTokenType.ANDAND) && !evaluatesToTrue || tokenType.equals(JavaTokenType.OROR) && evaluatesToTrue;
        }
        return parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)((PsiExpression)parent));
    }

    private static boolean isCondition(@NotNull PsiExpression expression) {
        PsiType type;
        if (expression == null) {
            ConstantValueInspection.$$$reportNull$$$0(8);
        }
        if ((type = expression.getType()) == null || !PsiTypes.booleanType().isAssignableFrom(type)) {
            return false;
        }
        if (!(expression instanceof PsiMethodCallExpression) && !(expression instanceof PsiReferenceExpression)) {
            return true;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (parent instanceof PsiStatement) {
            return !(parent instanceof PsiReturnStatement);
        }
        if (parent instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)parent;
            IElementType tokenType = polyadic.getOperationTokenType();
            return tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR) || tokenType.equals(JavaTokenType.AND) || tokenType.equals(JavaTokenType.OR);
        }
        if (parent instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)parent;
            return PsiTreeUtil.isAncestor((PsiElement)conditional.getCondition(), (PsiElement)expression, (boolean)false);
        }
        return PsiUtil.isAccessedForWriting((PsiExpression)expression);
    }

    @Contract(value="null -> false")
    private static boolean shouldBeSuppressed(PsiElement anchor) {
        PsiMethodCallExpression call;
        PsiPrefixExpression prefix;
        PsiBinaryExpression binOp;
        PsiSwitchExpression switchExpression;
        PsiField field;
        PsiClass containingClass;
        PsiElement psiElement;
        PsiReferenceExpression ref;
        PsiTypeCastExpression cast;
        if (!(anchor instanceof PsiExpression)) {
            return false;
        }
        PsiExpression expression = (PsiExpression)anchor;
        if (anchor instanceof PsiAssignmentExpression || anchor instanceof PsiTypeCastExpression && !((cast = (PsiTypeCastExpression)anchor).getType() instanceof PsiPrimitiveType)) {
            return true;
        }
        if (anchor instanceof PsiConditionalExpression) {
            return true;
        }
        if (expression instanceof PsiReferenceExpression && ("TRUE".equals((ref = (PsiReferenceExpression)expression).getReferenceName()) || "FALSE".equals(ref.getReferenceName())) && (psiElement = ref.resolve()) instanceof PsiField && (containingClass = (field = (PsiField)psiElement).getContainingClass()) != null && "java.lang.Boolean".equals(containingClass.getQualifiedName())) {
            return true;
        }
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binOp2 = (PsiBinaryExpression)expression;
            PsiExpression lOperand = binOp2.getLOperand();
            PsiExpression rOperand = binOp2.getROperand();
            IElementType tokenType = binOp2.getOperationTokenType();
            if (rOperand == null) {
                return true;
            }
            PsiType lType = lOperand.getType();
            PsiType rType = rOperand.getType();
            if (lType == null || rType == null) {
                return true;
            }
            if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)tokenType, (PsiType)lType, (PsiType)rType, (boolean)false)) {
                return true;
            }
        }
        if (expression instanceof PsiInstanceOfExpression) {
            PsiTypeElement checkType;
            PsiTypeTestPattern typeTestPattern;
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)expression;
            PsiType type = instanceOf.getOperand().getType();
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)instanceOf);
            if (!(type != null && (TypeConstraints.instanceOf((PsiType)type).isResolved() || JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS.isSufficient(languageLevel) && type instanceof PsiPrimitiveType))) {
                return true;
            }
            PsiPrimaryPattern pattern = instanceOf.getPattern();
            if (pattern instanceof PsiTypeTestPattern && (typeTestPattern = (PsiTypeTestPattern)pattern).getPatternVariable() != null && (checkType = typeTestPattern.getCheckType()) != null && checkType.getType().isAssignableFrom(type) && !JavaFeature.PATTERN_GUARDS_AND_RECORD_PATTERNS.isSufficient(languageLevel)) {
                return true;
            }
        }
        if (expression instanceof PsiSwitchExpression && ConstantValueInspection.containsImmediateThrowStatement(switchExpression = (PsiSwitchExpression)expression)) {
            return true;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (parent instanceof PsiBinaryExpression && ExpressionUtils.getValueComparedWithNull((PsiBinaryExpression)(binOp = (PsiBinaryExpression)parent)) != null) {
            return true;
        }
        if (parent instanceof PsiPrefixExpression && (prefix = (PsiPrefixExpression)parent).getOperationTokenType().equals(JavaTokenType.EXCL)) {
            return true;
        }
        if (ExpressionUtils.isVoidContext((PsiExpression)expression) || ConstantValueInspection.isDereferenceContext(expression)) {
            return true;
        }
        if (TypeUtils.typeEquals((String)"java.lang.Void", (PsiType)expression.getType())) {
            return true;
        }
        if (ConstantValueInspection.isFlagCheck(anchor)) {
            return true;
        }
        if (!ConstantValueInspection.isCondition(expression) && expression instanceof PsiMethodCallExpression) {
            PsiMethod method;
            PsiMethodCallExpression call2 = (PsiMethodCallExpression)expression;
            List contracts = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call2);
            ContractReturnValue value = JavaMethodContractUtil.getNonFailingReturnValue((List)contracts);
            if (value != null) {
                return true;
            }
            if (!(parent instanceof PsiAssignmentExpression || parent instanceof PsiVariable || parent instanceof PsiReturnStatement || (method = call2.resolveMethod()) != null && JavaMethodContractUtil.isPure((PsiMethod)method))) {
                return true;
            }
        }
        if (new PointlessBooleanExpressionInspection().getExpressionKind(expression) != PointlessBooleanExpressionInspection.BooleanExpressionKind.UNKNOWN) {
            return true;
        }
        while (expression != null && BoolUtils.isNegation((PsiExpression)expression)) {
            expression = BoolUtils.getNegated((PsiExpression)expression);
        }
        if (expression == null) {
            return false;
        }
        if (!ConstantValueInspection.isCondition(expression) && expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref2 = (PsiReferenceExpression)expression;
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)ref2.resolve(), PsiVariable.class);
            if (variable instanceof PsiField && variable.hasModifierProperty("static") && ExpressionUtils.isNullLiteral((PsiExpression)PsiFieldImpl.getDetachedInitializer((PsiVariable)variable))) {
                return true;
            }
            if (variable instanceof PsiLocalVariable && variable.hasInitializer()) {
                boolean effectivelyFinal = variable.hasModifierProperty("final") || !VariableAccessUtils.variableIsAssigned((PsiVariable)variable, (PsiElement)PsiUtil.getVariableCodeBlock((PsiVariable)variable, null));
                return effectivelyFinal && PsiUtil.isConstantExpression((PsiExpression)variable.getInitializer());
            }
            return false;
        }
        return expression instanceof PsiMethodCallExpression && EqualsWithItselfInspection.isEqualsWithItself((PsiMethodCallExpression)(call = (PsiMethodCallExpression)expression)) || expression instanceof PsiBinaryExpression && ComparisonToNaNInspection.extractNaNFromComparison((PsiBinaryExpression)(binOp = (PsiBinaryExpression)expression)) != null;
    }

    private static boolean containsImmediateThrowStatement(PsiSwitchExpression expression) {
        Ref ref = Ref.create();
        ref.set((Object)false);
        ControlFlowUtils.processElementsInCurrentScope((PsiElement)expression, element -> {
            PsiMethodCallExpression methodCallExpression;
            List contracts;
            if (element instanceof PsiThrowStatement) {
                ref.set((Object)true);
                return false;
            }
            if (element instanceof PsiMethodCallExpression && ContainerUtil.exists((Iterable)(contracts = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)(methodCallExpression = (PsiMethodCallExpression)element))), contract -> contract.isTrivial() && contract.getReturnValue().isFail())) {
                ref.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)ref.get();
    }

    private static boolean isDereferenceContext(PsiExpression ref) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)ref.getParent());
        return parent instanceof PsiReferenceExpression || parent instanceof PsiArrayAccessExpression || parent instanceof PsiSwitchStatement || parent instanceof PsiSynchronizedStatement;
    }

    static boolean isFlagCheck(PsiElement element) {
        PsiExpression topExpression;
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiVariable.class});
        if (scope instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)scope;
            v0 = ifStatement.getCondition();
        } else if (scope instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)scope;
            v0 = variable.getInitializer();
        } else {
            v0 = topExpression = null;
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)topExpression, (PsiElement)element, (boolean)false)) {
            return false;
        }
        return StreamEx.ofTree((Object)topExpression, e -> StreamEx.of((Object[])e.getChildren())).anyMatch(ConstantValueInspection::isCompileTimeFlagCheck);
    }

    private static boolean isCompileTimeFlagCheck(PsiElement element) {
        PsiBinaryExpression binOp;
        if (element instanceof PsiBinaryExpression && ComparisonUtils.isComparisonOperation((IElementType)(binOp = (PsiBinaryExpression)element).getOperationTokenType())) {
            PsiBinaryExpression subOp;
            PsiExpression comparedWith = null;
            if (ExpressionUtils.isLiteral((PsiExpression)binOp.getROperand())) {
                comparedWith = binOp.getLOperand();
            } else if (ExpressionUtils.isLiteral((PsiExpression)binOp.getLOperand())) {
                comparedWith = binOp.getROperand();
            }
            comparedWith = PsiUtil.skipParenthesizedExprDown((PsiExpression)comparedWith);
            if (ConstantValueInspection.isConstantOfType((PsiElement)comparedWith, PsiTypes.intType(), PsiTypes.longType())) {
                return true;
            }
            if (comparedWith instanceof PsiBinaryExpression && (subOp = (PsiBinaryExpression)comparedWith).getOperationTokenType().equals(JavaTokenType.AND)) {
                PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)subOp.getLOperand());
                PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)subOp.getROperand());
                if (ConstantValueInspection.isConstantOfType((PsiElement)left, PsiTypes.intType(), PsiTypes.longType()) || ConstantValueInspection.isConstantOfType((PsiElement)right, PsiTypes.intType(), PsiTypes.longType())) {
                    return true;
                }
            }
        }
        return ConstantValueInspection.isConstantOfType(element, PsiTypes.booleanType());
    }

    private static boolean isConstantOfType(PsiElement element, PsiPrimitiveType ... types) {
        PsiReferenceExpression ref;
        PsiElement psiElement;
        if (!(element instanceof PsiReferenceExpression) || !((psiElement = (ref = (PsiReferenceExpression)element).resolve()) instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)psiElement;
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null || !modifierList.hasModifierProperty("static") || !modifierList.hasModifierProperty("final")) {
            return false;
        }
        if (!ArrayUtil.contains((Object)field.getType(), (Object[])types)) {
            return false;
        }
        return field.hasInitializer() && PsiUtil.isConstantExpression((PsiExpression)field.getInitializer());
    }

    private static boolean isAtRHSOfBooleanAnd(PsiElement expr) {
        PsiElement cur = expr;
        while (cur != null && !(cur instanceof PsiMember)) {
            PsiBinaryExpression binOp;
            PsiElement parent = cur.getParent();
            if (parent instanceof PsiBinaryExpression && cur == (binOp = (PsiBinaryExpression)parent).getROperand()) {
                return true;
            }
            cur = parent;
        }
        return false;
    }

    private void reportConstantBoolean(ProblemsHolder reporter, PsiElement psiAnchor, boolean evaluatesToTrue) {
        PsiAssignmentExpression assignment;
        PsiExpression expr;
        boolean isAssertion;
        while (psiAnchor instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesized = (PsiParenthesizedExpression)psiAnchor;
            psiAnchor = parenthesized.getExpression();
        }
        if (psiAnchor == null || ConstantValueInspection.shouldBeSuppressed(psiAnchor)) {
            return;
        }
        boolean bl = isAssertion = psiAnchor instanceof PsiExpression && DfaPsiUtil.isAssertionEffectively((PsiExpression)(expr = (PsiExpression)psiAnchor), (boolean)evaluatesToTrue);
        if (this.DONT_REPORT_TRUE_ASSERT_STATEMENTS && isAssertion) {
            return;
        }
        PsiElement psiElement = PsiUtil.skipParenthesizedExprUp((PsiElement)psiAnchor.getParent());
        if (psiElement instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)(assignment = (PsiAssignmentExpression)psiElement).getLExpression(), (PsiElement)psiAnchor, (boolean)false)) {
            IElementType tokenType = assignment.getOperationTokenType();
            if ((tokenType.equals(JavaTokenType.ANDEQ) || tokenType.equals(JavaTokenType.OREQ)) && ConstantValueInspection.isFlagSetChain(assignment.getLExpression(), tokenType.equals(JavaTokenType.ANDEQ))) {
                return;
            }
            reporter.registerProblem(psiAnchor, JavaAnalysisBundle.message((String)"dataflow.message.pointless.assignment.expression", (Object[])new Object[]{Boolean.toString(evaluatesToTrue)}), ConstantValueInspection.createConditionalAssignmentFixes(evaluatesToTrue, assignment, reporter.isOnTheFly()));
            return;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (!ConstantValueInspection.isCoveredBySurroundingFix(psiAnchor, evaluatesToTrue)) {
            ContainerUtil.addIfNotNull(fixes, (Object)ConstantValueInspection.createSimplifyBooleanExpressionFix(psiAnchor, evaluatesToTrue));
            if (isAssertion && reporter.isOnTheFly()) {
                fixes.add(LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)this, "DONT_REPORT_TRUE_ASSERT_STATEMENTS", JavaAnalysisBundle.message((String)"inspection.data.flow.turn.off.true.asserts.quickfix", (Object[])new Object[0]), true)));
            }
            ContainerUtil.addIfNotNull(fixes, (Object)ConstantValueInspection.createReplaceWithNullCheckFix(psiAnchor, evaluatesToTrue));
        }
        if (psiAnchor instanceof PsiExpression) {
            PsiExpression expression = (PsiExpression)psiAnchor;
            ContainerUtil.addIfNotNull(fixes, (Object)new FindDfaProblemCauseFix(this.IGNORE_ASSERT_STATEMENTS, expression, (TrackingRunner.DfaProblemType)new TrackingRunner.ValueDfaProblemType((Object)evaluatesToTrue)));
        }
        String message = JavaAnalysisBundle.message((String)(ConstantValueInspection.isAtRHSOfBooleanAnd(psiAnchor) ? "dataflow.message.constant.condition.when.reached" : "dataflow.message.constant.condition"), (Object[])new Object[]{evaluatesToTrue ? 1 : 0});
        reporter.registerProblem(psiAnchor, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static boolean isFlagSetChain(@NotNull PsiExpression expression, boolean isAnd) {
        PsiLocalVariable local;
        if (expression == null) {
            ConstantValueInspection.$$$reportNull$$$0(9);
        }
        if ((local = ExpressionUtils.resolveLocalVariable((PsiExpression)expression)) == null) {
            return false;
        }
        PsiExpression initializer = local.getInitializer();
        if (!ExpressionUtils.isLiteral((PsiElement)initializer, (Object)isAnd)) {
            return false;
        }
        PsiElement psiElement = PsiUtil.getVariableCodeBlock((PsiVariable)local, null);
        if (!(psiElement instanceof PsiCodeBlock)) {
            return false;
        }
        PsiCodeBlock block = (PsiCodeBlock)psiElement;
        PsiElement[] defs = DefUseUtil.getDefs((PsiCodeBlock)block, (PsiVariable)local, (PsiElement)expression.getParent());
        return defs.length == 1 && defs[0] == local && VariableAccessUtils.getVariableReferences((PsiVariable)local).stream().filter(PsiUtil::isAccessedForWriting).limit(2L).count() > 1L;
    }

    @Nullable
    private static LocalQuickFix createSimplifyBooleanExpressionFix(PsiElement element, boolean value) {
        return LocalQuickFix.from((ModCommandAction)ConstantValueInspection.createSimplifyBooleanFix(element, value));
    }

    private static LocalQuickFix createReplaceWithNullCheckFix(PsiElement psiAnchor, boolean evaluatesToTrue) {
        if (!(psiAnchor instanceof PsiExpression)) {
            return null;
        }
        PsiExpression expr = (PsiExpression)psiAnchor;
        boolean negated = false;
        if (BoolUtils.isNegation((PsiExpression)expr)) {
            expr = BoolUtils.getNegated((PsiExpression)expr);
            negated = true;
        }
        if (evaluatesToTrue != negated) {
            return null;
        }
        if (!(expr instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expr;
        if (!MethodCallUtils.isEqualsCall((PsiMethodCallExpression)call)) {
            return null;
        }
        PsiExpression arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
        if (!ExpressionUtils.isNullLiteral((PsiExpression)arg)) {
            return null;
        }
        return EqualsToEqualityFix.buildFix((PsiMethodCallExpression)call, (boolean)negated);
    }

    private static LocalQuickFix @NotNull [] createConditionalAssignmentFixes(boolean evaluatesToTrue, @NotNull PsiAssignmentExpression assignment, boolean onTheFly) {
        IElementType op;
        boolean toRemove;
        if (assignment == null) {
            ConstantValueInspection.$$$reportNull$$$0(10);
        }
        boolean bl = toRemove = (op = assignment.getOperationTokenType()) == JavaTokenType.ANDEQ && !evaluatesToTrue || op == JavaTokenType.OREQ && evaluatesToTrue;
        if (toRemove && !onTheFly) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                ConstantValueInspection.$$$reportNull$$$0(11);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
        Object object = localQuickFixArray[0] = toRemove ? new RemoveAssignmentFix() : new SimplifyToAssignmentFix();
        if (localQuickFixArray == null) {
            ConstantValueInspection.$$$reportNull$$$0(12);
        }
        return localQuickFixArray;
    }

    private static SimplifyBooleanExpressionFix createSimplifyBooleanFix(PsiElement element, boolean value) {
        if (!(element instanceof PsiExpression)) {
            return null;
        }
        PsiExpression expression = (PsiExpression)element;
        if (PsiTreeUtil.findChildOfType((PsiElement)element, PsiAssignmentExpression.class) != null) {
            return null;
        }
        while (element.getParent() instanceof PsiExpression) {
            element = element.getParent();
        }
        SimplifyBooleanExpressionFix fix = new SimplifyBooleanExpressionFix(expression, value);
        if (!fix.isAvailable(expression) || SimplifyBooleanExpressionFix.canBeSimplified((PsiExpression)expression) && expression instanceof PsiLiteralExpression) {
            return null;
        }
        return fix;
    }

    private static boolean isAssertionEffectively(@NotNull PsiExpression anchor, ConstantResult result) {
        Object value;
        if (anchor == null) {
            ConstantValueInspection.$$$reportNull$$$0(13);
        }
        if ((value = result.value()) instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return DfaPsiUtil.isAssertionEffectively((PsiExpression)anchor, (boolean)booleanValue);
        }
        if (value != null) {
            return false;
        }
        return DfaPsiUtil.isAssertCallArgument((PsiElement)anchor, (ContractValue)ContractValue.nullValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ConstantValueInspection";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfr";
                break;
            }
            case 3: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ConstantValueInspection";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createConditionalAssignmentFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processAnchor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCondition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFlagSetChain";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createConditionalAssignmentFixes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAssertionEffectively";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13 -> new IllegalArgumentException(string);
        };
    }

    private static enum ConstantResult {
        TRUE,
        FALSE,
        NULL,
        ZERO,
        UNKNOWN;


        @NotNull
        public String toString() {
            String string = this == ZERO ? "0" : StringUtil.toLowerCase((String)this.name());
            if (string == null) {
                ConstantResult.$$$reportNull$$$0(0);
            }
            return string;
        }

        public Object value() {
            return switch (this.ordinal()) {
                case 0 -> Boolean.TRUE;
                case 1 -> Boolean.FALSE;
                case 3 -> Integer.valueOf(0);
                case 2 -> null;
                default -> throw new UnsupportedOperationException();
            };
        }

        @NotNull
        public static ConstantResult fromDfType(@NotNull DfType dfType) {
            if (dfType == null) {
                ConstantResult.$$$reportNull$$$0(1);
            }
            if (dfType == DfTypes.NULL) {
                ConstantResult constantResult = NULL;
                if (constantResult == null) {
                    ConstantResult.$$$reportNull$$$0(2);
                }
                return constantResult;
            }
            if (dfType == DfTypes.TRUE) {
                ConstantResult constantResult = TRUE;
                if (constantResult == null) {
                    ConstantResult.$$$reportNull$$$0(3);
                }
                return constantResult;
            }
            if (dfType == DfTypes.FALSE) {
                ConstantResult constantResult = FALSE;
                if (constantResult == null) {
                    ConstantResult.$$$reportNull$$$0(4);
                }
                return constantResult;
            }
            if (dfType.isConst((Object)0) || dfType.isConst((Object)0L)) {
                ConstantResult constantResult = ZERO;
                if (constantResult == null) {
                    ConstantResult.$$$reportNull$$$0(5);
                }
                return constantResult;
            }
            ConstantResult constantResult = UNKNOWN;
            if (constantResult == null) {
                ConstantResult.$$$reportNull$$$0(6);
            }
            return constantResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/ConstantValueInspection$ConstantResult";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dfType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/ConstantValueInspection$ConstantResult";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromDfType";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fromDfType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

