/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.daemon.impl.quickfix.UnwrapSwitchLabelFix;
import com.intellij.codeInsight.options.JavaInspectionButtons;
import com.intellij.codeInsight.options.JavaInspectionControls;
import com.intellij.codeInspection.AddAssertNonNullFromTestFrameworksFix;
import com.intellij.codeInspection.AddAssertStatementFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.RemoveAssignmentFix;
import com.intellij.codeInspection.ReplaceComputeWithComputeIfPresentFix;
import com.intellij.codeInspection.ReplaceTypeInCastFix;
import com.intellij.codeInspection.ReplaceWithTernaryOperatorFix;
import com.intellij.codeInspection.StreamFilterNotNullFix;
import com.intellij.codeInspection.SurroundWithIfFix;
import com.intellij.codeInspection.WrapWithMutableCollectionFix;
import com.intellij.codeInspection.dataFlow.DataFlowInspectionBase;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.TrackingRunner;
import com.intellij.codeInspection.dataFlow.fix.BoxPrimitiveInTernaryFix;
import com.intellij.codeInspection.dataFlow.fix.DeleteSwitchLabelFix;
import com.intellij.codeInspection.dataFlow.fix.FindDfaProblemCauseFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithBooleanEqualsFix;
import com.intellij.codeInspection.dataFlow.fix.SurroundWithRequireNonNullFix;
import com.intellij.codeInspection.nullable.NullableStuffInspection;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.dataflow.CreateNullBranchFix;
import com.siyeh.ig.fixes.IntroduceVariableFix;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataFlowInspection
extends DataFlowInspectionBase {
    private static final Logger LOG = Logger.getInstance(DataFlowInspection.class);

    protected LocalQuickFix createMutabilityViolationFix(PsiElement violation) {
        return WrapWithMutableCollectionFix.createFix((PsiElement)violation);
    }

    @Nullable
    protected LocalQuickFix createExplainFix(PsiExpression anchor, TrackingRunner.DfaProblemType problemType) {
        return new FindDfaProblemCauseFix(this.IGNORE_ASSERT_STATEMENTS, anchor, problemType);
    }

    @Nullable
    protected LocalQuickFix createUnwrapSwitchLabelFix() {
        return new UnwrapSwitchLabelFix();
    }

    protected LocalQuickFix createIntroduceVariableFix() {
        return new IntroduceVariableFix(true);
    }

    @Nullable
    protected LocalQuickFix createDeleteLabelFix(PsiCaseLabelElement label) {
        return LocalQuickFix.from((ModCommandAction)new DeleteSwitchLabelFix(label, true));
    }

    private static boolean isVolatileFieldReference(PsiExpression qualifier) {
        PsiElement target = qualifier instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifier).resolve() : null;
        return target instanceof PsiField && ((PsiField)target).hasModifierProperty("volatile");
    }

    @NotNull
    protected @NotNull List<@NotNull LocalQuickFix> createMethodReferenceNPEFixes(PsiMethodReferenceExpression methodRef, boolean onTheFly) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        ContainerUtil.addIfNotNull(fixes, (Object)StreamFilterNotNullFix.makeFix((PsiElement)methodRef));
        if (onTheFly) {
            fixes.add((LocalQuickFix)new ReplaceWithTernaryOperatorFix.ReplaceMethodRefWithTernaryOperatorFix());
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            DataFlowInspection.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    protected LocalQuickFix createRemoveAssignmentFix(PsiAssignmentExpression assignment) {
        if (assignment == null || assignment.getRExpression() == null || !(assignment.getParent() instanceof PsiExpressionStatement)) {
            return null;
        }
        return new RemoveAssignmentFix();
    }

    @NotNull
    protected @NotNull List<@NotNull LocalQuickFix> createCastFixes(PsiTypeCastExpression castExpression, PsiType realType, boolean onTheFly, boolean alwaysFails) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        PsiExpression operand = castExpression.getOperand();
        PsiTypeElement typeElement = castExpression.getCastType();
        if (typeElement != null && operand != null) {
            PsiType operandType;
            if (!alwaysFails && !SideEffectChecker.mayHaveSideEffects((PsiExpression)operand) && CodeBlockSurrounder.canSurround((PsiExpression)castExpression)) {
                String suffix = " instanceof " + typeElement.getText();
                fixes.add((LocalQuickFix)new AddAssertStatementFix(ParenthesesUtils.getText((PsiExpression)operand, (int)8) + suffix));
                if (SurroundWithIfFix.isAvailable((PsiExpression)operand)) {
                    fixes.add((LocalQuickFix)new SurroundWithIfFix(operand, suffix));
                }
            }
            if (realType != null && (operandType = operand.getType()) != null) {
                PsiType type = typeElement.getType();
                PsiType[] types = new PsiType[]{realType};
                if (realType instanceof PsiIntersectionType) {
                    types = ((PsiIntersectionType)realType).getConjuncts();
                }
                for (PsiType psiType : types) {
                    if (psiType.isAssignableFrom(operandType)) continue;
                    psiType = DfaPsiUtil.tryGenerify((PsiExpression)operand, (PsiType)psiType);
                    fixes.add((LocalQuickFix)new ReplaceTypeInCastFix(type, psiType));
                }
            }
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            DataFlowInspection.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    protected @NotNull List<@NotNull LocalQuickFix> createNPEFixes(@Nullable PsiExpression qualifier, PsiExpression expression, boolean onTheFly, boolean alwaysNull) {
        qualifier = PsiUtil.deparenthesizeExpression((PsiExpression)qualifier);
        SmartList fixes = new SmartList();
        if (qualifier == null || expression == null) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                DataFlowInspection.$$$reportNull$$$0(2);
            }
            return list;
        }
        try {
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)StreamFilterNotNullFix.makeFix((PsiElement)qualifier));
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)ReplaceComputeWithComputeIfPresentFix.makeFix((PsiElement)qualifier));
            if (DataFlowInspection.isVolatileFieldReference(qualifier)) {
                ContainerUtil.addIfNotNull((Collection)fixes, (Object)this.createIntroduceVariableFix());
            } else if (!alwaysNull && !SideEffectChecker.mayHaveSideEffects((PsiExpression)qualifier)) {
                String suffix = " != null";
                AddAssertNonNullFromTestFrameworksFix.Variant testFrameworkFixVariant = AddAssertNonNullFromTestFrameworksFix.isAvailable((PsiExpression)expression);
                if (testFrameworkFixVariant != null) {
                    fixes.add(new AddAssertNonNullFromTestFrameworksFix(qualifier, testFrameworkFixVariant));
                } else if (PsiUtil.isAvailable((JavaFeature)JavaFeature.ASSERTIONS, (PsiElement)qualifier) && CodeBlockSurrounder.canSurround((PsiExpression)expression)) {
                    String replacement = ParenthesesUtils.getText((PsiExpression)qualifier, (int)9) + suffix;
                    fixes.add(new AddAssertStatementFix(replacement));
                }
                if (SurroundWithIfFix.isAvailable((PsiExpression)qualifier)) {
                    fixes.add(new SurroundWithIfFix(qualifier, suffix));
                }
                if (onTheFly && ReplaceWithTernaryOperatorFix.isAvailable((PsiExpression)qualifier, (PsiExpression)expression)) {
                    fixes.add(new ReplaceWithTernaryOperatorFix(qualifier));
                }
            }
            if (!alwaysNull && PsiUtil.isAvailable((JavaFeature)JavaFeature.OBJECTS_CLASS, (PsiElement)qualifier)) {
                fixes.add(new SurroundWithRequireNonNullFix(qualifier));
            }
            if (!ExpressionUtils.isNullLiteral((PsiExpression)qualifier)) {
                ContainerUtil.addIfNotNull((Collection)fixes, (Object)this.createExplainFix(qualifier, (TrackingRunner.DfaProblemType)new TrackingRunner.NullableDfaProblemType()));
            }
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)DfaOptionalSupport.registerReplaceOptionalOfWithOfNullableFix((PsiExpression)qualifier));
            DataFlowInspection.addCreateNullBranchFix(qualifier, (List<? super LocalQuickFix>)fixes);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        SmartList smartList = fixes;
        if (smartList == null) {
            DataFlowInspection.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @NotNull
    protected @NotNull List<@NotNull LocalQuickFix> createUnboxingNullableFixes(@NotNull PsiExpression qualifier, PsiElement anchor, boolean onTheFly) {
        if (qualifier == null) {
            DataFlowInspection.$$$reportNull$$$0(4);
        }
        SmartList result = new SmartList();
        if (TypeConversionUtil.isBooleanType((PsiType)qualifier.getType())) {
            result.add(new ReplaceWithBooleanEqualsFix(qualifier));
        }
        ContainerUtil.addIfNotNull((Collection)result, (Object)BoxPrimitiveInTernaryFix.makeFix((PsiExpression)((PsiExpression)ObjectUtils.tryCast((Object)anchor, PsiExpression.class))));
        DataFlowInspection.addCreateNullBranchFix(qualifier, (List<? super LocalQuickFix>)result);
        SmartList smartList = result;
        if (smartList == null) {
            DataFlowInspection.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    private static void addCreateNullBranchFix(@NotNull PsiExpression qualifier, @NotNull @NotNull List<? super @NotNull LocalQuickFix> fixes) {
        PsiSwitchBlock block;
        if (qualifier == null) {
            DataFlowInspection.$$$reportNull$$$0(6);
        }
        if (fixes == null) {
            DataFlowInspection.$$$reportNull$$$0(7);
        }
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.PATTERNS_IN_SWITCH, (PsiElement)qualifier)) {
            return;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)qualifier.getParent());
        if (parent instanceof PsiSwitchBlock && PsiUtil.skipParenthesizedExprDown((PsiExpression)(block = (PsiSwitchBlock)parent).getExpression()) == qualifier) {
            fixes.add((LocalQuickFix)LocalQuickFix.from((ModCommandAction)new CreateNullBranchFix(block)));
        }
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter) {
        return new NullableStuffInspection.NavigateToNullLiteralArguments(parameter);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"SUGGEST_NULLABLE_ANNOTATIONS", (String)JavaBundle.message((String)"inspection.data.flow.nullable.quickfix.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"TREAT_UNKNOWN_MEMBERS_AS_NULLABLE", (String)JavaBundle.message((String)"inspection.data.flow.treat.non.annotated.members.and.parameters.as.nullable", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER", (String)JavaBundle.message((String)"inspection.data.flow.report.not.null.required.parameter.with.null.literal.argument.usages", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL", (String)JavaBundle.message((String)"inspection.data.flow.report.nullable.methods.that.always.return.a.non.null.value", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"IGNORE_ASSERT_STATEMENTS", (String)JavaBundle.message((String)"inspection.data.flow.ignore.assert.statements", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"REPORT_UNSOUND_WARNINGS", (String)JavaBundle.message((String)"inspection.data.flow.report.problems.that.happen.only.on.some.code.paths", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), JavaInspectionControls.button((JavaInspectionButtons.ButtonKind)JavaInspectionButtons.ButtonKind.NULLABILITY_ANNOTATIONS)});
        if (optPane == null) {
            DataFlowInspection.$$$reportNull$$$0(8);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspection";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodReferenceNPEFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCastFixes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNPEFixes";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnboxingNullableFixes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUnboxingNullableFixes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCreateNullBranchFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

