/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.ConstantValueInspection;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnreachableCodeInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean ignoreTrivialReturns = true;
    public boolean respectConstantValueSuppression = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreTrivialReturns", (String)JavaBundle.message((String)"inspection.data.flow.unreachable.code.option.ignore.trivial.name", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(HtmlChunk.raw((String)JavaBundle.message((String)"inspection.data.flow.unreachable.code.option.ignore.trivial.description", (Object[])new Object[0]))), OptPane.checkbox((String)"respectConstantValueSuppression", (String)JavaBundle.message((String)"inspection.data.flow.unreachable.code.option.respect.suppression.name", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(HtmlChunk.raw((String)JavaBundle.message((String)"inspection.data.flow.unreachable.code.option.respect.suppression.description", (Object[])new Object[0])))});
        if (optPane == null) {
            UnreachableCodeInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnreachableCodeInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.processElement((PsiElement)aClass);
            }

            public void visitMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!method.isConstructor()) {
                    this.processElement((PsiElement)method);
                }
            }

            private void processElement(@NotNull PsiElement element) {
                CommonDataflow.DataflowResult result;
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((result = CommonDataflow.getDataflowResult((PsiElement)element)) == null) {
                    return;
                }
                PsiFile file = holder.getFile();
                for (TextRange range : result.getUnreachableRanges()) {
                    PsiElement psiElement;
                    for (psiElement = file.findElementAt(range.getStartOffset()); psiElement != null && !psiElement.getTextRange().contains(range); psiElement = psiElement.getParent()) {
                    }
                    if (psiElement == null || psiElement.getTextRange().equals((Object)range) && this.shouldSuppress(psiElement) || element != StreamEx.iterate((Object)psiElement, Objects::nonNull, PsiElement::getParent).findFirst(e -> {
                        PsiMethod method;
                        return e instanceof PsiClass || e instanceof PsiMethod && !(method = (PsiMethod)e).isConstructor();
                    }).orElse(null)) continue;
                    holder.registerProblem(psiElement, range.shiftLeft(psiElement.getTextRange().getStartOffset()), JavaBundle.message((String)"inspection.data.flow.unreachable.code.display.name", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            private boolean shouldSuppress(PsiElement psiElement) {
                PsiSwitchLabeledRuleStatement rule;
                PsiElement psiElement2;
                PsiExpressionStatement statement;
                if (psiElement instanceof PsiExpressionStatement && 1.isTrivialExpression((statement = (PsiExpressionStatement)psiElement).getExpression()) && (psiElement2 = psiElement.getParent()) instanceof PsiSwitchLabeledRuleStatement && (rule = (PsiSwitchLabeledRuleStatement)psiElement2).isDefaultCase()) {
                    return true;
                }
                Condition condition = 1.findCondition(psiElement);
                if (condition != null) {
                    if (ConstantValueInspection.isFlagCheck((PsiElement)condition.expression)) {
                        return true;
                    }
                    if (UnreachableCodeInspection.this.respectConstantValueSuppression && (SuppressionUtil.isSuppressed((PsiElement)condition.expression, (String)"ConstantValue") || SuppressionUtil.isSuppressed((PsiElement)condition.expression, (String)"ConstantConditions"))) {
                        return true;
                    }
                }
                if (psiElement instanceof PsiCodeBlock) {
                    PsiCodeBlock block = (PsiCodeBlock)psiElement;
                    PsiElement psiElement3 = block.getParent();
                    if (psiElement3 instanceof PsiCatchSection) {
                        PsiCatchSection catchSection = (PsiCatchSection)psiElement3;
                        PsiType type = catchSection.getCatchType();
                        if (1.mayCover(type, "java.lang.LinkageError") || 1.mayCover(type, "java.lang.VirtualMachineError")) {
                            return true;
                        }
                    } else if (block.getStatementCount() == 1) {
                        psiElement = block.getStatements()[0];
                    }
                }
                return psiElement instanceof PsiThrowStatement || UnreachableCodeInspection.this.ignoreTrivialReturns && 1.isTrivialReturn(psiElement);
            }

            @Nullable
            private static Condition findCondition(PsiElement deadCode) {
                PsiExpression condition;
                PsiIfStatement prevIf;
                PsiStatement statement;
                PsiIfStatement ifStatement;
                PsiExpression condition2;
                PsiElement blockStatement;
                PsiCodeBlock block;
                PsiElement psiElement;
                PsiElement psiElement2;
                if (deadCode instanceof PsiExpression && (psiElement2 = deadCode.getParent()) instanceof PsiConditionalExpression) {
                    PsiConditionalExpression ternary = (PsiConditionalExpression)psiElement2;
                    if (ternary.getElseExpression() == deadCode) {
                        return new Condition(false, ternary.getCondition());
                    }
                    if (ternary.getThenExpression() == deadCode) {
                        return new Condition(true, ternary.getCondition());
                    }
                }
                if (deadCode instanceof PsiCodeBlock && (psiElement = (block = (PsiCodeBlock)deadCode).getParent()) instanceof PsiBlockStatement) {
                    deadCode = blockStatement = (PsiBlockStatement)psiElement;
                }
                if ((blockStatement = deadCode.getParent()) instanceof PsiIfStatement && (condition2 = (ifStatement = (PsiIfStatement)blockStatement).getCondition()) != null) {
                    if (ifStatement.getThenBranch() == deadCode) {
                        return new Condition(true, condition2);
                    }
                    if (ifStatement.getElseBranch() == deadCode) {
                        return new Condition(false, condition2);
                    }
                }
                if (deadCode instanceof PsiStatement && (psiElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)(statement = (PsiStatement)deadCode))) instanceof PsiIfStatement && (prevIf = (PsiIfStatement)psiElement).getElseBranch() == null && !ControlFlowUtils.statementMayCompleteNormally((PsiStatement)prevIf.getThenBranch()) && (condition = prevIf.getCondition()) != null) {
                    return new Condition(false, condition);
                }
                return null;
            }

            private static boolean mayCover(PsiType type, String exceptionFqn) {
                if (type == null) {
                    return false;
                }
                if (type instanceof PsiDisjunctionType) {
                    PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                    for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                        if (!1.mayCover(disjunction, exceptionFqn)) continue;
                        return true;
                    }
                    return false;
                }
                if (type instanceof PsiClassType) {
                    PsiClassType classType = (PsiClassType)type;
                    PsiClass psiClass = classType.resolve();
                    if (psiClass == null) {
                        return false;
                    }
                    if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)exceptionFqn)) {
                        return true;
                    }
                    PsiClass exceptionClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(exceptionFqn, psiClass.getResolveScope());
                    if (exceptionClass != null && exceptionClass.isInheritor(psiClass, true)) {
                        return true;
                    }
                }
                return false;
            }

            private static boolean isTrivialReturn(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (element instanceof PsiBreakStatement || element instanceof PsiContinueStatement) {
                    return true;
                }
                if (element instanceof PsiYieldStatement) {
                    PsiYieldStatement yieldStatement = (PsiYieldStatement)element;
                    return 1.isTrivialExpression(yieldStatement.getExpression());
                }
                if (element instanceof PsiReturnStatement) {
                    PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                    return 1.isTrivialExpression(returnStatement.getReturnValue());
                }
                return false;
            }

            private static boolean isTrivialExpression(PsiExpression expression) {
                PsiThisExpression thisExpression;
                if (expression == null) {
                    return true;
                }
                if (expression instanceof PsiThisExpression && (thisExpression = (PsiThisExpression)expression).getQualifier() == null) {
                    return true;
                }
                if (expression instanceof PsiLiteralExpression) {
                    Number number;
                    PsiLiteralExpression literal = (PsiLiteralExpression)expression;
                    Object value = literal.getValue();
                    if (value instanceof Boolean || "".equals(value) || value instanceof Number && (number = (Number)value).doubleValue() == 0.0) {
                        return true;
                    }
                    if (literal.textMatches((CharSequence)"null")) {
                        return true;
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/UnreachableCodeInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processElement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isTrivialReturn";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            record Condition(boolean value, @NotNull PsiExpression expression) {
                @NotNull
                private final PsiExpression expression;

                Condition(boolean value, @NotNull PsiExpression expression) {
                    if (expression == null) {
                        Condition.$$$reportNull$$$0(0);
                    }
                }

                @NotNull
                public PsiExpression expression() {
                    PsiExpression psiExpression = this.expression;
                    if (psiExpression == null) {
                        Condition.$$$reportNull$$$0(1);
                    }
                    return psiExpression;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInspection/dataFlow/UnreachableCodeInspection$1$Condition";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInspection/dataFlow/UnreachableCodeInspection$1$Condition";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "expression";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "<init>";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/UnreachableCodeInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/UnreachableCodeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

