/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.equalsAndHashcode;

import com.intellij.codeInsight.generation.GenerateEqualsHandler;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.equalsAndHashcode.EqualsAndHashcodeBase;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EqualsAndHashcode
extends EqualsAndHashcodeBase {
    protected LocalQuickFix[] buildFixes(boolean isOnTheFly, boolean hasEquals) {
        if (!isOnTheFly) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new GenerateEqualsHashcodeFix(hasEquals)};
    }

    private static class GenerateEqualsHashcodeFix
    implements LocalQuickFix {
        private final boolean myHasEquals;

        GenerateEqualsHashcodeFix(boolean hasEquals) {
            this.myHasEquals = hasEquals;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myHasEquals ? JavaBundle.message((String)"inspection.equals.hashcode.generate.hashcode.quickfix", (Object[])new Object[0]) : JavaBundle.message((String)"inspection.equals.hashcode.generate.equals.quickfix", (Object[])new Object[0]);
            if (string == null) {
                GenerateEqualsHashcodeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Editor editor;
            if (project == null) {
                GenerateEqualsHashcodeFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GenerateEqualsHashcodeFix.$$$reportNull$$$0(2);
            }
            if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) == null) {
                return;
            }
            PsiElement element = descriptor.getPsiElement();
            new GenerateEqualsHandler().invoke(project, editor, element.getContainingFile());
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                GenerateEqualsHashcodeFix.$$$reportNull$$$0(3);
            }
            return currentFile;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                GenerateEqualsHashcodeFix.$$$reportNull$$$0(4);
            }
            if (previewDescriptor == null) {
                GenerateEqualsHashcodeFix.$$$reportNull$$$0(5);
            }
            @Nls String preview = this.myHasEquals ? JavaBundle.message((String)"inspection.equals.hashcode.generate.hashcode.quickfix.preview", (Object[])new Object[0]) : JavaBundle.message((String)"inspection.equals.hashcode.generate.equals.quickfix.preview", (Object[])new Object[0]);
            return new IntentionPreviewInfo.Html(preview);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode$GenerateEqualsHashcodeFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode$GenerateEqualsHashcodeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

