/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IteratorDeclaration;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.CommonJavaInlineUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.IndexedContainer;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Java8ListReplaceAllInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher LIST_SET = CallMatcher.instanceCall((String)"java.util.List", (String[])new String[]{"set"}).parameterTypes(new String[]{"int", "E"});
    public boolean dontWarnInCaseOfMultilineLambda = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"dontWarnInCaseOfMultilineLambda", (String)JavaBundle.message((String)"checkbox.don.t.warn.in.case.of.multiline.lambda", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            Java8ListReplaceAllInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ADVANCED_COLLECTIONS_API);
        if (set == null) {
            Java8ListReplaceAllInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            Java8ListReplaceAllInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            private static boolean isRedundantOperation(PsiExpression replacement, PsiStatement body, CountingLoop countingLoop, IndexedContainer container) {
                PsiLocalVariable counter = countingLoop.getCounter();
                if (ExpressionUtils.isReferenceTo((PsiExpression)container.extractIndexFromGetExpression(replacement), (PsiVariable)counter)) {
                    return true;
                }
                if (!(replacement instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)replacement).resolve(), PsiVariable.class);
                if (variable == null) {
                    return false;
                }
                PsiExpression initializer = variable.getInitializer();
                PsiExpression index = container.extractIndexFromGetExpression(initializer);
                return ExpressionUtils.isReferenceTo((PsiExpression)index, (PsiVariable)counter) && ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)body);
            }

            private static boolean isMultilineLambda(PsiStatement body, PsiStatement[] statements) {
                if (statements.length == 1) {
                    return false;
                }
                if (statements.length > 3) {
                    return true;
                }
                if (Java8ListReplaceAllInspection.getVariableToInline(statements[0], body) == null) {
                    return true;
                }
                return statements.length == 3 && Java8ListReplaceAllInspection.getVariableToInline(statements[1], body) == null;
            }

            public void visitForStatement(@NotNull PsiForStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitForStatement(statement);
                PsiStatement body = statement.getBody();
                PsiStatement[] statements = ControlFlowUtils.unwrapBlock((PsiStatement)body);
                PsiMethodCallExpression maybeSetCall = Java8ListReplaceAllInspection.getLastMethodCall(statements);
                if (!LIST_SET.test(maybeSetCall)) {
                    return;
                }
                if (Java8ListReplaceAllInspection.this.dontWarnInCaseOfMultilineLambda && 1.isMultilineLambda(body, statements)) {
                    return;
                }
                PsiExpression index = PsiUtil.skipParenthesizedExprDown((PsiExpression)maybeSetCall.getArgumentList().getExpressions()[0]);
                CountingLoop countingLoop = CountingLoop.from((PsiForStatement)statement);
                if (countingLoop == null) {
                    return;
                }
                PsiLocalVariable counter = countingLoop.getCounter();
                if (countingLoop.isIncluding() || countingLoop.isDescending() || !ExpressionUtils.isZero((PsiExpression)countingLoop.getInitializer()) || !ExpressionUtils.isReferenceTo((PsiExpression)index, (PsiVariable)counter)) {
                    return;
                }
                IndexedContainer container = IndexedContainer.fromLengthExpression((PsiExpression)countingLoop.getBound());
                if (container == null) {
                    return;
                }
                List references = VariableAccessUtils.getVariableReferences((PsiVariable)counter, (PsiElement)body);
                if (!ContainerUtil.all((Collection)references, reference -> reference == index || container.extractGetExpressionFromIndex((PsiExpression)reference) != null)) {
                    return;
                }
                if (1.isRedundantOperation(maybeSetCall.getArgumentList().getExpressions()[1], body, countingLoop, container)) {
                    return;
                }
                if (!container.isQualifierEquivalent(ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)maybeSetCall.getMethodExpression()))) {
                    return;
                }
                Predicate<PsiVariable> variableAllowedPredicate = v -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)v, (PsiElement)counter);
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)body, variableAllowedPredicate)) {
                    return;
                }
                holder.registerProblem(statement.getFirstChild(), QuickFixBundle.message((String)"java.8.list.replaceall.inspection.description", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithReplaceAllQuickFix()});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/java18api/Java8ListReplaceAllInspection$1", "visitForStatement"));
            }
        };
    }

    @Nullable
    private static PsiMethodCallExpression getLastMethodCall(PsiStatement[] statements) {
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ArrayUtil.getLastElement((Object[])statements), PsiExpressionStatement.class);
        if (expressionStatement == null) {
            return null;
        }
        return (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiMethodCallExpression.class);
    }

    @Nullable
    private static PsiLocalVariable getVariableToInline(PsiStatement statement, PsiStatement body) {
        PsiLocalVariable localVariable = IteratorDeclaration.getDeclaredVariable((PsiStatement)statement);
        if (localVariable == null) {
            return null;
        }
        List references = VariableAccessUtils.getVariableReferences((PsiVariable)localVariable, (PsiElement)body);
        return references.size() != 1 ? null : localVariable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java18api/Java8ListReplaceAllInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java18api/Java8ListReplaceAllInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithReplaceAllQuickFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithReplaceAllQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message((String)"java.8.list.replaceall.inspection.fix.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithReplaceAllQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement psiElement;
            if (project == null) {
                ReplaceWithReplaceAllQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithReplaceAllQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithReplaceAllQuickFix.$$$reportNull$$$0(3);
            }
            if (!((psiElement = element.getParent()) instanceof PsiForStatement)) {
                return;
            }
            PsiForStatement statement = (PsiForStatement)psiElement;
            PsiStatement body = statement.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = ControlFlowUtils.unwrapBlock((PsiStatement)body);
            PsiMethodCallExpression call = Java8ListReplaceAllInspection.getLastMethodCall(statements);
            if (!LIST_SET.test(call)) {
                return;
            }
            PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier((PsiReferenceExpression)call.getMethodExpression());
            if (qualifier == null) {
                return;
            }
            CountingLoop countingLoop = CountingLoop.from((PsiForStatement)statement);
            if (countingLoop == null) {
                return;
            }
            IndexedContainer container = IndexedContainer.fromLengthExpression((PsiExpression)countingLoop.getBound());
            if (container == null) {
                return;
            }
            List<PsiMethodCallExpression> getCalls = ReplaceWithReplaceAllQuickFix.collectGetCalls(body, container, countingLoop.getCounter());
            String paramName = ReplaceWithReplaceAllQuickFix.generateParameterName(body, getCalls);
            getCalls.forEach(getCall -> new CommentTracker().replaceAndRestoreComments((PsiElement)getCall, paramName));
            if (statements.length == 2) {
                ReplaceWithReplaceAllQuickFix.inlineVariable(Java8ListReplaceAllInspection.getVariableToInline(statements[0], body), body);
            } else if (statements.length == 3) {
                ReplaceWithReplaceAllQuickFix.inlineVariable(Java8ListReplaceAllInspection.getVariableToInline(statements[0], body), body);
                ReplaceWithReplaceAllQuickFix.inlineVariable(Java8ListReplaceAllInspection.getVariableToInline(statements[1], body), body);
            }
            CommentTracker ct = new CommentTracker();
            PsiExpression replacementExpression = call.getArgumentList().getExpressions()[1];
            PsiElement returnStatement = new CommentTracker().replaceAndRestoreComments(call.getParent(), "return " + ct.textWithComments((PsiElement)replacementExpression) + ";");
            Object codeBlockText = body instanceof PsiBlockStatement ? ct.text((PsiElement)body) : "{ " + ct.text(returnStatement) + " }";
            String replaceAllParameter = paramName + " -> " + (String)codeBlockText;
            String text = ct.text((PsiElement)qualifier) + ".replaceAll(" + replaceAllParameter + ");";
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)statement, text);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences((PsiElement)result);
            ReplaceWithReplaceAllQuickFix.simplifyToExpressionLambda(result);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        @NotNull
        private static List<PsiMethodCallExpression> collectGetCalls(PsiStatement body, IndexedContainer container, PsiLocalVariable counter) {
            List list = ((StreamEx)StreamEx.of((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiMethodCallExpression.class)).filter(call -> ExpressionUtils.isReferenceTo((PsiExpression)container.extractIndexFromGetExpression((PsiExpression)call), (PsiVariable)counter))).toList();
            if (list == null) {
                ReplaceWithReplaceAllQuickFix.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private static String generateParameterName(PsiStatement body, List<PsiMethodCallExpression> getCalls) {
            if (getCalls.isEmpty()) {
                return "ignored";
            }
            String string = new VariableNameGenerator((PsiElement)body, VariableKind.PARAMETER).byExpression((PsiExpression)getCalls.getFirst()).generate(true);
            if (string == null) {
                ReplaceWithReplaceAllQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static void inlineVariable(PsiLocalVariable variable, PsiStatement body) {
            if (variable == null) {
                return;
            }
            if (!ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)body)) {
                return;
            }
            List references = VariableAccessUtils.getVariableReferences((PsiVariable)variable, (PsiElement)body);
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            references.forEach(reference -> CommonJavaInlineUtil.getInstance().inlineVariable((PsiVariable)variable, initializer, (PsiJavaCodeReferenceElement)reference, null));
            variable.delete();
        }

        private static void simplifyToExpressionLambda(PsiElement element) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)element, PsiExpressionStatement.class);
            if (expressionStatement == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpression arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)ObjectUtils.tryCast((Object)arg, PsiLambdaExpression.class);
            if (lambdaExpression == null) {
                return;
            }
            LambdaRefactoringUtil.simplifyToExpressionLambda((PsiLambdaExpression)lambdaExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java18api/Java8ListReplaceAllInspection$ReplaceWithReplaceAllQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java18api/Java8ListReplaceAllInspection$ReplaceWithReplaceAllQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectGetCalls";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateParameterName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

