/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.java.JavaBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class Java8MapForEachInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String JAVA_UTIL_MAP_ENTRY = "java.util.Map.Entry";
    private static final CallMatcher ITERABLE_FOREACH = CallMatcher.instanceCall((String)"java.lang.Iterable", (String[])new String[]{"forEach"}).parameterTypes(new String[]{"java.util.function.Consumer"});
    private static final CallMatcher MAP_ENTRY_SET = CallMatcher.instanceCall((String)"java.util.Map", (String[])new String[]{"entrySet"}).parameterCount(0);
    private static final CallMatcher ENTRY_GETTER = CallMatcher.instanceCall((String)"java.util.Map.Entry", (String[])new String[]{"getValue", "getKey"}).parameterCount(0);
    public boolean DO_NOT_HIGHLIGHT_LOOP = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"DO_NOT_HIGHLIGHT_LOOP", (String)JavaBundle.message((String)"inspection.map.foreach.option.no.loops", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            Java8MapForEachInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ADVANCED_COLLECTIONS_API);
        if (set == null) {
            Java8MapForEachInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            Java8MapForEachInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ITERABLE_FOREACH.test(call)) {
                    return;
                }
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
                if (!MAP_ENTRY_SET.test(qualifierCall)) {
                    return;
                }
                PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)call.getArgumentList().getExpressions()[0], PsiLambdaExpression.class);
                if (lambda == null) {
                    return;
                }
                PsiParameter[] lambdaParameters = lambda.getParameterList().getParameters();
                if (lambdaParameters.length != 1) {
                    return;
                }
                PsiParameter entry = lambdaParameters[0];
                if (!1.allUsagesAllowed(entry)) {
                    return;
                }
                PsiElement nameElement = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                holder.registerProblem(nameElement, JavaAnalysisBundle.message((String)"inspection.can.be.replaced.with.message", (Object[])new Object[]{"Map.forEach()"}), new LocalQuickFix[]{new ReplaceWithMapForEachFix()});
            }

            private static boolean allUsagesAllowed(@NotNull PsiParameter entry) {
                if (entry == null) {
                    1.$$$reportNull$$$0(1);
                }
                return ReferencesSearch.search((PsiElement)entry).allMatch(entryRef -> {
                    PsiMethodCallExpression entryCall = ExpressionUtils.getCallForQualifier((PsiExpression)((PsiExpression)ObjectUtils.tryCast((Object)entryRef.getElement(), PsiExpression.class)));
                    return ENTRY_GETTER.test(entryCall) && !ExpressionUtils.isVoidContext((PsiExpression)entryCall);
                });
            }

            public void visitForeachStatement(@NotNull PsiForeachStatement loop) {
                if (loop == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (Java8MapForEachInspection.this.DO_NOT_HIGHLIGHT_LOOP && !isOnTheFly) {
                    return;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)loop.getIteratedValue()), PsiMethodCallExpression.class);
                PsiParameter parameter = loop.getIterationParameter();
                if (MAP_ENTRY_SET.test(call) && LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)loop.getBody()) && 1.allUsagesAllowed(parameter)) {
                    TextRange range;
                    PsiElement toHighlight;
                    ProblemHighlightType type = Java8MapForEachInspection.this.DO_NOT_HIGHLIGHT_LOOP ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    boolean wholeStatement = isOnTheFly && (Java8MapForEachInspection.this.DO_NOT_HIGHLIGHT_LOOP || InspectionProjectProfileManager.isInformationLevel((String)Java8MapForEachInspection.this.getShortName(), (PsiElement)loop));
                    PsiJavaToken rParenth = loop.getRParenth();
                    PsiElement firstChild = loop.getFirstChild();
                    if (wholeStatement && rParenth != null) {
                        toHighlight = loop;
                        range = new TextRange(firstChild.getStartOffsetInParent(), rParenth.getStartOffsetInParent() + 1);
                    } else {
                        toHighlight = firstChild;
                        range = new TextRange(0, firstChild.getTextLength());
                    }
                    holder.registerProblem(toHighlight, JavaAnalysisBundle.message((String)"inspection.can.be.replaced.with.message", (Object[])new Object[]{"Map.forEach()"}), type, range, new LocalQuickFix[]{new ReplaceWithMapForEachFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "entry";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "loop";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/java18api/Java8MapForEachInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "allUsagesAllowed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitForeachStatement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java18api/Java8MapForEachInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java18api/Java8MapForEachInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithMapForEachFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithMapForEachFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Map.forEach()"});
            if (string == null) {
                ReplaceWithMapForEachFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement foreach;
            if (project == null) {
                ReplaceWithMapForEachFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithMapForEachFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithMapForEachFix.$$$reportNull$$$0(3);
            }
            PsiElement psiElement = foreach = element instanceof PsiForeachStatement ? element : element.getParent();
            if (foreach instanceof PsiForeachStatement) {
                ReplaceWithMapForEachFix.fixInForeach((PsiForeachStatement)foreach);
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiMethodCallExpression entrySetCall = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call);
            if (entrySetCall == null) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)args[0], PsiLambdaExpression.class);
            if (lambda == null) {
                return;
            }
            PsiElement body = lambda.getBody();
            if (body == null) {
                return;
            }
            PsiParameterList parameterList = lambda.getParameterList();
            PsiParameter[] lambdaParameters = parameterList.getParameters();
            if (lambdaParameters.length != 1) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiParameter entryParameter = lambdaParameters[0];
            String replacement = ReplaceWithMapForEachFix.createReplacementExpression(entrySetCall, entryParameter, body, ct);
            ct.replaceAndRestoreComments((PsiElement)call, replacement);
        }

        private static String createReplacementExpression(PsiMethodCallExpression entrySetCall, PsiParameter entryParameter, PsiElement body, CommentTracker ct) {
            PsiType entryType = entryParameter.getType();
            ParameterCandidate key = new ParameterCandidate(entryType, true);
            ParameterCandidate value = new ParameterCandidate(entryType, false);
            List references = VariableAccessUtils.getVariableReferences((PsiVariable)entryParameter, (PsiElement)body);
            for (Object ref : references) {
                PsiMethodCallExpression entryCall = ExpressionUtils.getCallForQualifier((PsiExpression)ref);
                if (!ENTRY_GETTER.test(entryCall)) continue;
                ParameterCandidate.select(entryCall, key, value).accept(entryCall);
            }
            key.createName(body, ct);
            value.createName(body, ct);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)entrySetCall.getProject());
            for (PsiExpression expression : references) {
                PsiMethodCallExpression entryCall;
                if (!expression.isValid() || !ENTRY_GETTER.test(entryCall = ExpressionUtils.getCallForQualifier((PsiExpression)expression))) continue;
                ct.replace((PsiElement)entryCall, ParameterCandidate.select((PsiMethodCallExpression)entryCall, (ParameterCandidate)key, (ParameterCandidate)value).myName);
            }
            Object lambdaBody = body instanceof PsiExpression || body instanceof PsiCodeBlock || body instanceof PsiBlockStatement ? ct.text(body) : "{" + ct.text(body) + "}";
            PsiLambdaExpression newLambda = (PsiLambdaExpression)factory.createExpressionFromText("(" + key.myName + "," + value.myName + ")->" + (String)lambdaBody, body);
            LambdaRefactoringUtil.simplifyToExpressionLambda((PsiLambdaExpression)newLambda);
            entrySetCall.getArgumentList().add((PsiElement)newLambda);
            ExpressionUtils.bindCallTo((PsiMethodCallExpression)entrySetCall, (String)"forEach");
            return ct.text((PsiElement)entrySetCall);
        }

        private static void fixInForeach(PsiForeachStatement loop) {
            PsiMethodCallExpression entrySetCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)loop.getIteratedValue()), PsiMethodCallExpression.class);
            if (entrySetCall == null) {
                return;
            }
            PsiStatement body = loop.getBody();
            if (body == null) {
                return;
            }
            PsiParameter entryParameter = loop.getIterationParameter();
            CommentTracker ct = new CommentTracker();
            String replacementExpression = ReplaceWithMapForEachFix.createReplacementExpression(entrySetCall, entryParameter, (PsiElement)body, ct);
            ct.replaceAndRestoreComments((PsiElement)loop, replacementExpression + ";");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java18api/Java8MapForEachInspection$ReplaceWithMapForEachFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java18api/Java8MapForEachInspection$ReplaceWithMapForEachFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }

        private static class ParameterCandidate {
            PsiVariable myOriginalVar;
            final PsiType myType;
            String myName;

            ParameterCandidate(PsiType entryType, boolean isKey) {
                this.myName = isKey ? "key" : "value";
                this.myType = GenericsUtil.getVariableTypeByExpressionType((PsiType)PsiUtil.substituteTypeParameter((PsiType)entryType, (String)Java8MapForEachInspection.JAVA_UTIL_MAP_ENTRY, (int)(isKey ? 0 : 1), (boolean)true));
            }

            private void createName(PsiElement context, CommentTracker ct) {
                if (this.myOriginalVar != null) {
                    this.myName = this.myOriginalVar.getName();
                    ct.delete((PsiElement)this.myOriginalVar);
                } else {
                    this.myName = JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestUniqueVariableName(this.myName, context, true);
                }
            }

            public void accept(PsiMethodCallExpression call) {
                if (this.myOriginalVar != null) {
                    return;
                }
                PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiLocalVariable.class);
                if (variable != null && EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(variable.getType(), this.myType)) {
                    this.myOriginalVar = variable;
                }
            }

            static ParameterCandidate select(PsiMethodCallExpression entryCall, ParameterCandidate key, ParameterCandidate value) {
                String methodName = entryCall.getMethodExpression().getReferenceName();
                return "getKey".equals(methodName) ? key : value;
            }
        }
    }
}

