/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19api;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Java9CollectionFactoryInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher UNMODIFIABLE_SET = CallMatcher.staticCall((String)"java.util.Collections", (String[])new String[]{"unmodifiableSet"}).parameterCount(1);
    private static final CallMatcher UNMODIFIABLE_MAP = CallMatcher.staticCall((String)"java.util.Collections", (String[])new String[]{"unmodifiableMap"}).parameterCount(1);
    private static final CallMatcher UNMODIFIABLE_LIST = CallMatcher.staticCall((String)"java.util.Collections", (String[])new String[]{"unmodifiableList"}).parameterCount(1);
    private static final CallMatcher ARRAYS_AS_LIST = CallMatcher.staticCall((String)"java.util.Arrays", (String[])new String[]{"asList"});
    private static final CallMatcher COLLECTION_ADD = CallMatcher.instanceCall((String)"java.util.Collection", (String[])new String[]{"add"}).parameterCount(1);
    private static final CallMatcher MAP_PUT = CallMatcher.instanceCall((String)"java.util.Map", (String[])new String[]{"put"}).parameterCount(2);
    private static final CallMatcher STREAM_COLLECT = CallMatcher.instanceCall((String)"java.util.stream.Stream", (String[])new String[]{"collect"}).parameterCount(1);
    private static final CallMatcher STREAM_OF = CallMatcher.staticCall((String)"java.util.stream.Stream", (String[])new String[]{"of"});
    private static final CallMatcher COLLECTORS_TO_SET = CallMatcher.staticCall((String)"java.util.stream.Collectors", (String[])new String[]{"toSet"}).parameterCount(0);
    private static final CallMatcher COLLECTORS_TO_LIST = CallMatcher.staticCall((String)"java.util.stream.Collectors", (String[])new String[]{"toList"}).parameterCount(0);
    private static final CallMapper<PrepopulatedCollectionModel> MAPPER = new CallMapper().register(UNMODIFIABLE_SET, call -> PrepopulatedCollectionModel.fromSet(call.getArgumentList().getExpressions()[0])).register(UNMODIFIABLE_MAP, call -> PrepopulatedCollectionModel.fromMap(call.getArgumentList().getExpressions()[0])).register(UNMODIFIABLE_LIST, call -> PrepopulatedCollectionModel.fromList(call.getArgumentList().getExpressions()[0]));
    public boolean IGNORE_NON_CONSTANT = false;
    public boolean SUGGEST_MAP_OF_ENTRIES = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"IGNORE_NON_CONSTANT", (String)JavaBundle.message((String)"inspection.collection.factories.option.ignore.non.constant", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"SUGGEST_MAP_OF_ENTRIES", (String)JavaBundle.message((String)"inspection.collection.factories.option.suggest.ofentries", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            Java9CollectionFactoryInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.COLLECTION_FACTORIES);
        if (set == null) {
            Java9CollectionFactoryInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            Java9CollectionFactoryInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                PrepopulatedCollectionModel model;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((model = (PrepopulatedCollectionModel)MAPPER.mapFirst(call)) != null && model.isValid(Java9CollectionFactoryInspection.this.SUGGEST_MAP_OF_ENTRIES)) {
                    PsiMethodCallExpression element;
                    ProblemHighlightType type;
                    ProblemHighlightType problemHighlightType = type = model.myConstantContent || !Java9CollectionFactoryInspection.this.IGNORE_NON_CONSTANT ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                    if (type == ProblemHighlightType.INFORMATION && !isOnTheFly) {
                        return;
                    }
                    boolean wholeStatement = isOnTheFly && (type == ProblemHighlightType.INFORMATION || InspectionProjectProfileManager.isInformationLevel((String)Java9CollectionFactoryInspection.this.getShortName(), (PsiElement)call));
                    Object object = element = wholeStatement ? call : call.getMethodExpression().getReferenceNameElement();
                    if (element != null) {
                        String replacementMethod = model.hasTooManyMapEntries() ? "ofEntries" : (model.myCopy ? "copyOf" : "of");
                        String fixMessage = JavaBundle.message((String)"inspection.collection.factories.fix.name", (Object[])new Object[]{model.myType, replacementMethod});
                        String inspectionMessage = JavaBundle.message((String)"inspection.collection.factories.message", (Object[])new Object[]{model.myType, replacementMethod});
                        holder.registerProblem((PsiElement)element, inspectionMessage, type, new LocalQuickFix[]{new ReplaceWithCollectionFactoryFix(fixMessage)});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/java19api/Java9CollectionFactoryInspection$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/java19api/Java9CollectionFactoryInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/java19api/Java9CollectionFactoryInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    static class PrepopulatedCollectionModel {
        final List<PsiExpression> myContent;
        final List<PsiElement> myElementsToDelete;
        final String myType;
        final boolean myCopy;
        final boolean myConstantContent;
        final boolean myRepeatingKeys;
        final boolean myMayHaveNulls;

        PrepopulatedCollectionModel(List<PsiExpression> content, List<PsiElement> delete, String type) {
            this(content, delete, type, false);
        }

        PrepopulatedCollectionModel(List<PsiExpression> content, List<PsiElement> delete, String type, boolean copy) {
            this.myContent = content;
            this.myElementsToDelete = delete;
            this.myType = type;
            this.myCopy = copy;
            Map constants = ((EntryStream)StreamEx.of(this.myContent).cross(ExpressionUtils::nonStructuralChildren).mapValues(ExpressionUtils::computeConstantExpression).distinct()).grouping();
            this.myConstantContent = !copy && StreamEx.ofValues((Map)constants).flatCollection(Function.identity()).allMatch(Objects::nonNull);
            this.myRepeatingKeys = ((StreamEx)this.keyExpressions().flatCollection(constants::get).nonNull().distinct(2L)).findAny().isPresent();
            this.myMayHaveNulls = !copy && StreamEx.of(this.myContent).flatMap(ExpressionUtils::nonStructuralChildren).anyMatch(ex -> NullabilityUtil.getExpressionNullability((PsiExpression)ex, (boolean)true) != Nullability.NOT_NULL);
        }

        boolean isValid(boolean suggestMapOfEntries) {
            return !this.myMayHaveNulls && !this.myRepeatingKeys && (suggestMapOfEntries || !this.hasTooManyMapEntries());
        }

        private boolean hasTooManyMapEntries() {
            return this.myType.equals("Map") && this.myContent.size() > 20;
        }

        private StreamEx<PsiExpression> keyExpressions() {
            return switch (this.myType) {
                case "Set" -> StreamEx.of(this.myContent);
                case "Map" -> IntStreamEx.range((int)0, (int)this.myContent.size(), (int)2).elements(this.myContent);
                default -> StreamEx.empty();
            };
        }

        public static PrepopulatedCollectionModel fromList(PsiExpression listDefinition) {
            if ((listDefinition = PsiUtil.skipParenthesizedExprDown((PsiExpression)listDefinition)) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)listDefinition;
                if (ARRAYS_AS_LIST.test(call)) {
                    Object[] elements;
                    PsiExpression arg;
                    PsiVariable variable;
                    Object[] expressions = call.getArgumentList().getExpressions();
                    if (!MethodCallUtils.isVarArgCall((PsiCall)call) && expressions.length == 1 && (variable = ExpressionUtils.resolveVariable((PsiExpression)(arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)expressions[0])))) != null && (elements = ExpressionUtils.getConstantArrayElements((PsiVariable)variable)) != null && ContainerUtil.all((Object[])elements, Objects::nonNull)) {
                        expressions = elements;
                    }
                    return new PrepopulatedCollectionModel(Arrays.asList(expressions), Collections.emptyList(), "List");
                }
                return PrepopulatedCollectionModel.fromCollect(call, "List", COLLECTORS_TO_LIST);
            }
            if (listDefinition instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)listDefinition;
                return PrepopulatedCollectionModel.fromNewExpression(newExpression, "List", "java.util.ArrayList");
            }
            if (listDefinition instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)listDefinition;
                return PrepopulatedCollectionModel.fromVariable(ref, "List", "java.util.ArrayList", COLLECTION_ADD);
            }
            return null;
        }

        public static PrepopulatedCollectionModel fromSet(PsiExpression setDefinition) {
            if ((setDefinition = PsiUtil.skipParenthesizedExprDown((PsiExpression)setDefinition)) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)setDefinition;
                return PrepopulatedCollectionModel.fromCollect(call, "Set", COLLECTORS_TO_SET);
            }
            if (setDefinition instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)setDefinition;
                return PrepopulatedCollectionModel.fromNewExpression(newExpression, "Set", "java.util.HashSet");
            }
            if (setDefinition instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)setDefinition;
                return PrepopulatedCollectionModel.fromVariable(ref, "Set", "java.util.HashSet", COLLECTION_ADD);
            }
            return null;
        }

        public static PrepopulatedCollectionModel fromMap(PsiExpression mapDefinition) {
            if ((mapDefinition = PsiUtil.skipParenthesizedExprDown((PsiExpression)mapDefinition)) instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)mapDefinition;
                return PrepopulatedCollectionModel.fromVariable(ref, "Map", "java.util.HashMap", MAP_PUT);
            }
            if (mapDefinition instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)mapDefinition;
                PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
                PsiExpressionList argumentList = newExpression.getArgumentList();
                if (argumentList != null) {
                    PsiJavaCodeReferenceElement baseClassReference;
                    PsiExpression arg;
                    PsiExpression[] args = argumentList.getExpressions();
                    PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
                    if (classReference != null && PsiUtil.getLanguageLevel((PsiElement)mapDefinition).isAtLeast(LanguageLevel.JDK_10) && "java.util.HashMap".equals(classReference.getQualifiedName()) && args.length == 1 && (arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0])) != null) {
                        PsiType sourceType = arg.getType();
                        PsiType targetType = newExpression.getType();
                        if (targetType != null && sourceType != null && sourceType.isAssignableFrom(targetType)) {
                            PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)sourceType, (String)"java.util.Map", (int)0, (boolean)false);
                            PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)sourceType, (String)"java.util.Map", (int)1, (boolean)false);
                            if (DfaPsiUtil.getTypeNullability((PsiType)keyType) == Nullability.NULLABLE || DfaPsiUtil.getTypeNullability((PsiType)valueType) == Nullability.NULLABLE) {
                                return null;
                            }
                            return new PrepopulatedCollectionModel(Collections.singletonList(arg), Collections.emptyList(), "Map", true);
                        }
                    }
                    if (anonymousClass != null && argumentList.isEmpty() && "java.util.HashMap".equals((baseClassReference = anonymousClass.getBaseClassReference()).getQualifiedName())) {
                        return PrepopulatedCollectionModel.fromInitializer(anonymousClass, "Map", MAP_PUT);
                    }
                }
            }
            return null;
        }

        @Nullable
        private static PrepopulatedCollectionModel fromCollect(PsiMethodCallExpression call, String typeName, CallMatcher collector) {
            PsiMethodCallExpression qualifier;
            if (STREAM_COLLECT.test(call) && collector.matches(call.getArgumentList().getExpressions()[0]) && STREAM_OF.matches((PsiExpression)(qualifier = MethodCallUtils.getQualifierMethodCall((PsiMethodCallExpression)call)))) {
                return new PrepopulatedCollectionModel(Arrays.asList(qualifier.getArgumentList().getExpressions()), Collections.emptyList(), typeName);
            }
            return null;
        }

        @Nullable
        private static PrepopulatedCollectionModel fromVariable(PsiReferenceExpression expression, String typeName, String collectionClass, CallMatcher addMethod) {
            PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)expression.resolve(), PsiLocalVariable.class);
            if (variable == null) {
                return null;
            }
            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class);
            if (block == null || declaration == null) {
                return null;
            }
            PsiElement[] defs = DefUseUtil.getDefs((PsiCodeBlock)block, (PsiVariable)variable, (PsiElement)expression);
            if (defs.length == 1 && defs[0] == variable) {
                PsiExpression initializer = variable.getInitializer();
                if (!ConstructionUtils.isEmptyCollectionInitializer((PsiExpression)initializer)) {
                    return null;
                }
                if (!PsiTypesUtil.classNameEquals((PsiType)initializer.getType(), (String)collectionClass)) {
                    return null;
                }
                HashSet refs = ContainerUtil.newHashSet((Object[])DefUseUtil.getRefs((PsiCodeBlock)block, (PsiVariable)variable, (PsiElement)initializer));
                refs.remove(expression);
                PsiDeclarationStatement cur = declaration;
                ArrayList<PsiExpression> contents = new ArrayList<PsiExpression>();
                ArrayList<PsiElement> elementsToRemove = new ArrayList<PsiElement>();
                elementsToRemove.add((PsiElement)initializer);
                while (!PsiTreeUtil.isAncestor((PsiElement)(cur = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)cur), PsiStatement.class)), (PsiElement)expression, (boolean)false)) {
                    if (!(cur instanceof PsiExpressionStatement)) {
                        return null;
                    }
                    PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)cur).getExpression(), PsiMethodCallExpression.class);
                    if (!addMethod.test(call)) {
                        return null;
                    }
                    if (!refs.remove(call.getMethodExpression().getQualifierExpression())) {
                        return null;
                    }
                    contents.addAll(Arrays.asList(call.getArgumentList().getExpressions()));
                    elementsToRemove.add((PsiElement)cur);
                }
                if (!refs.isEmpty()) {
                    return null;
                }
                return new PrepopulatedCollectionModel(contents, elementsToRemove, typeName);
            }
            return null;
        }

        @Nullable
        private static PrepopulatedCollectionModel fromNewExpression(PsiNewExpression newExpression, String type, String className) {
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList != null) {
                PsiJavaCodeReferenceElement baseClassReference;
                PsiExpression[] args = argumentList.getExpressions();
                PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
                if (classReference != null && className.equals(classReference.getQualifiedName())) {
                    return PrepopulatedCollectionModel.fromCopyConstructor(args, type);
                }
                PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
                if (anonymousClass != null && args.length == 0 && className.equals((baseClassReference = anonymousClass.getBaseClassReference()).getQualifiedName())) {
                    return PrepopulatedCollectionModel.fromInitializer(anonymousClass, type, COLLECTION_ADD);
                }
            }
            return null;
        }

        @Nullable
        private static PrepopulatedCollectionModel fromCopyConstructor(PsiExpression[] args, String type) {
            if (args.length == 1) {
                PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]);
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)arg, PsiMethodCallExpression.class);
                if (ARRAYS_AS_LIST.test(call)) {
                    return new PrepopulatedCollectionModel(Arrays.asList(call.getArgumentList().getExpressions()), Collections.emptyList(), type);
                }
                if (arg != null && PsiUtil.getLanguageLevel((PsiElement)arg).isAtLeast(LanguageLevel.JDK_10) && InheritanceUtil.isInheritor((PsiType)arg.getType(), (String)"java.util.Collection")) {
                    PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)arg.getType(), (String)"java.util.Collection", (int)0, (boolean)false);
                    if (DfaPsiUtil.getTypeNullability((PsiType)elementType) == Nullability.NULLABLE) {
                        return null;
                    }
                    return new PrepopulatedCollectionModel(Collections.singletonList(arg), Collections.emptyList(), type, true);
                }
            }
            return null;
        }

        @Nullable
        private static PrepopulatedCollectionModel fromInitializer(PsiAnonymousClass anonymousClass, String type, CallMatcher addMethod) {
            PsiClassInitializer initializer = ClassUtils.getDoubleBraceInitializer((PsiAnonymousClass)anonymousClass);
            if (initializer != null) {
                ArrayList<PsiExpression> contents = new ArrayList<PsiExpression>();
                for (PsiStatement statement : initializer.getBody().getStatements()) {
                    if (!(statement instanceof PsiExpressionStatement)) {
                        return null;
                    }
                    PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)statement).getExpression(), PsiMethodCallExpression.class);
                    if (!addMethod.test(call)) {
                        return null;
                    }
                    PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                    if (qualifier != null && !qualifier.getText().equals("this")) {
                        return null;
                    }
                    contents.addAll(Arrays.asList(call.getArgumentList().getExpressions()));
                }
                return new PrepopulatedCollectionModel(contents, Collections.emptyList(), type);
            }
            return null;
        }
    }

    private static class ReplaceWithCollectionFactoryFix
    extends PsiUpdateModCommandQuickFix {
        @IntentionName
        private final String myMessage;

        ReplaceWithCollectionFactoryFix(@IntentionName String message) {
            this.myMessage = message;
        }

        @NotNull
        public String getName() {
            String string = this.myMessage;
            if (string == null) {
                ReplaceWithCollectionFactoryFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaBundle.message((String)"inspection.collection.factories.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithCollectionFactoryFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Object replacementText;
            PsiMethodCallExpression call;
            if (project == null) {
                ReplaceWithCollectionFactoryFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceWithCollectionFactoryFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithCollectionFactoryFix.$$$reportNull$$$0(4);
            }
            if ((call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)false)) == null) {
                return;
            }
            PrepopulatedCollectionModel model = (PrepopulatedCollectionModel)MAPPER.mapFirst(call);
            if (model == null) {
                return;
            }
            String typeArgument = ReplaceWithCollectionFactoryFix.getTypeArguments(call.getType(), model.myType);
            CommentTracker ct = new CommentTracker();
            if (model.myCopy) {
                assert (model.myContent.size() == 1);
                replacementText = "java.util." + model.myType + "." + typeArgument + "copyOf(" + model.myContent.getFirst().getText() + ")";
            } else {
                replacementText = model.hasTooManyMapEntries() ? StreamEx.ofSubLists(model.myContent, (int)2).map(expr -> ct.commentsBefore((PsiElement)expr.getFirst()) + "java.util.Map.entry(" + ct.text((PsiElement)expr.getFirst()) + "," + ct.textWithComments((PsiElement)expr.get(1)) + ")").joining((CharSequence)",", (CharSequence)("java.util.Map." + typeArgument + "ofEntries("), (CharSequence)")") : StreamEx.of(model.myContent).map(arg_0 -> ((CommentTracker)ct).textWithComments(arg_0)).joining((CharSequence)",", (CharSequence)("java.util." + model.myType + "." + typeArgument + "of("), (CharSequence)")");
            }
            List vars = StreamEx.of(model.myElementsToDelete).map(PsiElement::getParent).select(PsiLocalVariable.class).toList();
            model.myElementsToDelete.forEach(arg_0 -> ((CommentTracker)ct).delete(arg_0));
            PsiElement replacement = ct.replaceAndRestoreComments((PsiElement)call, (String)replacementText);
            vars.stream().filter(var -> !VariableAccessUtils.variableIsUsed((PsiVariable)var, (PsiElement)PsiUtil.getVariableCodeBlock((PsiVariable)var, null))).forEach(PsiElement::delete);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments((PsiElement)replacement);
        }

        @NotNull
        private static String getTypeArguments(PsiType type, String typeName) {
            if (typeName.equals("Map")) {
                PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)0, (boolean)false);
                PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)1, (boolean)false);
                if (keyType != null && valueType != null) {
                    String string = "<" + keyType.getCanonicalText() + "," + valueType.getCanonicalText() + ">";
                    if (string == null) {
                        ReplaceWithCollectionFactoryFix.$$$reportNull$$$0(5);
                    }
                    return string;
                }
            } else {
                PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Collection", (int)0, (boolean)false);
                if (elementType != null) {
                    String string = "<" + elementType.getCanonicalText() + ">";
                    if (string == null) {
                        ReplaceWithCollectionFactoryFix.$$$reportNull$$$0(6);
                    }
                    return string;
                }
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/java19api/Java9CollectionFactoryInspection$ReplaceWithCollectionFactoryFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/java19api/Java9CollectionFactoryInspection$ReplaceWithCollectionFactoryFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

